// 
// File:          sort_IntegerContainer_Impl.cc
// Symbol:        sort.IntegerContainer-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.IntegerContainer
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_IntegerContainer_Impl.hh"

#line 14 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.IntegerContainer._includes)
#include <sstream>
#include <iostream>
#include "synch_RegOut.hh"
// DO-NOT-DELETE splicer.end(sort.IntegerContainer._includes)
#line 20 "sort_IntegerContainer_Impl.cc"

// user-defined constructor.
void sort::IntegerContainer_impl::_ctor() {
#line 22 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor)
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor)
#line 27 "sort_IntegerContainer_Impl.cc"
}

// user-defined destructor.
void sort::IntegerContainer_impl::_dtor() {
#line 28 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor)
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor)
#line 35 "sort_IntegerContainer_Impl.cc"
}

// static class initializer.
void sort::IntegerContainer_impl::_load() {
#line 34 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer._load)
#line 44 "sort_IntegerContainer_Impl.cc"
}

// user-defined static methods: (none)

// user-defined non-static methods:
/**
 * This sets the container length and pseudo-randomly orders the
 * Integer elements contained.
 */
void
sort::IntegerContainer_impl::setLength (
  /* in */ int32_t len ) 
throw () 
{
#line 51 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength)
  int32_t i, j;
  d_elements = sidl::array<sort::Integer>::create1d(len);
  for(i = 0; i < len; ++i){
    sort::Integer intObj = sort::Integer::_create();
    intObj.setValue(i);
    d_elements.set(i, intObj);
  }
  for(i = len - 1; i > 0; --i) {
    j = random() % (i + 1);
    if (j != i) {
      self.swap(i, j);
    }
  }
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength)
#line 75 "sort_IntegerContainer_Impl.cc"
}

/**
 * Return the number of elements in the container.
 */
int32_t
sort::IntegerContainer_impl::getLength ()
throw () 

{
#line 76 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength)
  return 1 + d_elements.upper(0) - d_elements.lower(0);
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength)
#line 90 "sort_IntegerContainer_Impl.cc"
}

/**
 * Return -1 if element i is less than element j, 0 if element i
 * is equal to element j, or otherwise 1.
 */
int32_t
sort::IntegerContainer_impl::compare (
  /* in */ int32_t i,
  /* in */ int32_t j,
  /* in */ ::sort::Comparator comp ) 
throw () 
{
#line 92 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare)
  sidl::BaseInterface i1(d_elements.get(i));
  sidl::BaseInterface i2(d_elements.get(j));
  return comp.compare(i1, i2);
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare)
#line 110 "sort_IntegerContainer_Impl.cc"
}

/**
 * Swap elements i and j.
 */
void
sort::IntegerContainer_impl::swap (
  /* in */ int32_t i,
  /* in */ int32_t j ) 
throw () 
{
#line 108 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap)
  const int32_t len = self.getLength();
  if (i >= 0 && j >= 0 && i < len && j < len) {
    sort::Integer 
      i1(d_elements.get(i)),
      i2(d_elements.get(j));
    d_elements.set(i, i2);
    d_elements.set(j, i1);
  }
  else {
    std::cerr << "sort::IntegerContainer::swap index out of bounds swap ("
	      << i << ", " << j << ") len (" << len << ")" << std::endl;
    synch::RegOut::getInstance().forceFailure();
  }
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap)
#line 138 "sort_IntegerContainer_Impl.cc"
}

/**
 * Print elements s through e-1
 */
void
sort::IntegerContainer_impl::output (
  /* in */ int32_t s,
  /* in */ int32_t e ) 
throw () 
{
#line 134 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output)
  std::ostringstream buf;
  buf << "list";
  while (s < e) {
    buf << ' ' << d_elements.get(s++).getValue();
  }
  synch::RegOut::getInstance().writeComment(buf.str());
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.output)
#line 159 "sort_IntegerContainer_Impl.cc"
}


#line 145 "../../../../babel/regression/sort/libCxx/sort_IntegerContainer_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.IntegerContainer._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.IntegerContainer._misc)
#line 167 "sort_IntegerContainer_Impl.cc"

