##
## File:        make.runC
## Package:     Babel regression checks
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for run regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


OUTPUTSIDL=$(srcdir)/../../output/output.sidl

check_PROGRAMS    = $(STATIC_PROGS) $(SHARED_PROGS)
check_SCRIPTS     = runAll.sh
check_LTLIBRARIES = libClient.la

BABELDIR    = $(top_builddir)/bin
INCLUDEDIR  = $(top_builddir)/runtime/sidl
INCLUDEDIR2 = .
LIBSIDL     = $(top_builddir)/runtime/sidl/libsidl.la
LIBSYNC     = ../../output/libC/libOutput.la
PUREBABELGEN = $(STUBSRCS) $(STUBHDRS) $(IORHDRS) \
	$(synch_STUBSRCS) $(synch_STUBHDRS) $(synch_IORHDRS)
CLEANFILES = $(PUREBABELGEN) core babel-stamp babel-temp \
	stamp-installcheck

if SUPPORT_STATIC
if SUPPORT_FORTRAN77
  BABEL_STATIC_F77 = runC2F77
else
  BABEL_STATIC_F77 = 
endif
if SUPPORT_FORTRAN90
  BABEL_STATIC_F90 = runC2F90
else
  BABEL_STATIC_F90 = 
endif
STATIC_PROGS = runC2C runC2Cxx runC2UCxx $(BABEL_STATIC_F77) $(BABEL_STATIC_F90)

runC2C_SOURCES        = $(TESTFILE)
runC2C_LDFLAGS        = -static
runC2C_LDADD          = libClient.la ../libC/libImpl.la \
			$(LIBSYNC) $(LIBSIDL)

runC2Cxx_SOURCES      = $(TESTFILE)
runC2Cxx_LDFLAGS      = -static
runC2Cxx_LDADD        = libClient.la ../libCxx/libImpl.la \
			$(LIBSYNC) $(LIBSIDL)
runC2Cxx_LINK	      = $(CXXLINK)

runC2UCxx_SOURCES      = force_cxx_linker.cc $(TESTFILE)
runC2UCxx_LDFLAGS      = -static
runC2UCxx_LDADD        = libClient.la ../libUCxx/libImpl.la \
			$(LIBSYNC) $(LIBSIDL)
runC2UCxx_LINK	       = $(CXXLINK)

if SUPPORT_FORTRAN77
runC2F77_SOURCES      = $(TESTFILE)
runC2F77_LDFLAGS      = -static
runC2F77_LDADD        = libClient.la ../libF77/libImpl.la \
			$(LIBSYNC) $(LIBSIDL) $(FLIBS)
endif

if SUPPORT_FORTRAN90
runC2F90_SOURCES      =  $(TESTFILE)
runC2F90_LDFLAGS      = -static
runC2F90_LDADD        = libClient.la ../libF90/libImpl.la \
			$(LIBSYNC) $(LIBSIDL) $(FCLIBS)
endif
endif

if SUPPORT_SHARED
SHARED_PROGS          = runAll
runAll_SOURCES        = $(TESTFILE)
runAll_LDFLAGS	      = -dynamic
runAll_LDADD          = libClient.la $(LIBSYNC) $(LIBSIDL)
endif

nodist_libClient_la_SOURCES      = $(PUREBABELGEN)
libClient_la_LIBADD       = $(LIBSYNC) $(LIBSIDL)
libClient_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs \
			    -release @VERSION@

EXTRA_DIST = babel.make synch_babel.make
AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2)

$(PUREBABELGEN) : babel-stamp
	@if test -f $@; then \
	    touch $@; \
	else \
	    rm -f babel-stamp ; \
	    $(MAKE) $(AM_MAKEFLAGS) babel-stamp; \
	fi

babel-stamp: $(SIDLFILE) $(OUTPUTSIDL)
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --client=C \
		--suppress-timestamp $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --client=C --make-prefix=synch_ \
		--suppress-timestamp --exclude-external $(OUTPUTSIDL)
	@mv -f babel-temp $@

clean-local:
	test "X$(srcdir)" = "X." || rm -f babel.make synch_babel.make

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)  $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS)

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  INCLUDEDIR=$(includedir)			\
	  INCLUDEDIR2=$(exec_prefix)/include		\
	  LIBSIDL=$(libdir)/libsidl.la $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS) 
	touch stamp-installcheck

# Make sure Makefile.in is newer than babel.make
dist-hook:
	touch -c $(distdir)/Makefile.in
