// 
// File:          gov_cca_ports_ParameterPort.hh
// Symbol:        gov.cca.ports.ParameterPort-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.ports.ParameterPort
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_ports_ParameterPort_hh
#define included_gov_cca_ports_ParameterPort_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 
    namespace ports { 

      class ParameterPort;
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::ports::ParameterPort >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_ports_ParameterPort_IOR_h
#include "gov_cca_ports_ParameterPort_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 
    namespace ports { 

      /**
       * Symbol "gov.cca.ports.ParameterPort" (version 0.6.3)
       * 
       * This type of interface is exported for manipulation by other
       * components or by a user-interface (UI) (text or graphic).
       * By using the port ParameterFactory the component
       * writer never actually has to implement this port directly.
       * The recommended instance name for this port type is "CONFIG",
       * if a component provides only one such port. 
       * Component assembly or user interface rendering agents might 
       * assume this name. However, clever agents will act based on
       * port type rather than port instance name.
       * 
       * Data types represented: Anything representable in a TypeMap.
       * The following auxiliary information is managed for the benefit
       * of component end-user, UI, and other agents. 
       * Per map:
       * - title -- a name suitable to a top level window frame.
       * - group names -- data items are put in subsets (groups)
       *                  as, for example, in tabbed dialogs.
       * - list of all published parameter keys, those defined
       *   with the add functions of ParameterPortFactory. 
       * Per group name:
       * - group title -- ui-appropriate subset title, typically a tab heading.
       * - group keys -- list of data item keys in a named group.
       * Per data item key:
       * - default value 
       * - current value -- queryable directly from TypeMap by key name.
       * - help string -- potentially long-winded explanation of parameter use.
       * - prompt string -- shorter than help string and usually shown
       *                    in UI somehow while soliciting input.
       * - numeric bounds or value choice list. Where data type is
       *   an array type, the choice or bound restrictions are applied
       *   element-wise.
       * 
       * 
       * Special notes:
       * - The rendering of array-valued parameters in UI's poses a variety
       * of thorny problems in human-computer interaction. Use of
       * array parameters should be considered carefully. Not all UI
       * agents may be able to render array-valued parameters.
       * - Keys in the TypeMap with names starting with "gcpPPF." are
       *   reserved for private use by the 
       *   ParameterPortFactory implementation.
       */
      class ParameterPort : public ::sidl::StubBase {

        //////////////////////////////////////////////////
        // 
        // User Defined Methods
        // 

      public:

        /**
         * <p>
         * Add one to the intrinsic reference count in the underlying object.
         * Object in <code>sidl</code> have an intrinsic reference count.
         * Objects continue to exist as long as the reference count is
         * positive. Clients should call this method whenever they
         * create another ongoing reference to an object or interface.
         * </p>
         * <p>
         * This does not have a return value because there is no language
         * independent type that can refer to an interface or a
         * class.
         * </p>
         */
        inline void
        addRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_addRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
          }
        }



        /**
         * Decrease by one the intrinsic reference count in the underlying
         * object, and delete the object if the reference is non-positive.
         * Objects in <code>sidl</code> have an intrinsic reference count.
         * Clients should call this method whenever they remove a
         * reference to an object or interface.
         */
        inline void
        deleteRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
            d_self = 0;
          }
        }



        /**
         * Return true if and only if <code>obj</code> refers to the same
         * object as this object.
         */
        bool
        isSame (
          /* in */ ::sidl::BaseInterface iobj
        )
        throw () 
        ;



        /**
         * Check whether the object can support the specified interface or
         * class.  If the <code>sidl</code> type name in <code>name</code>
         * is supported, then a reference to that object is returned with the
         * reference count incremented.  The callee will be responsible for
         * calling <code>deleteRef</code> on the returned object.  If
         * the specified type is not supported, then a null reference is
         * returned.
         */
        ::sidl::BaseInterface
        queryInt (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return whether this object is an instance of the specified type.
         * The string name must be the <code>sidl</code> type name.  This
         * routine will return <code>true</code> if and only if a cast to
         * the string type name would succeed.
         */
        bool
        isType (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return the meta-data about the class implementing this interface.
         */
        ::sidl::ClassInfo
        getClassInfo() throw () 
        ;


        /**
         * Return a TypeMap of runtime configuration parameters. 
         *  @throws gov.cca.CCAException if mapName is unknown.
         */
        ::gov::cca::TypeMap
        readConfigurationMap() throw ( 
          ::gov::cca::CCAException
        );


        /**
         * Copy the parameter values given in map into the
         * internal map, for those parameters which
         * are already defined by the internal map.
         * The outsider does not get to cause arbitrary
         * keys to be copied into the internal map.
         * @throws gov.cca.CCAException if TypeMap operations fail.
         */
        void
        writeConfigurationMap (
          /* in */ ::gov::cca::TypeMap map
        )
        throw () 
        ;



        /**
         * Fetch the list of keys in the TypeMap that are
         *   for public configuration purposes. Other values found in
         *   the TypeMap must not be changed.
         */
        ::sidl::array< ::std::string>
        readConfigurationKeys() throw () 
        ;


        /**
         * Fetch configuration title. 
         *  @return Description of data set.
         */
        ::std::string
        readTitle() throw () 
        ;


        /**
         * Fetch the names of groups. Each page in a tabbed dialog
         *  goes with a group, for example.
         */
        ::sidl::array< ::std::string>
        readGroupNames() throw () 
        ;


        /**
         * Fetch UI-appropriate name for group.
         *  Group name and group title may be the same.
         *  @throws gov.cca.CCAException if groupName is unknown.
         */
        ::std::string
        readGroupTitle (
          /* in */ const ::std::string& groupName
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch data item keys associated with groupName.
         *  Array order will be the same as the order in which
         *  the additions were made in the ParameterPortFactory interface.
         *  @throws gov.cca.CCAException if groupName is unknown.
         */
        ::sidl::array< ::std::string>
        readGroupKeys (
          /* in */ const ::std::string& groupName
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the help string for key.
         *  @throws gov.cca.CCAException if key is unknown.
         */
        ::std::string
        readHelp (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the prompt string for key.
         *  @throws gov.cca.CCAException if key is unknown.
         */
        ::std::string
        readPrompt (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * By default, bounds are defined except for complex numbers
         *  booleans, and strings. On array types, bounds apply
         *  element-wise. i.e.  low <= arr[i] <= high for all i.
         *  @return true if simple bounds are defined for a key.
         *  @throws gov.cca.CCAException if key is unknown.
         */
        bool
        hasBounds (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * By default, lists of choices are not defined for scalars or arrays.
         *  Choices are applied element-wise for array types.
         *  I.e. (arr[i] IN choice-set) == true  for all i.
         *  @return true if choice list is defined for a key.
         *  @throws gov.cca.CCAException if key is unknown.
         */
        bool
        hasChoices (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for boolean-typed key. 
         *  @thr2ows gov.cca.CCAException if key is unknown or mistyped.
         */
        bool
        readDefaultBoolean (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for string-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::std::string
        readDefaultString (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for integer-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        int32_t
        readDefaultInt (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for long-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        int64_t
        readDefaultLong (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for float-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        float
        readDefaultFloat (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for double-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        double
        readDefaultDouble (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for fcomplex-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::std::complex<float>
        readDefaultFcomplex (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for dcomplex-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::std::complex<double>
        readDefaultDcomplex (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for string-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::std::string>
        readDefaultStringArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for boolean-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<bool>
        readDefaultBooleanArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for integer-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<int32_t>
        readDefaultIntArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for long-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<int64_t>
        readDefaultLongArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for float-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<float>
        readDefaultFloatArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for double-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<double>
        readDefaultDoubleArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for fcomplex-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::sidl::fcomplex>
        readDefaultFcomplexArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for dcomplex-array-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::sidl::dcomplex>
        readDefaultDcomplexArray (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the bounds for integer-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        readBoundsInt (
          /* in */ const ::std::string& key,
          /* out */ int32_t& low,
          /* out */ int32_t& high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for long-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        readBoundsLong (
          /* in */ const ::std::string& key,
          /* out */ int64_t& low,
          /* out */ int64_t& high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for float-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        readBoundsFloat (
          /* in */ const ::std::string& key,
          /* out */ float& low,
          /* out */ float& high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for double-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        readBoundsDouble (
          /* in */ const ::std::string& key,
          /* out */ double& low,
          /* out */ double& high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the choices for string(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::std::string>
        readChoicesString (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the choices for integer(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<int32_t>
        readChoicesInt (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the choices for long(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<int64_t>
        readChoicesLong (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the choices for float(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<float>
        readChoicesFloat (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for double(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array<double>
        readChoicesDouble (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for fcomplex(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::sidl::fcomplex>
        readChoicesFcomplex (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Fetch the default for dcomplex(-array)-typed key. 
         *  @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        ::sidl::array< ::sidl::dcomplex>
        readChoicesDcomplex (
          /* in */ const ::std::string& key
        )
        throw ( 
          ::gov::cca::CCAException
        );



        //////////////////////////////////////////////////
        // 
        // End User Defined Methods
        // (everything else in this file is specific to
        //  Babel's C++ bindings)
        // 

      public:
        typedef struct gov_cca_ports_ParameterPort__object ior_t;
        typedef struct gov_cca_ports_ParameterPort__external ext_t;
        typedef struct gov_cca_ports_ParameterPort__sepv sepv_t;

        // default constructor
        ParameterPort() : d_self(0), d_weak_reference(false) { }

        // default destructor
        virtual ~ParameterPort ();

        // copy constructor
        ParameterPort ( const ParameterPort& original );

        // assignment operator
        ParameterPort& operator= ( const ParameterPort& rhs );

        // conversion from ior to C++ class
        ParameterPort ( ParameterPort::ior_t* ior );

        // Alternate constructor: does not call addRef()
        // (sets d_weak_reference=isWeak)
        // For internal use by Impls (fixes bug#275)
        ParameterPort ( ParameterPort::ior_t* ior, bool isWeak );

        // conversion from a StubBase
        ParameterPort ( const ::sidl::StubBase& base );

        ior_t* _get_ior() { return d_self; }

        const ior_t* _get_ior() const { return d_self; }

        void _set_ior( ior_t* ptr ) { d_self = ptr; }

        bool _is_nil() const { return (d_self==0); }

        bool _not_nil() const { return (d_self!=0); }

        bool operator !() const { return (d_self==0); }

      protected:
        virtual void* _cast(const char* type) const;

      private:
        // Pointer to sidl's IOR type (one per instance)
        ior_t * d_self;

        // Weak references (used by Impl's only) don't add/deleteRef()
        bool d_weak_reference;

        // Pointer to external (DLL loadable) symbols (shared among instances)
        static const ext_t * s_ext;

      public:
        static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

      }; // end class ParameterPort
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::ports::ParameterPort > {
    typedef array< ::gov::cca::ports::ParameterPort > cxx_array_t;
    typedef ::gov::cca::ports::ParameterPort cxx_item_t;
    typedef struct gov_cca_ports_ParameterPort__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_ports_ParameterPort__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::ports::ParameterPort > > 
      iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::ports::ParameterPort > 
      > const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::ports::ParameterPort >: public interface_array< 
    array_traits< ::gov::cca::ports::ParameterPort > > {
  public:
    typedef interface_array< array_traits< ::gov::cca::ports::ParameterPort > > 
      Base;
    typedef array_traits< ::gov::cca::ports::ParameterPort >::cxx_array_t       
      cxx_array_t;
    typedef array_traits< ::gov::cca::ports::ParameterPort >::cxx_item_t        
      cxx_item_t;
    typedef array_traits< ::gov::cca::ports::ParameterPort >::ior_array_t       
      ior_array_t;
    typedef array_traits< ::gov::cca::ports::ParameterPort 
      >::ior_array_internal_t ior_array_internal_t;
    typedef array_traits< ::gov::cca::ports::ParameterPort >::ior_item_t        
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_ports_ParameterPort__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::ports::ParameterPort >&src) : Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::ports::ParameterPort >&
    operator =( const array< ::gov::cca::ports::ParameterPort >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
