// 
// File:          gov_cca_AbstractFramework.hh
// Symbol:        gov.cca.AbstractFramework-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.AbstractFramework
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_AbstractFramework_hh
#define included_gov_cca_AbstractFramework_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 

    class AbstractFramework;
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::AbstractFramework >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_AbstractFramework_IOR_h
#include "gov_cca_AbstractFramework_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_Services_hh
#include "gov_cca_Services.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 

    /**
     * Symbol "gov.cca.AbstractFramework" (version 0.6.3)
     * 
     *  This is an interface presented by a CCA-compliant framework to access its 
     *  application framing capabilities. Most of the manipulation of the 
     *  underlying framework is expected to be be done with the 
     *  gov.cca.BuilderService Port. This class exists as a sort of bootstrap 
     *  to get a Services object necessary to retrieve Port's, including 
     *  BuilderService, from the underlying framework. How the interface and 
     *  the underlying framework is created is entirely unspecified and is up 
     *  to the devices of the programmer and the framework provider.
     * 
     *  <p>Example</p>
     *  <p>
     *  Here it is assumed that an instance of AbstractFramework
     *  is created in the main() from some hypothetical implementation.
     *  The idea is to allow a complete swap of framework choice by 
     *  changing out the specified implementation class of a framework.
     *  </p>
     * 
     *  <code><pre>
     *  // java
     *  main() {
     *    cca.reference.Framework fwkimpl = new cca.reference.Framework();
     *    // change fwkimpl above to use different cca implementations when
     *    // AbstractFramework becomes part of the standard.
     *    gov.cca.AbstractFramework fwk = (gov.cca.AbstractFramework)fwkimpl;
     *    gov.cca.Services svc = 
     * 	   fwk.getServices("instance0","AppDriver",null);
     *    // From here on, access all services, components, etc
     *    // through svc.
     *    ...
     *    // when done
     *    fwk.releaseServices(svc);
     *    fwk.shutdownFramework();
     *  }
     * 
     *  // c++
     *  int functionName() {
     *    ::gov::sandia::ccafe::Framework fwkimpl;
     *    ::gov::cca::AbstractFrameworkPtr fwk;
     * 
     *    fwk = fwkimpl.getStandardFramework();
     *    ::gov::cca::Services_Interface * svc = 0;
     *    svc = fwk->getServices("instance0","AppDriver",0);
     *    // From here on, access all services, components, etc
     *    // through svc.
     *    ...
     *    // when done
     *    fwk->releaseServices(svc);
     *    svc = 0;
     *    fwk->shutdownFramework();
     * 
     *    // at scope exit, all memory is automatically cleaned up.
     *  }
     *  </pre></code>
     */
    class AbstractFramework : public ::sidl::StubBase {

      //////////////////////////////////////////////////
      // 
      // User Defined Methods
      // 

    public:

      /**
       * <p>
       * Add one to the intrinsic reference count in the underlying object.
       * Object in <code>sidl</code> have an intrinsic reference count.
       * Objects continue to exist as long as the reference count is
       * positive. Clients should call this method whenever they
       * create another ongoing reference to an object or interface.
       * </p>
       * <p>
       * This does not have a return value because there is no language
       * independent type that can refer to an interface or a
       * class.
       * </p>
       */
      inline void
      addRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_addRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
        }
      }



      /**
       * Decrease by one the intrinsic reference count in the underlying
       * object, and delete the object if the reference is non-positive.
       * Objects in <code>sidl</code> have an intrinsic reference count.
       * Clients should call this method whenever they remove a
       * reference to an object or interface.
       */
      inline void
      deleteRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
          d_self = 0;
        }
      }



      /**
       * Return true if and only if <code>obj</code> refers to the same
       * object as this object.
       */
      bool
      isSame (
        /* in */ ::sidl::BaseInterface iobj
      )
      throw () 
      ;



      /**
       * Check whether the object can support the specified interface or
       * class.  If the <code>sidl</code> type name in <code>name</code>
       * is supported, then a reference to that object is returned with the
       * reference count incremented.  The callee will be responsible for
       * calling <code>deleteRef</code> on the returned object.  If
       * the specified type is not supported, then a null reference is
       * returned.
       */
      ::sidl::BaseInterface
      queryInt (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return whether this object is an instance of the specified type.
       * The string name must be the <code>sidl</code> type name.  This
       * routine will return <code>true</code> if and only if a cast to
       * the string type name would succeed.
       */
      bool
      isType (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return the meta-data about the class implementing this interface.
       */
      ::sidl::ClassInfo
      getClassInfo() throw () 
      ;


      /**
       *  Create an empty TypeMap. Presumably this would be used in 
       *  an ensuing call to <code>getServices()</code>. The "normal" method of
       *  creating typemaps is found in the <code>Services</code> interface. It
       *  is duplicated here to break the "chicken and egg" problem.
       */
      ::gov::cca::TypeMap
      createTypeMap() throw ( 
        ::gov::cca::CCAException
      );


      /**
       * Retrieve a Services handle to the underlying framework. 
       * This interface effectively causes the calling program to 
       * appear as the image of a component inside the framework.
       * This method may be called any number of times
       * with different arguments, creating a new component image 
       * each time. 
       * The only proper method to destroy a Services obtained 
       * from this interface is to pass it to releaseServices.
       * 
       * @param selfInstanceName the Component instance name,
       * as it will appear in the framework.
       * 
       * @param selfClassName the Component type of the 
       * calling program, as it will appear in the framework. 
       * 
       * @param selfProperties (which can be null) the properties 
       * of the component image to appear. 
       * 
       * @throws CCAException in the event that selfInstanceName 
       * is already in use by another component.
       * 
       * @return  A Services object that pertains to the
       * 	    image of the this component. This is identical
       * 	    to the object passed into Component.setServices() 
       * 	    when a component is created.
       */
      ::gov::cca::Services
      getServices (
        /* in */ const ::std::string& selfInstanceName,
        /* in */ const ::std::string& selfClassName,
        /* in */ ::gov::cca::TypeMap selfProperties
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Inform framework that the <code>Services</code> handle is no longer needed by the 
       * caller and that the reference to its component image is to be
       * deleted from the context of the underlying framework. This invalidates
       * any <code>ComponentID</code>'s or <code>ConnectionID</code>'s associated 
       * with the given <code>Services</code>' component image. 
       * 
       * @param svc The result of getServices earlier obtained.
       * 
       * @throws CCAException if the <code>Services</code>
       *         handle has already been released or is otherwise rendered invalid 
       *         or was not obtained from <code>getServices()</code>.
       */
      void
      releaseServices (
        /* in */ ::gov::cca::Services svc
      )
      throw ( 
        ::gov::cca::CCAException
      );



      /**
       * Tell the framework it is no longer needed and to clean up after itself. 
       *  @throws CCAException if the framework has already been shutdown.
       */
      void
      shutdownFramework() throw ( 
        ::gov::cca::CCAException
      );


      /**
       * Creates a new framework instance based on the same underlying 
       * framework implementation. This does not copy the existing 
       * framework, nor are any of the user-instantiated components in
       * the original framework available in the newly created 
       * <code>AbstractFramework</code>. 
       * 
       * @throws CCAException when one of the following conditions occur:
       * 
       * (1)the AbstractFramework previously had shutdownFramework() called on it, or 
       * (2)the underlying framework implementation does not permit creation 
       * of another instance.	 
       */
      ::gov::cca::AbstractFramework
      createEmptyFramework() throw ( 
        ::gov::cca::CCAException
      );


      //////////////////////////////////////////////////
      // 
      // End User Defined Methods
      // (everything else in this file is specific to
      //  Babel's C++ bindings)
      // 

    public:
      typedef struct gov_cca_AbstractFramework__object ior_t;
      typedef struct gov_cca_AbstractFramework__external ext_t;
      typedef struct gov_cca_AbstractFramework__sepv sepv_t;

      // default constructor
      AbstractFramework() : d_self(0), d_weak_reference(false) { }

      // default destructor
      virtual ~AbstractFramework ();

      // copy constructor
      AbstractFramework ( const AbstractFramework& original );

      // assignment operator
      AbstractFramework& operator= ( const AbstractFramework& rhs );

      // conversion from ior to C++ class
      AbstractFramework ( AbstractFramework::ior_t* ior );

      // Alternate constructor: does not call addRef()
      // (sets d_weak_reference=isWeak)
      // For internal use by Impls (fixes bug#275)
      AbstractFramework ( AbstractFramework::ior_t* ior, bool isWeak );

      // conversion from a StubBase
      AbstractFramework ( const ::sidl::StubBase& base );

      ior_t* _get_ior() { return d_self; }

      const ior_t* _get_ior() const { return d_self; }

      void _set_ior( ior_t* ptr ) { d_self = ptr; }

      bool _is_nil() const { return (d_self==0); }

      bool _not_nil() const { return (d_self!=0); }

      bool operator !() const { return (d_self==0); }

    protected:
      virtual void* _cast(const char* type) const;

    private:
      // Pointer to sidl's IOR type (one per instance)
      ior_t * d_self;

      // Weak references (used by Impl's only) don't add/deleteRef()
      bool d_weak_reference;

      // Pointer to external (DLL loadable) symbols (shared among instances)
      static const ext_t * s_ext;

    public:
      static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

    }; // end class AbstractFramework
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::AbstractFramework > {
    typedef array< ::gov::cca::AbstractFramework > cxx_array_t;
    typedef ::gov::cca::AbstractFramework cxx_item_t;
    typedef struct gov_cca_AbstractFramework__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_AbstractFramework__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::AbstractFramework > > 
      iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::AbstractFramework > > 
      const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::AbstractFramework >: public interface_array< 
    array_traits< ::gov::cca::AbstractFramework > > {
  public:
    typedef interface_array< array_traits< ::gov::cca::AbstractFramework > > 
      Base;
    typedef array_traits< ::gov::cca::AbstractFramework >::cxx_array_t          
      cxx_array_t;
    typedef array_traits< ::gov::cca::AbstractFramework >::cxx_item_t           
      cxx_item_t;
    typedef array_traits< ::gov::cca::AbstractFramework >::ior_array_t          
      ior_array_t;
    typedef array_traits< ::gov::cca::AbstractFramework >::ior_array_internal_t 
      ior_array_internal_t;
    typedef array_traits< ::gov::cca::AbstractFramework >::ior_item_t           
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_AbstractFramework__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::AbstractFramework >&src) : Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::AbstractFramework >&
    operator =( const array< ::gov::cca::AbstractFramework >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
