/*
 * Decompiled with CFR 0.152.
 */
package sidl;

import gov.llnl.sidl.BaseArray;
import gov.llnl.sidl.BaseClass;
import java.io.Serializable;
import sidl.Sfun;

public class FloatComplex
implements Serializable,
Cloneable {
    private float re;
    private float im;
    static final long serialVersionUID = -633126172485117692L;
    public static String suffix = "i";
    private static final float PI = (float)Math.PI;
    private static final int negZeroBits = Float.floatToIntBits(-0.0f);

    public FloatComplex(FloatComplex z) {
        this.re = z.re;
        this.im = z.im;
    }

    public FloatComplex(float re, float im) {
        this.re = re;
        this.im = im;
    }

    public FloatComplex(float re) {
        this.re = re;
        this.im = 0.0f;
    }

    public FloatComplex() {
        this.re = 0.0f;
        this.im = 0.0f;
    }

    private boolean isNaN() {
        return Float.isNaN(this.re) || Float.isNaN(this.im);
    }

    public boolean equals(FloatComplex z) {
        if (this.isNaN() && z.isNaN()) {
            return true;
        }
        return this.re == z.re && this.im == z.im;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FloatComplex) {
            return this.equals((FloatComplex)obj);
        }
        return false;
    }

    public int hashCode() {
        int re_bits = Float.floatToIntBits(this.re);
        int im_bits = Float.floatToIntBits(this.im);
        return re_bits ^ im_bits;
    }

    public void set(float real, float imag) {
        this.re = real;
        this.im = imag;
    }

    public float real() {
        return this.re;
    }

    public float imag() {
        return this.im;
    }

    public static float real(FloatComplex z) {
        return z.re;
    }

    public static float imag(FloatComplex z) {
        return z.im;
    }

    public static FloatComplex negative(FloatComplex z) {
        return new FloatComplex(-z.re, -z.im);
    }

    public static FloatComplex conjugate(FloatComplex z) {
        return new FloatComplex(z.re, -z.im);
    }

    public static FloatComplex plus(FloatComplex x, FloatComplex y) {
        return new FloatComplex(x.re + y.re, x.im + y.im);
    }

    public static FloatComplex plus(FloatComplex x, float y) {
        return new FloatComplex(x.re + y, x.im);
    }

    public static FloatComplex plus(float x, FloatComplex y) {
        return new FloatComplex(x + y.re, y.im);
    }

    public FloatComplex plus(FloatComplex y) {
        return new FloatComplex(this.re + y.re, this.im + y.im);
    }

    public FloatComplex plus(float y) {
        return new FloatComplex(this.re + y, this.im);
    }

    public FloatComplex plusReverse(float x) {
        return new FloatComplex(this.re + x, this.im);
    }

    public static FloatComplex minus(FloatComplex x, FloatComplex y) {
        return new FloatComplex(x.re - y.re, x.im - y.im);
    }

    public static FloatComplex minus(FloatComplex x, float y) {
        return new FloatComplex(x.re - y, x.im);
    }

    public static FloatComplex minus(float x, FloatComplex y) {
        return new FloatComplex(x - y.re, -y.im);
    }

    public FloatComplex minus(FloatComplex y) {
        return new FloatComplex(this.re - y.re, this.im - y.im);
    }

    public FloatComplex minus(float y) {
        return new FloatComplex(this.re - y, this.im);
    }

    public FloatComplex minusReverse(float x) {
        return new FloatComplex(x - this.re, -this.im);
    }

    public static FloatComplex times(FloatComplex x, FloatComplex y) {
        FloatComplex t = new FloatComplex(x.re * y.re - x.im * y.im, x.re * y.im + x.im * y.re);
        if (Float.isNaN(t.re) && Float.isNaN(t.im)) {
            FloatComplex.timesNaN(x, y, t);
        }
        return t;
    }

    private static float copysign(float a, float b) {
        float abs = Math.abs(a);
        return b < 0.0f ? -abs : abs;
    }

    private static void timesNaN(FloatComplex x, FloatComplex y, FloatComplex t) {
        boolean recalc = false;
        float a = x.re;
        float b = x.im;
        float c = y.re;
        float d = y.im;
        if (Float.isInfinite(a) || Float.isInfinite(b)) {
            a = FloatComplex.copysign(Float.isInfinite(a) ? 1.0f : 0.0f, a);
            b = FloatComplex.copysign(Float.isInfinite(b) ? 1.0f : 0.0f, b);
            if (Float.isNaN(c)) {
                c = FloatComplex.copysign(0.0f, c);
            }
            if (Float.isNaN(d)) {
                d = FloatComplex.copysign(0.0f, d);
            }
            recalc = true;
        }
        if (Float.isInfinite(c) || Float.isInfinite(d)) {
            a = FloatComplex.copysign(Float.isInfinite(c) ? 1.0f : 0.0f, c);
            b = FloatComplex.copysign(Float.isInfinite(d) ? 1.0f : 0.0f, d);
            if (Float.isNaN(a)) {
                a = FloatComplex.copysign(0.0f, a);
            }
            if (Float.isNaN(b)) {
                b = FloatComplex.copysign(0.0f, b);
            }
            recalc = true;
        }
        if (!recalc && (Float.isInfinite(a * c) || Float.isInfinite(b * d) || Float.isInfinite(a * d) || Float.isInfinite(b * c))) {
            if (Float.isNaN(a)) {
                a = FloatComplex.copysign(0.0f, a);
            }
            if (Float.isNaN(b)) {
                b = FloatComplex.copysign(0.0f, b);
            }
            if (Float.isNaN(c)) {
                c = FloatComplex.copysign(0.0f, c);
            }
            if (Float.isNaN(d)) {
                d = FloatComplex.copysign(0.0f, d);
            }
            recalc = true;
        }
        if (recalc) {
            t.re = Float.POSITIVE_INFINITY * (a * c - b * d);
            t.im = Float.POSITIVE_INFINITY * (a * d + b * c);
        }
    }

    public static FloatComplex times(FloatComplex x, float y) {
        return new FloatComplex(x.re * y, x.im * y);
    }

    public static FloatComplex times(float x, FloatComplex y) {
        return new FloatComplex(x * y.re, x * y.im);
    }

    public FloatComplex times(FloatComplex y) {
        return FloatComplex.times(this, y);
    }

    public FloatComplex times(float y) {
        return new FloatComplex(this.re * y, this.im * y);
    }

    public FloatComplex timesReverse(float x) {
        return new FloatComplex(x * this.re, x * this.im);
    }

    private static boolean isFinite(float x) {
        return !Float.isInfinite(x) && !Float.isNaN(x);
    }

    public static FloatComplex over(FloatComplex x, FloatComplex y) {
        float a = x.re;
        float b = x.im;
        float c = y.re;
        float d = y.im;
        float scale = Math.max(Math.abs(c), Math.abs(d));
        boolean isScaleFinite = FloatComplex.isFinite(scale);
        if (isScaleFinite) {
            c /= scale;
            d /= scale;
        }
        float den = c * c + d * d;
        FloatComplex z = new FloatComplex((a * c + b * d) / den, (b * c - a * d) / den);
        if (isScaleFinite) {
            z.re /= scale;
            z.im /= scale;
        }
        if (Float.isNaN(z.re) && Float.isNaN(z.im)) {
            if (!(den != 0.0f || Float.isNaN(a) && Float.isNaN(b))) {
                float s = FloatComplex.copysign(Float.POSITIVE_INFINITY, c);
                z.re = s * a;
                z.im = s * b;
            } else if ((Float.isInfinite(a) || Float.isInfinite(b)) && FloatComplex.isFinite(c) && FloatComplex.isFinite(d)) {
                a = FloatComplex.copysign(Float.isInfinite(a) ? 1.0f : 0.0f, a);
                b = FloatComplex.copysign(Float.isInfinite(b) ? 1.0f : 0.0f, b);
                z.re = Float.POSITIVE_INFINITY * (a * c + b * d);
                z.im = Float.POSITIVE_INFINITY * (b * c - a * d);
            } else if (Float.isInfinite(scale) && FloatComplex.isFinite(a) && FloatComplex.isFinite(b)) {
                c = FloatComplex.copysign(Float.isInfinite(c) ? 1.0f : 0.0f, c);
                d = FloatComplex.copysign(Float.isInfinite(d) ? 1.0f : 0.0f, d);
                z.re = 0.0f * (a * c + b * d);
                z.im = 0.0f * (b * c - a * d);
            }
        }
        return z;
    }

    public static FloatComplex over(FloatComplex x, float y) {
        return new FloatComplex(x.re / y, x.im / y);
    }

    public static FloatComplex over(float x, FloatComplex y) {
        return y.overReverse(x);
    }

    public FloatComplex over(FloatComplex y) {
        return FloatComplex.over(this, y);
    }

    public FloatComplex over(float y) {
        return FloatComplex.over(this, y);
    }

    public FloatComplex overReverse(float x) {
        FloatComplex z;
        if (Math.abs(this.re) > Math.abs(this.im)) {
            float t = this.im / this.re;
            float den = this.re + this.im * t;
            z = new FloatComplex(x / den, -x * t / den);
        } else {
            float t = this.re / this.im;
            float den = this.im + this.re * t;
            z = new FloatComplex(x * t / den, -x / den);
        }
        return z;
    }

    public static float abs(FloatComplex z) {
        float x = Math.abs(z.re);
        float y = Math.abs(z.im);
        if (Float.isInfinite(x) || Float.isInfinite(y)) {
            return Float.POSITIVE_INFINITY;
        }
        if (x + y == 0.0f) {
            return 0.0f;
        }
        if (x > y) {
            return x * (float)Math.sqrt(1.0f + (y /= x) * y);
        }
        return y * (float)Math.sqrt((x /= y) * x + 1.0f);
    }

    public static float argument(FloatComplex z) {
        return (float)Math.atan2(z.im, z.re);
    }

    public static FloatComplex sqrt(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        if (Float.isInfinite(z.im)) {
            result.re = Float.POSITIVE_INFINITY;
            result.im = z.im;
        } else if (Float.isNaN(z.re)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
        } else if (Float.isNaN(z.im)) {
            if (Float.isInfinite(z.re)) {
                if (z.re > 0.0f) {
                    result.re = z.re;
                    result.im = z.im;
                } else {
                    result.re = z.im;
                    result.im = Float.POSITIVE_INFINITY;
                }
            } else {
                result.im = Float.NaN;
                result.re = Float.NaN;
            }
        } else {
            float t = FloatComplex.abs(z);
            if (Math.abs(z.re) <= Math.abs(z.im)) {
                result.re = (float)Math.sqrt(0.5 * (double)(t + z.re));
                result.im = (float)Math.sqrt(0.5 * (double)(t - z.re));
            } else if (z.re > 0.0f) {
                result.re = t + z.re;
                result.im = Math.abs(z.im) * (float)Math.sqrt(0.5 / (double)result.re);
                result.re = (float)Math.sqrt(0.5 * (double)result.re);
            } else {
                result.im = t - z.re;
                result.re = Math.abs(z.im) * (float)Math.sqrt(0.5 / (double)result.im);
                result.im = (float)Math.sqrt(0.5 * (double)result.im);
            }
            if (z.im < 0.0f) {
                result.im = -result.im;
            }
        }
        return result;
    }

    public static FloatComplex exp(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = (float)Math.exp(z.re);
        float cosa = (float)Math.cos(z.im);
        float sina = (float)Math.sin(z.im);
        if (Float.isInfinite(z.im) || Float.isNaN(z.im) || Math.abs(cosa) > 1.0f) {
            sina = Float.NaN;
            cosa = Float.NaN;
        }
        if (Float.isInfinite(z.re) || Float.isInfinite(r)) {
            if (z.re < 0.0f) {
                r = 0.0f;
                if (Float.isInfinite(z.im) || Float.isNaN(z.im)) {
                    sina = 0.0f;
                    cosa = 0.0f;
                } else {
                    cosa /= Float.POSITIVE_INFINITY;
                    sina /= Float.POSITIVE_INFINITY;
                }
            } else {
                r = z.re;
                if (Float.isNaN(z.im)) {
                    cosa = 1.0f;
                }
            }
        }
        if ((double)z.im == 0.0) {
            result.re = r;
            result.im = z.im;
        } else {
            result.re = r * cosa;
            result.im = r * sina;
        }
        return result;
    }

    public static FloatComplex log(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        if (Float.isNaN(z.re)) {
            result.re = result.im = z.re;
            if (Float.isInfinite(z.im)) {
                result.re = Float.POSITIVE_INFINITY;
            }
        } else if (Float.isNaN(z.im)) {
            result.re = result.im = z.im;
            if (Float.isInfinite(z.re)) {
                result.re = Float.POSITIVE_INFINITY;
            }
        } else {
            result.re = (float)Math.log(FloatComplex.abs(z));
            result.im = FloatComplex.argument(z);
        }
        return result;
    }

    public static FloatComplex sin(FloatComplex z) {
        FloatComplex iz = new FloatComplex(-z.im, z.re);
        FloatComplex s = FloatComplex.sinh(iz);
        float re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static FloatComplex cos(FloatComplex z) {
        return FloatComplex.cosh(new FloatComplex(-z.im, z.re));
    }

    public static FloatComplex tan(FloatComplex z) {
        FloatComplex iz = new FloatComplex(-z.im, z.re);
        FloatComplex s = FloatComplex.tanh(iz);
        float re = s.im;
        s.im = -s.re;
        s.re = re;
        return s;
    }

    public static FloatComplex asin(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(r)) {
            boolean infiniteX = Float.isInfinite(z.re);
            boolean infiniteY = Float.isInfinite(z.im);
            if (infiniteX) {
                float pi2 = 1.5707964f;
                float f = result.re = z.re > 0.0f ? pi2 : -pi2;
                if (infiniteY) {
                    result.re /= 2.0f;
                }
            } else if (infiniteY) {
                result.re = z.re / Float.POSITIVE_INFINITY;
            }
            if (Float.isNaN(z.im)) {
                result.im = -z.re;
                result.re = z.im;
            } else {
                result.im = z.im * Float.POSITIVE_INFINITY;
            }
            return result;
        }
        if (Float.isNaN(r)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
            if (z.re == 0.0f) {
                result.re = z.re;
            }
        } else if ((double)r < 2.58095E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if (z.re == 0.0f) {
            result.re = 0.0f;
            result.im = (float)Sfun.asinh(z.im);
        } else if (r <= 0.1f) {
            FloatComplex z2 = FloatComplex.times(z, z);
            for (int i = 1; i <= 8; ++i) {
                float twoi = 2.0f * (8.0f - (float)i) + 1.0f;
                result = FloatComplex.times(FloatComplex.times(result, z2), twoi / (twoi + 1.0f));
                result.re += 1.0f / twoi;
            }
            result = result.times(z);
        } else {
            FloatComplex w = z.im < 0.0f ? FloatComplex.negative(z) : z;
            FloatComplex sqzp1 = FloatComplex.sqrt(FloatComplex.plus(w, 1.0f));
            if (sqzp1.im < 0.0f) {
                sqzp1 = FloatComplex.negative(sqzp1);
            }
            FloatComplex sqzm1 = FloatComplex.sqrt(FloatComplex.minus(w, 1.0f));
            result = FloatComplex.log(FloatComplex.plus(w, FloatComplex.times(sqzp1, sqzm1)));
            float rx = result.re;
            result.re = 1.5707964f + result.im;
            result.im = -rx;
        }
        if (result.re > 1.5707964f) {
            result.re = (float)Math.PI - result.re;
            result.im = -result.im;
        }
        if (result.re < -1.5707964f) {
            result.re = (float)(-Math.PI) - result.re;
            result.im = -result.im;
        }
        if (z.im < 0.0f) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    public static FloatComplex acos(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(z.re) && Float.isNaN(z.im)) {
            result.re = Float.NaN;
            result.im = Float.NEGATIVE_INFINITY;
        } else if (Float.isInfinite(r)) {
            result.re = (float)Math.atan2(Math.abs(z.im), z.re);
            result.im = z.im * Float.NEGATIVE_INFINITY;
        } else if (r == 0.0f) {
            result.re = 1.5707964f;
            result.im = -z.im;
        } else {
            result = FloatComplex.minus(1.5707964f, FloatComplex.asin(z));
        }
        return result;
    }

    public static FloatComplex atan(FloatComplex z) {
        FloatComplex result = new FloatComplex();
        float r = FloatComplex.abs(z);
        if (Float.isInfinite(r)) {
            float pi2 = 1.5707964f;
            float im = Float.isNaN(z.im) ? 0.0f : z.im;
            result.re = z.re < 0.0f ? -pi2 : pi2;
            result.im = (float)(im < 0.0f ? -1 : 1) / Float.POSITIVE_INFINITY;
            if (Float.isNaN(z.re)) {
                result.re = z.re;
            }
        } else if (Float.isNaN(r)) {
            result.im = Float.NaN;
            result.re = Float.NaN;
            if (z.im == 0.0f) {
                result.im = z.im;
            }
        } else if ((double)r < 1.82501E-8) {
            result.re = z.re;
            result.im = z.im;
        } else if ((double)r < 0.1) {
            FloatComplex z2 = FloatComplex.times(z, z);
            for (int k = 0; k < 17; ++k) {
                FloatComplex temp = FloatComplex.times(z2, result);
                int twoi = 2 * (17 - k) - 1;
                result.re = 1.0f / (float)twoi - temp.re;
                result.im = -temp.im;
            }
            result = result.times(z);
        } else if ((double)r < 9.0072E15) {
            float r2 = r * r;
            result.re = 0.5f * (float)Math.atan2(2.0f * z.re, 1.0 - (double)r2);
            result.im = 0.25f * (float)Math.log((r2 + 2.0f * z.im + 1.0f) / (r2 - 2.0f * z.im + 1.0f));
        } else {
            result.re = z.re < 0.0f ? -1.5707964f : 1.5707964f;
        }
        return result;
    }

    public static FloatComplex sinh(FloatComplex z) {
        FloatComplex result;
        float coshx = (float)Sfun.cosh(z.re);
        float sinhx = (float)Sfun.sinh(z.re);
        float cosy = (float)Math.cos(z.im);
        float siny = (float)Math.sin(z.im);
        boolean infiniteX = Float.isInfinite(coshx);
        boolean infiniteY = Float.isInfinite(z.im);
        if (z.im == 0.0f) {
            result = new FloatComplex((float)Sfun.sinh(z.re));
        } else {
            result = new FloatComplex(sinhx * cosy, coshx * siny);
            if (infiniteY) {
                result.im = Float.NaN;
                if (z.re == 0.0f) {
                    result.re = 0.0f;
                }
            }
            if (infiniteX) {
                result.re = z.re * cosy;
                result.im = z.re * siny;
                if (z.im == 0.0f) {
                    result.im = 0.0f;
                }
                if (infiniteY) {
                    result.re = z.im;
                }
            }
        }
        return result;
    }

    public static FloatComplex cosh(FloatComplex z) {
        if (z.im == 0.0f) {
            return new FloatComplex((float)Sfun.cosh(z.re));
        }
        float coshx = (float)Sfun.cosh(z.re);
        float sinhx = (float)Sfun.sinh(z.re);
        float cosy = (float)Math.cos(z.im);
        float siny = (float)Math.sin(z.im);
        boolean infiniteX = Float.isInfinite(coshx);
        boolean infiniteY = Float.isInfinite(z.im);
        FloatComplex result = new FloatComplex(coshx * cosy, sinhx * siny);
        if (infiniteY) {
            result.re = Float.NaN;
        }
        if (z.re == 0.0f) {
            result.im = 0.0f;
        } else if (infiniteX) {
            result.re = z.re * cosy;
            result.im = z.re * siny;
            if (z.im == 0.0f) {
                result.im = 0.0f;
            }
            if (Float.isNaN(z.im)) {
                result.re = z.re;
            } else if (infiniteY) {
                result.re = z.im;
            }
        }
        return result;
    }

    public static FloatComplex tanh(FloatComplex z) {
        float sinh2x = (float)Sfun.sinh(2.0f * z.re);
        if (z.im == 0.0f) {
            return new FloatComplex((float)Sfun.tanh(z.re));
        }
        if (sinh2x == 0.0f) {
            return new FloatComplex(0.0f, (float)Math.tan(z.im));
        }
        float cosh2x = (float)Sfun.cosh(2.0 * (double)z.re);
        float cos2y = (float)Math.cos(2.0 * (double)z.im);
        float sin2y = (float)Math.sin(2.0 * (double)z.im);
        boolean infiniteX = Float.isInfinite(cosh2x);
        if (Float.isInfinite(z.im) || Float.isNaN(z.im)) {
            sin2y = Float.NaN;
            cos2y = Float.NaN;
        }
        if (infiniteX) {
            return new FloatComplex(z.re > 0.0f ? 1.0f : -1.0f);
        }
        float den = cosh2x + cos2y;
        return new FloatComplex(sinh2x / den, sin2y / den);
    }

    public static FloatComplex pow(FloatComplex z, float x) {
        float absz = FloatComplex.abs(z);
        FloatComplex result = new FloatComplex();
        if ((double)absz == 0.0) {
            result = z;
        } else {
            float a = FloatComplex.argument(z);
            float e = (float)Math.pow(absz, x);
            result.re = e * (float)Math.cos(x * a);
            result.im = e * (float)Math.sin(x * a);
        }
        return result;
    }

    public static FloatComplex asinh(FloatComplex z) {
        FloatComplex miz = new FloatComplex(z.im, -z.re);
        FloatComplex result = FloatComplex.asin(miz);
        float rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static FloatComplex acosh(FloatComplex z) {
        FloatComplex result = FloatComplex.acos(z);
        float rx = -result.im;
        result.im = result.re;
        result.re = rx;
        if (result.re < 0.0f || FloatComplex.isNegZero(result.re)) {
            result.re = -result.re;
            result.im = -result.im;
        }
        return result;
    }

    private static boolean isNegZero(float x) {
        return Float.floatToIntBits(x) == negZeroBits;
    }

    public static FloatComplex atanh(FloatComplex z) {
        FloatComplex miz = new FloatComplex(z.im, -z.re);
        FloatComplex result = FloatComplex.atan(miz);
        float rx = result.im;
        result.im = result.re;
        result.re = -rx;
        return result;
    }

    public static FloatComplex pow(FloatComplex x, FloatComplex y) {
        return FloatComplex.exp(FloatComplex.times(y, FloatComplex.log(x)));
    }

    public String toString() {
        if ((double)this.im == 0.0) {
            return String.valueOf(this.re);
        }
        if ((double)this.re == 0.0) {
            return String.valueOf(this.im) + suffix;
        }
        String sign = (double)this.im < 0.0 ? "" : "+";
        return String.valueOf(this.re) + sign + String.valueOf(this.im) + suffix;
    }

    public static FloatComplex valueOf(String s) throws NumberFormatException {
        String input = s.trim();
        int iBeginNumber = 0;
        FloatComplex z = new FloatComplex();
        int state = 0;
        int sign = 1;
        boolean haveRealPart = false;
        block7: for (int k = 0; k < input.length(); ++k) {
            char ch = input.charAt(k);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == 0 || state == 1) {
                        state = 2;
                        continue block7;
                    }
                    if (state != 4) continue block7;
                    state = 5;
                    continue block7;
                }
                case '+': 
                case '-': {
                    int n = sign = ch == '+' ? 1 : -1;
                    if (state == 0) {
                        state = 1;
                        continue block7;
                    }
                    if (state == 4) {
                        state = 5;
                        continue block7;
                    }
                    if (!haveRealPart) {
                        z.re = Float.valueOf(input.substring(iBeginNumber, k)).floatValue();
                        haveRealPart = true;
                        iBeginNumber = k;
                        state = 1;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case '.': {
                    if (state == 0 || state == 1 || state == 2) {
                        state = 3;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                case 'I': 
                case 'J': 
                case 'i': 
                case 'j': {
                    if (k + 1 != input.length()) {
                        throw new NumberFormatException(input);
                    }
                    if (state == 0 || state == 1) {
                        z.im = sign;
                        return z;
                    }
                    if (state == 2 || state == 3 || state == 5) {
                        z.im = Float.valueOf(input.substring(iBeginNumber, k)).floatValue();
                        return z;
                    }
                    throw new NumberFormatException(input);
                }
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    if (state == 2 || state == 3) {
                        state = 4;
                        continue block7;
                    }
                    throw new NumberFormatException(input);
                }
                default: {
                    throw new NumberFormatException(input);
                }
            }
        }
        if (!haveRealPart) {
            z.re = Float.valueOf(input).floatValue();
            return z;
        }
        throw new NumberFormatException(input);
    }

    public static class Array7
    extends Array {
        public Array7() {
        }

        protected Array7(long array, boolean owner) {
            super(array, owner);
        }

        public Array7(int l0, int l1, int l2, int l3, int l4, int l5, int l6, int u0, int u1, int u2, int u3, int u4, int u5, int u6, boolean isRow) {
            super(7, new int[]{l0, l1, l2, l3, l4, l5, l6}, new int[]{u0, u1, u2, u3, u4, u5, u6}, isRow);
        }

        public Array7(int s0, int s1, int s2, int s3, int s4, int s5, int s6, boolean isRow) {
            super(7, new int[]{0, 0, 0, 0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1, s3 - 1, s4 - 1, s5 - 1, s6 - 1}, isRow);
        }

        public Array7(FloatComplex[][][][][][][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j, int k, int l, int m, int n, int o) {
            return super._get(i, j, k, l, m, n, o);
        }

        public FloatComplex get(int i, int j, int k, int l, int m, int n, int o) {
            this.checkBounds(i, j, k, l, m, n, o);
            return this._get(i, j, k, l, m, n, o);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int l4, int l5, int l6, int u0, int u1, int u2, int u3, int u4, int u5, int u6, boolean isRow) {
            this.reallocate(7, new int[]{l0, l1, l2, l3, l4, l5, l6}, new int[]{u0, u1, u2, u3, u4, u5, u6}, isRow);
        }

        public Array7 smartCopy() {
            return (Array7)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array7 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, int k, int l, int m, int n, int o, FloatComplex value) {
            super._set(i, j, k, l, m, n, o, value);
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, FloatComplex value) {
            this.checkBounds(i, j, k, l, m, n, o);
            this._set(i, j, k, l, m, n, o, value);
        }

        public FloatComplex[][][][][][][] toArray() {
            FloatComplex[][][][][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(6);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                int l4 = this._lower(4);
                int u4 = this._upper(4);
                int l5 = this._lower(5);
                int u5 = this._upper(5);
                int l6 = this._lower(6);
                int u6 = this._upper(6);
                array = new FloatComplex[u0 - l0 + 1][][][][][][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1][][][][][];
                    for (int j = l1; j <= u1; ++j) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1][][][][];
                        for (int k = l2; k <= u2; ++k) {
                            array[i][j][k] = new FloatComplex[u3 - l3 + 1][][][];
                            for (int l = l3; l <= u3; ++l) {
                                array[i][j][k][l] = new FloatComplex[u4 - l4 + 1][][];
                                for (int m = l4; m <= u4; ++m) {
                                    array[i][j][k][l][m] = new FloatComplex[u4 - l4 + 1][];
                                    for (int n = l5; n <= u5; ++n) {
                                        array[i][j][k][l][m][n] = new FloatComplex[u5 - l5 + 1];
                                        for (int o = l6; o <= u6; ++o) {
                                            array[i - l0][j - l1][k - l2][l - l3][m - l4][n - l5][o - l6] = this._get(i, j, k, l, m, n, o);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][][][][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                int s4 = array[0][0][0][0].length - 1;
                int s5 = array[0][0][0][0][0].length - 1;
                int s6 = array[0][0][0][0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, 0, 0, 0, s0, s1, s2, s3, s4, s5, s6, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        for (int k = 0; k <= s2; ++k) {
                            for (int l = 0; l <= s3; ++l) {
                                for (int m = 0; m <= s4; ++m) {
                                    for (int n = 0; n <= s5; ++n) {
                                        for (int o = 0; o <= s6; ++o) {
                                            this._set(i, j, k, l, m, n, o, array[i][j][k][l][m][n][o]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static class Holder {
            private Array7 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array7 obj) {
                this.d_obj = obj;
            }

            public void set(Array7 obj) {
                this.d_obj = obj;
            }

            public Array7 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array6
    extends Array {
        public Array6() {
        }

        protected Array6(long array, boolean owner) {
            super(array, owner);
        }

        public Array6(int l0, int l1, int l2, int l3, int l4, int l5, int u0, int u1, int u2, int u3, int u4, int u5, boolean isRow) {
            super(6, new int[]{l0, l1, l2, l3, l4, l5}, new int[]{u0, u1, u2, u3, u4, u5}, isRow);
        }

        public Array6(int s0, int s1, int s2, int s3, int s4, int s5, boolean isRow) {
            super(6, new int[]{0, 0, 0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1, s3 - 1, s4 - 1, s5 - 1}, isRow);
        }

        public Array6(FloatComplex[][][][][][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j, int k, int l, int m, int n) {
            return this._get(i, j, k, l, m, n, 0);
        }

        public FloatComplex get(int i, int j, int k, int l, int m, int n) {
            this.checkBounds(i, j, k, l, m, n);
            return this._get(i, j, k, l, m, n, 0);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int l4, int l5, int u0, int u1, int u2, int u3, int u4, int u5, boolean isRow) {
            this.reallocate(6, new int[]{l0, l1, l2, l3, l4, l5}, new int[]{u0, u1, u2, u3, u4, u5}, isRow);
        }

        public Array6 smartCopy() {
            return (Array6)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array6 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, int k, int l, int m, int n, FloatComplex value) {
            this._set(i, j, k, l, m, n, 0, value);
        }

        public void set(int i, int j, int k, int l, int m, int n, FloatComplex value) {
            this.checkBounds(i, j, k, l, m, n);
            this._set(i, j, k, l, m, n, 0, value);
        }

        public FloatComplex[][][][][][] toArray() {
            FloatComplex[][][][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(6);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                int l4 = this._lower(4);
                int u4 = this._upper(4);
                int l5 = this._lower(5);
                int u5 = this._upper(5);
                array = new FloatComplex[u0 - l0 + 1][][][][][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1][][][][];
                    for (int j = l1; j <= u1; ++j) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1][][][];
                        for (int k = l2; k <= u2; ++k) {
                            array[i][j][k] = new FloatComplex[u3 - l3 + 1][][];
                            for (int l = l3; l <= u3; ++l) {
                                array[i][j][k][l] = new FloatComplex[u4 - l4 + 1][];
                                for (int m = l4; m <= u4; ++m) {
                                    array[i][j][k][l][m] = new FloatComplex[u4 - l4 + 1];
                                    for (int n = l5; n <= u5; ++n) {
                                        array[i - l0][j - l1][k - l2][l - l3][m - l4][n - l5] = this._get(i, j, k, l, m, n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][][][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                int s4 = array[0][0][0][0].length - 1;
                int s5 = array[0][0][0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, 0, 0, s0, s1, s2, s3, s4, s5, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        for (int k = 0; k <= s2; ++k) {
                            for (int l = 0; l <= s3; ++l) {
                                for (int m = 0; m <= s4; ++m) {
                                    for (int n = 0; n <= s5; ++n) {
                                        this._set(i, j, k, l, m, n, array[i][j][k][l][m][n]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public static class Holder {
            private Array6 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array6 obj) {
                this.d_obj = obj;
            }

            public void set(Array6 obj) {
                this.d_obj = obj;
            }

            public Array6 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array5
    extends Array {
        public Array5() {
        }

        protected Array5(long array, boolean owner) {
            super(array, owner);
        }

        public Array5(int l0, int l1, int l2, int l3, int l4, int u0, int u1, int u2, int u3, int u4, boolean isRow) {
            super(5, new int[]{l0, l1, l2, l3, l4}, new int[]{u0, u1, u2, u3, u4}, isRow);
        }

        public Array5(int s0, int s1, int s2, int s3, int s4, boolean isRow) {
            super(5, new int[]{0, 0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1, s3 - 1, s4 - 1}, isRow);
        }

        public Array5(FloatComplex[][][][][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j, int k, int l, int m) {
            return this._get(i, j, k, l, m, 0, 0);
        }

        public FloatComplex get(int i, int j, int k, int l, int m) {
            this.checkBounds(i, j, k, l, m);
            return this._get(i, j, k, l, m, 0, 0);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int l4, int u0, int u1, int u2, int u3, int u4, boolean isRow) {
            this.reallocate(5, new int[]{l0, l1, l2, l3, l4}, new int[]{u0, u1, u2, u3, u4}, isRow);
        }

        public Array5 smartCopy() {
            return (Array5)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array5 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, int k, int l, int m, FloatComplex value) {
            this._set(i, j, k, l, m, 0, 0, value);
        }

        public void set(int i, int j, int k, int l, int m, FloatComplex value) {
            this.checkBounds(i, j, k, l, m);
            this._set(i, j, k, l, m, 0, 0, value);
        }

        public FloatComplex[][][][][] toArray() {
            FloatComplex[][][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(5);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                int l4 = this._lower(4);
                int u4 = this._upper(4);
                array = new FloatComplex[u0 - l0 + 1][][][][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1][][][];
                    for (int j = l1; j <= u1; ++j) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1][][];
                        for (int k = l2; k <= u2; ++k) {
                            array[i][j][k] = new FloatComplex[u3 - l3 + 1][];
                            for (int l = l3; l <= u3; ++l) {
                                array[i][j][k][l] = new FloatComplex[u4 - l4 + 1];
                                for (int m = l4; m <= u4; ++m) {
                                    array[i - l0][j - l1][k - l2][l - l3][m - l4] = this._get(i, j, k, l, m);
                                }
                            }
                        }
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                int s4 = array[0][0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, 0, s0, s1, s2, s3, s4, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        for (int k = 0; k <= s2; ++k) {
                            for (int l = 0; l <= s3; ++l) {
                                for (int m = 0; m <= s4; ++m) {
                                    this._set(i, j, k, l, m, array[i][j][k][l][m]);
                                }
                            }
                        }
                    }
                }
            }
        }

        public static class Holder {
            private Array5 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array5 obj) {
                this.d_obj = obj;
            }

            public void set(Array5 obj) {
                this.d_obj = obj;
            }

            public Array5 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array4
    extends Array {
        public Array4() {
        }

        protected Array4(long array, boolean owner) {
            super(array, owner);
        }

        public Array4(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3, boolean isRow) {
            super(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, u3}, isRow);
        }

        public Array4(int s0, int s1, int s2, int s3, boolean isRow) {
            super(4, new int[]{0, 0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1, s3 - 1}, isRow);
        }

        public Array4(FloatComplex[][][][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j, int k, int l) {
            return this._get(i, j, k, l, 0, 0, 0);
        }

        public FloatComplex get(int i, int j, int k, int l) {
            this.checkBounds(i, j, k, l);
            return this._get(i, j, k, l, 0, 0, 0);
        }

        public void reallocate(int l0, int l1, int l2, int l3, int u0, int u1, int u2, int u3, boolean isRow) {
            this.reallocate(4, new int[]{l0, l1, l2, l3}, new int[]{u0, u1, u2, l3}, isRow);
        }

        public Array4 smartCopy() {
            return (Array4)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array4 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, int k, int l, FloatComplex value) {
            this._set(i, j, k, l, 0, 0, 0, value);
        }

        public void set(int i, int j, int k, int l, FloatComplex value) {
            this.checkBounds(i, j, k, l);
            this._set(i, j, k, l, 0, 0, 0, value);
        }

        public FloatComplex[][][][] toArray() {
            FloatComplex[][][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(4);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                int l3 = this._lower(3);
                int u3 = this._upper(3);
                array = new FloatComplex[u0 - l0 + 1][][][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1][][];
                    for (int j = l1; j <= u1; ++j) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1][];
                        for (int k = l2; k <= u2; ++k) {
                            array[i][j][k] = new FloatComplex[u3 - l3 + 1];
                            for (int l = l3; l <= u3; ++l) {
                                array[i - l0][j - l1][k - l2][l - l3] = this._get(i, j, k, l);
                            }
                        }
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                int s3 = array[0][0][0].length - 1;
                this.reallocate(0, 0, 0, 0, s0, s1, s2, s3, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        for (int k = 0; k <= s1; ++k) {
                            for (int l = 0; l <= s2; ++l) {
                                this._set(i, j, k, l, array[i][j][k][l]);
                            }
                        }
                    }
                }
            }
        }

        public static class Holder {
            private Array4 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array4 obj) {
                this.d_obj = obj;
            }

            public void set(Array4 obj) {
                this.d_obj = obj;
            }

            public Array4 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array3
    extends Array {
        public Array3() {
        }

        protected Array3(long array, boolean owner) {
            super(array, owner);
        }

        public Array3(int l0, int l1, int l2, int u0, int u1, int u2, boolean isRow) {
            super(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2}, isRow);
        }

        public Array3(int s0, int s1, int s2, boolean isRow) {
            super(3, new int[]{0, 0, 0}, new int[]{s0 - 1, s1 - 1, s2 - 1}, isRow);
        }

        public Array3(FloatComplex[][][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j, int k) {
            return this._get(i, j, k, 0, 0, 0, 0);
        }

        public FloatComplex get(int i, int j, int k) {
            this.checkBounds(i, j, k);
            return this._get(i, j, k, 0, 0, 0, 0);
        }

        public void reallocate(int l0, int l1, int l2, int u0, int u1, int u2, boolean isRow) {
            this.reallocate(3, new int[]{l0, l1, l2}, new int[]{u0, u1, u2}, isRow);
        }

        public Array3 smartCopy() {
            return (Array3)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array3 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, int k, FloatComplex value) {
            this._set(i, j, k, 0, 0, 0, 0, value);
        }

        public void set(int i, int j, int k, FloatComplex value) {
            this.checkBounds(i, j, k);
            this._set(i, j, k, 0, 0, 0, 0, value);
        }

        public FloatComplex[][][] toArray() {
            FloatComplex[][][] array = null;
            if (!this.isNull()) {
                this.checkDimension(3);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                int l2 = this._lower(2);
                int u2 = this._upper(2);
                array = new FloatComplex[u0 - l0 + 1][][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1][];
                    for (int j = l1; j <= u1; ++j) {
                        array[i][j] = new FloatComplex[u2 - l2 + 1];
                        for (int k = l2; k <= u2; ++k) {
                            array[i - l0][j - l1][k - l2] = this._get(i, j, k);
                        }
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                int s2 = array[0][0].length - 1;
                this.reallocate(0, 0, 0, s0, s1, s2, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        for (int k = 0; k <= s1; ++k) {
                            this._set(i, j, k, array[i][j][k]);
                        }
                    }
                }
            }
        }

        public static class Holder {
            private Array3 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array3 obj) {
                this.d_obj = obj;
            }

            public void set(Array3 obj) {
                this.d_obj = obj;
            }

            public Array3 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array2
    extends Array {
        public Array2() {
        }

        protected Array2(long array, boolean owner) {
            super(array, owner);
        }

        public Array2(int l0, int l1, int u0, int u1, boolean isRow) {
            super(2, new int[]{l0, l1}, new int[]{u0, u1}, isRow);
        }

        public Array2(int s0, int s1, boolean isRow) {
            super(2, new int[]{0, 0}, new int[]{s0 - 1, s1 - 1}, isRow);
        }

        public Array2(FloatComplex[][] array) {
            this.fromArray(array);
        }

        public int length(int dim) {
            return super._length(dim);
        }

        public FloatComplex _get(int i, int j) {
            return this._get(i, j, 0, 0, 0, 0, 0);
        }

        public FloatComplex get(int i, int j) {
            this.checkBounds(i, j);
            return this._get(i, j, 0, 0, 0, 0, 0);
        }

        public void reallocate(int l0, int l1, int u0, int u1, boolean isRow) {
            this.reallocate(2, new int[]{l0, l1}, new int[]{u0, u1}, isRow);
        }

        public Array2 smartCopy() {
            return (Array2)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array2 dest) {
            this._copy(dest);
        }

        public void _set(int i, int j, FloatComplex value) {
            this._set(i, j, 0, 0, 0, 0, 0, value);
        }

        public void set(int i, int j, FloatComplex value) {
            this.checkBounds(i, j);
            this._set(i, j, 0, 0, 0, 0, 0, value);
        }

        public FloatComplex[][] toArray() {
            FloatComplex[][] array = null;
            if (!this.isNull()) {
                this.checkDimension(2);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                int l1 = this._lower(1);
                int u1 = this._upper(1);
                array = new FloatComplex[u0 - l0 + 1][];
                for (int i = l0; i <= u0; ++i) {
                    array[i] = new FloatComplex[u1 - l1 + 1];
                    for (int j = l1; j <= u1; ++j) {
                        array[i - l0][j - l1] = this._get(i, j);
                    }
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[][] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                int s1 = array[0].length - 1;
                this.reallocate(0, 0, s0, s1, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    for (int j = 0; j <= s1; ++j) {
                        this._set(i, j, array[i][j]);
                    }
                }
            }
        }

        public static class Holder {
            private Array2 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array2 obj) {
                this.d_obj = obj;
            }

            public void set(Array2 obj) {
                this.d_obj = obj;
            }

            public Array2 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array1
    extends Array {
        public Array1() {
        }

        protected Array1(long array, boolean owner) {
            super(array, owner);
        }

        public Array1(int l0, int u0, boolean isRow) {
            super(1, new int[]{l0}, new int[]{u0}, isRow);
        }

        public Array1(int s0, boolean isRow) {
            super(1, new int[]{0}, new int[]{s0 - 1}, isRow);
        }

        public Array1(FloatComplex[] array) {
            this.fromArray(array);
        }

        public int length() {
            return super._length(0);
        }

        public FloatComplex _get(int i) {
            return this._get(i, 0, 0, 0, 0, 0, 0);
        }

        public FloatComplex get(int i) {
            this.checkBounds(i);
            return this._get(i, 0, 0, 0, 0, 0, 0);
        }

        public void reallocate(int l0, int u0, boolean isRow) {
            this.reallocate(1, new int[]{l0}, new int[]{u0}, isRow);
        }

        public Array1 smartCopy() {
            return (Array1)((Array)this._smartCopy())._dcast();
        }

        public void copy(Array1 dest) {
            this._copy(dest);
        }

        public void _set(int i, FloatComplex value) {
            this._set(i, 0, 0, 0, 0, 0, 0, value);
        }

        public void set(int i, FloatComplex value) {
            this.checkBounds(i);
            this._set(i, 0, 0, 0, 0, 0, 0, value);
        }

        public FloatComplex[] toArray() {
            FloatComplex[] array = null;
            if (!this.isNull()) {
                this.checkDimension(1);
                int l0 = this._lower(0);
                int u0 = this._upper(0);
                array = new FloatComplex[u0 - l0 + 1];
                for (int i = l0; i <= u0; ++i) {
                    array[i - l0] = this._get(i);
                }
            }
            return array;
        }

        public void fromArray(FloatComplex[] array) {
            if (array == null) {
                this.destroy();
            } else {
                int s0 = array.length - 1;
                this.reallocate(0, s0, this._isRowOrder());
                for (int i = 0; i <= s0; ++i) {
                    this._set(i, array[i]);
                }
            }
        }

        public static class Holder {
            private Array1 d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array1 obj) {
                this.d_obj = obj;
            }

            public void set(Array1 obj) {
                this.d_obj = obj;
            }

            public Array1 get() {
                return this.d_obj;
            }
        }
    }

    public static class Array
    extends BaseArray {
        public Array() {
        }

        protected Array(long array, boolean owner) {
            super(array, owner);
        }

        public Array(int dim, int[] lower, int[] upper, boolean isRow) {
            this.reallocate(dim, lower, upper, isRow);
        }

        public native FloatComplex _get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        public native void _set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, FloatComplex var8);

        public native void _reallocate(int var1, int[] var2, int[] var3, boolean var4);

        public native Array _slice(int var1, int[] var2, int[] var3, int[] var4, int[] var5);

        public native void _copy(Array var1);

        public Array _dcast() {
            try {
                int dimen = this._dim();
                Array ret = null;
                switch (dimen) {
                    case 1: {
                        ret = new Array1(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 2: {
                        ret = new Array2(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 3: {
                        ret = new Array3(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 4: {
                        ret = new Array4(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 5: {
                        ret = new Array5(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 6: {
                        ret = new Array6(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                    case 7: {
                        ret = new Array7(this.get_ior_pointer(), true);
                        this._addRef();
                        return ret;
                    }
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        static {
            BaseClass._registerNatives("sidl.FloatComplex");
        }

        public static class Holder {
            private Array d_obj;

            public Holder() {
                this.d_obj = null;
            }

            public Holder(Array obj) {
                this.d_obj = obj;
            }

            public void set(Array obj) {
                this.d_obj = obj;
            }

            public Array get() {
                return this.d_obj;
            }
        }
    }

    public static class Holder {
        private FloatComplex d_obj;

        public Holder() {
            this.d_obj = null;
        }

        public Holder(FloatComplex obj) {
            this.d_obj = obj;
        }

        public void set(FloatComplex obj) {
            this.d_obj = obj;
        }

        public FloatComplex get() {
            return this.d_obj;
        }
    }
}

