/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.xml;

import gov.llnl.babel.xml.ExceptionErrorHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtilities {
    private static final String EOL = "\n";

    public static DOMImplementation createDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public static Document parse(String uri) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setErrorHandler((ErrorHandler)new ExceptionErrorHandler());
        parser.parse(uri);
        return parser.getDocument();
    }

    public static Document parse(InputSource is, EntityResolver er) throws IOException, SAXException {
        DOMParser parser = new DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setErrorHandler((ErrorHandler)new ExceptionErrorHandler());
        parser.setEntityResolver(er);
        parser.parse(is);
        return parser.getDocument();
    }

    public static Document checkXML(String frag) {
        StringBuffer text = new StringBuffer();
        text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        text.append(frag);
        Document document = null;
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler((ErrorHandler)new ExceptionErrorHandler());
            InputSource is = new InputSource(new StringReader(text.toString()));
            parser.parse(is);
            document = parser.getDocument();
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document;
    }

    public static Document validateXML(String dtdPublic, String dtdFile, EntityResolver er, String start, String frag) {
        StringBuffer text = new StringBuffer();
        text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        text.append("<!DOCTYPE " + start + " PUBLIC \"" + dtdPublic + "\" " + "\"" + dtdFile + "\">" + EOL);
        text.append(frag);
        Document document = null;
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler((ErrorHandler)new ExceptionErrorHandler());
            InputSource is = new InputSource(new StringReader(text.toString()));
            parser.parse(is);
            document = parser.getDocument();
        }
        catch (SAXException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return document;
    }

    public static String encodeXMLString(String s) {
        StringBuffer buffer = new StringBuffer();
        int length = s == null ? 0 : s.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String decodeXMLString(String s) {
        StringBuffer buffer = new StringBuffer();
        String quot = "&quot;";
        String amp = "&amp;";
        String lt = "&lt;";
        String gt = "&gt;";
        int length = s == null ? 0 : s.length();
        int i = 0;
        while (i < length) {
            char ch = s.charAt(i);
            if (ch == '&') {
                int n_remaining = length - i;
                if (s.regionMatches(i, "&quot;", 0, "&quot;".length())) {
                    buffer.append('\"');
                    i += "&quot;".length();
                    continue;
                }
                if (s.regionMatches(i, "&amp;", 0, "&amp;".length())) {
                    buffer.append('&');
                    i += "&amp;".length();
                    continue;
                }
                if (s.regionMatches(i, "&gt;", 0, "&gt;".length())) {
                    buffer.append('>');
                    i += "&gt;".length();
                    continue;
                }
                if (s.regionMatches(i, "&lt;", 0, "&lt;".length())) {
                    buffer.append('<');
                    i += "&lt;".length();
                    continue;
                }
                buffer.append(ch);
                ++i;
                continue;
            }
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static Element lookupElement(Element e, String name) {
        Element match = null;
        if (e != null) {
            for (Node t = e.getFirstChild(); t != null; t = t.getNextSibling()) {
                if (!(t instanceof Element) || !t.getNodeName().equals(name)) continue;
                match = (Element)t;
                break;
            }
        }
        return match;
    }

    public static Node cloneDOM(Node node, Document document) {
        Node clone = null;
        if (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    clone = document.createElement(node.getNodeName());
                    NamedNodeMap attrs = node.getAttributes();
                    int nattrs = attrs == null ? 0 : attrs.getLength();
                    for (int a = 0; a < nattrs; ++a) {
                        Attr attr = (Attr)attrs.item(a);
                        clone.setAttribute(attr.getName(), attr.getValue());
                    }
                    for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                        clone.appendChild(XMLUtilities.cloneDOM(c, document));
                    }
                    break;
                }
                case 3: 
                case 4: {
                    clone = document.createTextNode(node.getNodeValue());
                    break;
                }
            }
        }
        return clone;
    }

    public static void writeDOM(Node node, PrintWriter writer) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 9: {
                    writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    DocumentType doctype = ((Document)node).getDoctype();
                    if (doctype != null) {
                        writer.print("<!DOCTYPE ");
                        writer.print(doctype.getName());
                        String public_id = doctype.getPublicId();
                        String system_id = doctype.getSystemId();
                        if (public_id != null) {
                            writer.print(" PUBLIC \"");
                            writer.print(public_id);
                            writer.print("\" \"");
                        } else {
                            writer.print(" SYSTEM \"");
                        }
                        if (system_id != null) {
                            writer.print(system_id);
                        }
                        writer.print("\">\n");
                    }
                    XMLUtilities.writeDOM(((Document)node).getDocumentElement(), writer);
                    break;
                }
                case 1: {
                    writer.print("<");
                    writer.print(node.getNodeName());
                    NamedNodeMap attrs = node.getAttributes();
                    int length = attrs == null ? 0 : attrs.getLength();
                    for (int i = 0; i < length; ++i) {
                        Attr attr = (Attr)attrs.item(i);
                        writer.print(" ");
                        writer.print(attr.getName());
                        writer.print("=\"");
                        writer.print(XMLUtilities.encodeXMLString(attr.getValue()));
                        writer.print("\"");
                    }
                    Node c = node.getFirstChild();
                    if (c == null) {
                        writer.print("/>");
                        break;
                    }
                    writer.print(">");
                    while (c != null) {
                        XMLUtilities.writeDOM(c, writer);
                        c = c.getNextSibling();
                    }
                    writer.print("</" + node.getNodeName() + ">");
                    break;
                }
                case 5: {
                    writer.print("&");
                    writer.print(node.getNodeName());
                    writer.print(";");
                    break;
                }
                case 3: 
                case 4: {
                    writer.print(XMLUtilities.encodeXMLString(node.getNodeValue()));
                    break;
                }
            }
        }
    }

    public static String getXMLString(Node node) {
        StringWriter writer = new StringWriter();
        XMLUtilities.writeDOM(node, new PrintWriter(writer));
        return writer.toString();
    }

    public static String formatChildren(Node root) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (root != null) {
            for (Node c = root.getFirstChild(); c != null; c = c.getNextSibling()) {
                XMLUtilities.writeDOM(c, pw);
            }
        }
        return XMLUtilities.trimWhiteSpaceLines(sw.toString());
    }

    public static String trimWhiteSpaceLines(String s) {
        int i;
        int start = 0;
        int end = s.length() - 1;
        for (i = 0; i <= end; ++i) {
            if (s.charAt(i) == '\n') {
                start = i + 1;
                continue;
            }
            if (s.charAt(i) > ' ') break;
        }
        for (i = end; i >= start; --i) {
            if (s.charAt(i) == '\n') {
                end = i - 1;
                continue;
            }
            if (s.charAt(i) > ' ') break;
        }
        String t = null;
        if (end >= start && XMLUtilities.isWhitespace(t = s.substring(start, end + 1))) {
            t = null;
        }
        return t;
    }

    public static boolean isWhitespace(String s) {
        if (s != null) {
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                if (s.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }
}

