/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class Method
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int STATIC = 3;
    public static final int LOCAL = 1;
    public static final int ONEWAY = 2;
    public static final String[] s_def_mod = new String[]{"", "abstract", "final", "static"};
    public static final String[] s_comm_mod = new String[]{"", "local", "oneway"};
    private ArrayList d_arguments = new ArrayList();
    private Comment d_comment = null;
    private int d_communication_modifier = 0;
    private int d_definition_modifier = 0;
    private String d_short_name = null;
    private String d_extension = null;
    private String d_long_name = null;
    private HashSet d_references = new HashSet();
    private HashSet d_basicarrays = new HashSet();
    private boolean d_return_copy = false;
    private Type d_return_type = null;
    private HashSet d_throws = new HashSet();
    private ArrayList d_preconditions = new ArrayList();
    private ArrayList d_postconditions = new ArrayList();
    private HashSet d_rarray_indices = null;
    private HashMap d_rarray_index_map;

    public Method cloneMethod() {
        Method m = null;
        try {
            m = (Method)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
        return m;
    }

    public void addArgument(Argument arg) {
        this.d_arguments.add(arg);
        this.addTypeReferences(arg.getType());
    }

    public ArrayList getArgumentList() {
        return this.getArgumentListWithOutIndices();
    }

    public ArrayList getArgumentListWithOutIndices() {
        if (this.d_rarray_indices != null) {
            ArrayList<Argument> ret = new ArrayList<Argument>(this.d_arguments.size() - this.d_rarray_indices.size());
            Iterator a = this.d_arguments.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                if (this.d_rarray_indices.contains(arg.getFormalName())) continue;
                ret.add(arg);
            }
            return ret;
        }
        return this.d_arguments;
    }

    public ArrayList getArgumentListWithIndices() {
        return this.d_arguments;
    }

    public void addRarrayIndex(String s) {
        if (this.d_rarray_indices == null) {
            this.d_rarray_indices = new HashSet();
        }
        this.d_rarray_indices.add(s);
    }

    public void addRarrayIndex(Collection new_indices) {
        if (this.d_rarray_indices == null) {
            this.d_rarray_indices = new HashSet();
        }
        this.d_rarray_indices.addAll(new_indices);
    }

    public Set getRarrayIndices() {
        return this.d_rarray_indices;
    }

    public boolean hasRarray() {
        return this.d_rarray_indices != null;
    }

    public Type getArgumentType(String name) {
        Type t = null;
        Iterator i = this.d_arguments.iterator();
        while (i.hasNext() && t == null) {
            Argument arg = (Argument)i.next();
            if (!arg.getFormalName().equals(name)) continue;
            t = arg.getType();
        }
        return t;
    }

    public int getArgumentMode(String name) {
        int m = -1;
        Iterator i = this.d_arguments.iterator();
        while (i.hasNext() && m == -1) {
            Argument arg = (Argument)i.next();
            if (!arg.getFormalName().equals(name)) continue;
            m = arg.getMode();
        }
        return m;
    }

    public void setComment(Comment comment) {
        this.d_comment = comment;
    }

    public Comment getComment() {
        return this.d_comment;
    }

    public void setCommunicationModifier(int modifier) {
        this.d_communication_modifier = modifier;
    }

    public int getCommunicationModifier() {
        return this.d_communication_modifier;
    }

    public String getCommunicationModifierString() {
        return s_comm_mod[this.d_communication_modifier];
    }

    public void setDefinitionModifier(int modifier) {
        this.d_definition_modifier = modifier;
    }

    public int getDefinitionModifier() {
        return this.d_definition_modifier;
    }

    public String getDefinitionModifier(boolean is_interface) {
        String mod = null;
        if (!is_interface || this.d_definition_modifier == 0) {
            mod = s_def_mod[this.d_definition_modifier];
        }
        return mod;
    }

    public boolean isAbstract() {
        return this.d_definition_modifier == 1;
    }

    public boolean isFinal() {
        return this.d_definition_modifier == 2;
    }

    public boolean isStatic() {
        return this.d_definition_modifier == 3;
    }

    public boolean hasArrayOrderSpec() {
        if (this.d_return_type.hasArrayOrderSpec()) {
            return true;
        }
        Iterator i = this.d_arguments.iterator();
        while (i.hasNext()) {
            if (!((Argument)i.next()).hasArrayOrderSpec()) continue;
            return true;
        }
        return false;
    }

    public void setMethodName(String shortName, String extension) {
        this.d_short_name = shortName;
        this.d_extension = extension;
        this.d_long_name = shortName + extension;
    }

    public void setMethodName(String shortName) {
        this.setMethodName(shortName, "");
    }

    public String getShortMethodName() {
        return this.d_short_name;
    }

    public String getNameExtension() {
        return this.d_extension;
    }

    public String getLongMethodName() {
        return this.d_long_name;
    }

    public void setReturnCopy(boolean copy) {
        this.d_return_copy = copy;
    }

    public boolean isReturnCopy() {
        return this.d_return_copy;
    }

    public void setReturnType(Type type) {
        this.d_return_type = type;
        this.addTypeReferences(type);
    }

    public Type getReturnType() {
        return this.d_return_type;
    }

    public void addThrows(SymbolID id) {
        this.d_throws.add(id);
        this.d_references.add(id);
    }

    public Set getThrows() {
        return this.d_throws;
    }

    public Set getSymbolReferences() {
        return this.d_references;
    }

    public Set getBasicArrays() {
        return this.d_basicarrays;
    }

    public String getReturnType(String parent_pkg) {
        StringBuffer result = new StringBuffer();
        String rtype = this.d_return_type.getTypeString();
        if (parent_pkg != null) {
            result.append(SymbolUtilities.getSymbolName(rtype, parent_pkg));
        } else {
            result.append(rtype);
        }
        return result.toString();
    }

    public String getSignaturePreface(boolean is_interface, String parent_pkg) {
        StringBuffer preface = new StringBuffer();
        String dmod = this.getDefinitionModifier(is_interface);
        if (dmod != null) {
            preface.append(dmod + " ");
        }
        if (this.d_return_copy) {
            preface.append("copy ");
        }
        preface.append(this.getReturnType(parent_pkg));
        preface.append(" ");
        preface.append(this.d_short_name);
        if (this.d_extension != null && this.d_extension != "") {
            preface.append(" [");
            preface.append(this.d_extension);
            preface.append("] ");
        }
        return preface.toString();
    }

    public String getSignature(boolean is_interface, String parent_pkg) {
        StringBuffer signature = new StringBuffer();
        signature.append(this.getSignaturePreface(is_interface, parent_pkg));
        signature.append("(");
        Iterator a = this.d_arguments.iterator();
        while (a.hasNext()) {
            signature.append(((Argument)a.next()).getArgumentString());
            if (!a.hasNext()) continue;
            signature.append(", ");
        }
        signature.append(") " + this.getCommunicationModifierString());
        if (!this.d_throws.isEmpty()) {
            signature.append(" throws ");
            Iterator t = this.d_throws.iterator();
            while (t.hasNext()) {
                SymbolID sid = (SymbolID)t.next();
                String fname = sid.getFullName();
                if (parent_pkg != null) {
                    signature.append(SymbolUtilities.getSymbolName(fname, parent_pkg));
                } else {
                    signature.append(fname);
                }
                if (!t.hasNext()) continue;
                signature.append(", ");
            }
        }
        return signature.toString();
    }

    public String getSignature() {
        return this.getSignature(false, null);
    }

    public boolean sameSignature(Method m) {
        if (this.d_communication_modifier != m.d_communication_modifier) {
            return false;
        }
        if (!this.d_short_name.equals(m.d_short_name)) {
            return false;
        }
        if (!this.d_extension.equals(m.d_extension)) {
            return false;
        }
        if (this.d_return_copy != m.d_return_copy) {
            return false;
        }
        if (this.d_return_type == null ? m.d_return_type != null : !this.d_return_type.equals(m.d_return_type)) {
            return false;
        }
        if (this.d_throws.size() != m.d_throws.size()) {
            return false;
        }
        Iterator i = this.d_throws.iterator();
        while (i.hasNext()) {
            if (m.d_throws.contains(i.next())) continue;
            return false;
        }
        return this.sameArguments(m);
    }

    public boolean sameBaseSignature(Method m) {
        if (!this.d_short_name.equals(m.d_short_name)) {
            return false;
        }
        return this.sameArguments(m);
    }

    private boolean sameArguments(Method m) {
        int size = this.d_arguments.size();
        if (size != m.d_arguments.size()) {
            return false;
        }
        for (int a = 0; a < size; ++a) {
            if (this.d_arguments.get(a).equals(m.d_arguments.get(a))) continue;
            return false;
        }
        return true;
    }

    public Argument getArgumentByName(String s) {
        Iterator a = this.d_arguments.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (arg.getFormalName().compareTo(s) != 0) continue;
            return arg;
        }
        return null;
    }

    private void addTypeReferences(Type type) {
        if (type != null) {
            if (type.getType() == 15) {
                this.d_references.add(type.getSymbolID());
            } else if (type.getType() == 16 && null != (type = type.getArrayType())) {
                this.addTypeReferences(type);
                if (type.getType() >= 1 && type.getType() <= 10) {
                    Version v = new Version();
                    v.appendVersionNumber(0);
                    this.d_basicarrays.add(new SymbolID("sidl." + type.getTypeString(), v));
                }
            }
        }
    }

    public boolean hasPureAssertion() {
        boolean found = false;
        ArrayList list = this.getPostconditions();
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !found) {
            Assertion item = (Assertion)iter.next();
            if (!item.hasPureClause()) continue;
            found = true;
        }
        return found;
    }

    public void addAssertion(Assertion assertion) throws AssertionException {
        if (assertion.isPrecondition()) {
            this.d_preconditions.add(assertion);
        } else if (assertion.isPostcondition()) {
            this.d_postconditions.add(assertion);
        } else {
            throw new AssertionException("Method: " + this.d_long_name, "Cannot add a(n) \"" + assertion.getTypeName() + "\" assertion to a " + "method's assertion list.");
        }
    }

    public ArrayList getPreconditions() {
        return this.d_preconditions;
    }

    public ArrayList getPostconditions() {
        return this.d_postconditions;
    }

    public boolean hasReservedMethodAssertion(ArrayList list, int type) {
        boolean hasIt = false;
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !hasIt) {
            Assertion item = (Assertion)iter.next();
            if (!item.hasReservedMethod(type)) continue;
            hasIt = true;
        }
        return hasIt;
    }

    public int getMaxArrayIterMacros(char type) {
        int num;
        Assertion as;
        int max = 0;
        Iterator i = this.d_preconditions.iterator();
        while (i.hasNext()) {
            as = (Assertion)i.next();
            num = as.getNumArrayIterMacrosByType(type);
            if (num <= max) continue;
            max = num;
        }
        i = this.d_postconditions.iterator();
        while (i.hasNext()) {
            as = (Assertion)i.next();
            num = as.getNumArrayIterMacrosByType(type);
            if (num <= max) continue;
            max = num;
        }
        return max;
    }

    public boolean hasReservedMethodAssertion(int type) {
        boolean hasIt = this.hasReservedMethodAssertion(this.d_preconditions, type);
        if (!hasIt) {
            hasIt = this.hasReservedMethodAssertion(this.d_postconditions, type);
        }
        return hasIt;
    }

    public boolean hasUnreservedMethodAssertion(ArrayList list, boolean any) {
        boolean hasIt = false;
        ListIterator iter = list.listIterator();
        while (iter.hasNext() && !hasIt) {
            Assertion item = (Assertion)iter.next();
            if (!item.hasUnreservedMethod(any)) continue;
            hasIt = true;
        }
        return hasIt;
    }

    public boolean hasUnreservedMethodAssertion(boolean any) {
        boolean hasIt = this.hasUnreservedMethodAssertion(this.d_preconditions, any);
        if (!hasIt) {
            hasIt = this.hasUnreservedMethodAssertion(this.d_postconditions, any);
        }
        return hasIt;
    }

    public HashMap getRarrayInfo() {
        if (this.d_rarray_index_map == null) {
            this.createRarrayMap();
        }
        return this.d_rarray_index_map;
    }

    private void createRarrayMap() {
        this.d_rarray_index_map = new HashMap();
        Iterator i = this.d_arguments.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type argType = a.getType();
            if (!argType.isRarray()) continue;
            Iterator j = argType.getArrayIndices().iterator();
            int position = 0;
            while (j.hasNext()) {
                String indexName = j.next().toString();
                HashSet<RarrayInfo> indexSet = (HashSet<RarrayInfo>)this.d_rarray_index_map.get(indexName);
                Argument index_arg = null;
                if (indexSet == null) {
                    indexSet = new HashSet<RarrayInfo>();
                    this.d_rarray_index_map.put(indexName, indexSet);
                }
                Iterator a1 = this.d_arguments.iterator();
                while (a1.hasNext()) {
                    Argument arg = (Argument)a1.next();
                    if (indexName.compareTo(arg.getFormalName()) != 0) continue;
                    index_arg = arg;
                    break;
                }
                indexSet.add(new RarrayInfo(a, index_arg, position));
                ++position;
            }
        }
    }

    public int hashCode() {
        return this.d_long_name.hashCode() + this.d_short_name.hashCode() + this.d_communication_modifier + this.d_throws.hashCode() + this.d_arguments.hashCode() + (this.d_return_copy ? 1 : 0);
    }

    public boolean equals(Object o) {
        try {
            Method m = (Method)o;
            return this.d_communication_modifier == m.d_communication_modifier && this.d_return_copy == m.d_return_copy && this.d_arguments.equals(m.d_arguments) && this.d_return_type.equals(m.d_return_type) && this.d_long_name.equals(m.d_long_name) && this.d_short_name.equals(m.d_short_name) && this.d_throws.equals(m.d_throws);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public class RarrayInfo {
        public final Argument rarray;
        public final Argument index;
        public final int dim;

        public RarrayInfo(Argument r, Argument i, int d) {
            this.rarray = r;
            this.index = i;
            this.dim = d;
        }

        public int hashCode() {
            return this.rarray.getFormalName().hashCode() + this.index.getFormalName().hashCode() + this.dim;
        }

        public boolean equals(Object o) {
            RarrayInfo r = null;
            try {
                r = (RarrayInfo)o;
                if (r.rarray == this.rarray && r.index == this.index && r.dim == this.dim) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return false;
        }
    }
}

