/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.repository;

import gov.llnl.babel.repository.FileRepository;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.repository.WebRepository;
import java.net.MalformedURLException;
import java.net.URL;

public class RepositoryFactory {
    private static RepositoryFactory s_instance = null;

    public static RepositoryFactory getInstance() {
        if (s_instance == null) {
            s_instance = new RepositoryFactory();
        }
        return s_instance;
    }

    public static void setInstance(RepositoryFactory instance) {
        s_instance = instance;
    }

    public Repository createRepository(String uri) throws RepositoryException {
        Repository repository = null;
        try {
            URL url = new URL(uri);
            String protocol = url.getProtocol();
            repository = protocol == null || protocol.equals("") ? new FileRepository(uri) : (protocol.equals("http") || protocol.equals("https") ? new WebRepository(uri) : (protocol.equals("file") ? new FileRepository(url.getFile()) : new FileRepository(uri)));
        }
        catch (MalformedURLException ex) {
            repository = new FileRepository(uri);
        }
        return repository;
    }
}

