/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ucxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.ucxx.Cxx;
import gov.llnl.babel.backend.ucxx.CxxStubHeader;
import gov.llnl.babel.backend.ucxx.CxxStubSource;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.backend.writers.PrettyWriter;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateCxxClient
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: 
                case 13: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
                case 11: {
                    this.generateEnumeration((Enumeration)symbol);
                    break;
                }
                case 14: {
                    this.generatePackage((Package)symbol);
                }
            }
        }
    }

    private void generatePackage(Package pkg) throws CodeGenerationException {
        LanguageWriterForCxx out = null;
        SymbolID id = pkg.getSymbolID();
        String filename = Cxx.generateFilename(id, 3, 1);
        out = Cxx.createHeader(pkg, 3, "STUBHDRS");
        out.println();
        out.openHeaderGuard(filename);
        out.println();
        ArrayList entries = Utilities.sort(pkg.getSymbols().keySet());
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String include = Cxx.generateFilename((SymbolID)i.next(), 3, 1);
            out.generateInclude(include, true);
            out.println();
        }
        out.println();
        out.closeHeaderGuard();
    }

    private void writeArrayDefinition(LanguageWriter lw, Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        String ior_item_t = IOR.getEnumName(id);
        String cxx_item_t = Cxx.getEnumName(id);
        String cxx_array_t = "array< " + cxx_item_t + " >";
        String ior_array_t = IOR.getArrayName(id);
        String array_traits = "array_traits< " + cxx_item_t + " >";
        lw.println(IOR.getArrayName(id) + ";");
        lw.println("namespace ucxx {");
        lw.tab();
        lw.println("namespace sidl {");
        lw.tab();
        lw.writeCommentLine("traits specialization");
        lw.println("template<>");
        lw.println("struct " + array_traits + " {");
        lw.tab();
        lw.println("typedef " + cxx_array_t + " cxx_array_t;");
        lw.println("typedef " + cxx_item_t + " cxx_item_t;");
        lw.println("typedef " + ior_array_t + " ior_array_t;");
        lw.println("typedef sidl_int__array ior_array_internal_t;");
        lw.println("typedef " + ior_item_t + " ior_item_t;");
        lw.println("typedef cxx_item_t value_type;");
        lw.println("typedef value_type& reference;");
        lw.println("typedef value_type* pointer;");
        lw.println("typedef const value_type& const_reference;");
        lw.println("typedef const value_type* const_pointer;");
        lw.println("typedef array_iter< " + array_traits + " > iterator;");
        lw.println("typedef const_array_iter< " + array_traits + " > const_iterator;");
        lw.backTab();
        lw.println("};");
        lw.println();
        lw.writeCommentLine("array specialization");
        lw.println("template<>");
        lw.println("class " + cxx_array_t + ": public enum_array< " + array_traits + " > {");
        lw.println("public:");
        lw.tab();
        lw.println("typedef enum_array< " + array_traits + " > Base;");
        lw.println("typedef " + array_traits + "::cxx_array_t          cxx_array_t;");
        lw.println("typedef " + array_traits + "::cxx_item_t           cxx_item_t;");
        lw.println("typedef " + array_traits + "::ior_array_t          ior_array_t;");
        lw.println("typedef " + array_traits + "::ior_array_internal_t ior_array_internal_t;");
        lw.println("typedef " + array_traits + "::ior_item_t           ior_item_t;");
        lw.println();
        lw.beginBlockComment(true);
        lw.println("conversion from ior to C++ class");
        lw.println("(constructor/casting operator)");
        lw.endBlockComment(true);
        lw.println("array( " + ior_array_t + "* src = 0) : Base(src) {}");
        lw.println();
        lw.beginBlockComment(true);
        lw.println("copy constructor");
        lw.endBlockComment(true);
        lw.println("array( const " + cxx_array_t + " &src) {");
        lw.tab();
        lw.println("d_array = src.d_array;");
        lw.println("if (d_array) addRef();");
        lw.backTab();
        lw.println("}");
        lw.println();
        lw.beginBlockComment(true);
        lw.println("assignment");
        lw.endBlockComment(true);
        lw.println(cxx_array_t + "&");
        lw.println("operator =( const " + cxx_array_t + " &rhs) {");
        lw.tab();
        lw.println("if (d_array != rhs.d_array) {");
        lw.tab();
        lw.println("if (d_array) deleteRef();");
        lw.println("d_array = rhs.d_array;");
        lw.println("if (d_array) addRef();");
        lw.backTab();
        lw.println("}");
        lw.println("return *this;");
        lw.backTab();
        lw.println("}");
        lw.println();
        lw.backTab();
        lw.println("};");
        lw.backTab();
        lw.println("}");
        lw.println();
        lw.println("}");
        lw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEnumeration(Enumeration enumeration) throws CodeGenerationException {
        PrettyWriter out = null;
        if (enumeration == null) {
            System.out.println("enum == null");
        }
        try {
            String filename = Cxx.generateFilename(enumeration.getSymbolID(), 3, 1);
            out = Cxx.createHeader(enumeration, 3, "STUBHDRS");
            out.println();
            ((LanguageWriterForC)out).openHeaderGuard(filename);
            out.println();
            ((LanguageWriterForC)out).generateInclude("sidl_ucxx.hh", false);
            ((LanguageWriterForC)out).generateInclude(IOR.getHeaderFile(enumeration.getSymbolID()), false);
            out.println();
            Cxx.nestPackagesInNamespaces((LanguageWriterForCxx)out, enumeration);
            out.println("enum " + enumeration.getSymbolID().getShortName() + " {");
            out.tab();
            String enum_name = enumeration.getSymbolID().getShortName();
            int maxlength = Utilities.getWidth(enumeration.getEnumerators());
            Iterator e = enumeration.getIterator();
            while (e.hasNext()) {
                String name = (String)e.next();
                Comment cmt = enumeration.getEnumeratorComment(name);
                ((LanguageWriter)out).writeComment(cmt, true);
                out.printAligned(enum_name + "_" + name, maxlength);
                out.print(" = ");
                out.print(String.valueOf(enumeration.getEnumeratorValue(name)));
                if (e.hasNext()) {
                    out.print(",");
                }
                out.println();
                if (cmt == null) continue;
                out.println();
            }
            out.backTab();
            out.println("};");
            out.println();
            Cxx.unnestPackagesInNamespaces((LanguageWriterForCxx)out, enumeration);
            out.println();
            this.writeArrayDefinition((LanguageWriter)out, enumeration);
            out.println();
            ((LanguageWriterForC)out).closeHeaderGuard();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void generateExtendable(Extendable extendable) throws CodeGenerationException {
        CxxStubHeader header = new CxxStubHeader(extendable);
        CxxStubSource source = new CxxStubSource(extendable);
        header.generateCode();
        source.generateCode();
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return false;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("uc++");
        result.add("ucxx");
        return result;
    }
}

