/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ucxx;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.ucxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CxxStubHeader {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private String d_self = null;

    public CxxStubHeader(Extendable ext) {
        this.d_ext = ext;
    }

    public CxxStubHeader(Extendable ext, LanguageWriterForCxx writer) {
        this.d_ext = ext;
        this.d_writer = writer;
        this.d_self = "self";
    }

    public static void generateSupers(Class cls, LanguageWriterForCxx writer) throws CodeGenerationException {
        CxxStubHeader source = new CxxStubHeader(cls, writer);
        source.generateSupers();
    }

    private void generateSupers() throws CodeGenerationException {
        Class cls = (Class)this.d_ext;
        SymbolID clsID = cls.getSymbolID();
        String ext_name = IOR.getExternalName(clsID);
        this.d_writer.println("public:");
        this.d_writer.writeComment("Hold pointer to IOR functions.", false);
        this.d_writer.println("class Super {");
        this.d_writer.tab();
        this.d_writer.println();
        this.d_writer.println("private:");
        this.d_writer.tab();
        this.d_writer.writeComment("Hold pointer to Super EPV", false);
        this.d_writer.println(IOR.getEPVName(cls.getParentClass().getSymbolID()) + "* superEPV;");
        this.d_writer.println(IOR.getObjectName(clsID) + "* superSelf;");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("Super() : superEPV(NULL), superSelf(NULL) {}");
        this.d_writer.println();
        this.d_writer.println("Super(" + IOR.getObjectName(clsID) + "* loc_self, const " + IOR.getExternalName(cls.getSymbolID()) + "* loc_ext) {");
        this.d_writer.tab();
        this.d_writer.println("superEPV = loc_ext->getSuperEPV();");
        this.d_writer.println("superSelf = loc_self;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        Collection methods = cls.getOverwrittenClassMethods();
        Iterator mit = methods.iterator();
        while (mit.hasNext()) {
            Method method = (Method)mit.next();
            this.generateInlineMethodDispatch(method, null, true, true);
        }
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("};");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 1);
        this.d_self = this.d_ext.isInterface() ? "loc_self->d_object" : "loc_self";
        try {
            try {
                this.d_writer = Cxx.createHeader(this.d_ext, 3, "STUBHDRS");
                if (this.d_ext.getSymbolType() == 14) {
                    this.d_writer.skipIncludeGuard();
                }
                this.d_writer.println();
                this.d_writer.openHeaderGuard(filename);
                this.writeDefineNullIORException();
                this.writeClassDeclaration();
                Cxx.generateDependencyIncludes(this.d_writer, this.d_ext, true);
                Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
                this.writeClassBegin();
                this.writeUserDefinedMethods();
                this.writeTypedefs();
                this.writeConstructors();
                this.writeCastingOperators();
                this.writeBindingSpecificMethods();
                this.writeClassEnd();
                Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
                this.writeArrayDefinition();
                this.d_writer.closeHeaderGuard();
            }
            catch (Exception ex) {
                throw new CodeGenerationException("Exception : " + ex.getMessage());
            }
            Object var4_2 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeDefineNullIORException() {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        String flagname = this.d_ext.getSymbolID().getFullName().replace('.', '_').toUpperCase() + "_NULL_IOR_EXCEPTION";
        if (s_babel_config.makeCxxCheckNullIOR()) {
            this.d_writer.printlnUnformatted("#ifndef " + flagname);
            this.d_writer.printlnUnformatted("#define " + flagname + " 1");
            this.d_writer.printlnUnformatted("#endif ");
        }
    }

    private void writeClassDeclaration() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        this.d_writer.writeCommentLine("declare class before #includes");
        this.d_writer.writeCommentLine("(this alleviates circular #include guard problems)[BUG#393]");
        Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
        this.d_writer.println("class " + name + ";");
        Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
        this.d_writer.writeCommentLine("Some compilers need to define array template before the specializations");
        this.d_writer.generateInclude("sidl_ucxx.hh", true);
        Cxx.openUCxxNamespace(this.d_writer);
        this.d_writer.println("namespace sidl {");
        this.d_writer.tab();
        this.d_writer.println("template<>");
        this.d_writer.println("class array< " + Cxx.getObjectName(id) + " >;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        Cxx.closeUCxxNamespace(this.d_writer);
        HashSet decls = new HashSet();
        Iterator i = this.d_ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            decls.addAll(method.getSymbolReferences());
        }
        if (!decls.isEmpty()) {
            this.d_writer.writeComment("Forward declarations for method dependencies.", false);
            ArrayList entries = Utilities.sort(decls);
            Iterator i2 = entries.iterator();
            while (i2.hasNext()) {
                SymbolID s = (SymbolID)i2.next();
                Symbol symbol = Utilities.lookupSymbol(s);
                if (symbol.getSymbolType() == 11) continue;
                Cxx.nestPackagesInNamespaces(this.d_writer, s);
                this.d_writer.println("class " + s.getShortName() + ";");
                Cxx.unnestPackagesInNamespaces(this.d_writer, s);
            }
        }
    }

    private void writeClassBegin() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.print("class " + name);
        Collection parents = this.d_ext.getParents(false);
        boolean first = true;
        Iterator i2 = parents.iterator();
        if (!i2.hasNext()) {
            this.d_writer.print(": public virtual " + Cxx.prependGlobalUCxx() + "::sidl::StubBase");
        } else {
            Iterator i = parents.iterator();
            while (i.hasNext()) {
                Extendable parent = (Extendable)i.next();
                String parentName = Cxx.getSymbolName(parent.getSymbolID(), "");
                if (first) {
                    this.d_writer.print(": ");
                } else {
                    this.d_writer.print(", ");
                }
                first = false;
                this.d_writer.print("public virtual " + parentName);
            }
        }
        this.d_writer.println(" {");
    }

    private void writeUserDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.beginBoldComment();
        this.d_writer.println("User Defined Methods");
        this.d_writer.endBoldComment();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (!Cxx.inlineStub(method)) {
                Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 3, true);
                this.d_writer.println();
                if (!method.hasRarray()) continue;
                Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 3, false);
                this.d_writer.println();
                continue;
            }
            this.generateInlineMethodDispatch(method, "user defined static method", false, true);
            this.d_writer.println();
        }
        m = this.d_ext.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (!Cxx.inlineStub(method)) {
                Cxx.generateMethodSignature(this.d_writer, method, "user defined non-static method.", 3, true);
                this.d_writer.println();
                if (!method.hasRarray()) continue;
                Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 3, false);
                this.d_writer.println();
                continue;
            }
            this.generateInlineMethodDispatch(method, "user defined non-static method", false, true);
            this.d_writer.println();
        }
        this.d_writer.beginBoldComment();
        this.d_writer.println("End User Defined Methods");
        this.d_writer.println("(everything else in this file is specific to");
        this.d_writer.println(" Babel's C++ bindings)");
        this.d_writer.endBoldComment();
    }

    private void writeTypedefs() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("typedef " + IOR.getObjectName(id) + " ior_t;");
        this.d_writer.println("typedef " + IOR.getExternalName(id) + " ext_t;");
        this.d_writer.println("typedef " + IOR.getSEPVName(id) + " sepv_t;");
        this.d_writer.println();
    }

    private void writeConstructors() {
        SymbolID id = this.d_ext.getSymbolID();
        String ior_ptr = "ior_t*";
        String name = id.getShortName();
        this.d_writer.writeCommentLine("default constructor");
        this.d_writer.println(name + "() { }");
        this.d_writer.println();
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeCommentLine("static constructor");
            this.d_writer.println("static " + Cxx.getObjectName(id) + " _create();");
            this.d_writer.println();
        }
        this.d_writer.writeCommentLine("default destructor");
        this.d_writer.println("virtual ~" + name + " () { }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("copy constructor");
        this.d_writer.println(name + " ( const " + name + "& original );");
        this.d_writer.println();
        this.d_writer.writeCommentLine("assignment operator");
        this.d_writer.println(name + "& operator= ( const " + name + "& rhs );");
        this.d_writer.println();
    }

    private void writeCastingOperators() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        String ior_ptr = "ior_t*";
        this.d_writer.writeCommentLine("conversion from ior to C++ class");
        this.d_writer.println(name + " ( " + name + "::ior_t* ior );");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Alternate constructor: does not call addRef()");
        this.d_writer.writeCommentLine("(sets d_weak_reference=isWeak)");
        this.d_writer.writeCommentLine("For internal use by Impls (fixes bug#275)");
        this.d_writer.println(name + " ( " + name + "::ior_t* ior, bool isWeak );");
        this.d_writer.println();
    }

    private void writeBindingSpecificMethods() {
        SymbolID id = this.d_ext.getSymbolID();
        String name = id.getShortName();
        String ior_ptr = "ior_t*";
        this.d_writer.println(ior_ptr + " _get_ior() { return " + Cxx.reinterpretCast("ior_t*", "d_self") + "; }");
        this.d_writer.println();
        this.d_writer.println("const " + ior_ptr + " _get_ior() const { return " + Cxx.reinterpretCast("ior_t*", "d_self") + "; }");
        this.d_writer.println();
        this.d_writer.println("void _set_ior( " + ior_ptr + " ptr ) { d_self = " + Cxx.reinterpretCast("void*", "ptr") + "; }");
        this.d_writer.println();
        this.d_writer.println("bool _is_nil() const { return (d_self==0); }");
        this.d_writer.println();
        this.d_writer.println("bool _not_nil() const { return (d_self!=0); }");
        this.d_writer.println();
        this.d_writer.println("bool operator !() const { return (d_self==0); }");
        this.d_writer.println();
        this.d_writer.println("static inline const char * type_name() { return \"" + id.getFullName() + "\";}");
        this.d_writer.println("virtual void* _cast(const char* type) const;");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("protected:");
        this.d_writer.tab();
        this.d_writer.tab();
        this.d_writer.writeCommentLine("Pointer to external (DLL loadable) symbols (shared among instances)");
        this.d_writer.println("static const ext_t * s_ext;");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("static const ext_t * _get_ext() throw ( " + Cxx.prependGlobalUCxx() + "::sidl::NullIORException );");
        this.d_writer.println();
        if (this.d_ext.hasStaticMethod(true)) {
            this.d_writer.println("static const sepv_t * _get_sepv() {");
            this.d_writer.tab();
            this.d_writer.println("return (*(_get_ext()->getStaticEPV))();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.backTab();
        this.d_writer.println("}; // end class " + name);
    }

    private void writeArrayDefinition() {
        SymbolID id = this.d_ext.getSymbolID();
        String cxx_item_t = Cxx.getObjectName(id);
        String cxx_array_t = "array< " + cxx_item_t + " >";
        String ior_item_t = IOR.getObjectName(id);
        String ior_array_t = IOR.getArrayName(id);
        String array_traits = "array_traits< " + cxx_item_t + " >";
        Cxx.openUCxxNamespace(this.d_writer);
        this.d_writer.println("namespace sidl {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("traits specialization");
        this.d_writer.println("template<>");
        this.d_writer.println("struct " + array_traits + " {");
        this.d_writer.tab();
        this.d_writer.println("typedef " + cxx_array_t + " cxx_array_t;");
        this.d_writer.println("typedef " + cxx_item_t + " cxx_item_t;");
        this.d_writer.println("typedef " + ior_array_t + " ior_array_t;");
        this.d_writer.println("typedef sidl_interface__array ior_array_internal_t;");
        this.d_writer.println("typedef " + ior_item_t + " ior_item_t;");
        this.d_writer.println("typedef cxx_item_t value_type;");
        this.d_writer.println("typedef value_type reference;");
        this.d_writer.println("typedef value_type* pointer;");
        this.d_writer.println("typedef const value_type const_reference;");
        this.d_writer.println("typedef const value_type* const_pointer;");
        this.d_writer.println("typedef array_iter< " + array_traits + " > iterator;");
        this.d_writer.println("typedef const_array_iter< " + array_traits + " > const_iterator;");
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.println();
        this.d_writer.writeCommentLine("array specialization");
        this.d_writer.println("template<>");
        this.d_writer.println("class " + cxx_array_t + ": public interface_array< " + array_traits + " > {");
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.println("typedef interface_array< " + array_traits + " > Base;");
        this.d_writer.println("typedef " + array_traits + "::cxx_array_t          cxx_array_t;");
        this.d_writer.println("typedef " + array_traits + "::cxx_item_t           cxx_item_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_array_t          ior_array_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_array_internal_t ior_array_internal_t;");
        this.d_writer.println("typedef " + array_traits + "::ior_item_t           ior_item_t;");
        this.d_writer.println();
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("conversion from ior to C++ class");
        this.d_writer.println("(constructor/casting operator)");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("array( " + ior_array_t + "* src = 0) : Base(src) {}");
        this.d_writer.println();
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("copy constructor");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("array( const " + cxx_array_t + "&src) : Base(src) {}");
        this.d_writer.println();
        if (BabelConfiguration.getBaseInterface().equals(id.getFullName())) {
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("Assignment to promote a generic array to an");
            this.d_writer.println("array of sidl.BaseInterface references. This");
            this.d_writer.println("will produce a nil array if the generic array");
            this.d_writer.println("isn't an array of objects/interfaces.");
            this.d_writer.endBlockComment(true);
            this.d_writer.println(cxx_array_t + "&");
            this.d_writer.println("operator =(const basearray &rhs) throw() {");
            this.d_writer.tab();
            this.d_writer.println("if (this->d_array != rhs._get_baseior()) {");
            this.d_writer.tab();
            this.d_writer.println("deleteRef();");
            this.d_writer.println("this->d_array =");
            this.d_writer.tab();
            this.d_writer.println("(rhs._get_baseior() &&");
            this.d_writer.println(" (sidl_interface_array == rhs.arrayType()))");
            this.d_writer.println("? const_cast<sidl__array *>(rhs._get_baseior())");
            this.d_writer.println(": NULL;");
            this.d_writer.backTab();
            this.d_writer.println("addRef();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("return *this;");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("assignment");
        this.d_writer.endBlockComment(true);
        this.d_writer.println(cxx_array_t + "&");
        this.d_writer.println("operator =( const " + cxx_array_t + "&rhs ) { ");
        this.d_writer.tab();
        this.d_writer.println("if (d_array != rhs._get_baseior()) {");
        this.d_writer.tab();
        this.d_writer.println("if (d_array) deleteRef();");
        this.d_writer.println("d_array = const_cast<sidl__array *>(rhs._get_baseior());");
        this.d_writer.println("if (d_array) addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return *this;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("};");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        Cxx.closeUCxxNamespace(this.d_writer);
    }

    private void generateInlineMethodDispatch(Method m, String altcomment, boolean isSuper, boolean rarrays) throws CodeGenerationException {
        if (m == null) {
            return;
        }
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        if (shortMethodName.equals(className)) {
            System.out.println("WARNING: gov.llnl.babel.backend.UCxx.CxxStubSource: sidl / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::f_" + shortMethodName + "()");
            shortMethodName = "f_" + shortMethodName;
        }
        Cxx.generateInlineMethodSignature(this.d_writer, m, "user defined static method", 3, isSuper, rarrays);
        this.d_writer.tab();
        if (!m.isStatic() && s_babel_config.makeCxxCheckNullIOR()) {
            this.d_writer.println("if ( d_self == 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("throw " + Cxx.prependGlobalUCxx() + "::sidl::NullIORException( ::std::string (");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("\"Null IOR Pointer in \\\"" + Cxx.getMethodStubName(this.d_ext.getSymbolID(), shortMethodName) + "()\\\"\"");
            this.d_writer.enableLineBreak();
            this.d_writer.backTab();
            this.d_writer.println("));");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(Cxx.generateInitialization(m, this.d_ext, this.d_self));
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            this.d_writer.println("if ( !d_weak_reference ) {");
            this.d_writer.tab();
        }
        this.d_writer.println(Cxx.generatePreIORCall(m, this.d_ext, this.d_self, isSuper, rarrays));
        if (isSuper) {
            Class cls = (Class)this.d_ext;
            String tmp_self = Cxx.reinterpretCast(IOR.getObjectName(cls.getParentClass().getSymbolID()) + "*", "superSelf");
            this.d_writer.println(Cxx.generateIORCall(m, this.d_ext, tmp_self, isSuper, rarrays));
        } else {
            this.d_writer.println(Cxx.generateIORCall(m, this.d_ext, this.d_self, isSuper, rarrays));
        }
        if (m.getThrows().size() > 0) {
            this.d_writer.println("if (_exception != 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("void * _p = 0;");
            Object[] exceptions = m.getThrows().toArray();
            Arrays.sort(exceptions, new LevelComparator(SymbolTable.getInstance()));
            for (int i = 0; i < exceptions.length; ++i) {
                SymbolID exid = (SymbolID)exceptions[i];
                this.d_writer.println("if ( (_p=(*(_exception->d_epv->f__cast))(_exception, \"" + exid.getFullName() + "\")) != 0 ) {");
                this.d_writer.tab();
                this.d_writer.println(IOR.getObjectName(exid) + " * _realtype = " + Cxx.reinterpretCast(IOR.getObjectName(exid) + "*", "_p") + ";");
                this.d_writer.writeCommentLine("Note: alternate constructor does not increment refcount.");
                this.d_writer.println("throw " + Cxx.getObjectName(exid) + "( _realtype, false );");
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(Cxx.generatePostIORCall(m, this.d_ext, this.d_self, rarrays));
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            if (shortMethodName.equals("deleteRef")) {
                this.d_writer.println("d_self = 0;");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        if (return_type.getType() != 0) {
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

