/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.mangler;

import gov.llnl.babel.backend.mangler.NameMangler;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;

public class ShaMangler
implements NameMangler {
    private static String s_STANDARD_ENCODING = "ISO-8859-1";
    private MessageDigest d_digest;
    private int d_maxLength;
    private int d_maxUnmangled;
    private char[] d_charSet;
    private BigInteger d_charSetSize;

    public ShaMangler(int maxNameLen, int maxUnmangled, char[] charSet) throws NoSuchAlgorithmException {
        this.d_charSet = (char[])charSet.clone();
        this.d_maxLength = maxNameLen;
        if (this.d_maxLength < 0) {
            this.d_maxLength = 0;
        }
        this.d_maxUnmangled = maxUnmangled;
        if (this.d_maxUnmangled < 0) {
            this.d_maxUnmangled = 0;
        }
        this.d_charSetSize = BigInteger.valueOf(this.d_charSet.length);
        this.d_digest = MessageDigest.getInstance("SHA");
    }

    private String truncateSymbol(String symbol, int maxLength) {
        if (maxLength > 0) {
            int i;
            StringBuffer result = new StringBuffer(maxLength);
            StringTokenizer tok = new StringTokenizer(symbol, ".");
            int len = tok.countTokens();
            String[] tokens = new String[len];
            for (i = 0; i < len; ++i) {
                tokens[i] = tok.nextToken();
            }
            for (i = len - 1; i >= 0 && maxLength - tokens[i].length() - 1 >= 0; --i) {
                maxLength -= tokens[i].length() + 1;
            }
            if (++i < len) {
                result.append(tokens[i++]);
                while (i < len) {
                    result.append('_').append(tokens[i]);
                    ++i;
                }
            } else {
                result.append(tokens[len - 1].substring(0, maxLength));
            }
            return result.toString();
        }
        return "";
    }

    private BigInteger calculateDigest(String symbol, String method, String array, String suffix) throws UnsupportedEncodingException {
        BigInteger result = null;
        byte[] digest = null;
        this.d_digest.reset();
        this.d_digest.update(symbol.getBytes(s_STANDARD_ENCODING));
        this.d_digest.update(method.getBytes(s_STANDARD_ENCODING));
        this.d_digest.update(array.getBytes(s_STANDARD_ENCODING));
        this.d_digest.update(suffix.getBytes(s_STANDARD_ENCODING));
        digest = this.d_digest.digest();
        result = new BigInteger(1, digest);
        return result;
    }

    public String shortName(String symbol, String method, String suffix) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer(this.d_maxLength);
        if (symbol.length() + method.length() + suffix.length() >= this.d_maxLength) {
            BigInteger digest = this.calculateDigest(symbol, method, "", suffix);
            symbol = this.truncateSymbol(symbol, this.d_maxUnmangled - method.length() - suffix.length() - 1);
            method = method.substring(0, Math.max(0, Math.min(method.length(), this.d_maxUnmangled - suffix.length())));
            suffix = suffix.substring(0, Math.min(suffix.length(), this.d_maxUnmangled));
            result.append(symbol);
            if (symbol.length() > 0) {
                result.append('_');
            }
            result.append(method);
            if (symbol.length() == 0 && suffix.indexOf(95) < 0 && method.indexOf(95) < 0) {
                result.append('_');
            }
            int mangledChars = this.d_maxLength - suffix.length() - result.length();
            while (mangledChars-- > 0) {
                BigInteger[] next = digest.divideAndRemainder(this.d_charSetSize);
                digest = next[0];
                result.append(this.d_charSet[next[1].intValue()]);
            }
            result.append(suffix);
        } else {
            result.append(symbol.replace('.', '_')).append('_').append(method).append(suffix);
        }
        return result.toString();
    }

    public String shortArrayName(String symbol, String method, String suffix) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer(this.d_maxLength);
        if (symbol.length() + method.length() + 7 + suffix.length() >= this.d_maxLength) {
            BigInteger digest = this.calculateDigest(symbol, method, "_ary_", suffix);
            symbol = this.truncateSymbol(symbol, this.d_maxUnmangled - method.length() - suffix.length() - 8);
            method = method.substring(0, Math.max(0, Math.min(method.length(), this.d_maxUnmangled - suffix.length() - (symbol.length() > 0 ? 5 : 4))));
            suffix = suffix.substring(0, Math.min(suffix.length(), this.d_maxUnmangled));
            result.append(symbol);
            if (symbol.length() > 0) {
                result.append("_ary_");
            } else {
                result.append("ary_");
            }
            result.append(method);
            int mangledChars = this.d_maxLength - suffix.length() - result.length();
            while (mangledChars-- > 0) {
                BigInteger[] next = digest.divideAndRemainder(this.d_charSetSize);
                digest = next[0];
                result.append(this.d_charSet[next[1].intValue()]);
            }
            result.append(suffix);
        } else {
            result.append(symbol.replace('.', '_')).append("__array_").append(method).append(suffix);
        }
        return result.toString();
    }

    public String shortName(String symbol, String suffix) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer(this.d_maxLength);
        if (symbol.length() + suffix.length() >= this.d_maxLength) {
            BigInteger digest = this.calculateDigest(symbol, "", "", suffix);
            symbol = this.truncateSymbol(symbol, this.d_maxUnmangled - suffix.length());
            suffix = suffix.substring(0, Math.min(suffix.length(), this.d_maxUnmangled));
            result.append(symbol);
            if (symbol.length() == 0 && suffix.indexOf(95) < 0) {
                result.append('_');
            }
            int mangledChars = this.d_maxLength - suffix.length() - result.length();
            while (mangledChars-- > 0) {
                BigInteger[] next = digest.divideAndRemainder(this.d_charSetSize);
                digest = next[0];
                result.append(this.d_charSet[next[1].intValue()]);
            }
            result.append(suffix);
        } else {
            result.append(symbol.replace('.', '_')).append(suffix);
        }
        return result.toString();
    }
}

