/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServerJNI {
    private LanguageWriterForC d_writer;
    private Extendable d_ext;
    private static final String JPREFIX = "_j_";
    private static final String JRETURN = "_j_retval";
    private static final String CRETURN = "_retval";
    private static final String JPTR = "_jptr_";
    private static final String JCLS = "_jCls_";
    private static final String JCTORMID = "_jCtorMID_";
    private static final String[] s_ensureOrderConstant = new String[]{"sidl_general_order", "sidl_column_major_order", "sidl_row_major_order"};

    public ServerJNI(Extendable ext, LanguageWriterForC writer) throws CodeGenerationException {
        String pre = "java.ServerJNI.ServerJNI: ";
        if (ext == null) {
            throw new CodeGenerationException("java.ServerJNI.ServerJNI: Unexpected null extendable object.");
        }
        this.d_ext = ext;
        this.d_writer = writer;
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Java.getServerJNIFile(id);
        this.d_writer.setLineBreakString(", ");
        this.d_writer.writeBanner(this.d_ext, filename, true, "Server-side JNI glue code for " + id.getFullName());
    }

    public ServerJNI(Extendable ext) throws CodeGenerationException {
        String pre = "java.ServerJNI.ServerJNI: ";
        if (ext == null) {
            throw new CodeGenerationException("java.ServerJNI.ServerJNI: Unexpected null extendable object");
        }
        this.d_ext = ext;
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Java.getServerJNIFile(id);
        this.d_writer = new LanguageWriterForC(FileManager.getInstance().createFile(id, type, "SKELSRCS", filename));
        this.d_writer.setLineBreakString(", ");
        this.d_writer.writeBanner(this.d_ext, filename, true, "Server-side JNI glue code for " + id.getFullName());
    }

    public static void generateCode(Extendable symbol, LanguageWriterForC writer) throws CodeGenerationException {
        ServerJNI jni = new ServerJNI(symbol, writer);
        jni.generateCode();
    }

    public static void generateCode(Extendable symbol) throws CodeGenerationException {
        ServerJNI jni = new ServerJNI(symbol);
        jni.generateCode();
    }

    public synchronized void generateCode() throws CodeGenerationException {
        this.generateIncludes();
        this.generatePointerJLongConv();
        this.generateJNISkelData();
        this.generateInitData();
        this.generateCtor();
        this.generateDtor();
        this.writeCallLoad();
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!this.d_ext.isInterface() && method.isAbstract()) continue;
            this.generateMethod(method);
            this.d_writer.println();
        }
        this.generateSetEPV();
        if (this.d_ext.hasStaticMethod(true)) {
            this.generateSetSEPV();
        }
        this.d_writer.close();
    }

    private void generateIncludes() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.generateInclude("sidl_Java.h", false);
        this.d_writer.generateInclude("sidl_Loader.h", false);
        this.d_writer.generateInclude("sidl_String.h", false);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), false);
        this.d_writer.generateInclude("babel_config.h", false);
        this.d_writer.println();
    }

    private void generatePointerJLongConv() {
        this.d_writer.writeComment("Convert between jlong and void* pointers.", false);
        this.d_writer.disableLineBreak();
        this.d_writer.println("#if (SIZEOF_VOID_P == 8)");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(x))");
        this.d_writer.println("#else");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.println("#ifndef NULL");
        this.d_writer.println("#define NULL 0");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.enableLineBreak();
    }

    private void generateJNISkelData() {
        this.d_writer.writeComment("JNISkel data struct to cache JNIEnv, class, and needed MID's", true);
        this.d_writer.print("static struct ");
        this.d_writer.println(this.d_ext.getSymbolID().getFullName().replace('.', '_') + "_jniSkel__data");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("JNIEnv *env;");
        this.d_writer.println("jclass thisCls;");
        this.d_writer.println("jmethodID ctorMID;");
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (method.isAbstract()) continue;
            this.d_writer.println("jmethodID " + Java.getJavaServerMethodName(method) + "MID;");
        }
        this.d_writer.backTab();
        this.d_writer.println("} data;");
        this.d_writer.println();
    }

    private void generateInitData() {
        this.d_writer.writeComment("Method to initialize struct members", true);
        this.d_writer.println("static void");
        this.d_writer.println("init_data(void)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("if(data.env == NULL) {");
        this.d_writer.tab();
        this.generateInitEnv();
        this.generateInitCls();
        this.generateJNIMethodID("ctor", null, false);
        List methods = (List)this.d_ext.getMethods(this.d_ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (method.isAbstract()) continue;
            String name = method.getLongMethodName() + "_Impl";
            String descriptor = Java.getJavaServerSignature(method);
            this.generateJNIMethodID(name, descriptor, method.isStatic());
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateCtor() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.writeComment("Constructor", true);
        this.d_writer.println("static void");
        this.d_writer.print(Java.getJNIFunction(IOR.getBuiltinMethod(3, id)) + "(");
        this.d_writer.println("struct " + id.getFullName().replace('.', '_') + "__object *self)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.print("jobject this = ");
        String[] args1 = new String[]{"data.env", "data.thisCls", "data.ctorMID", "POINTER_TO_JLONG(self)"};
        this.printCallToJNIMethod("NewObject", args1);
        this.d_writer.println(";");
        this.generateJNIException("");
        this.d_writer.print("self->d_data = ");
        String[] args2 = new String[]{"data.env", "this"};
        this.printCallToJNIMethod("NewGlobalRef", args2);
        this.d_writer.println(";");
        this.printCallToJNIMethod("DeleteLocalRef", args2);
        this.d_writer.println(";\n");
        this.generateJNIException("");
        this.d_writer.backTab();
        this.d_writer.println("}\n");
    }

    private void generateDtor() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.writeComment("Deconstructing method", true);
        this.d_writer.println("static void");
        this.d_writer.print(Java.getJNIFunction(IOR.getBuiltinMethod(4, id)) + "(");
        this.d_writer.println("struct " + id.getFullName().replace('.', '_') + "__object *self)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("jfieldID j_ior = NULL;");
        this.d_writer.println("JNIEnv* env = sidl_Java_getEnv();");
        this.d_writer.println("j_ior = (*env)->GetFieldID(env, data.thisCls, \"d_ior\", \"J\");");
        this.d_writer.println("(*env)->SetLongField(env, (jobject)self->d_data, j_ior, POINTER_TO_JLONG(NULL));");
        this.d_writer.println("(*env)->DeleteGlobalRef(env, (jobject)self->d_data);");
        this.d_writer.backTab();
        this.d_writer.println("}\n");
    }

    private void writeCallLoad() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        Method load = IOR.getBuiltinMethod(5, id);
        this.d_writer.println("void " + IOR.getSymbolName(id) + "__call_load(void) { ");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("FIXME: Not implemented for Java yet");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateMethod(Method method) throws CodeGenerationException {
        this.generateMethodHeader(method);
        this.generateMethodBody(method);
    }

    private void generateSetEPV() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.openCxxExtern();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("initialize skel data struct");
        this.d_writer.println("init_data();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("initialize builtin methods");
        this.initializeEPVMethodPointer(IOR.getBuiltinMethod(3, id), id);
        this.initializeEPVMethodPointer(IOR.getBuiltinMethod(4, id), id);
        this.d_writer.println();
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.getDefinitionModifier() != 0 && m.getDefinitionModifier() != 2) continue;
            this.initializeEPVMethodPointer(m, id);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.closeCxxExtern();
        this.d_writer.println();
    }

    private void generateSetSEPV() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.openCxxExtern();
        this.d_writer.println("void");
        this.d_writer.print(IOR.getSetSEPVName(id));
        this.d_writer.print("(");
        this.d_writer.print(IOR.getSEPVName(id));
        this.d_writer.println(" *epv) {");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("initialize skel data struct");
        this.d_writer.println("init_data();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("initialize local methods");
        Iterator i = this.d_ext.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.getDefinitionModifier() != 3) continue;
            this.initializeEPVMethodPointer(m, id);
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.closeCxxExtern();
        this.d_writer.println();
    }

    private void generateInitEnv() {
        this.d_writer.println("data.env = sidl_Java_getEnv();");
        this.d_writer.println("if (data.env == NULL) {");
        this.d_writer.tab();
        this.d_writer.println("return;");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateInitCls() {
        this.d_writer.println("jclass tempCls = NULL;");
        this.d_writer.print("tempCls = ");
        String fullFilename = "\"" + this.d_ext.getSymbolID().getFullName().replace('.', '/') + "_Impl\"";
        String[] args = new String[]{"data.env", fullFilename};
        this.printCallToJNIMethod("FindClass", args);
        this.d_writer.println(";");
        this.generateJNIException("");
        this.d_writer.println("");
        this.d_writer.println("data.thisCls = (*data.env)->NewGlobalRef(data.env, tempCls);");
        this.d_writer.println("(*data.env)->DeleteLocalRef(data.env, tempCls);");
        this.generateJNIException("");
    }

    private void generateJNIMethodID(String name, String descriptor, boolean isStatic) {
        this.d_writer.print("data." + name + "MID = ");
        if (name.equals("ctor")) {
            String[] args1;
            String[] args = args1 = new String[]{"data.env", "data.thisCls", "\"<init>\"", "\"(J)V\""};
            this.printCallToJNIMethod("GetMethodID", args);
        } else {
            String[] args1;
            String[] args = args1 = new String[]{"data.env", "data.thisCls", "\"" + name + "\"", "\"" + descriptor + "\""};
            if (isStatic) {
                this.printCallToJNIMethod("GetStaticMethodID", args);
            } else {
                this.printCallToJNIMethod("GetMethodID", args);
            }
        }
        this.d_writer.println(";");
        this.generateJNIException("");
    }

    private void generateMethodHeader(Method m) throws CodeGenerationException {
        ArrayList args;
        this.d_writer.writeComment(m, false);
        this.d_writer.print("static ");
        this.d_writer.println(ServerJNI.getReturnString(m.getReturnType()));
        this.d_writer.println(Java.getJNIFunction(m) + "(");
        this.d_writer.tab();
        if (!m.isStatic()) {
            this.d_writer.print("struct " + this.d_ext.getSymbolID().getFullName().replace('.', '_') + "__object *self");
        }
        if ((args = m.getArgumentList()).isEmpty() && m.getThrows().isEmpty()) {
            if (m.isStatic()) {
                this.d_writer.print("void");
            }
            this.d_writer.println(")");
        } else {
            if (!m.isStatic()) {
                this.d_writer.println(",");
            }
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                this.d_writer.print(IOR.getArgumentWithFormal(arg, true, false, false));
                if (a.hasNext() || !m.getThrows().isEmpty()) {
                    this.d_writer.println(",");
                    continue;
                }
                this.d_writer.println(")");
            }
        }
        if (!m.getThrows().isEmpty()) {
            this.printExceptionArgument();
            this.d_writer.println(")");
        }
        this.d_writer.backTab();
    }

    private void generateMethodBody(Method m) throws CodeGenerationException {
        this.d_writer.println("{");
        this.d_writer.tab();
        this.generateSetUpForCallback(m);
        this.generateCallback(m);
        if (m.getThrows().isEmpty()) {
            this.generateJNIException(Java.getDefaultJNIReturnValue(m));
        } else {
            this.generateSIDLExceptionCatch(m);
        }
        this.processOutInout(m);
        this.generateReturn(m);
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateSetUpForCallback(Method m) throws CodeGenerationException {
        ArrayList args = m.getArgumentList();
        if (!m.isStatic()) {
            this.d_writer.writeCommentLine("Reference to the object");
            this.d_writer.println("jobject this = (jobject)(self->d_data);");
            this.d_writer.println();
        }
        this.declareJNIArgsList(m);
        if (!args.isEmpty()) {
            this.d_writer.writeCommentLine("Preprocess JNI variables");
            int i = 0;
            Iterator a = args.iterator();
            while (a.hasNext()) {
                Argument arg = (Argument)a.next();
                if (arg.hasArrayOrderSpec()) {
                    this.generateEnsureCall(arg);
                }
                Java.preprocessServerJNIArgument(this.d_writer, arg, "_tmp_");
                ++i;
            }
            this.d_writer.println();
        }
    }

    private void generateEnsureCall(Argument arg) throws CodeGenerationException {
        Type argType = arg.getType();
        String argName = arg.getFormalName();
        this.d_writer.print(Java.getJNIEnsureName(arg));
        if (arg.getMode() != 2) {
            this.d_writer.println(" = " + Java.getEnsureArray(argType.getArrayType()) + "(" + (arg.getMode() == 0 ? argName : "*" + argName) + ", " + argType.getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
        } else {
            this.d_writer.println(" = NULL;");
        }
    }

    private void generateOutEnsureCall(Argument arg) throws CodeGenerationException {
        Type argType = arg.getType();
        String argName = arg.getFormalName();
        this.d_writer.print("*" + argName);
        this.d_writer.println(" = " + Java.getEnsureArray(argType.getArrayType()) + "(" + Java.getJNIEnsureName(arg) + ", " + argType.getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
    }

    private void generateReturnEnsureCall(Type argType, String argName) throws CodeGenerationException {
        this.d_writer.print(Java.getJNIEnsureName(argName));
        this.d_writer.println(" = " + Java.getEnsureArray(argType.getArrayType()) + "(" + argName + ", " + argType.getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
    }

    private void declareJNIArgsList(Method m) throws CodeGenerationException {
        ArrayList args = m.getArgumentList();
        Type return_type = m.getReturnType();
        this.d_writer.writeCommentLine("Declare return and temp variables");
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (arg.getMode() == 0) {
                Java.declareJavaVariable(this.d_writer, arg.getType(), "_tmp_" + arg.getFormalName());
            } else {
                Java.declareServerInOutVariable(this.d_writer, arg.getType(), "_tmp_" + arg.getFormalName());
            }
            if (!arg.hasArrayOrderSpec()) continue;
            Java.declareIORVariable(this.d_writer, arg.getType(), Java.getJNIEnsureName(arg));
        }
        if (return_type.getType() != 0) {
            Java.declareJavaVariable(this.d_writer, return_type, JRETURN);
            Java.declareIORVariable(this.d_writer, return_type, CRETURN);
            if (return_type.hasArrayOrderSpec()) {
                Java.declareIORVariable(this.d_writer, return_type, "_ensure__retval");
            }
        }
        if (!m.getThrows().isEmpty()) {
            this.d_writer.println("*_ex = NULL;");
        }
        this.d_writer.println();
    }

    private void declareJNIReturn(Type t) throws CodeGenerationException {
        if (t.getDetailedType() != 0) {
            this.d_writer.writeCommentLine("Return variables");
            String jrtype = Java.getJNIReturnType(t);
            this.d_writer.println(jrtype + " " + JRETURN + ";");
            if (t.getDetailedType() == 10) {
                this.d_writer.println("const char* _temp_str = NULL;");
            }
            String rtype = ServerJNI.getReturnString(t);
            this.d_writer.println(rtype + " " + CRETURN + ";");
            this.d_writer.println();
        }
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private void printInitJVariable(Argument arg, String varname) throws CodeGenerationException {
        switch (arg.getType().getDetailedType()) {
            case 0: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 3: 
            case 5: {
                if (arg.getMode() == 0) {
                    this.printInitInComplex(arg, varname);
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                if (arg.getMode() == 0) {
                    this.d_writer.print(varname + " = ");
                    this.d_writer.print("(" + Java.getJNIReturnType(arg.getType()) + ")");
                    this.d_writer.println(arg.getFormalName() + ";");
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 10: {
                if (arg.getMode() == 0) {
                    String[] args = new String[]{"data.env", arg.getFormalName()};
                    this.d_writer.print(varname + " = ");
                    this.printCallToJNIMethod("NewStringUTF", args);
                    this.d_writer.println(";");
                    break;
                }
                this.printInitInoutOut(arg, varname);
                break;
            }
            case 15: {
                this.printInitObject(arg, varname);
                break;
            }
        }
    }

    private void printInitInoutOut(Argument arg, String varname) {
        String holderType = this.getSIDLHolderTypeName(arg.getType());
        String callSymbol = this.getSIDLConversionName(arg.getType());
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        String fullFilename = "\"sidl/" + holderType + "$Holder\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"()V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        String[] initargs = new String[]{"data.env", JCLS + arg.getFormalName(), JCTORMID + arg.getFormalName()};
        this.printCallToJNIMethod("NewObject", initargs);
        this.d_writer.println(";");
        this.d_writer.print("sidl_Java_I2J_" + callSymbol + "_holder");
        if (arg.getType().getDetailedType() == 5 || arg.getType().getDetailedType() == 3) {
            this.d_writer.println("(data.env," + varname + ", " + arg.getFormalName() + ");");
        } else {
            this.d_writer.println("(data.env," + varname + ", *" + arg.getFormalName() + ");");
        }
        this.d_writer.println();
    }

    private void printInitInComplex(Argument arg, String varname) {
        String holderType = this.getSIDLHolderTypeName(arg.getType());
        String callSymbol = this.getSIDLConversionName(arg.getType());
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        String fullFilename = "\"sidl/" + holderType + "\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"()V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        this.d_writer.print("sidl_Java_I2J_" + callSymbol);
        this.d_writer.println("(data.env, &" + arg.getFormalName() + ");");
    }

    private void printInitObject(Argument arg, String varname) {
        this.d_writer.print("if (_jCls_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        String fullFilename = ("\"" + arg.getType().getTypeString()).replace('.', '/') + "\"";
        String[] ctorargs = new String[]{"data.env", fullFilename};
        this.d_writer.print(JCLS + arg.getFormalName() + " = ");
        this.printCallToJNIMethod("FindClass", ctorargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print("if (_jCtorMID_" + arg.getFormalName() + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        this.d_writer.print(JCTORMID + arg.getFormalName() + " = ");
        String[] midargs = new String[]{"data.env", JCLS + arg.getFormalName(), "\"<init>\"", "\"(J)V\""};
        this.printCallToJNIMethod("GetMethodID", midargs);
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.print(varname + " = ");
        String[] objargs = new String[]{"data.env", JCLS + arg.getFormalName(), JCTORMID + arg.getFormalName(), JPTR + arg.getFormalName()};
        this.printCallToJNIMethod("NewObject", objargs);
        this.d_writer.println(";");
    }

    private String getSIDLHolderTypeName(Type t) {
        String holderType = null;
        switch (t.getDetailedType()) {
            case 0: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                holderType = "FloatComplex";
                break;
            }
            case 3: {
                holderType = "DoubleComplex";
                break;
            }
            case 11: {
                holderType = "Enum";
                break;
            }
            case 7: {
                holderType = "Integer";
                break;
            }
            case 2: {
                holderType = "Character";
                break;
            }
            case 1: {
                holderType = "Boolean";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                StringBuffer sb = new StringBuffer(t.getTypeString());
                sb.setCharAt(0, (char)(sb.charAt(0) - 32));
                holderType = sb.toString();
            }
        }
        return holderType;
    }

    private String getSIDLConversionName(Type t) {
        String callSymbol = null;
        switch (t.getDetailedType()) {
            case 0: 
            case 9: 
            case 11: 
            case 12: {
                callSymbol = "cls";
                break;
            }
            case 13: {
                callSymbol = "ifc";
                break;
            }
            case 16: {
                callSymbol = "array";
                break;
            }
            case 2: {
                callSymbol = "character";
                break;
            }
            case 1: {
                callSymbol = "boolean";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: {
                callSymbol = t.getTypeString();
            }
        }
        return callSymbol;
    }

    private void generateCallback(Method m) throws CodeGenerationException {
        this.d_writer.writeCommentLine("Callback to java method");
        Type t = m.getReturnType();
        String jniCallType = this.getJNICallbackType(t);
        if (t.getDetailedType() != 0) {
            this.d_writer.print("_j_retval = ");
        }
        ArrayList methodArgs = m.getArgumentList();
        String[] args = new String[3 + methodArgs.size()];
        args[0] = "data.env";
        args[2] = "data." + Java.getJavaServerMethodName(m) + "MID";
        int i = 3;
        Iterator a = methodArgs.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            args[i] = "_tmp_" + arg.getFormalName();
            ++i;
        }
        if (m.isStatic()) {
            args[1] = "data.thisCls";
            this.printCallToJNIMethod("CallStatic" + jniCallType + "Method", args);
        } else {
            args[1] = "this";
            this.printCallToJNIMethod("Call" + jniCallType + "Method", args);
        }
        this.d_writer.println(";");
    }

    private String getJNICallbackType(Type t) {
        String jniCallType = null;
        switch (t.getDetailedType()) {
            case 0: {
                jniCallType = "Void";
                break;
            }
            case 11: {
                jniCallType = "Int";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                jniCallType = "Object";
                break;
            }
            case 1: {
                jniCallType = "Boolean";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                StringBuffer sb = new StringBuffer(t.getTypeString());
                sb.setCharAt(0, (char)(sb.charAt(0) - 32));
                jniCallType = sb.toString();
                break;
            }
        }
        return jniCallType;
    }

    private void processOutInout(Method m) throws CodeGenerationException {
        ArrayList args = m.getArgumentList();
        this.d_writer.writeCommentLine("Postprocess inout/out args");
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            Java.postprocessServerJNIArgument(this.d_writer, arg, "_tmp_");
            if (!arg.hasArrayOrderSpec() || arg.getMode() == 0) continue;
            this.generateOutEnsureCall(arg);
        }
    }

    private void generateReturn(Method m) throws CodeGenerationException {
        Type return_type = m.getReturnType();
        Java.postprocessServerJNIReturn(this.d_writer, m.getReturnType(), JRETURN, CRETURN);
        if (return_type.hasArrayOrderSpec()) {
            this.generateReturnEnsureCall(return_type, CRETURN);
        }
        if (m.getReturnType().getDetailedType() != 0) {
            this.d_writer.println("return " + (return_type.hasArrayOrderSpec() ? "_ensure__retval" : CRETURN) + ";");
        }
    }

    private void generateNullCheckImmediateReturn(String var, String defaultReturn) {
        this.d_writer.print("if (" + var + " == NULL");
        this.d_writer.println(") {");
        this.d_writer.tab();
        this.d_writer.println("return " + defaultReturn + ";");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void printExceptionArgument() {
        this.d_writer.println("struct sidl_BaseInterface__object ** _ex");
    }

    private void generateJNIException(String defaultReturn) {
        this.d_writer.print("if (");
        String[] args = new String[]{"data.env"};
        this.printCallToJNIMethod("ExceptionCheck", args);
        this.d_writer.println(") {");
        this.d_writer.tab();
        this.printCallToJNIMethod("ExceptionDescribe", args);
        this.d_writer.println(";");
        this.d_writer.println("return " + defaultReturn + ";");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateSIDLExceptionCatch(Method m) {
        this.d_writer.println("if ((*data.env)->ExceptionCheck(data.env)) {");
        this.d_writer.tab();
        this.d_writer.println("jthrowable javaEx = (*data.env)->ExceptionOccurred(data.env);");
        this.d_writer.println("(*data.env)->ExceptionClear(data.env);");
        this.d_writer.println("if(sidl_Java_isSIDLException(data.env, javaEx)) {");
        this.d_writer.tab();
        this.d_writer.println("*_ex = sidl_Java_catch_SIDLException(data.env, javaEx, ");
        Iterator t = m.getThrows().iterator();
        while (t.hasNext()) {
            this.d_writer.println("\"" + ((SymbolID)t.next()).getFullName() + "\",");
        }
        this.d_writer.println("NULL);");
        this.d_writer.println("} ");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("If _ex is still Null, the exception was not expected.  ");
        this.d_writer.println("Re-throw the exception in order to print it and it's description.  ");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("if(*_ex == NULL) {");
        this.d_writer.tab();
        this.d_writer.println("if((*data.env)->Throw(data.env, javaEx)) {");
        this.d_writer.tab();
        this.d_writer.println("fprintf(stderr,\"Babel Java Skeleton: Caught unknown exception from\");");
        this.d_writer.println("fprintf(stderr, \"" + m.getLongMethodName() + " Unable to describe.\\n\");");
        this.d_writer.backTab();
        this.d_writer.println("} else {");
        this.d_writer.println("(*data.env)->ExceptionDescribe(data.env);");
        this.d_writer.println("} ");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Return all inout and out arguments a NULL", false);
        ArrayList args = m.getArgumentList();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (arg.getMode() != 1 && arg.getMode() != 2) continue;
            this.d_writer.println("*" + arg.getFormalName() + " = NULL; ");
        }
        this.d_writer.println("return 0;");
        this.d_writer.println("} ");
        this.d_writer.backTab();
    }

    private void printCallToJNIMethod(String name, String[] args) {
        this.d_writer.print("(*data.env)->");
        this.d_writer.print(name + "(");
        for (int i = 0; i < args.length - 1; ++i) {
            this.d_writer.print(args[i] + ", ");
        }
        this.d_writer.print(args[args.length - 1] + ")");
    }

    private void initializeEPVMethodPointer(Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: 
            case 3: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.print(" = ");
                this.d_writer.print(Java.getJNIFunction(m));
                this.d_writer.println(";");
                break;
            }
            case 1: {
                this.d_writer.print("epv->");
                this.d_writer.print(IOR.getVectorEntry(methodName));
                this.d_writer.println(" = NULL;");
                break;
            }
        }
    }

    private int countMethods() {
        int count;
        boolean isInterface = this.d_ext.isInterface();
        Collection methods = this.d_ext.getMethods(isInterface);
        if (isInterface) {
            count = methods.size();
        } else {
            count = 0;
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (m.isAbstract()) continue;
                ++count;
            }
        }
        return count;
    }
}

