/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Fortran
implements CodeConstants {
    private static final String[] s_f77_types = new String[]{"void", "logical", "character", "double complex", "double precision", "complex", "real", "integer*4", "integer*8", "integer*8", "character*(*)", "integer*4", "integer*8", "integer*8", "void", "integer*8"};
    private static final String[] s_f90_types = new String[]{"void", "logical", "character (len=1)", "complex (selected_real_kind(15, 307))", "real (selected_real_kind(15, 307))", "complex (selected_real_kind(6, 37))", "real (selected_real_kind(6, 37))", "integer (selected_int_kind(9))", "integer (selected_int_kind(18))", "integer (selected_int_kind(18))", "character (len=*)", "integer (selected_int_kind(9))"};
    private static final String[] s_cTypeMatchingFortran = new String[]{"void", "SIDL_F77_Bool", "char", "struct sidl_dcomplex", "double", "struct sidl_fcomplex", "float", "int32_t", "int64_t", "int64_t", "char *", "int32_t", "int64_t", "int64_t", "void", "int64_t", "int64_t"};
    private static final int s_Fortran_Bool = 1;
    private static final String s_F90_Bool = "SIDL_F90_Bool";
    private static final String s_F90_Array = "struct sidl_fortran_array";

    private Fortran() {
    }

    public static String getSymbolName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getSymbolNameForFile(SymbolID id) {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        return id.getFullName().replace('.', '_');
    }

    public static String getSymbolNameForFile(SymbolID id, boolean isImpl) {
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        if (s_babel_config.makePackageSubdirs() && s_babel_config.getShortFileNames()) {
            return id.getShortName().replace('.', '_');
        }
        return id.getFullName().replace('.', '_');
    }

    public static String getStubFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_fStub.c";
    }

    public static String getStubNameFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_fAbbrev.h";
    }

    public static String getStubDocFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + ".fif";
    }

    public static String getModuleFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "." + "F90";
    }

    public static String getTypeFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_type." + "F90";
    }

    public static String getTypeModule(SymbolID id) {
        return Fortran.getSymbolName(id) + "_type";
    }

    public static String getArrayModule(SymbolID id) {
        return Fortran.getSymbolName(id) + "_array";
    }

    public static String getArrayFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_array." + "F90";
    }

    public static String getTypeName(SymbolID id) {
        return Fortran.getSymbolName(id) + "_t";
    }

    public static String getArrayName(SymbolID id, int dim) {
        if (dim == 0) {
            return "sidl__array";
        }
        return Fortran.getSymbolName(id) + "_" + dim + "d";
    }

    public static String getModule(SymbolID id) {
        return Fortran.getSymbolName(id);
    }

    public static List reorderArguments(List args) {
        ArrayList<Argument> result = new ArrayList<Argument>(args.size());
        ArrayList<Argument> deferred = new ArrayList<Argument>(args.size());
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if (a.getType().isRarray()) {
                deferred.add(a);
                continue;
            }
            result.add(a);
        }
        result.addAll(deferred);
        return result;
    }

    public static String arrayIndices(Collection indices) {
        StringBuffer result = new StringBuffer();
        Iterator i = indices.iterator();
        result.append('(');
        while (i.hasNext()) {
            result.append("0:");
            result.append(i.next().toString());
            result.append("-1");
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        return result.toString();
    }

    public static boolean hasDirectAccess(Type t) {
        Type arrayType;
        if (t.getDetailedType() == 16 && null != (arrayType = t.getArrayType())) {
            switch (arrayType.getDetailedType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String getEnumStubFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + ".inc";
    }

    public static String getEnsureArray(Type arrayType) {
        switch (arrayType.getDetailedType()) {
            case 12: 
            case 13: {
                return "sidl_interface__array_ensure((struct sidl_interface__array *)";
            }
            case 11: {
                return "sidl_int__array_ensure((struct sidl_int__array *)";
            }
        }
        return "sidl_" + arrayType.getTypeString() + "__array_ensure(";
    }

    public static String getInitArray(Type arrayType) {
        return "sidl_" + arrayType.getTypeString() + "__array_init(";
    }

    public static String getDelRefArray(Type arrayType) {
        return "sidl__array_deleteRef((struct sidl__array *)";
    }

    public static String getEnumStubImpl(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_fStub.c";
    }

    public static String getSkelFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id) + "_fSkel.c";
    }

    public static String getImplExtension() {
        if (Fortran.isFortran90()) {
            return "F90";
        }
        return "f";
    }

    public static String getImplFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id, true) + "_Impl." + Fortran.getImplExtension();
    }

    public static String getImplModuleFile(SymbolID id) {
        return Fortran.getSymbolNameForFile(id, true) + "_Mod." + Fortran.getImplExtension();
    }

    public static String getMethodStubName(SymbolID id, Method method) {
        return Fortran.getSymbolName(id) + "_" + method.getLongMethodName() + Fortran.getMethodSuffix();
    }

    public static String getAltStubName(SymbolID id, Method method) {
        return Fortran.getSymbolName(id) + "_" + method.getLongMethodName() + Fortran.getAltSuffix();
    }

    public static String getMethodSuperName(SymbolID id, Method method) {
        return Fortran.getSymbolName(id) + "_" + "super_" + method.getLongMethodName() + Fortran.getMethodSuffix();
    }

    public static int getFortranVersion() {
        int fversion = Fortran.isFortran90() ? 90 : 77;
        return fversion;
    }

    public static String getMethodSuffix() {
        if (Fortran.isFortran90()) {
            return "_m";
        }
        return "_f";
    }

    public static String getAltSuffix() {
        return "_a";
    }

    public static String getImplMethodSuffix() {
        if (Fortran.isFortran90()) {
            return "_mi";
        }
        return "_fi";
    }

    public static String getFortranSymbol() {
        return "SIDLFortran" + Fortran.getFortranVersion() + "Symbol";
    }

    public static String getArrayDestructor(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_deleteRef" + Fortran.getMethodSuffix();
    }

    public static String getArrayConstructor(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_createRow" + Fortran.getMethodSuffix();
    }

    public static String getArraySet(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_set" + Fortran.getMethodSuffix();
    }

    public static String getArraySet(SymbolID id, int numArgs) {
        return Fortran.getSymbolName(id) + "__array_set" + Integer.toString(numArgs) + Fortran.getMethodSuffix();
    }

    public static String getArrayGet(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_get" + Fortran.getMethodSuffix();
    }

    public static String getArrayGet(SymbolID id, int numArgs) {
        return Fortran.getSymbolName(id) + "__array_get" + Integer.toString(numArgs) + Fortran.getMethodSuffix();
    }

    public static String getArrayDimen(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_dimen" + Fortran.getMethodSuffix();
    }

    public static String getArrayLower(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_lower" + Fortran.getMethodSuffix();
    }

    public static String getArrayUpper(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_upper" + Fortran.getMethodSuffix();
    }

    public static String getArrayLength(SymbolID id) {
        return Fortran.getSymbolName(id) + "__array_length" + Fortran.getMethodSuffix();
    }

    public static String getMethodImplName(SymbolID id, Method method, NameMangler mang) throws CodeGenerationException {
        try {
            return mang.shortName(id.getFullName(), method.getLongMethodName(), Fortran.getImplMethodSuffix());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException(uee.getMessage());
        }
    }

    public static String getMethodSuperImplName(SymbolID id, Method method, NameMangler mang) throws CodeGenerationException {
        try {
            return mang.shortName(id.getFullName(), "super_" + method.getLongMethodName(), Fortran.getImplMethodSuffix());
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException(uee.getMessage());
        }
    }

    public static String getMethodSkelName(SymbolID id, Method method) {
        return "skel_" + method.getLongMethodName();
    }

    public static String getFortranTypeInC(Type type) throws CodeGenerationException {
        int t = type.getDetailedType();
        if (t >= 0 && t < s_cTypeMatchingFortran.length) {
            if (Fortran.isFortran90()) {
                if (t == 1) {
                    return s_F90_Bool;
                }
                if (t == 16) {
                    return s_F90_Array;
                }
            }
            return s_cTypeMatchingFortran[t];
        }
        throw new CodeGenerationException("Unknown supported " + t);
    }

    public static String getFortranPrefix() {
        return "SIDL_F" + Fortran.getFortranVersion();
    }

    public static boolean needsAbbrev() {
        return !"f77".equals(BabelConfiguration.getInstance().getTargetLanguage());
    }

    public static boolean isFortran90() {
        return "f90".equals(BabelConfiguration.getInstance().getTargetLanguage());
    }

    public static String arrayIOR() {
        return Fortran.isFortran90() ? ".d_ior" : "";
    }

    public static Method createCast(SymbolID id) {
        Method m = new Method();
        m.setMethodName("_cast");
        m.setDefinitionModifier(3);
        String[] s = new String[]{"Cast method for interface and type conversions."};
        m.setComment(new Comment(s));
        m.setReturnType(new Type(id));
        Argument a = new Argument(false, 0, new Type(9), "ref");
        m.addArgument(a);
        return m;
    }

    public static Method createCastTwo(SymbolID id) throws CodeGenerationException {
        Method m = IOR.getBuiltinMethod(0, id).cloneMethod();
        m.setMethodName("_cast2");
        return m;
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        int t = type.getDetailedType();
        if (Fortran.isFortran90()) {
            if (t >= 0 && t < s_f90_types.length) {
                return s_f90_types[t];
            }
            switch (t) {
                case 12: 
                case 13: {
                    return "type(" + Fortran.getTypeName(type.getSymbolID()) + ")";
                }
                case 16: {
                    Type arrayType = type.getArrayType();
                    if (null != arrayType) {
                        if (type.isRarray()) {
                            return Fortran.getReturnString(arrayType);
                        }
                        if (arrayType.getDetailedType() <= 10) {
                            return "type(" + Fortran.getArrayName(new SymbolID("sidl." + arrayType.getTypeString(), new Version()), type.getArrayDimension()) + ")";
                        }
                        return "type(" + Fortran.getArrayName(arrayType.getSymbolID(), type.getArrayDimension()) + ")";
                    }
                    return "type(sidl__array)";
                }
            }
            throw new CodeGenerationException("Unknown supported " + t);
        }
        if (t >= 0 && t < s_f77_types.length) {
            return s_f77_types[t];
        }
        if (type.isArray()) {
            return type.isRarray() ? Fortran.getReturnString(type.getArrayType()) : "integer*8";
        }
        throw new CodeGenerationException("Unknown supported " + t);
    }
}

