/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.cxx.CxxImplHeader;
import gov.llnl.babel.backend.cxx.CxxImplSource;
import gov.llnl.babel.backend.cxx.CxxSkelSource;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateCxxServer
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
            }
        }
    }

    private void generateExtendable(Extendable extendable) throws CodeGenerationException {
        CxxSkelSource skelsource = new CxxSkelSource(extendable);
        skelsource.generateCode();
        CxxImplHeader implheader = new CxxImplHeader(extendable);
        CxxImplSource implsource = new CxxImplSource(extendable);
        implheader.generateCode();
        implsource.generateCode();
    }

    public String getType() {
        return "skel";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("c++");
        result.add("cxx");
        return result;
    }
}

