/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.ImplHeader;
import gov.llnl.babel.backend.c.StubSource;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{"sidl_general_order", "sidl_column_major_order", "sidl_row_major_order"};
    private static final String s_self = "self";

    public static void generateCode(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        writer.writeBanner(cls, C.getSkelFile(cls.getSymbolID()), false, "Server-side glue code for " + id.getFullName());
        writer.generateInclude(IOR.getHeaderFile(cls.getSymbolID()), false);
        writer.generateInclude(C.getHeaderFile(cls.getSymbolID()), false);
        writer.printlnUnformatted("#include <stddef.h>");
        if (cls.hasOverwrittenMethods()) {
            writer.generateInclude(IOR.getHeaderFile(id), false);
            writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            writer.printlnUnformatted("#include <stdio.h>");
            writer.printlnUnformatted("#include <stdlib.h>");
            writer.printlnUnformatted("#include \"sidl_Loader.h\"");
            writer.printlnUnformatted("#endif");
            writer.println();
            writer.println("extern void " + C.getObjectName(id) + "__superEPV(");
            writer.println("struct " + C.getObjectName(cls.getParentClass().getSymbolID()) + "__epv*);");
            StubSource.generateGetExternals(cls, writer);
        }
        writer.println();
        if (cls.getParentClass() == null) {
            SkelSource.writeIORCall(cls, C.getPrivateDestructor(id), IOR.getBuiltinMethod(1, id), writer);
        }
        ImplHeader.writeBuiltinDecls(writer, cls);
        ImplHeader.writeMethodDecls(writer, cls, true);
        ImplHeader.writeMethodDecls(writer, cls, false);
        SkelSource.writeSkelMethods(cls, writer);
        SkelSource.writeInitializeEPV(cls, writer);
        if (cls.hasStaticMethod(true)) {
            SkelSource.writeInitializeSEPV(cls, writer);
        }
        SkelSource.writeCallLoad(cls, writer);
        SkelSource.writeGetDataPointer(cls, writer);
        SkelSource.writeSetDataPointer(cls, writer);
    }

    private static void writeSkelMethods(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.hasArrayOrderSpec() && !m.hasRarray()) continue;
            if (IOR.supportInterceptors(cls)) {
                SkelSource.writeSkelMethod(cls.getSymbolID(), m, "_pre", writer);
                SkelSource.writeSkelMethod(cls.getSymbolID(), m, "", writer);
                SkelSource.writeSkelMethod(cls.getSymbolID(), m, "_post", writer);
                continue;
            }
            SkelSource.writeSkelMethod(cls.getSymbolID(), m, "", writer);
        }
    }

    private static String getArgValue(Argument arg) {
        return arg.getMode() == 0 ? arg.getFormalName() : "*" + arg.getFormalName();
    }

    private static void writeSkelMethod(SymbolID id, Method m, String suffix, LanguageWriterForC writer) throws CodeGenerationException {
        Argument arg;
        Argument arg2;
        boolean isNormal = suffix.equals("");
        Type methodReturn = m.getReturnType();
        boolean useReturn = isNormal && methodReturn.getType() != 0;
        String method_name = C.getMethodSkelName(id, m) + suffix;
        writer.print("static ");
        if (isNormal) {
            writer.println(SkelSource.getReturnString(methodReturn));
        } else {
            writer.println("void");
        }
        writer.println(method_name + "(");
        writer.tab();
        C.generateArgumentList(writer, s_self, false, id, m, true, true, false, true, false, false, false);
        writer.backTab();
        writer.println(")");
        writer.println("{");
        writer.tab();
        if (useReturn) {
            writer.println(SkelSource.getReturnString(methodReturn) + " _return;");
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println(SkelSource.getReturnString(methodReturn) + " _return_proxy;");
            }
        }
        List extArgs = Utilities.extendArgs(id, m, false);
        Iterator args = extArgs.iterator();
        HashMap index_args = m.getRarrayInfo();
        while (args.hasNext()) {
            Type argType;
            arg2 = (Argument)args.next();
            if (arg2.hasArrayOrderSpec()) {
                argType = arg2.getType();
                writer.print(SkelSource.getReturnString(argType) + " " + arg2.getFormalName() + "_proxy");
                if (arg2.getMode() != 2) {
                    writer.println(" = " + C.getEnsureArray(argType.getArrayType()) + "(" + SkelSource.getArgValue(arg2) + ", " + argType.getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
                } else {
                    writer.println(" = NULL;");
                }
            }
            if (!arg2.getType().isRarray()) continue;
            argType = arg2.getType();
            Type arrayType = argType.getArrayType();
            writer.print(IOR.getArgumentWithFormal(arg2, false, true, false) + "_tmp" + " = ");
            writer.println(arg2.getFormalName() + "_proxy->d_firstElement;");
        }
        Iterator i = index_args.values().iterator();
        while (i.hasNext()) {
            HashSet index_collection = (HashSet)i.next();
            Iterator tmp = index_collection.iterator();
            Method.RarrayInfo info = (Method.RarrayInfo)tmp.next();
            Argument index = info.index;
            Argument rarray = info.rarray;
            Type arrayType = rarray.getType().getArrayType();
            int dim = info.dim;
            String upper_func_name = "sidlLength";
            if (index.getType().getType() == 8) {
                writer.print("int64_t ");
            } else {
                writer.print("int32_t ");
            }
            writer.print(index.getFormalName() + " = " + upper_func_name + "(");
            writer.println(info.rarray.getFormalName() + "_proxy," + dim + ");");
        }
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg2 = (Argument)args.next();
            if (!arg2.hasArrayOrderSpec() || arg2.getMode() != 1 || arg2.getType().isRarray()) continue;
            writer.println(C.getDelRefArray(arg2.getType().getArrayType()) + "(" + SkelSource.getArgValue(arg2) + ");");
        }
        if (useReturn) {
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println("_return_proxy =");
            } else {
                writer.println("_return =");
            }
            writer.tab();
        }
        writer.println(C.getMethodImplName(id, m.getLongMethodName()) + suffix + "(");
        writer.tab();
        List callArgs = Utilities.extendArgs(id, m, true);
        args = callArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (arg.hasArrayOrderSpec() && !arg.getType().isRarray()) {
                if (0 != arg.getMode()) {
                    writer.print("&");
                }
                writer.print(arg.getFormalName() + "_proxy");
            } else if (arg.getType().isRarray()) {
                writer.print(arg.getFormalName() + "_tmp");
            } else {
                writer.print(arg.getFormalName());
            }
            if (!args.hasNext()) continue;
            writer.println(",");
        }
        writer.println(");");
        writer.backTab();
        if (useReturn) {
            writer.backTab();
        }
        args = extArgs.iterator();
        while (args.hasNext()) {
            arg = (Argument)args.next();
            if (arg.hasArrayOrderSpec() && !arg.getType().isRarray()) {
                Type argType = arg.getType();
                if (arg.getMode() != 0) {
                    writer.println(SkelSource.getArgValue(arg) + " = " + C.getEnsureArray(argType.getArrayType()) + "(" + arg.getFormalName() + "_proxy, " + arg.getType().getArrayDimension() + ", " + s_ensureOrderConstant[argType.getArrayOrder()] + ");");
                }
                writer.println(C.getDelRefArray(argType.getArrayType()) + "(" + arg.getFormalName() + "_proxy);");
            }
            if (!arg.getType().isRarray() || arg.getMode() != 1) continue;
            String r_name = arg.getFormalName();
            String init_func_name = IOR.getArrayNameForFunctions(arg.getType().getArrayType().getType()) + "_init";
            writer.println(init_func_name + "(" + r_name + "_tmp" + ", *" + r_name + ", " + arg.getType().getArrayDimension() + ", (*" + r_name + ")->d_metadata.d_lower, (*" + r_name + ")->d_metadata.d_upper, (*" + r_name + ")->d_metadata.d_stride);\n");
        }
        if (useReturn) {
            if (methodReturn.hasArrayOrderSpec()) {
                writer.println("_return = " + C.getEnsureArray(methodReturn.getArrayType()) + "(_return_proxy, " + methodReturn.getArrayDimension() + ", " + s_ensureOrderConstant[methodReturn.getArrayOrder()] + ");");
                writer.println(C.getDelRefArray(methodReturn.getArrayType()) + "(_return_proxy);");
            }
            writer.println("return _return;");
        }
        writer.backTab();
        writer.println("}");
        writer.println();
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, false, false);
    }

    private static void writeGetDataPointer(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println(C.getDataName(id) + "*");
        writer.println(C.getDataGetName(id) + "(" + C.getObjectName(id) + " self)");
        writer.println("{");
        writer.tab();
        writer.println("return (" + C.getDataName(id) + "*)" + "(self ? self->d_data : " + "NULL" + ");");
        writer.backTab();
        writer.println("}");
        writer.println();
    }

    private static void writeSetDataPointer(Class cls, LanguageWriter writer) {
        SymbolID id = cls.getSymbolID();
        writer.println("void " + C.getDataSetName(id) + "(");
        writer.tab();
        writer.println(C.getObjectName(id) + " self,");
        writer.println(C.getDataName(id) + "* data)");
        writer.backTab();
        writer.println("{");
        writer.tab();
        writer.println("if (self) {");
        writer.tab();
        writer.println("self->d_data = data;");
        writer.backTab();
        writer.println("}");
        writer.backTab();
        writer.println("}");
    }

    private static void writeInitializeEPV(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        writer.openCxxExtern();
        writer.println("void");
        writer.println(C.getSetEPVName(id) + "(" + IOR.getEPVName(id) + " *epv)");
        writer.println("{");
        writer.tab();
        SkelSource.initializeMethodPointer(writer, IOR.getBuiltinMethod(3, id), id);
        SkelSource.initializeMethodPointer(writer, IOR.getBuiltinMethod(4, id), id);
        if (IOR.supportAssertions(cls)) {
            SkelSource.initializeMethodPointer(writer, IOR.getBuiltinMethod(8, id), id);
        }
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            SkelSource.initializeMethodPointer(writer, m, id);
        }
        writer.println();
        if (cls.hasOverwrittenMethods()) {
            writer.println(C.getObjectName(id) + "__superEPV(_getExternals()->" + "getSuperEPV());");
        }
        writer.backTab();
        writer.println("}");
        writer.closeCxxExtern();
        writer.println();
    }

    private static void writeCallLoad(Class cls, LanguageWriterForC writer) {
        SymbolID id = cls.getSymbolID();
        String name = IOR.getSymbolName(id);
        writer.openCxxExtern();
        writer.println("void " + IOR.getCallLoadName(id) + "(void) { ");
        writer.tab();
        writer.println("impl_" + name + "__load();");
        writer.backTab();
        writer.println("}");
    }

    private static void initializeMethodPointer(LanguageWriter writer, Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        String epv = "epv";
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                String ename = IOR.getVectorEntry(methodName);
                String sname = C.getMethodSkelName(id, m);
                if (IOR.supportInterceptors(id) & !IOR.isBuiltinMethod(methodName)) {
                    SkelSource.writeMethodAssignment(writer, "epv", ename + "_pre", sname + "_pre");
                    SkelSource.writeMethodAssignment(writer, "epv", ename, sname);
                    SkelSource.writeMethodAssignment(writer, "epv", ename + "_post", sname + "_post");
                    break;
                }
                SkelSource.writeMethodAssignment(writer, "epv", ename, sname);
                break;
            }
            case 1: {
                SkelSource.writeMethodAssignment(writer, "epv", IOR.getVectorEntry(methodName), "NULL");
                break;
            }
        }
    }

    private static void writeInitializeSEPV(Class cls, LanguageWriterForC writer) throws CodeGenerationException {
        String epv = "sepv";
        SymbolID id = cls.getSymbolID();
        writer.openCxxExtern();
        writer.println("void");
        writer.println(C.getSetSEPVName(id) + "(" + IOR.getSEPVName(id) + " *" + "sepv" + ")");
        writer.println("{");
        writer.tab();
        if (IOR.supportAssertions(cls)) {
            SkelSource.writeMethodAssignment(writer, "sepv", IOR.getVectorEntry(IOR.getBuiltinName(8, true)), C.getMethodSkelName(id, IOR.getBuiltinMethod(8, id, true)));
        }
        Iterator i = cls.getMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            String name = m.getLongMethodName();
            String skelName = C.getMethodSkelName(id, m);
            if (IOR.supportInterceptors(cls) && !IOR.isBuiltinMethod(name, true)) {
                SkelSource.writeMethodAssignment(writer, "sepv", IOR.getVectorEntry(name + "_pre"), skelName + "_pre");
                SkelSource.writeMethodAssignment(writer, "sepv", IOR.getVectorEntry(name), skelName);
                SkelSource.writeMethodAssignment(writer, "sepv", IOR.getVectorEntry(name + "_post"), skelName + "_post");
                continue;
            }
            SkelSource.writeMethodAssignment(writer, "sepv", IOR.getVectorEntry(name), skelName);
        }
        writer.backTab();
        writer.println("}");
        writer.closeCxxExtern();
        writer.println();
    }

    private static void writeMethodAssignment(LanguageWriter writer, String var, String mname, String value) {
        writer.println(var + "->" + mname + " = " + value + ";");
    }

    private static void writeIORCall(Class cls, String funcName, Method iorMethod, LanguageWriter writer) throws CodeGenerationException {
        Argument a;
        SymbolID id = cls.getSymbolID();
        List extArgs = Utilities.extendArgs(id, iorMethod, false);
        Iterator args = extArgs.iterator();
        writer.println("void");
        writer.print(funcName);
        writer.print("(");
        while (args.hasNext()) {
            a = (Argument)args.next();
            writer.print(IOR.getArgumentWithFormal(a, false, false, false));
            if (!args.hasNext()) continue;
            writer.print(", ");
        }
        writer.println(") {");
        writer.tab();
        writer.println("if (self) {");
        writer.tab();
        writer.writeCommentLine("call the IOR method");
        writer.print("self->" + IOR.getEPVVar(0) + "->");
        writer.print(IOR.getVectorEntry(iorMethod.getLongMethodName()));
        writer.print("(");
        args = extArgs.iterator();
        while (args.hasNext()) {
            a = (Argument)args.next();
            writer.print(a.getFormalName());
            if (!args.hasNext()) continue;
            writer.print(", ");
        }
        writer.println(");");
        writer.backTab();
        writer.println("}");
        writer.backTab();
        writer.println("}");
        writer.println();
    }
}

