/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.ImplHeader;
import gov.llnl.babel.backend.c.ImplSource;
import gov.llnl.babel.backend.c.SkelSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LineCountingFilterWriter;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateServerC
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null || symbol.getSymbolType() != 12) continue;
            Class cls = (Class)symbol;
            this.generateSkeleton(cls);
            this.generateImplHeader(cls);
            this.generateImplSource(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSkeleton(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        PrintWriter pw = null;
        try {
            String f = C.getSkelFile(id);
            pw = FileManager.getInstance().createFile(id, 12, "SKELSRCS", f);
            LanguageWriterForC writer = new LanguageWriterForC(pw);
            SkelSource.generateCode(cls, writer);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void generateImplHeader(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        PrintWriter pw = null;
        try {
            String f = C.getImplHeaderFile(id);
            CodeSplicer splicer = FileManager.getInstance().getCodeSplicer(id, 12, f);
            Writer fw = FileManager.getInstance().createWriter(id, 12, "IMPLHDRS", f);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            pw = new PrintWriter(lcfw);
            LanguageWriterForC writer = new LanguageWriterForC(pw, lcfw);
            splicer.setLineRedirector(writer);
            ImplHeader.generateCode(cls, writer, splicer);
        }
        catch (IOException ex) {
            throw new CodeGenerationException(ex.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private void generateImplSource(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        PrintWriter pw = null;
        try {
            String f = C.getImplSourceFile(id);
            CodeSplicer splicer = FileManager.getInstance().getCodeSplicer(id, 12, f);
            Writer fw = FileManager.getInstance().createWriter(id, 12, "IMPLSRCS", f);
            LineCountingFilterWriter lcfw = new LineCountingFilterWriter(fw);
            pw = new PrintWriter(lcfw);
            LanguageWriterForC writer = new LanguageWriterForC(pw, lcfw);
            splicer.setLineRedirector(writer);
            ImplSource.generateCode(cls, writer, splicer);
        }
        catch (IOException ex) {
            throw new CodeGenerationException(ex.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public String getType() {
        return "skel";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("c");
        return result;
    }
}

