/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class IOR {
    public static final int MAJOR_VERSION = 0;
    public static final int MINOR_VERSION = 9;
    private static final String[] s_types = new String[]{"void", "sidl_bool", "char", "struct sidl_dcomplex", "double", "struct sidl_fcomplex", "float", "int32_t", "int64_t", "void*", "char*"};
    private static final String[] s_array_types = new String[]{null, "struct sidl_bool__array*", "struct sidl_char__array*", "struct sidl_dcomplex__array*", "struct sidl_double__array*", "struct sidl_fcomplex__array*", "struct sidl_float__array*", "struct sidl_int__array*", "struct sidl_long__array*", "struct sidl_opaque__array*", "struct sidl_string__array*"};
    private static final String[] s_builtinMethods = new String[]{"_cast", "_delete", "_exec", "_ctor", "_dtor", "_load", "_checks", "_iceptors", "_check_error", "_dump_stats"};
    private static final String[] s_builtin_comments = new String[]{"Cast method for interface and class type conversions.", "Delete method called automatically by IOR to destroy object.", "Select and execute a method by name", "Class constructor called when the class is created.", "Class destructor called when the class is deleted.", "Static class initializer called exactly once before any user-defined method is dispatched", "Method to set the level of checking SIDL-specified assertions.", "Method to set whether or not method interceptors should be invoked.", "Method to handle assertion violations.", "Method to dump assertion checking statistics."};
    public static final int INTERFACE_BUILTIN_METHODS = 3;
    public static final int CLASS_BUILTIN_METHODS = 10;
    public static final int CAST = 0;
    public static final int DELETE = 1;
    public static final int EXEC = 2;
    public static final int CONSTRUCTOR = 3;
    public static final int DESTRUCTOR = 4;
    public static final int LOAD = 5;
    public static final int CHECKS = 6;
    public static final int INTERCEPTORS = 7;
    public static final int CHECK_ERROR = 8;
    public static final int DUMP_STATS = 9;
    private static final int BUILTIN_MIN = 0;
    private static final int BUILTIN_MAX = 9;
    private static final String s_default_version = "0.9.0";
    private static SymbolID s_exceptionID = null;
    private static String s_exceptionFundamentalType = null;
    private static String s_objectType = null;
    private static String s_interfaceType = null;
    public static String FUND_EXCEPTION_CALL_PREFIX = "sidl.BaseInterface".replace('.', '_');
    public static String PRECONDITION_CALL_PREFIX = "sidl.PreconditionViolation".replace('.', '_');
    public static String POSTCONDITION_CALL_PREFIX = "sidl.PostconditionViolation".replace('.', '_');
    public static String INVARIANT_CALL_PREFIX = "sidl.InvariantViolation".replace('.', '_');
    public static final boolean SUPPORT_ASSERTIONS;
    public static final String ASSERTION_LEVEL;
    public static final boolean SUPPORT_INTERCEPTORS;
    private static final String[] s_epv_type;
    public static final int PUBLIC_EPV = 0;
    public static final int BASE_EPV = 1;
    private static final int MIN_EPV_TYPE = 0;
    private static final int MAX_EPV_TYPE = 1;
    public static final int SET_PUBLIC = 0;
    public static final int SET_ASSERTIONS = 1;
    public static final int SET_INTERCEPTORS = 2;
    private static final int SET_MINIMUM = 0;
    private static final int SET_MAXIMUM = 2;
    private static final String[] s_SET_EPV_NAMES;
    public static final int EPV_NEW = 0;
    public static final int EPV_OLD = 1;
    public static final int EPV_REMOTE = 2;
    public static final int EPV_STATIC = 3;
    private static final int EPV_MINIMUM = 0;
    private static final int EPV_MAXIMUM = 3;
    private static final String[] s_EPV_DESC;
    public static final String GENERIC_PRE_SUFFIX = "_pre";
    public static final String GENERIC_POST_SUFFIX = "_post";
    public static final int GENERIC_SUFFIX_MAXLEN = 5;
    public static final String D_CALLS = "calls";
    public static final String D_CHECKS = "checking_level";
    public static final String D_CONTROLS = "d_controls";
    public static final String D_COUNTDOWN = "countdown";
    public static final String D_DATA = "d_data";
    public static final String D_INTERCEPTORS = "use_iceptors";
    public static final String D_METHOD_CONTROLS = "method_controls";
    public static final String D_METHOD_EXCEPT = "method_exceptions";
    public static final String D_SUCCESSES = "successes";
    public static final String D_RATE = "check_rate";
    public static final String D_TRIES = "tries";
    public static final String S_CONTROLS = "s_control_stats";
    public static final String S_DUMP_FILE = "s_dump_fptr";
    public static final String DEFAULT_CHECK_LEVEL = "CHECK_ALL_TYPES | CHECK_ALWAYS";
    public static final String DEFAULT_OPTION_INTERCEPTORS = "0";
    public static final String DEFAULT_THRESHOLD = "0.03";
    public static final String S_FULL_STATS_MACRO = "SIDL_FULL_ASTATS";
    public static final String S_TEXT_STATS_MACRO = "SIDL_TEXT_ASTATS";
    public static final String s_static_suffix = "_static";

    public static String getLockStaticGlobalsMacroName() {
        return "LOCK_STATIC_GLOBALS";
    }

    public static String getUnlockStaticGlobalsMacroName() {
        return "UNLOCK_STATIC_GLOBALS";
    }

    public static String getHaveLockStaticGlobalsMacroName() {
        return "HAVE_LOCKED_STATIC_GLOBALS";
    }

    public static Method getBuiltinMethod(int index, SymbolID id, boolean sVersion) throws CodeGenerationException {
        Method m = new Method();
        m.setMethodName(IOR.getBuiltinName(index));
        if (index == 5 || sVersion) {
            m.setDefinitionModifier(3);
        } else {
            m.setDefinitionModifier(0);
        }
        String[] s = new String[]{sVersion ? "Static " + s_builtin_comments[index] : s_builtin_comments[index]};
        m.setComment(new Comment(s));
        Argument a = null;
        switch (index) {
            case 0: {
                a = new Argument(false, 0, new Type(10), "name");
                m.addArgument(a);
                m.setReturnType(new Type(9));
                break;
            }
            case 2: {
                a = new Argument(false, 0, new Type(10), "methodName");
                m.addArgument(a);
                Symbol tmpSym = Utilities.lookupSymbol("sidl.io.Deserializer");
                a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "inArgs");
                m.addArgument(a);
                tmpSym = Utilities.lookupSymbol("sidl.io.Serializer");
                a = new Argument(false, 0, new Type(tmpSym.getSymbolID()), "outArgs");
                m.addArgument(a);
                m.setReturnType(new Type(0));
                break;
            }
            case 6: {
                a = new Argument(false, 0, new Type(7), "level");
                m.addArgument(a);
                a = new Argument(false, 0, new Type(4), "rate");
                m.addArgument(a);
                a = new Argument(false, 0, new Type(7), "resetCounters");
                m.addArgument(a);
                m.setReturnType(new Type(0));
                break;
            }
            case 7: {
                a = new Argument(false, 0, new Type(7), "on");
                m.addArgument(a);
                m.setReturnType(new Type(0));
                break;
            }
            case 8: {
                a = new Argument(false, 0, new Type(10), "msg");
                m.addArgument(a);
                m.setReturnType(new Type(0));
                break;
            }
            case 9: {
                a = new Argument(false, 0, new Type(10), "filename");
                m.addArgument(a);
                m.setReturnType(new Type(0));
                break;
            }
            default: {
                m.setReturnType(new Type(0));
            }
        }
        return m;
    }

    public static Method getBuiltinMethod(int index, SymbolID id) throws CodeGenerationException {
        return IOR.getBuiltinMethod(index, id, false);
    }

    public static boolean hasStaticBuiltin(int index) {
        boolean has = false;
        if (index == 6 || index == 7 || index == 8 || index == 9) {
            has = true;
        }
        return has;
    }

    public static String getBuiltinName(int index, boolean sVersion) {
        return s_builtinMethods[index] + (sVersion ? s_static_suffix : "");
    }

    public static String getBuiltinName(int index) {
        return IOR.getBuiltinName(index, false);
    }

    public static boolean isBuiltinMethod(String methodName, boolean sVersion) {
        boolean isBuiltin = false;
        for (int i = 0; i <= 9 && !isBuiltin; ++i) {
            if (!IOR.hasStaticBuiltin(i) || !methodName.equals(IOR.getBuiltinName(i, sVersion))) continue;
            isBuiltin = true;
        }
        return isBuiltin;
    }

    public static boolean isBuiltinMethod(String methodName) {
        boolean isBuiltin = false;
        for (int i = 0; i <= 9 && !isBuiltin; ++i) {
            if (!methodName.equals(IOR.getBuiltinName(i, false))) continue;
            isBuiltin = true;
        }
        return isBuiltin;
    }

    public static boolean isBuiltinBasic(int ind) {
        boolean is = false;
        if (0 <= ind && ind <= 4) {
            is = true;
        }
        return is;
    }

    public static boolean isBuiltinAssert(int ind) {
        boolean is = false;
        if (ind == 6 || ind == 8 || ind == 9) {
            is = true;
        }
        return is;
    }

    public static String getVectorEntry(String methodName) {
        StringBuffer buf = new StringBuffer(2 + methodName.length());
        buf.append("f_").append(methodName);
        return buf.toString();
    }

    public static String getHeaderFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_IOR.h";
    }

    public static String getSourceFile(SymbolID id) {
        return id.getFullName().replace('.', '_') + "_IOR.c";
    }

    public static String getSymbolName(SymbolID id) {
        return id.getFullName().replace('.', '_');
    }

    public static String getEnumName(SymbolID id) {
        return C.getEnumName(id);
    }

    public static String getExternalName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__external";
    }

    public static String getExternalFunc(SymbolID id) {
        return IOR.getSymbolName(id) + "__externals";
    }

    public static String getObjectName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__object";
    }

    public static String getArrayName(SymbolID id) {
        return null != id ? "struct " + IOR.getSymbolName(id) + "__array" : "struct sidl__array";
    }

    public static String getArrayName(int intType) {
        return s_array_types[intType];
    }

    public static String getArrayNameWithoutAsterix(int intType) {
        return s_array_types[intType].substring(0, s_array_types[intType].length() - 1);
    }

    public static String getArrayNameForFunctions(int intType) {
        return s_array_types[intType].substring(7, s_array_types[intType].length() - 1);
    }

    public static boolean isSIDLSymbol(SymbolID id) {
        return id.getFullName().toUpperCase().startsWith("sidl");
    }

    public static boolean isSIDLSymbol(Extendable ext) {
        return IOR.isSIDLSymbol(ext.getSymbolID());
    }

    public static boolean supportAssertions(Extendable ext) {
        return SUPPORT_ASSERTIONS && ext.hasAssertions() && !IOR.isSIDLSymbol(ext);
    }

    public static boolean supportInterceptors(Extendable ext) {
        return SUPPORT_INTERCEPTORS && !IOR.isSIDLSymbol(ext);
    }

    public static boolean supportInterceptors(SymbolID id) {
        return SUPPORT_INTERCEPTORS && !IOR.isSIDLSymbol(id);
    }

    public static boolean supportBaseEPVAttr(Extendable ext) {
        return IOR.supportInterceptors(ext) && IOR.supportAssertions(ext);
    }

    public static String getMethodDescDataStruct(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__method";
    }

    public static String getMethodDescDataName(SymbolID id) {
        return "s_ior_" + IOR.getSymbolName(id) + "_method";
    }

    public static String getControlsStruct(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__controls";
    }

    public static String getMethodControlsStruct(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__method_controls";
    }

    public static String getEPVName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__epv";
    }

    public static String getSEPVName(SymbolID id) {
        return "struct " + IOR.getSymbolName(id) + "__sepv";
    }

    public static String getEPVType(int type) {
        String ret = "";
        if (0 <= type && type <= 1) {
            ret = s_epv_type[type];
        }
        return ret;
    }

    public static String getEPVVar(int type) {
        String etype = IOR.getEPVType(type);
        return etype.equals("") ? "d_epv" : "d_" + etype + "epv";
    }

    public static String getSetEPVTypeName(int type) {
        int t = 0;
        if (0 <= type && type <= 2) {
            t = type;
        }
        return s_SET_EPV_NAMES[t];
    }

    public static String getNewName(SymbolID id) {
        return IOR.getSymbolName(id) + "__new";
    }

    public static String getRemoteName(SymbolID id) {
        return IOR.getSymbolName(id) + "__remote";
    }

    public static String getSetEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__set_epv";
    }

    public static String getSetSEPVName(SymbolID id) {
        return IOR.getSymbolName(id) + "__set_sepv";
    }

    public static String getEPVPrefix(int epvType) {
        int type = 0;
        if (0 <= epvType && epvType <= 3) {
            type = epvType;
        }
        return "s_" + s_EPV_DESC[type] + "_epv";
    }

    public static String getStaticEPVVariable(SymbolID id, int epvType, int setType) {
        String name = IOR.getSymbolName(id).toLowerCase();
        String type = IOR.getSetEPVTypeName(setType);
        return IOR.getEPVPrefix(epvType) + (type.equals("") ? "" : "_" + type) + "__" + name;
    }

    public static void generateStaticEPVVariables(LanguageWriterForC lw, Extendable ext, boolean has_static, boolean is_remote, int setType) {
        SymbolID id = ext.getSymbolID();
        String sType = "static " + IOR.getEPVName(id);
        String sTypeStr = has_static ? sType + "  " : sType + " ";
        String ssTypeStr = "static " + IOR.getSEPVName(id) + " ";
        if (!ext.isInterface() && !is_remote) {
            lw.print(sTypeStr);
            lw.println(IOR.getStaticEPVVariable(id, 0, setType) + ";");
        }
        if (is_remote) {
            lw.print(sTypeStr);
            lw.println(IOR.getStaticEPVVariable(id, 2, setType) + ";");
        }
        if (has_static) {
            lw.print(ssTypeStr);
            lw.println(IOR.getStaticEPVVariable(id, 3, setType) + ";");
        }
        lw.println();
    }

    public static String getCallLoadName(SymbolID id) {
        return IOR.getSymbolName(id) + "__call_load";
    }

    public static String getLocalStaticsName(SymbolID id) {
        return IOR.getSymbolName(id) + "__get_static_epv";
    }

    public static String getStaticsName(SymbolID id) {
        return IOR.getSymbolName(id) + "__statics";
    }

    public static String getInitName(SymbolID id) {
        return IOR.getSymbolName(id) + "__init";
    }

    public static String getFiniName(SymbolID id) {
        return IOR.getSymbolName(id) + "__fini";
    }

    public static String getVersionName(SymbolID id) {
        return IOR.getSymbolName(id) + "__IOR_version";
    }

    public static String getExceptionFundamentalType() {
        return s_exceptionFundamentalType;
    }

    public static String getClassType() {
        return s_objectType;
    }

    public static String getInterfaceType() {
        return s_interfaceType;
    }

    public static String getPreconditionExceptType() {
        return "struct " + PRECONDITION_CALL_PREFIX + "__object *";
    }

    public static String getPostconditionExceptType() {
        return "struct " + POSTCONDITION_CALL_PREFIX + "__object *";
    }

    public static String getInvariantExceptType() {
        return "struct " + INVARIANT_CALL_PREFIX + "__object *";
    }

    public static String getSymbolType(Symbol sym) {
        if (sym.getSymbolType() == 11) {
            return IOR.getEnumName(sym.getSymbolID());
        }
        return IOR.getObjectName(sym.getSymbolID()) + "*";
    }

    public static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    public static String getReturnString(Type type, boolean objPtr, boolean inStub) throws CodeGenerationException {
        int t = type.getType();
        if (t < s_types.length) {
            return s_types[t];
        }
        if (t == 15) {
            Symbol symbol = Utilities.lookupSymbol(type.getSymbolID());
            SymbolID id = symbol.getSymbolID();
            if (symbol.getSymbolType() == 11) {
                return C.getEnumName(id);
            }
            if (objPtr) {
                return C.getSymbolObjectPtr(id);
            }
            return C.getObjectName(id);
        }
        if (t == 16) {
            Type atype = type.getArrayType();
            if (inStub && type.isRarray()) {
                return IOR.getReturnString(atype, objPtr, inStub) + "*";
            }
            if (null != atype) {
                int a = atype.getType();
                if (a < s_array_types.length) {
                    return s_array_types[a];
                }
                return IOR.getArrayName(atype.getSymbolID()) + "*";
            }
            return IOR.getArrayName(null) + "*";
        }
        return null;
    }

    public static String getArgumentString(Method method) throws CodeGenerationException {
        StringBuffer argstring = new StringBuffer();
        boolean has_throws = !method.getThrows().isEmpty();
        ArrayList args = method.getArgumentList();
        if (args.size() > 0 || has_throws) {
            argstring.append(",");
        }
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            argstring.append(IOR.getArgumentString(arg, true, false, false));
            if (!a.hasNext() && !has_throws) continue;
            argstring.append(",");
        }
        if (has_throws) {
            argstring.append(IOR.getExceptionFundamentalType());
            argstring.append('*');
        }
        return argstring.toString();
    }

    public static String getArgumentString(Argument arg) throws CodeGenerationException {
        return IOR.getArgumentString(arg, false, false, false);
    }

    public static String getArgumentString(Argument arg, boolean objPtr, boolean inStub, boolean isExec) throws CodeGenerationException {
        Type type = arg.getType();
        String s = IOR.getReturnString(type, objPtr, inStub);
        if (arg.getMode() == 0) {
            if (type.getType() == 10) {
                s = "const " + s;
            }
        } else if (!(inStub && type.isRarray() || isExec)) {
            s = s + "*";
        }
        return s;
    }

    public static String getArgumentWithFormal(Argument arg) throws CodeGenerationException {
        return IOR.getArgumentWithFormal(arg, false, false, false);
    }

    public static String getArgumentWithFormal(Argument arg, boolean objPtr, boolean inStub, boolean isExec) throws CodeGenerationException {
        return IOR.getArgumentString(arg, objPtr, inStub, isExec) + " " + arg.getFormalName();
    }

    public static String getCast(Method method, String self) throws CodeGenerationException {
        StringBuffer cast = new StringBuffer();
        cast.append("(");
        cast.append(IOR.getReturnString(method.getReturnType(), true, false));
        cast.append(" (*)(");
        cast.append(self);
        cast.append(IOR.getArgumentString(method));
        cast.append("))");
        return cast.toString();
    }

    public static String getStaticTypeOption(SymbolID id, int type) {
        int t = 0;
        if (0 <= type && type <= 2) {
            t = type;
        }
        String name = IOR.getSetEPVTypeName(t).toUpperCase();
        return "s_SEPV_" + IOR.getSymbolName(id).toUpperCase() + "_" + (name.equals("") ? "BASE" : name);
    }

    public static String getMethodIndex(SymbolID id, Method meth) {
        return "s_IOR_" + IOR.getSymbolName(id).toUpperCase() + "_" + meth.getLongMethodName().toUpperCase();
    }

    public static String getMethodIndex(SymbolID id, String lit) {
        return "s_IOR_" + IOR.getSymbolName(id).toUpperCase() + "_" + lit.toUpperCase();
    }

    static {
        s_exceptionID = new SymbolID(BabelConfiguration.getBaseExceptionType(), new Version(s_default_version));
        s_exceptionFundamentalType = IOR.getObjectName(s_exceptionID) + " *";
        SymbolID id = new SymbolID(BabelConfiguration.getBaseClass(), new Version());
        s_objectType = IOR.getObjectName(id) + " *";
        id = new SymbolID(BabelConfiguration.getBaseInterface(), new Version());
        s_interfaceType = IOR.getObjectName(id) + " *";
        SUPPORT_ASSERTIONS = BabelConfiguration.getInstance().generateAssertions();
        ASSERTION_LEVEL = BabelConfiguration.getInstance().getAssertionLevel();
        SUPPORT_INTERCEPTORS = BabelConfiguration.getInstance().generateInterceptors();
        s_epv_type = new String[]{"", "b"};
        s_SET_EPV_NAMES = new String[]{"", "assertions", "interceptors"};
        s_EPV_DESC = new String[]{"new", "old", "rem", "stc"};
    }

    public static class CompareMethods
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            return m1.getLongMethodName().compareTo(m2.getLongMethodName());
        }
    }
}

