;;; -*- Mode: LISP; Package: CL-USER -*-
;;;
;;; Copyright Peter Van Eynde, 2001
;;;
;;; License: LGPL v2
;;;
(in-package "CL-USER")

(load "/usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp")

(common-lisp-controller:init-common-lisp-controller 
   "/usr/lib/common-lisp/acl6/")

;;; make the directory if you're nobody:
(ensure-directories-exist 
 (make-pathname 
  :directory
  (pathname-directory      
   (translate-logical-pathname 
    (compile-file-pathname
     "cl-library:;defsystem;defsystem.lisp")))))

;;; try to compile too:
(let ((*compile-print* nil)               ; tell where the compiler is
      (*compile-progress* nil)
      (*load-verbose* nil)
      (*compile-verbose*  nil)
      (*require-verbose* nil)
      (*gc-verbose* nil))
  
   (compile-file "cl-library:;defsystem;defsystem.lisp"
		 :output-file
		 (compile-file-pathname
		  "cl-library:;defsystem;defsystem.lisp")
		 :progress nil
		 :print nil
		 :verbose nil))

;; normally try to load the fasl if it's the latest
;; otherwise try to load the source:

(load (compile-file-pathname
       "cl-library:;defsystem;defsystem.fasl")
      :if-does-not-exist :error
      :verbose nil)
;; it loaded, configure it for common-lisp-controller use:
(push "cl-systems:"
      (symbol-value (intern "*CENTRAL-REGISTRY*"
			    (find-package :make))))

