/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventIn.java,v 1.2 1997/09/19 15:20:50 mpichler Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.Field;
import iicm.vrml.vrwave.Scene;

public class EventIn
{
  /**
   * Get the type of this EventIn (specified in FieldTypes.java).
   */

  public int getType ()
  {
    return fieldtype_;
  }


  /** VRwave implementation. do not call from applets */

  protected Field eventin_;
  protected Scene scene_;
  protected int fieldtype_;
  protected double lastevent_ = 0.0;

  public void initialize (Field eventin, int fieldtype, Scene scene)
  {
    eventin_ = eventin;
    scene_ = scene;
    fieldtype_ = fieldtype;
  }

  protected void sendEvent ()
  {
    while (scene_.currentTime () == lastevent_) { }  // don't send two or more events with same timestamp
    lastevent_ = scene_.currentTime ();
    eventin_.sendEvent (lastevent_);
  }
}
