/*
 * LocationDialog - open location dialog
 * contributed by Martin Buechler <s570714@tfh-berlin.de>
 *
 * created: mbuechler, 19970410
 *
 * changed: mpichler, 19970522
 *
 * $Id: DialogOpenLocation.java,v 1.4 1997/08/06 16:42:49 mpichler Exp $
 */


package iicm.vrml.vrwave;

import iicm.widgets.Fontify;

import java.awt.*;


/**
 * LocationDialog - open location dialog
 *
 * @author Martin Buechler, Michael Pichler
 * @version 1.0, latest change: 22 May 1997
 */

class DialogOpenLocation extends Dialog
{
  private String urlString = null;
  private TextField urlfield_ = null;
  private Button ok_, reset_, clear_, cancel_;

  public DialogOpenLocation (Frame parent)
  {
    super (parent, Translator.getLabel (Translator.L_OPENLOCATION), true);  // modal

    Panel ifield = new Panel ();
    ifield.setLayout (new FlowLayout (FlowLayout.CENTER, 10, 10));
    ifield.add (new Label ("URL: "));
    ifield.add (urlfield_ = new TextField ("http://", 64));

    Panel buttons = new Panel ();
    buttons.setLayout (new FlowLayout (FlowLayout.CENTER, 10, 10));
    buttons.setFont (Fontify.fntButton);
    buttons.add (ok_ = new Button (Translator.getLabel (Translator.B_OK)));
    buttons.add (reset_ = new Button (Translator.getLabel (Translator.B_RESET)));
    buttons.add (clear_ = new Button (Translator.getLabel (Translator.B_CLEAR)));
    buttons.add (cancel_ = new Button (Translator.getLabel (Translator.B_CANCEL)));

    add ("Center", ifield);
    add ("South", buttons);

    setFont (Fontify.fntLabel1);
    pack ();
  }

  public boolean action (Event e, Object arg)
  {
    if (e.target == urlfield_ || e.target == ok_)
    {
      urlString = urlfield_.getText ();
      // System.out.println (evt.toString ());
      dispose ();
      return true;
    }
    if (e.target == reset_)
    {
      urlfield_.setText ("http://");
      return true;
    }
    if (e.target == clear_)
    {
      urlfield_.setText ("");
      return true;
    }
    if (e.target == cancel_)
    {
      urlString = null;
      dispose ();
      return true;
    }
    return false;
  } // action

  public String getURLString ()
  {
    return urlString;  // null in case of cancel
  }

} // DialogOpenLocation
