/*
 * Copyright 1988, 1992 Hiroto Kagotani
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Hiroto Kagotani not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 *
 * HIROTO KAGOTANI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL HIROTO KAGOTANI BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 * 
 * Author:
 * 	Hiroto Kagotani
 * 	Dept. of Computer Science
 *	Tokyo Institute of Technology
 * 	2-12-2 Ookayama, Meguro-ku Tokyo 152 Japan
 * 	kagotani@cs.titech.ac.jp
 */ 

#include	<stdio.h>
#include	<ctype.h>	/* isxdigit() macro */
#include	<strings.h>	/* bzero() function */
#include	<sys/param.h>	/* howmany(), MAX(), MIN() macro */
#include	"def.h"

#define		xdigit(c)	((c)>='a' ? (c)-'a'+10\
					  : (c)>='A' ? (c)-'A'+10\
						     : (c)-'0')

static int	bbw;
static int	newbbw;
static int	bbh;
static int	newbbh;
static int	graylevel;

static int	bit[8] = { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01 };


processChar()
{
	char	*malloc();
	char	*srcimage;
	int	*dstgray;

	startchar();
	encoding();
	swidth();
	dwidth();
	bbx();
	processAttributes();
	bitmap();

	srcimage = (char*)malloc(bbw * bbh * sizeof(char));
	bzero(srcimage, bbw * bbh * sizeof(char));
	dstgray = (int*)malloc(newbbw * newbbh * sizeof(int));
	bzero(dstgray, newbbw * newbbh * sizeof(int));

	read_image(srcimage);
	magnify(srcimage, dstgray);
	write_image(dstgray);

	free(dstgray);
	free(srcimage);

	endchar();
}


processAttributes()
{
	get_line();
	if (beginwith(linebuf, "ATTRIBUTES")) { /* optional */
		put_line();
		get_line();
	}
}


startchar()
{
	get_line();
	if (!beginwith(linebuf, "STARTCHAR")) {
		error("STARTCHAR expected\n");
	}
	put_line();
}


encoding()
{
	get_line();
	if (!beginwith(linebuf, "ENCODING")) {
		error("ENCODING expected\n");
	}
	put_line();
}


swidth()
{
	int	arg1, arg2;
	int	newwx, newwy;

	get_line();
	if (!beginwith(linebuf, "SWIDTH")) {
		error("SWIDTH expected\n");
	}
	if (sscanf(linebuf, "SWIDTH %d %d", &arg1, &arg2) != 2) {
		error("SWIDTH has illegal arguments\n");
	}
	newwx = WRESIZE(arg1);
	newwy = HRESIZE(arg2);
	sprintf(linebuf, "SWIDTH %d %d", newwx, newwy);
	put_line();
}


dwidth()
{
	int	arg1, arg2;
	int	newwx, newwy;

	get_line();
	if (!beginwith(linebuf, "DWIDTH")) {
		error("DWIDTH expected\n");
	}
	if (sscanf(linebuf, "DWIDTH %d %d", &arg1, &arg2) != 2) {
		error("DWIDTH has illegal arguments\n");
	}
	newwx = WRESIZE(arg1);
	newwy = HRESIZE(arg2);
	sprintf(linebuf, "DWIDTH %d %d", newwx, newwy);
	put_line();
}


bbx()
{
	int	arg1, arg2, arg3, arg4;
	int	newbbox, newbboy;

	get_line();
	if (!beginwith(linebuf, "BBX")) {
		error("BBX expected\n");
	}
	if (sscanf(linebuf, "BBX %d %d %d %d", &arg1, &arg2, &arg3, &arg4) != 4
	  || arg1 < 0 || arg2 < 0) {
		error("BBX has illegal arguments\n");
	}
	bbw = arg1;
	newbbw = WRESIZE(arg1);
	bbh = arg2;
	newbbh = HRESIZE(arg2);
	graylevel = bbw * bbh / blackness;

	newbbox = XRESIZE(arg3);
	newbboy = YRESIZE(arg4);
	sprintf(linebuf, "BBX %d %d %d %d", newbbw, newbbh, newbbox, newbboy);
	put_line();
}


bitmap()
{
	if (!beginwith(linebuf, "BITMAP")) {
		error("BITMAP expected\n");
	}
	put_line();
}


endchar()
{
	get_line();
	if (!beginwith(linebuf, "ENDCHAR")) {
		error("ENDCHAR expected\n");
	}
	put_line();
}


read_image(srcimage)
char	*srcimage;
{
	int	x, y, i;
	int	byte;

	for (y = 0; y < bbh; y ++) {
		get_line();
		for (x = 0; x < bbw; x += 8) {
			byte = get_byte(linebuf+x/4);
			for (i = 0; i < 8 && x+i < bbw; i ++) {
				*srcimage++ = ((byte & bit[i]) != 0);
			}
		}
	}
}


get_byte(cp)
char	*cp;
{
	int	byte = 0;
	if (!isxdigit(*cp)) {
		error("illegal raster data\n");
	}
	byte |= xdigit(*cp);
	byte <<= 4;
	cp ++;
	if (!isxdigit(*cp)) {
		error("illegal raster data\n");
	}
	byte |= xdigit(*cp);
	return byte;
}


magnify(srcimage, dstgray)
register char	*srcimage;
register int	*dstgray;
{
	register int	x, y;

	for (y = 0; y < bbh; y ++) {
		for (x = 0; x < bbw; x ++) {
			if (srcimage[y*bbw + x]) {
				countup_score(dstgray, x, y);
			}
		}
	}
}


countup_score(dstgray, x, y)
int	*dstgray;
int	x;
int	y;
{
	int	X = x * newbbw;
	int	Y = y * newbbh;
	int	X1 = X + newbbw;
	int	Y1 = Y + newbbh;

	int	newx, newy;
	int	newxbegin = X / bbw;
	int	newybegin = Y / bbh;
	int	newxend = howmany(X1, bbw);
	int	newyend = howmany(Y1, bbh);

	for (newy = newybegin; newy < newyend; newy ++) {
		for (newx = newxbegin; newx < newxend; newx ++) {
			int	newX = newx * bbw;
			int	newY = newy * bbh;
			int	newX1 = newX + bbw;
			int	newY1 = newY + bbh;
			dstgray[newy * newbbw + newx] +=
				(MIN(X1,newX1) - MAX(X,newX))
				  * (MIN(Y1,newY1) - MAX(Y,newY));
		}
	}
}


write_image(dstgray)
register int	*dstgray;
{
	register int	x, y, i;
	for (y = 0; y < newbbh; y ++) {
		register int	*row = dstgray + y*newbbw;
		for (x = 0; x < newbbw; x += 8) {
			register int	byte = 0;
			for (i = 0; i < 8 && x+i < newbbw; i ++) {
				if (row[x + i] >= graylevel) {
					byte |= bit[i];
				}
			}
			printf("%02X", byte);
		}
		printf("\n");
	}
}
