// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        tiosrc_p.C
// 
// Purpose:     
// 
// Created:     18 Jun 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: tiosrc_p.C,v 1.2 1996/10/03 12:02:50 jfasch Exp $
// 
// $Log: tiosrc_p.C,v $
// Revision 1.2  1996/10/03 12:02:50  jfasch
// verbose.h and assert.h moved
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#include "tiosrc_p.h"

#include "tio.h"

#include <hyperg/utils/assert.h>

// --------------------------------------------------------------------
bool TIOSourcePassive :: start (TIOSourcePassiveUser* u) {
   hgassert (!user_, "TIOSourcePassive::start(): already being used by someone else") ;
   hgassert (u, "TIOSourcePassive::start(): nil user") ;
   user_ = u ;
   return start_() ;
}

void TIOSourcePassive :: stop (const TIOSourcePassiveUser* u) {
   hgassert (user_==u, "TIOSourcePassive::stop(): can be stopped by my user") ;
   user_ = nil ;
   stop_() ;
}

void TIOSourcePassive :: ready_(const TransparentIOPtr& io) const {
   hgassert (user_, "TIOSourcePassive::ready_(): not being used") ;
   hgassert (io, "TIOSourcePassive::ready_(): nil io") ;
   user_->tioSrcPReady (this, io) ;
}

void TIOSourcePassive :: error_() const {
   hgassert (user_, "TIOSourcePassive::error_(): not being used") ;
   user_->tioSrcPError (this) ;
}
