/* main.c - Contains main function */

#ifndef lint
char RCS_main_c[] =
"$Id: main.c,v 2.4 1998/08/11 17:36:46 caleishm Exp caleishm $  Produced by Chris Leishman & Trevor Cohn.  Ormond College student IT department, 1998.$\n";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include "main.h"
#include "config.h"
#include "redir.h"
#include "utils.h"

#ifndef SYSCONFDIR
	#define SYSCONFDIR "/etc/"
#endif
#define CONFIG     "urlredir.conf"
#define DIRSEP     '/'
#define MAXLINELEN 1000

char *path_concat(const char *, const char *);

/* Yes, a global variable, but it's the easiest way to pass around the address
   for logging purposes... */

char *address = NULL;


/* The main function obtains the data structure using load_config, then
   reads lines of input from stdin for processing.  It first breaks these
   input lines into url and source address before calling redirect to 
   process the url. */

int main(void)
{
	char line[MAXLINELEN];
	char *url = NULL;
	char *fname = NULL;
	item *data;
	int i;

   fname = path_concat(SYSCONFDIR, CONFIG);
   data = load_config(fname);
   free(fname);

	setbuf(stdin, NULL);
	setbuf(stdout, NULL);
	srand(time(NULL));

	while (fgets(line, MAXLINELEN, stdin) != NULL) {
		strlower(line, MAXLINELEN);
		url = line;
		for(i = 0; !isspace(line[i]); i++);
		line[i++] = '\0';
		while(isspace(line[i])) i++;
		address = line + i;
		for(;!isspace(line[i]); i++);
		line[i] = '\0';
#ifdef DEBUG
		printf("Read url %s.  Source address %s.\n", url, address);
#endif
		redirect(data, url); 
	}


	/* We shouldn't be exiting */

	return EXIT_FAILURE;
}


/* path_concat takes a directory and a file and returns a string with
   the two joined together.  The appropriate memory for this string is
   first malloc'ed. */

char *path_concat(const char *dir, const char *file)
{
	char *p_concat;
	int dirsize;

	if (!dir)
		return strdup(file);

	dirsize = strlen(dir);
	p_concat = safemalloc(dirsize + strlen(file) + 2);

	strncpy(p_concat, dir, dirsize); 

	if (file[0] == DIRSEP && p_concat[dirsize-1] == DIRSEP) {
		p_concat[dirsize-1] = '\0';
		dirsize--;
	}
	else if (file[0] != DIRSEP && p_concat[dirsize-1] != DIRSEP) {
		p_concat[dirsize] = DIRSEP;
		p_concat[dirsize+1] = '\0';
		dirsize++;
	}

	strncat (p_concat, file, sizeof(p_concat) - dirsize - 2);

	return p_concat;
}

