/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

#include "StCaptureView.h"
#include "UGraphicGizmos.h"

// 
//		
// 

StCaptureView::StCaptureView(LView& inView)
	:	mOffscreenMacWorld(nil),
		mView(inView)
{
	Init();

	SDimension16 theViewFrameSize;
	mView.GetFrameSize(theViewFrameSize);
	
	mPortionToCapture.left		= mPortionToCapture.top = 0;
	mPortionToCapture.right		= mPortionToCapture.left + theViewFrameSize.width;
	mPortionToCapture.bottom	= mPortionToCapture.top  + theViewFrameSize.height;
}

// 
//		
// 

StCaptureView::StCaptureView(LView& inView, const Rect& inPortionToCapture)
	:	mOffscreenMacWorld(nil),
		mView(inView),
		mPortionToCapture(inPortionToCapture)
{
	Init();
}

// 
//		
// 

void
StCaptureView::Init()
{
	if (mView.IsActive())
		mActive = triState_On;
		
	if (mView.IsEnabled())
		mEnabled = triState_On;
		
	if (mView.IsVisible())
		mVisible = triState_On;
}

// 
//		
// 

StCaptureView::~StCaptureView()
{
}

// 
//		
// 

void StCaptureView::Capture(CGWorld& ioWorld)
{
	try
	{
		PlaceInSuperFrameAt(-mPortionToCapture.left, -mPortionToCapture.top, false);
		ResizeFrameTo(
						mPortionToCapture.right  - mPortionToCapture.left,
						mPortionToCapture.bottom - mPortionToCapture.top,
						false);

		InstallOccupant(&mView, kAlignNone);

		Rect theSaveFrame = ioWorld.GetBounds();
		if (!ioWorld.BeginDrawing())
		{
			throw memFullErr;
		}

		mOffscreenMacWorld = ioWorld.GetMacGWorld();

		OutOfFocus(nil);
		mView.Draw(nil);
		OutOfFocus(nil);

		ioWorld.EndDrawing();
		ioWorld.UpdateOrigin(topLeft(theSaveFrame));		

		RemoveOccupant();
		mOffscreenMacWorld = nil;
	}
	catch (...)
	{
		RemoveOccupant();
		mOffscreenMacWorld = nil;
		throw;
	}
}

// 
//		
// 

Boolean StCaptureView::EstablishPort(void)
{
	GrafPtr	thisPort = GetMacPort();
	Boolean	portSet = (thisPort != nil);
	if (portSet && (UQDGlobals::GetCurrentPort() != thisPort))
		{
		if (thisPort == (GrafPtr)mOffscreenMacWorld)
			::SetGWorld((GWorldPtr)thisPort, nil);
		else
			::SetPort(thisPort);
		}
	return portSet;
}

// 
//		
// 

GrafPtr StCaptureView::GetMacPort(void) const
{
	GrafPtr	theMacPort;
	if (mOffscreenMacWorld != nil)
		theMacPort = (GrafPtr)mOffscreenMacWorld;
	else
		theMacPort = LView::GetMacPort();

	return theMacPort;
}

