/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
/*	dblower.c	*/
/*
	This function contain the doublebyte to lower table which need to implement function in
	intlcomp.c.
	None of the function in this file should be made public
	The interface function is INTL_GetDoubleByteToLowerMap() and it should only be called 
	inside libi18n
*/
#include "intlpriv.h"
#include "pintlcmp.h"

PRIVATE DoubleByteToLowerMap lower_lookup_none[]=
{	
	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};

#ifndef XP_UNIX
PRIVATE DoubleByteToLowerMap lower_lookup_sjis[]=
{	
	/*	Full-width Latin */
	{ 0x82, 0x60, 0x7a, 0x82, 0x81 },	
	
	/*	Map Full-width Hiragana to  Full-width Katakana */
	{ 0x82, 0x9f, 0x9f, 0x83, 0x41 },	/*	A	*/
	{ 0x82, 0xa0, 0xa0, 0x83, 0x41 },

	{ 0x82, 0xa1, 0xa1, 0x83, 0x43 },	/*	I	*/
	{ 0x82, 0xa2, 0xa2, 0x83, 0x43 },

	{ 0x82, 0xa3, 0xa3, 0x83, 0x45 },	/*	U	*/
	{ 0x82, 0xa4, 0xa4, 0x83, 0x45 },

	{ 0x82, 0xa5, 0xa5, 0x83, 0x47 },	/*	E	*/
	{ 0x82, 0xa6, 0xa6, 0x83, 0x47 },

	{ 0x82, 0xa7, 0xa7, 0x83, 0x49 },	/*	O	*/
	{ 0x82, 0xa8, 0xa8, 0x83, 0x49 },
	
	{ 0x82, 0xa9, 0xc0, 0x83, 0x4a },	/* KA - DI */

	{ 0x82, 0xc1, 0xc1, 0x83, 0x63 },	/* TU */
	{ 0x82, 0xc2, 0xc2, 0x83, 0x63 },

	{ 0x82, 0xc3, 0xdd, 0x83, 0x64 },	/* DU - MI */
	{ 0x82, 0xde, 0xe0, 0x83, 0x80 },	/* MU - MO */

	{ 0x82, 0xe1, 0xe1, 0x83, 0x84 },	/* YA	*/
	{ 0x82, 0xe2, 0xe2, 0x83, 0x84 },

	{ 0x82, 0xe3, 0xe3, 0x83, 0x86 },	/* YU	*/
	{ 0x82, 0xe4, 0xe4, 0x83, 0x86 },

	{ 0x82, 0xe5, 0xe5, 0x83, 0x88 },	/* YO	*/
	{ 0x82, 0xe6, 0xe6, 0x83, 0x88 },

	{ 0x82, 0xe7, 0xeb, 0x83, 0x89 },	/* RA - RO */

	{ 0x82, 0xec, 0xec, 0x83, 0x8f },	/* WA	*/
	{ 0x82, 0xed, 0xed, 0x83, 0x8f },

	{ 0x82, 0xee, 0xf1, 0x83, 0x90 },	/* WI - N */

	/*	Map SMALL Full-width Katakana to Full-width Katakana */
	{ 0x83, 0x40, 0x40, 0x83, 0x41 },	/*	A	*/
	{ 0x83, 0x42, 0x42, 0x83, 0x43 },	/*	I	*/
	{ 0x83, 0x43, 0x44, 0x83, 0x45 },	/*	U	*/
	{ 0x83, 0x46, 0x46, 0x83, 0x47 },	/*	E	*/
	{ 0x83, 0x48, 0x47, 0x83, 0x49 },	/*	O	*/
	{ 0x83, 0x62, 0x62, 0x83, 0x63 },	/* TU	*/
	{ 0x83, 0x83, 0x83, 0x83, 0x84 },	/* YA	*/
	{ 0x83, 0x85, 0x85, 0x83, 0x86 },	/* YU	*/
	{ 0x83, 0x87, 0x87, 0x83, 0x88 },	/* YO	*/
	{ 0x83, 0x8e, 0x8e, 0x83, 0x8f },	/* WA	*/

	/*	Full-width Greek */
	{ 0x83, 0x9f, 0xb6, 0x83, 0xbf },	
	
	/*	Full-width Cyrillic*/
	{ 0x84, 0x40, 0x4e, 0x84, 0x70 },	/* Part 1 */
	{ 0x84, 0x4f, 0x61, 0x84, 0x80 },	/* Part 2 */
	
	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};
#endif
/* Don't #ifdef XP_UNIX for lower_lookup_eucjp. It is also used by GB2312 */
PRIVATE DoubleByteToLowerMap lower_lookup_eucjp[]=
{	
	/*	Half-width Katakana */
	{ SS2,  0xa6, 0xa6, 0xa5, 0xf2 },	/*	WO */
	
	{ SS2,  0xa7, 0xa7, 0xa5, 0xa2 },	/*	A */
	{ SS2,  0xa8, 0xa8, 0xa5, 0xa4 },	/*	I */
	{ SS2,  0xa9, 0xa9, 0xa5, 0xa6 },	/*	U */
	{ SS2,  0xaa, 0xaa, 0xa5, 0xa8 },	/*	E */
	{ SS2,  0xab, 0xab, 0xa5, 0xaa },	/*	O */
	
	{ SS2,  0xac, 0xac, 0xa5, 0xe4 },	/*	YA */
	{ SS2,  0xad, 0xad, 0xa5, 0xe6 },	/*	YU */
	{ SS2,  0xae, 0xae, 0xa5, 0xe8 },	/*	YO */
	{ SS2,  0xaf, 0xaf, 0xa5, 0xc4 },	/*	TU */
	
	{ SS2,  0xb1, 0xb1, 0xa5, 0xa2 },	/*	A */
	{ SS2,  0xb2, 0xb2, 0xa5, 0xa4 },	/*	I */
	{ SS2,  0xb3, 0xb3, 0xa5, 0xa6 },	/*	U */
	{ SS2,  0xb4, 0xb4, 0xa5, 0xa8 },	/*	E */
	{ SS2,  0xb5, 0xb5, 0xa5, 0xaa },	/*	O */
	
	{ SS2,  0xb6, 0xb6, 0xa5, 0xab },	/*	KA */
	{ SS2,  0xb7, 0xb7, 0xa5, 0xad },	/*	KI */
	{ SS2,  0xb8, 0xb8, 0xa5, 0xaf },	/*	KU */
	{ SS2,  0xb9, 0xb9, 0xa5, 0xb1 },	/*	KE */
	{ SS2,  0xba, 0xba, 0xa5, 0xb3 },	/*	KO */
	
	{ SS2,  0xbb, 0xbb, 0xa5, 0xb5 },	/*	SA */
	{ SS2,  0xbc, 0xbc, 0xa5, 0xb7 },	/*	SI */
	{ SS2,  0xbd, 0xbd, 0xa5, 0xb9 },	/*	SU */
	{ SS2,  0xbe, 0xbe, 0xa5, 0xbb },	/*	SE */
	{ SS2,  0xbf, 0xbf, 0xa5, 0xbd },	/*	SO */
	
	{ SS2,  0xc0, 0xc0, 0xa5, 0xbf },	/*	TA */
	{ SS2,  0xc1, 0xc1, 0xa5, 0xc1 },	/*	TI */
	{ SS2,  0xc2, 0xc2, 0xa5, 0xc4 },	/*	TU */
	{ SS2,  0xc3, 0xc3, 0xa5, 0xc6 },	/*	TE */
	{ SS2,  0xc4, 0xc4, 0xa5, 0xc8 },	/*	TO */
	
	{ SS2,  0xc5, 0xc9, 0xa5, 0xca },	/*	NA - NO */
	
	{ SS2,  0xca, 0xca, 0xa5, 0xcf },	/*	HA */
	{ SS2,  0xcb, 0xcb, 0xa5, 0xd2 },	/*	HI */
	{ SS2,  0xcc, 0xcc, 0xa5, 0xd5 },	/*	HU */
	{ SS2,  0xcd, 0xcd, 0xa5, 0xd8 },	/*	HE */
	{ SS2,  0xce, 0xce, 0xa5, 0xdb },	/*	HO */
	
	{ SS2,  0xcf, 0xd3, 0xa5, 0xde },	/*	MA - MO */
	
	{ SS2,  0xd4, 0xd4, 0xa5, 0xe4 },	/*	YA */
	{ SS2,  0xd5, 0xd5, 0xa5, 0xe6 },	/*	YU */
	{ SS2,  0xd6, 0xd6, 0xa5, 0xe8 },	/*	YO */

	{ SS2,  0xd7, 0xdb, 0xa5, 0xe9 },	/*	RA - RO */

	{ SS2,  0xdc, 0xdc, 0xa5, 0xef },	/*	WA */

	{ SS2,  0xdd, 0xdd, 0xa5, 0xf3 },	/*	N */
	
	/*	Full-width Latin */
	{ 0xa3, 0xc1, 0xda, 0xa3, 0xe1 },	
	
	/*	Map Full-width Hiragana to  Full-width Katakana */
	{ 0xa4, 0xa1, 0xa1, 0xa5, 0xa2 },	/*	A	*/
	{ 0xa4, 0xa2, 0xa2, 0xa5, 0xa2 },

	{ 0xa4, 0xa3, 0xa3, 0xa5, 0xa4 },	/*	I	*/
	{ 0xa4, 0xa4, 0xa4, 0xa5, 0xa4 },

	{ 0xa4, 0xa5, 0xa5, 0xa5, 0xa6 },	/*	U	*/
	{ 0xa4, 0xa6, 0xa6, 0xa5, 0xa6 },

	{ 0xa4, 0xa7, 0xa7, 0xa5, 0xa8 },	/*	E	*/
	{ 0xa4, 0xa8, 0xa8, 0xa5, 0xa8 },

	{ 0xa4, 0xa9, 0xa9, 0xa5, 0xaa },	/*	O	*/
	{ 0xa4, 0xaa, 0xaa, 0xa5, 0xaa },	
	
	{ 0xa4, 0xab, 0xc2, 0xa5, 0xab},	/* KA - DI */

	{ 0xa4, 0xc3, 0xc3, 0xa5, 0xc4 },	/* TU */
	{ 0xa4, 0xc4, 0xc4, 0xa5, 0xc4 },

	{ 0xa4, 0xc5, 0xe2, 0xa5, 0xc5 },	/* DU - MO */

	{ 0xa4, 0xe3, 0xe3, 0xa5, 0xe4 },	/* YA	*/
	{ 0xa4, 0xe4, 0xe4, 0xa5, 0xe4 },

	{ 0xa4, 0xe5, 0xe5, 0xa5, 0xe6 },	/* YU	*/
	{ 0xa4, 0xe6, 0xe6, 0xa5, 0xe6 },

	{ 0xa4, 0xe7, 0xe7, 0xa5, 0xe8 },	/* YO	*/
	{ 0xa4, 0xe8, 0xe8, 0xa5, 0xe8 },

	{ 0xa4, 0xe9, 0xed, 0xa5, 0xe9},	/* RA - RO */

	{ 0xa4, 0xee, 0xee, 0xa5, 0xef },	/* WA	*/
	{ 0xa4, 0xef, 0xef, 0xa5, 0xef },

	{ 0xa4, 0xf0, 0xf3, 0xa5, 0xf0 },	/* WI - N */
	
	/*	Map SMALL Full-width Katakana to Full-width Katakana */
	{ 0xa5, 0xa1, 0xa1, 0xa5, 0xa2 },	/*	A	*/
	{ 0xa5, 0xa3, 0xa3, 0xa5, 0xa4 },	/*	I	*/
	{ 0xa5, 0xa5, 0xa5, 0xa5, 0xa6 },	/*	U	*/
	{ 0xa5, 0xa7, 0xa7, 0xa5, 0xa8 },	/*	E	*/
	{ 0xa5, 0xa9, 0xa9, 0xa5, 0xaa },	/*	O	*/
	{ 0xa5, 0xc3, 0xc3, 0xa5, 0xc4 },	/* TU	*/
	{ 0xa5, 0xe3, 0xe3, 0xa5, 0xe4 },	/* YA	*/
	{ 0xa5, 0xe5, 0xe5, 0xa5, 0xe6 },	/* YU	*/
	{ 0xa5, 0xe7, 0xe7, 0xa5, 0xe8 },	/* YO	*/
	{ 0xa5, 0xee, 0xee, 0xa5, 0xef },	/* WA	*/
	
	/*	Full-width Greek */
	{ 0xa6, 0xa1, 0xb8, 0xa6, 0xc1 },	
	/*	Full-width Cyrillic*/
	{ 0xa7, 0xa1, 0xc1, 0xa7, 0xd1 },	

	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};	
PRIVATE DoubleByteToLowerMap lower_lookup_big5[]=
{	
	/*	Full-width Latin */
	{ 0xa2, 0xcf, 0xe4, 0xa2, 0xe9 },	/* Part 1 A-V */
	{ 0xa2, 0xe5, 0xe8, 0xa3, 0x40 },	/* Part 2 W-Z */
	
	/*	Full-width Greek */
	{ 0xa3, 0x44, 0x5b, 0xa3, 0x5c },

	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};	
PRIVATE DoubleByteToLowerMap lower_lookup_cns11643_1[]=
{	
	/*	Roman Number  */
	{ 0xa4, 0xab, 0xb4, 0xa6, 0xb5 },	
	
	/*	Full-width Latin */
	{ 0xa4, 0xc1, 0xda, 0xa4, 0xdb },	
	
	/*	Full-width Greek */
	{ 0xa4, 0xf5, 0xfe, 0xa5, 0xaf },	/* Part 1 Alpha - kappa */
	{ 0xa5, 0xa1, 0xae, 0xa5, 0xb9 },	/* Part 2 Lamda - Omega */

	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};	
PRIVATE DoubleByteToLowerMap lower_lookup_ksc5601[]=
{	
	/*	Full-width Latin */
	{ 0xa3, 0xc1, 0xda, 0xa3, 0xe1 },	

	/*	Full-width Roman Number */
	{ 0xa5, 0xb0, 0xb9, 0xa5, 0xa1 },	

	/*	Full-width Greek */
	{ 0xa5, 0xc1, 0xd8, 0xa5, 0xe1 },	

	/*	Map Full-width Hiragana to  Full-width Katakana */
	{ 0xaa, 0xa1, 0xa1, 0xab, 0xa2 },	/*	A	*/
	{ 0xaa, 0xa2, 0xa2, 0xab, 0xa2 },

	{ 0xaa, 0xa3, 0xa3, 0xab, 0xa4 },	/*	I	*/
	{ 0xaa, 0xa4, 0xa4, 0xab, 0xa4 },

	{ 0xaa, 0xa5, 0xa5, 0xab, 0xa6 },	/*	U	*/
	{ 0xaa, 0xa6, 0xa6, 0xab, 0xa6 },

	{ 0xaa, 0xa7, 0xa7, 0xab, 0xa8 },	/*	E	*/
	{ 0xaa, 0xa8, 0xa8, 0xab, 0xa8 },

	{ 0xaa, 0xa9, 0xa9, 0xab, 0xaa },	/*	O	*/
	{ 0xaa, 0xaa, 0xaa, 0xab, 0xaa },	
	
	{ 0xaa, 0xab, 0xc2, 0xab, 0xab},	/* KA - DI */

	{ 0xaa, 0xc3, 0xc3, 0xab, 0xc4 },	/* TU */
	{ 0xaa, 0xc4, 0xc4, 0xab, 0xc4 },

	{ 0xaa, 0xc5, 0xe2, 0xab, 0xc5 },	/* DU - MO */

	{ 0xaa, 0xe3, 0xe3, 0xab, 0xe4 },	/* YA	*/
	{ 0xaa, 0xe4, 0xe4, 0xab, 0xe4 },

	{ 0xaa, 0xe5, 0xe5, 0xab, 0xe6 },	/* YU	*/
	{ 0xaa, 0xe6, 0xe6, 0xab, 0xe6 },

	{ 0xaa, 0xe7, 0xe7, 0xab, 0xe8 },	/* YO	*/
	{ 0xaa, 0xe8, 0xe8, 0xab, 0xe8 },

	{ 0xaa, 0xe9, 0xed, 0xab, 0xe9},	/* RA - RO */

	{ 0xaa, 0xee, 0xee, 0xab, 0xef },	/* WA	*/
	{ 0xaa, 0xef, 0xef, 0xab, 0xef },

	{ 0xaa, 0xf0, 0xf3, 0xab, 0xf0 },	/* WI - N */
	
	/*	Map SMALL Full-width Katakana to Full-width Katakana */
	{ 0xab, 0xa1, 0xa1, 0xab, 0xa2 },	/*	A	*/
	{ 0xab, 0xa3, 0xa3, 0xab, 0xa4 },	/*	I	*/
	{ 0xab, 0xa5, 0xa5, 0xab, 0xa6 },	/*	U	*/
	{ 0xab, 0xa7, 0xa7, 0xab, 0xa8 },	/*	E	*/
	{ 0xab, 0xa9, 0xa9, 0xab, 0xaa },	/*	O	*/
	{ 0xab, 0xc3, 0xc3, 0xab, 0xc4 },	/* TU	*/
	{ 0xab, 0xe3, 0xe3, 0xab, 0xe4 },	/* YA	*/
	{ 0xab, 0xe5, 0xe5, 0xab, 0xe6 },	/* YU	*/
	{ 0xab, 0xe7, 0xe7, 0xab, 0xe8 },	/* YO	*/
	{ 0xab, 0xee, 0xee, 0xab, 0xef },	/* WA	*/

	/*	Full-width Cyrillic*/
	{ 0xac, 0xa1, 0xc1, 0xac, 0xd1 },	
	
	{ 0x00, 0x00, 0x00, 0x00, 0x00 }	/* Terminator */
};

MODULE_PRIVATE DoubleByteToLowerMap *INTL_GetDoubleByteToLowerMap(int16 csid)
{
	switch(csid)
	{
#ifndef XP_UNIX
		case CS_SJIS:
			return lower_lookup_sjis;
#else
		case CS_EUCJP:
			return lower_lookup_eucjp;
#endif
		case CS_BIG5:		
			return lower_lookup_big5;
		case CS_CNS_8BIT:		
			return lower_lookup_cns11643_1;
		case CS_GB_8BIT:	
			return lower_lookup_eucjp;	/*	The to_lower mapping for GB 2312 and JIS0208 are exactly the same */
										/*  We just use the same table here.								  */
		case CS_KSC_8BIT:	
			return lower_lookup_ksc5601;
		default:
			return lower_lookup_none;
	}
}



