/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */

/*----------------------------------------------------------------------*/
/*																		*/
/* Name:		<Xfe/FancyBox.h>										*/
/* Description:	XfeFancyBox widget public header file.					*/
/* Author:		Ramiro Estrugo <ramiro@netscape.com>					*/
/*																		*/
/*----------------------------------------------------------------------*/

#ifndef _XfeFancyBox_h_							/* start FancyBox.h		*/
#define _XfeFancyBox_h_

#include <Xfe/ComboBox.h>

XFE_BEGIN_CPLUSPLUS_PROTECTION

/*----------------------------------------------------------------------*/
/*																		*/
/* XfeFancyBox resource names											*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XmNicon							"icon"

/*----------------------------------------------------------------------*/
/*																		*/
/* XfeFancyBox class names												*/
/*																		*/
/*----------------------------------------------------------------------*/
externalref WidgetClass xfeFancyBoxWidgetClass;

typedef struct _XfeFancyBoxClassRec *			XfeFancyBoxWidgetClass;
typedef struct _XfeFancyBoxRec *				XfeFancyBoxWidget;

/*----------------------------------------------------------------------*/
/*																		*/
/* XfeFancyBox subclass test macro										*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XfeIsFancyBox(w)	XtIsSubclass(w,xfeFancyBoxWidgetClass)

/*----------------------------------------------------------------------*/
/*																		*/
/* XfeFancyBox public methods											*/
/*																		*/
/*----------------------------------------------------------------------*/
extern Widget
XfeCreateFancyBox				(Widget		pw,
								 String		name,
								 Arg *		av,
								 Cardinal	ac);
/*----------------------------------------------------------------------*/

XFE_END_CPLUSPLUS_PROTECTION

#endif											/* end FancyBox.h		*/
