/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPSortControl
extends LDAPControl {
    public static final String SORTREQUEST = "1.2.840.113556.1.4.473";

    public LDAPSortControl(LDAPSortKey key, boolean critical) {
        super(SORTREQUEST, critical, null);
        LDAPSortKey[] keys = new LDAPSortKey[]{key};
        this.m_value = this.createSortSpecification(keys);
    }

    public LDAPSortControl(LDAPSortKey[] keys, boolean critical) {
        super(SORTREQUEST, critical, null);
        this.m_value = this.createSortSpecification(keys);
    }

    public static String parseResponse(LDAPControl[] controls, int[] results) {
        String attr;
        block5: {
            attr = null;
            LDAPControl sort = null;
            int i = 0;
            while (controls != null && i < controls.length) {
                if (controls[i].getID().equals("1.2.840.113556.1.4.474")) {
                    sort = controls[i];
                    break;
                }
                ++i;
            }
            if (sort == null) break block5;
            ByteArrayInputStream inStream = new ByteArrayInputStream(sort.getValue());
            new BERSequence();
            JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
            int[] nRead = new int[]{0};
            try {
                BERSequence seq = (BERSequence)BERElement.getElement(decoder, inStream, nRead);
                int result = ((BEREnumerated)seq.elementAt(0)).getValue();
                if (results != null && results.length > 0) {
                    results[0] = result;
                }
                BEROctetString t = (BEROctetString)seq.elementAt(1);
                attr = new String(t.getValue(), "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return attr;
    }

    private byte[] createSortSpecification(LDAPSortKey[] keys) {
        BERSequence ber = new BERSequence();
        int i = 0;
        while (i < keys.length) {
            BERSequence seq = new BERSequence();
            seq.addElement(new BEROctetString(keys[i].getKey()));
            if (keys[i].getMatchRule() != null) {
                seq.addElement(new BERTag(160, new BEROctetString(keys[i].getMatchRule()), true));
            }
            if (keys[i].getReverse()) {
                seq.addElement(new BERTag(129, new BEREnumerated(129), true));
            }
            ber.addElement(seq);
            ++i;
        }
        return this.flattenBER(ber);
    }
}

