/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;

public class JDAPControl {
    String m_type;
    boolean m_criticality = false;
    byte[] m_vals;

    public JDAPControl(String type, boolean criticality, byte[] vals) {
        this.m_type = type;
        this.m_criticality = criticality;
        this.m_vals = vals;
    }

    public JDAPControl(BERElement e) {
        BERSequence s = (BERSequence)e;
        try {
            this.m_type = new String(((BEROctetString)s.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {}
        BERElement value = s.elementAt(1);
        if (value instanceof BERBoolean) {
            this.m_criticality = ((BERBoolean)value).getValue();
        } else {
            this.m_vals = ((BEROctetString)value).getValue();
        }
        if (s.size() >= 3) {
            this.m_vals = ((BEROctetString)s.elementAt(2)).getValue();
        }
    }

    public BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_type));
        seq.addElement(new BERBoolean(this.m_criticality));
        if (this.m_vals == null || this.m_vals.length < 1) {
            seq.addElement(new BEROctetString(null));
        } else {
            seq.addElement(new BEROctetString(this.m_vals, 0, this.m_vals.length));
        }
        return seq;
    }

    public String getID() {
        return this.m_type;
    }

    public boolean isCritical() {
        return this.m_criticality;
    }

    public byte[] getValue() {
        return this.m_vals;
    }

    public String toString() {
        return "Control { type=" + this.m_type + ", criticality=" + this.m_criticality;
    }
}

