/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Serializer;
import netscape.util.Sort;
import netscape.util.Vector;

public class FormattingSerializer
extends Serializer {
    private final int MAX_SIZE_FOR_SMALL_EXPRESSION = 80;
    private int indentationLength = 4;
    private int tabLevel = 0;
    private int nextCharIndex = 0;

    public FormattingSerializer(OutputStream outputStream) {
        super(outputStream);
    }

    public void setIndentationLength(int numberOfSpaces) {
        this.indentationLength = numberOfSpaces;
    }

    public int indentationLength() {
        return this.indentationLength;
    }

    public void writeComment(String aComment, boolean cStyle) throws IOException {
        int delimiterSize;
        int length = aComment.length();
        if (length + (delimiterSize = cStyle ? 7 : 4) <= 80 - this.nextCharIndex && aComment.indexOf(10) == -1) {
            if (cStyle) {
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(42);
                this.writeCommentCharacter(32);
            } else {
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(32);
            }
            int i = 0;
            while (i < length) {
                this.writeCommentCharacter(aComment.charAt(i));
                ++i;
            }
            if (cStyle) {
                this.writeCommentCharacter(32);
                this.writeCommentCharacter(42);
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(10);
                return;
            }
            this.writeCommentCharacter(10);
            return;
        }
        if (cStyle) {
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(10);
            this.writeCommentCharacter(32);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(32);
        } else {
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(32);
        }
        int i = 0;
        while (i < length) {
            char ch = aComment.charAt(i);
            if (ch == '\n') {
                this.writeCommentCharacter(10);
                if (cStyle) {
                    this.writeCommentCharacter(32);
                    this.writeCommentCharacter(42);
                    this.writeCommentCharacter(32);
                } else {
                    this.writeCommentCharacter(47);
                    this.writeCommentCharacter(47);
                    this.writeCommentCharacter(32);
                }
            } else {
                this.writeCommentCharacter(ch);
            }
            ++i;
        }
        if (cStyle) {
            this.writeCommentCharacter(10);
            this.writeCommentCharacter(32);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(10);
            return;
        }
        this.writeCommentCharacter(10);
    }

    private final void increaseTabLevel() {
        ++this.tabLevel;
    }

    private final void decreaseTabLevel() {
        --this.tabLevel;
    }

    private final void insertNewLine() throws IOException {
        this.writeCharacter(10);
        int i = 0;
        int c = this.tabLevel * this.indentationLength();
        while (i < c) {
            this.writeCharacter(32);
            ++i;
        }
    }

    private final void writeCharacter(int c) throws IOException {
        super.writeOutput(c);
        if (c == 10) {
            this.nextCharIndex = 0;
            return;
        }
        ++this.nextCharIndex;
    }

    private final void writeCommentCharacter(int ch) throws IOException {
        if (ch >= 32 && ch < 127) {
            this.writeCharacter(ch);
            return;
        }
        switch (ch) {
            case 9: 
            case 10: 
            case 13: {
                this.writeCharacter(ch);
            }
        }
    }

    private final int serializedStringFitsIn(String str, int maxSize) {
        if (str == null || str.length() == 0) {
            return 2;
        }
        int c = str.length();
        if (c > maxSize) {
            return c;
        }
        int length = this.stringRequiresQuotes(str) ? 2 : 0;
        int i = 0;
        while (i < c) {
            char ch = str.charAt(i);
            if (ch < '\u00ff') {
                if (ch >= '#' && ch <= '~' && ch != '\\') {
                    ++length;
                } else {
                    switch (ch) {
                        case ' ': 
                        case '!': {
                            ++length;
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case '\"': 
                        case '\\': {
                            length += 2;
                            break;
                        }
                        default: {
                            length += 4;
                            break;
                        }
                    }
                }
            } else {
                length += 6;
            }
            if (length > maxSize) {
                return length;
            }
            ++i;
        }
        return length;
    }

    private final int serializedHashtableFitsIn(Hashtable h, int maxSize) {
        int length = 2;
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ++length;
            if ((length += this.serializedObjectFitsIn(key, maxSize - length)) > maxSize) {
                return length;
            }
            length += 3;
            length += this.serializedObjectFitsIn(h.get(key), maxSize - length);
            if (++length <= maxSize) continue;
            return length;
        }
        return length;
    }

    private final int serializedArrayFitsIn(Object[] a, int maxSize) {
        int length = 3;
        int i = 0;
        int c = a.length;
        while (i < c) {
            ++length;
            if ((length += this.serializedObjectFitsIn(a[i], maxSize - length)) > maxSize) {
                return length;
            }
            if (i < c - 1) {
                ++length;
            }
            ++i;
        }
        return length;
    }

    private final int serializedVectorFitsIn(Vector v, int maxSize) {
        int length = 3;
        int i = 0;
        int c = v.count();
        while (i < c) {
            ++length;
            if ((length += this.serializedObjectFitsIn(v.elementAt(i), maxSize - length)) > maxSize) {
                return length;
            }
            if (i < c - 1) {
                ++length;
            }
            ++i;
        }
        return length;
    }

    private final int serializedNullFitsIn() {
        return 1;
    }

    private final int serializedObjectFitsIn(Object anObject, int maxSize) {
        if (anObject instanceof String) {
            return this.serializedStringFitsIn((String)anObject, maxSize);
        }
        if (anObject instanceof Hashtable) {
            return this.serializedHashtableFitsIn((Hashtable)anObject, maxSize);
        }
        if (anObject instanceof Object[]) {
            return this.serializedArrayFitsIn((Object[])anObject, maxSize);
        }
        if (anObject instanceof Vector) {
            return this.serializedVectorFitsIn((Vector)anObject, maxSize);
        }
        if (anObject == null) {
            return this.serializedNullFitsIn();
        }
        return this.serializedStringFitsIn(anObject.toString(), maxSize);
    }

    private final boolean canFitExpressionOnLine(Object anObject) {
        int maxLength = 80 - this.nextCharIndex;
        return this.serializedObjectFitsIn(anObject, maxLength) <= maxLength;
    }

    private final void formatVector(Vector aVector) throws IOException {
        int count = aVector.count();
        if (this.canFitExpressionOnLine(aVector)) {
            this.writeCharacter(40);
            int i = 0;
            while (i < count) {
                this.writeCharacter(32);
                this.formatObject(aVector.elementAt(i));
                if (i < count - 1) {
                    this.writeCharacter(44);
                }
                ++i;
            }
            this.writeCharacter(32);
            this.writeCharacter(41);
            return;
        }
        this.writeCharacter(40);
        this.increaseTabLevel();
        int i = 0;
        while (i < count) {
            this.insertNewLine();
            this.formatObject(aVector.elementAt(i));
            if (i < count - 1) {
                this.writeCharacter(44);
            }
            ++i;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(41);
    }

    private final void formatArray(Object[] anArray) throws IOException {
        int count = anArray.length;
        if (this.canFitExpressionOnLine(anArray)) {
            this.writeCharacter(91);
            int i = 0;
            while (i < count) {
                this.writeCharacter(32);
                this.formatObject(anArray[i]);
                if (i < count - 1) {
                    this.writeCharacter(44);
                }
                ++i;
            }
            this.writeCharacter(32);
            this.writeCharacter(93);
            return;
        }
        this.writeCharacter(91);
        this.increaseTabLevel();
        int i = 0;
        while (i < count) {
            this.insertNewLine();
            this.formatObject(anArray[i]);
            if (i < count - 1) {
                this.writeCharacter(44);
            }
            ++i;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(93);
    }

    private final void formatHashtable(Hashtable h) throws IOException {
        Enumeration e = h.keys();
        int nonStringKeysCount = 0;
        int stringCount = 0;
        int count = h.count();
        Object[] keys = new String[count];
        Object[] nonStringKeys = new Object[count];
        e = h.keys();
        int i = 0;
        while (i < count) {
            Object s = e.nextElement();
            if (s instanceof String) {
                keys[stringCount++] = (String)s;
            } else {
                nonStringKeys[nonStringKeysCount++] = s;
            }
            ++i;
        }
        if (stringCount > 0) {
            Sort.sortStrings(keys, 0, stringCount, true, false);
            System.arraycopy(keys, 0, nonStringKeys, nonStringKeysCount, stringCount);
        }
        if (this.canFitExpressionOnLine(h)) {
            this.writeCharacter(123);
            i = 0;
            while (i < count) {
                this.writeCharacter(32);
                Object key = nonStringKeys[i];
                Object value = h.get(key);
                this.formatObject(key);
                this.writeCharacter(32);
                this.writeCharacter(61);
                this.writeCharacter(32);
                this.formatObject(value);
                this.writeCharacter(59);
                ++i;
            }
            this.writeCharacter(125);
            return;
        }
        this.writeCharacter(123);
        this.increaseTabLevel();
        i = 0;
        while (i < count) {
            Object key = nonStringKeys[i];
            Object value = h.get(key);
            this.insertNewLine();
            this.formatObject(key);
            this.writeCharacter(32);
            this.writeCharacter(61);
            this.writeCharacter(32);
            this.formatObject(value);
            this.writeCharacter(59);
            ++i;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(125);
    }

    private final void formatObject(Object anObject) throws IOException {
        if (anObject instanceof String) {
            this.serializeString((String)anObject);
            return;
        }
        if (anObject instanceof Hashtable) {
            this.formatHashtable((Hashtable)anObject);
            return;
        }
        if (anObject instanceof Object[]) {
            this.formatArray((Object[])anObject);
            return;
        }
        if (anObject instanceof Vector) {
            this.formatVector((Vector)anObject);
            return;
        }
        if (anObject == null) {
            this.serializeNull();
            return;
        }
        this.serializeString(anObject.toString());
    }

    public void writeObject(Object anObject) throws IOException {
        this.formatObject(anObject);
    }

    public static String serializeObject(Object anObject) {
        String result = null;
        if (anObject == null) {
            result = null;
        } else {
            ByteArrayOutputStream memory = new ByteArrayOutputStream(256);
            FormattingSerializer serializer = new FormattingSerializer(memory);
            try {
                serializer.writeObject(anObject);
                serializer.flush();
            }
            catch (IOException iOException) {}
            result = memory.toString();
            try {
                serializer.close();
                ((OutputStream)memory).close();
            }
            catch (IOException iOException) {}
            memory = null;
            Object var3_3 = null;
        }
        return result;
    }

    public static byte[] formatBytes(byte[] input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input);
        Object o = Deserializer.readObject(in);
        if (o != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FormattingSerializer serializer = new FormattingSerializer(out);
            try {
                serializer.writeObject(o);
                serializer.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            return out.toByteArray();
        }
        return null;
    }

    public static boolean writeObject(OutputStream outputStream, Object anObject) {
        try {
            FormattingSerializer serializer = new FormattingSerializer(outputStream);
            serializer.writeObject(anObject);
            serializer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

