/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.ExtendedTarget;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.TextFieldOwner;
import netscape.application.TextFilter;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextField
extends View
implements ExtendedTarget,
FormElement {
    TextFieldOwner _owner;
    TextFilter _filter;
    Target _tabTarget;
    Target _backtabTarget;
    Target _contentsChangedTarget;
    Target _commitTarget;
    Vector _keyVector;
    Border border = BezelBorder.loweredBezel();
    Font _font;
    Color _textColor;
    Color _backgroundColor;
    Color _selectionColor;
    Color _caretColor;
    String _tabCommand;
    String _backtabCommand;
    String _contentsChangedCommand;
    String _commitCommand;
    FastStringBuffer _contents;
    FastStringBuffer _oldContents;
    Timer blinkTimer;
    char _drawableCharacter;
    int _selectionAnchorChar = -1;
    int _selectionEndChar = -1;
    int _justification;
    int _scrollOffset;
    int _fontHeight;
    int _initialAnchorChar = -1;
    int _clickCount;
    boolean _editing;
    boolean _caretShowing;
    boolean _canBlink;
    boolean _editable;
    boolean _selectable;
    boolean _mouseDragging;
    boolean _shadowed;
    boolean _textChanged = false;
    boolean _canWrap;
    boolean transparent = false;
    boolean wantsAutoscrollEvents = false;
    boolean isScrollable = true;
    boolean hasFocus = false;
    boolean _ignoreWillBecomeSelected;
    public static char ANY_CHARACTER = (char)65535;
    public static final String SELECT_TEXT = "selectText";
    static final String BLINK_CARET = "blinkCaret";
    static final String OWNER_KEY = "owner";
    static final String FILTER_KEY = "filter";
    static final String TABREC_KEY = "tabTarget";
    static final String BACKTABREC_KEY = "backtabTarget";
    static final String CONTENTSCHANGEDREC_KEY = "contentsChangedTarget";
    static final String COMMITREC_KEY = "commitTarget";
    static final String BORDER_KEY = "border";
    static final String FONT_KEY = "font";
    static final String TEXTC_KEY = "textColor";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String SELECTIONC_KEY = "selectionColor";
    static final String CARETC_KEY = "caretColor";
    static final String TABCOM_KEY = "tabCommand";
    static final String BACKTABCOM_KEY = "backtabCommand";
    static final String CONTENTSCHANGEDCOM_KEY = "contentsChangedCommand";
    static final String COMMITCOM_KEY = "commitCommand";
    static final String CONTENTS_KEY = "contents";
    static final String SELECTIONANCH_KEY = "selectionAnchorChar";
    static final String SELECTIONEND_KEY = "selectionEndChar";
    static final String JUSTIFICATION_KEY = "justification";
    static final String SCROLLOFFSET_KEY = "scrollOffset";
    static final String EDITABLE_KEY = "editable";
    static final String SELECTABLE_KEY = "selectable";
    static final String SHADOWED_KEY = "shadowed";
    static final String CANWRAP_KEY = "canWrap";
    static final String AUTOSCROLLEVENT_KEY = "wantsAutoscrollEvents";
    static final String TRANSPARENT_KEY = "transparent";
    static final String DRAWABLE_CHAR_KEY = "drawableCharacter";
    static final String DRAWABLE_CHAR_STRING_KEY = "drawable char";
    static final String SCROLLABLE_KEY = "isScrollable";

    public TextField() {
        this(0, 0, 0, 0);
    }

    public TextField(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public TextField(int x, int y, int width, int height) {
        super(x, y, width, height);
        this._keyVector = new Vector();
        this._contents = new FastStringBuffer();
        this._drawableCharacter = ANY_CHARACTER;
        this._textColor = Color.black;
        this._backgroundColor = Color.white;
        this._selectionColor = Color.lightGray;
        this._caretColor = Color.black;
        this.setEditable(true);
        this.setFont(Font.defaultFont());
    }

    public static TextField createLabel(String string, Font font) {
        FontMetrics metrics = font.fontMetrics();
        int width = metrics.stringWidth(string);
        int height = metrics.stringHeight();
        TextField label = new TextField(0, 0, width, height);
        label.setBorder(null);
        label.setStringValue(string);
        label.setFont(font);
        label.setTransparent(true);
        label.setEditable(false);
        label.setSelectable(false);
        return label;
    }

    public static TextField createLabel(String string) {
        return TextField.createLabel(string, Font.defaultFont());
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int leftIndent() {
        int leftIndent = this.border.leftMargin();
        if (leftIndent > 2) {
            leftIndent = 2;
        }
        return leftIndent;
    }

    public int rightIndent() {
        int rightIndent = this.border.rightMargin() + 1;
        if (rightIndent > 3) {
            rightIndent = 3;
        }
        return rightIndent;
    }

    private int widthIndent() {
        return this.leftIndent() + this.rightIndent();
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        Size theSize = this._font.fontMetrics().stringSize(this.drawableString());
        Rect interiorRect = this.interiorRect();
        if (this.horizResizeInstruction() != 2 && this._canWrap && !this.isEditable() && theSize.width > interiorRect.width) {
            Vector stringVector = this.stringVectorForContents(interiorRect.width);
            theSize.sizeTo(interiorRect.width, theSize.height * stringVector.count());
        }
        Rect.returnRect(interiorRect);
        theSize.sizeBy(this.border.widthMargin() + this.widthIndent(), this.border.heightMargin());
        return theSize;
    }

    public void setDrawableCharacter(char aChar) {
        this._drawableCharacter = aChar;
        this._scrollOffset = 0;
        this._computeScrollOffset();
        this.setDirty(true);
    }

    public char drawableCharacter() {
        return this._drawableCharacter;
    }

    public void setFont(Font aFont) {
        this._font = aFont == null ? Font.defaultFont() : aFont;
        Size stringSize = this._font.fontMetrics().stringSize(null);
        this._fontHeight = stringSize.height;
        this.setDirty(true);
    }

    public Font font() {
        return this._font;
    }

    public void setTextColor(Color aColor) {
        this._textColor = aColor;
        if (this._textColor == null) {
            this._textColor = Color.black;
        }
        this.setDirty(true);
    }

    public Color textColor() {
        return this._textColor;
    }

    public void setBackgroundColor(Color aColor) {
        this._backgroundColor = aColor;
        if (this._backgroundColor == null) {
            this._backgroundColor = Color.white;
        }
        this.setDirty(true);
    }

    public Color backgroundColor() {
        return this._backgroundColor;
    }

    public void setSelectionColor(Color aColor) {
        this._selectionColor = aColor;
        if (this._selectionColor == null) {
            this._selectionColor = Color.lightGray;
        }
        this.setDirty(true);
    }

    public Color selectionColor() {
        return this._selectionColor;
    }

    public void setCaretColor(Color aColor) {
        this._caretColor = aColor;
        if (this._caretColor == null) {
            this._caretColor = Color.black;
        }
    }

    public Color caretColor() {
        return this._caretColor;
    }

    public void setBorder(Border newBorder) {
        if (newBorder == null) {
            newBorder = EmptyBorder.emptyBorder();
        }
        this.border = newBorder;
    }

    public Border border() {
        return this.border;
    }

    public void setDrawsDropShadow(boolean flag) {
        this._shadowed = flag;
        this.setDirty(true);
    }

    public boolean drawsDropShadow() {
        return this._shadowed;
    }

    public void setJustification(int aJustification) {
        if (aJustification < 0 || aJustification > 2) {
            return;
        }
        if (aJustification != this._justification) {
            this._justification = aJustification;
            this._scrollOffset = 0;
        }
    }

    public int justification() {
        return this._justification;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
        if (this.transparent) {
            this.setBorder(null);
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setSelectable(boolean flag) {
        if (this._selectable != flag) {
            RootView rootView;
            this._selectable = flag;
            this.wantsAutoscrollEvents = flag;
            if (!this._selectable && this._scrollOffset != 0) {
                this._scrollOffset = 0;
                this.drawInterior();
            }
            if ((rootView = this.rootView()) != null) {
                rootView.updateCursor();
            }
        }
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public boolean wantsAutoscrollEvents() {
        return this.wantsAutoscrollEvents;
    }

    public void setWrapsContents(boolean flag) {
        this._canWrap = flag;
        if (flag && this.isEditable()) {
            this.setEditable(false);
        }
        this.drawInterior();
    }

    public boolean wrapsContents() {
        return this._canWrap;
    }

    public void setEditable(boolean aFlag) {
        if (this._editable != aFlag) {
            this._editable = aFlag;
            this.setSelectable(aFlag);
            if (aFlag && this.wrapsContents()) {
                this.setWrapsContents(false);
            }
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isBeingEdited() {
        return this._editing;
    }

    public int cursorForPoint(int x, int y) {
        if (this.isEditable() || this.isSelectable()) {
            return 2;
        }
        return 0;
    }

    public void setOwner(TextFieldOwner owner) {
        this._owner = owner;
    }

    public TextFieldOwner owner() {
        return this._owner;
    }

    public void setFilter(TextFilter aFilter) {
        this._filter = aFilter;
    }

    public TextFilter filter() {
        return this._filter;
    }

    public void setContentsChangedCommandAndTarget(String aCommand, Target aTarget) {
        this._contentsChangedCommand = aCommand;
        this._contentsChangedTarget = aTarget;
    }

    public Target contentsChangedTarget() {
        return this._contentsChangedTarget;
    }

    public String contentsChangedCommand() {
        return this._contentsChangedCommand;
    }

    public void setTabField(TextField aTextField) {
        if (aTextField == null) {
            this._tabTarget = null;
            this._tabCommand = null;
        } else {
            this._tabTarget = aTextField;
            this._tabCommand = SELECT_TEXT;
        }
        this.invalidateKeyboardSelectionOrder();
    }

    public TextField tabField() {
        if (this._tabTarget instanceof TextField) {
            return (TextField)this._tabTarget;
        }
        return null;
    }

    public void setBacktabField(TextField aTextField) {
        if (aTextField == null) {
            this._backtabTarget = null;
            this._backtabCommand = null;
        } else if (aTextField != this) {
            this._backtabTarget = aTextField;
            this._backtabCommand = SELECT_TEXT;
        }
        this.invalidateKeyboardSelectionOrder();
    }

    public TextField backtabField() {
        if (this._backtabTarget instanceof TextField) {
            return (TextField)this._backtabTarget;
        }
        return null;
    }

    public void setTarget(Target aTarget) {
        this._commitTarget = aTarget;
    }

    public void setCommand(String aCommand) {
        this._commitCommand = aCommand;
    }

    public Target target() {
        return this._commitTarget;
    }

    public String command() {
        return this._commitCommand;
    }

    public void setStringValue(String aString) {
        if (aString != null && aString.equals(this.stringValue())) {
            if (this.isBeingEdited()) {
                this.cancelEditing();
            }
            return;
        }
        if (aString == null) {
            aString = "";
        }
        this.replaceRangeWithString(new Range(0, this.charCount()), aString);
        this._oldContents = null;
        if (this.isBeingEdited()) {
            this.cancelEditing();
            return;
        }
        this.setDirty(true);
    }

    public String stringValue() {
        if (this._contents == null) {
            return "";
        }
        return this._contents.toString();
    }

    public void replaceRangeWithString(Range aRange, String aString) {
        String contents = this.stringValue();
        Range r = new Range();
        r.index = aRange.index;
        r.length = aRange.length;
        r.intersectWith(new Range(0, contents.length()));
        if (r.isNullRange()) {
            r.index = contents.length();
            r.length = 0;
        }
        String before = contents.substring(0, r.index);
        String after = contents.substring(r.index + r.length);
        this._contents = aString != null ? new FastStringBuffer(String.valueOf(before) + aString + after) : new FastStringBuffer(String.valueOf(before) + after);
        if (this.isBeingEdited()) {
            r.index = 0;
            r.length = this._contents.length();
            Range selectedRange = this.selectedRange();
            selectedRange.intersectWith(r);
            if (selectedRange.isNullRange()) {
                this.selectRange(new Range(this._contents.length, 0));
                return;
            }
            this.selectRange(selectedRange);
            return;
        }
        this.setDirty(true);
    }

    public String stringForRange(Range aRange) {
        String contents = this.stringValue();
        Range r = new Range();
        r.index = aRange.index;
        r.length = aRange.length;
        r.intersectWith(new Range(0, contents.length()));
        if (r.isNullRange()) {
            return "";
        }
        return contents.substring(r.index, r.index + r.length());
    }

    public String selectedStringValue() {
        if (this.hasInsertionPoint()) {
            return "";
        }
        int start = this.selectionStart();
        int stop = this.selectionStop();
        if (start == -1 || stop == -1) {
            return "";
        }
        if (stop == this._contents.length()) {
            return this._contents.toString().substring(start);
        }
        return this._contents.toString().substring(start, stop);
    }

    public void setIntValue(int anInt) {
        this.setStringValue(Integer.toString(anInt));
    }

    public int intValue() {
        return TextField.parseInt(this._contents.toString());
    }

    public boolean isEmpty() {
        return this.charCount() == 0;
    }

    public int charCount() {
        return this._contents.length();
    }

    public int baseline() {
        String contentString = this.drawableString();
        Size stringSize = this._font.fontMetrics().stringSize(contentString);
        Rect interiorRect = Rect.newRect();
        this.border.computeInteriorRect(0, 0, this.bounds.width, this.bounds.height, interiorRect);
        int y = interiorRect.maxY() - (interiorRect.height - stringSize.height) / 2 - this._font.fontMetrics().descent();
        Rect.returnRect(interiorRect);
        return y;
    }

    public void selectRange(Range aRange) {
        if (aRange.length < 0 || aRange.index < 0) {
            throw new InconsistencyException("TextField - invalid range: " + aRange);
        }
        this.selectRange(aRange.index, aRange.index + aRange.length);
    }

    protected void selectRange(int start, int stop) {
        if (!this.isSelectable()) {
            return;
        }
        if (start < 0) {
            start = 0;
        } else if (start > this._contents.length()) {
            start = this._contents.length();
        }
        if (stop < 0) {
            stop = 0;
        } else if (stop > this._contents.length()) {
            stop = this._contents.length();
        }
        this._selectionAnchorChar = start;
        this._selectionEndChar = stop;
        if (this.isEditable() && !this.isBeingEdited()) {
            this._startEditing(true);
        }
        this.drawInterior();
    }

    public void selectText() {
        this.selectRange(0, this.charCount());
    }

    public void setInsertionPoint(int position) {
        this.selectRange(position, position);
    }

    int selectionAnchorPoint() {
        return this._selectionAnchorChar;
    }

    int selectionEndPoint() {
        return this._selectionEndChar;
    }

    public Range selectedRange() {
        if (this.hasInsertionPoint()) {
            return new Range(this._selectionAnchorChar, 0);
        }
        if (this._selectionAnchorChar == -1 || this._selectionEndChar == -1) {
            return new Range();
        }
        return Range.rangeFromIndices(this.selectionStart(), this.selectionStop());
    }

    int selectionStart() {
        if (this._selectionAnchorChar < this._selectionEndChar) {
            return this._selectionAnchorChar;
        }
        return this._selectionEndChar;
    }

    int selectionStop() {
        if (this._selectionAnchorChar < this._selectionEndChar) {
            return this._selectionEndChar;
        }
        return this._selectionAnchorChar;
    }

    public boolean hasSelection() {
        return this._selectionAnchorChar != this._selectionEndChar;
    }

    public boolean hasInsertionPoint() {
        return this._selectionAnchorChar == this._selectionEndChar && this._selectionAnchorChar != -1;
    }

    Rect caretRect() {
        int cutoff;
        FontMetrics fontMetrics = this._font.fontMetrics();
        if (fontMetrics == null) {
            return null;
        }
        Rect interiorRect = this.interiorRect();
        int y2 = interiorRect.maxY() - (interiorRect.height - this._fontHeight) / 2;
        int y1 = y2 - fontMetrics.charHeight();
        if (y1 < (cutoff = this.border.topMargin())) {
            y1 = cutoff;
        }
        Rect.returnRect(interiorRect);
        return Rect.newRect(this.xPositionOfCharacter(this._selectionEndChar), y1, 1, y2 - y1);
    }

    Rect interiorRect() {
        Rect interiorRect = Rect.newRect();
        this.border.computeInteriorRect(0, 0, this.width(), this.height(), interiorRect);
        return interiorRect;
    }

    Rect rectForRange(int start, int stop) {
        int startX = this.xPositionOfCharacter(start);
        Rect tmpRect = this.interiorRect();
        tmpRect.setBounds(startX, tmpRect.y, this.xPositionOfCharacter(stop) - startX + 1, tmpRect.height);
        return tmpRect;
    }

    public int xPositionOfCharacter(int charNumber) {
        FontMetrics fontMetrics = this._font.fontMetrics();
        String contentString = this.drawableString();
        int stringWidth = fontMetrics.stringWidth(contentString);
        int startX = this.absoluteXOriginForStringWithWidth(stringWidth);
        if (charNumber <= 0) {
            return startX;
        }
        return startX + fontMetrics.stringWidth(contentString.substring(0, charNumber));
    }

    public int charNumberForPoint(int x) {
        String contentString;
        int contentLength = this._contents.length();
        if (contentLength == 0) {
            return 0;
        }
        FontMetrics fontMetrics = this._font.fontMetrics();
        int stringWidth = fontMetrics.stringWidth(contentString = this.drawableString());
        int startX = this.absoluteXOriginForStringWithWidth(stringWidth);
        if (x < startX) {
            return 0;
        }
        if (x > startX + stringWidth) {
            return contentLength;
        }
        int oldWidth = 0;
        int i = 1;
        while (i < contentLength) {
            int width = fontMetrics.stringWidth(contentString.substring(0, i));
            int delta = width - oldWidth;
            if (x <= startX + width) {
                if (x > startX + oldWidth + delta / 2) {
                    return i;
                }
                return i - 1;
            }
            oldWidth = width;
            ++i;
        }
        return contentLength;
    }

    void drawViewCaret(Graphics g) {
        if (!this._caretShowing || this._selectionAnchorChar == -1 || this._selectionAnchorChar != this._selectionEndChar || !this.hasFocus) {
            return;
        }
        g.setColor(this._caretColor);
        Rect caretRect = this.caretRect();
        g.drawLine(caretRect.x, caretRect.y, caretRect.x, caretRect.maxY() - 1);
        Rect.returnRect(caretRect);
    }

    Vector stringVectorForContents(int maxWidth) {
        Vector result = new Vector();
        String contents = this.drawableString();
        char[] buf = new char[1];
        FontMetrics fm = this.font().fontMetrics();
        int[] charWidths = fm.widthsArray();
        int index = 0;
        int length = contents.length();
        int firstIndex = index;
        int currentWidth = 0;
        int lastSpace = -1;
        while (index < length) {
            char ch = contents.charAt(index);
            if (ch == ' ' || ch == '\t') {
                lastSpace = index;
            }
            if (ch == '\n') {
                result.addElement(contents.substring(firstIndex, index));
                firstIndex = ++index;
                currentWidth = 0;
                lastSpace = -1;
                continue;
            }
            if (ch < '\u0100') {
                currentWidth += charWidths[ch];
            } else {
                buf[0] = ch;
                currentWidth += fm.stringWidth(new String(buf));
            }
            if (currentWidth > maxWidth) {
                if (index == firstIndex) {
                    result.addElement(contents.substring(firstIndex, firstIndex + 1));
                    firstIndex = ++index;
                }
                if (lastSpace == -1) {
                    result.addElement(contents.substring(firstIndex, index));
                    firstIndex = index;
                } else {
                    result.addElement(contents.substring(firstIndex, lastSpace));
                    index = firstIndex = lastSpace + 1;
                }
                currentWidth = 0;
                lastSpace = -1;
                continue;
            }
            ++index;
        }
        if (firstIndex < length) {
            result.addElement(contents.substring(firstIndex));
        }
        return result;
    }

    public void drawViewStringAt(Graphics g, String aString, int x, int y) {
        if (this._shadowed) {
            g.setColor(Color.black);
            g.drawString(aString, x + 2, y + 2);
        }
        g.setColor(this._textColor);
        g.drawString(aString, x, y);
    }

    int absoluteXOriginForStringWithWidth(int stringWidth) {
        int x = this._justification == 2 ? this.width() - this.border.rightMargin() - this.rightIndent() - stringWidth - this._scrollOffset : (this._justification == 1 ? this.border.leftMargin() + this.leftIndent() + (this.width() - (this.border.widthMargin() + this.widthIndent()) - stringWidth) / 2 - this._scrollOffset : this.border.leftMargin() + this.leftIndent() - this._scrollOffset);
        return x;
    }

    void drawViewLine(Graphics g, String aString, Size stringSize, int y) {
        if (stringSize == null) {
            stringSize = this._font.fontMetrics().stringSize(aString);
        }
        int x = this.absoluteXOriginForStringWithWidth(stringSize.width);
        this.drawViewStringAt(g, aString, x, y);
    }

    public void drawViewInterior(Graphics g, Rect interiorRect) {
        int y = this.baseline();
        g.pushState();
        g.setClipRect(interiorRect);
        if (!this.isTransparent()) {
            g.setColor(this._backgroundColor);
            g.fillRect(interiorRect);
        }
        if (this._selectionAnchorChar != this._selectionEndChar && this.hasFocus && this.isSelectable()) {
            int x1 = this.xPositionOfCharacter(this.selectionStart());
            int x2 = this.xPositionOfCharacter(this.selectionStop());
            Rect caretRect = this.caretRect();
            g.setColor(this._selectionColor);
            g.fillRect(x1, caretRect.y, x2 - x1, caretRect.height);
            Rect.returnRect(caretRect);
        }
        g.setFont(this._font);
        String contentString = this.drawableString();
        Size stringSize = this._font.fontMetrics().stringSize(contentString);
        if (!this._canWrap || this.isEditable()) {
            this.drawViewLine(g, contentString, stringSize, y);
        } else {
            Vector stringVector = this.stringVectorForContents(interiorRect.width);
            int count = stringVector.count();
            if (count > 1) {
                y += (interiorRect.height - stringSize.height) / 2;
                int delta = (interiorRect.height - stringSize.height * count) / 2;
                y -= delta + (count - 1) * stringSize.height;
            }
            int i = 0;
            while (i < count) {
                this.drawViewLine(g, (String)stringVector.elementAt(i), null, y);
                y += stringSize.height;
                ++i;
            }
        }
        if (this.isBeingEdited() && this._caretShowing) {
            this.drawViewCaret(g);
        }
        g.popState();
    }

    public void drawViewBorder(Graphics g) {
        if (this.border != null) {
            this.border.drawInRect(g, 0, 0, this.width(), this.height());
            return;
        }
        if (!this.isTransparent() && this._backgroundColor != null) {
            g.setColor(this._backgroundColor);
            g.fillRect(0, 0, this.width(), this.height());
        }
    }

    public void drawView(Graphics g) {
        this.drawViewBorder(g);
        Rect interiorRect = this.interiorRect();
        this.drawViewInterior(g, interiorRect);
        Rect.returnRect(interiorRect);
    }

    void drawCaret() {
        Rect caretRect = this.caretRect();
        this.addDirtyRect(caretRect);
        Rect.returnRect(caretRect);
    }

    void hideCaret() {
        this._caretShowing = false;
        this.drawCaret();
    }

    void showCaret() {
        this._caretShowing = true;
        this.drawCaret();
    }

    public void drawInterior() {
        Rect interiorRect = this.interiorRect();
        this.addDirtyRect(interiorRect);
        Rect.returnRect(interiorRect);
    }

    public boolean mouseDown(MouseEvent event) {
        Rect redrawRect = null;
        this._clickCount = event.clickCount();
        if (this._clickCount > 3) {
            return true;
        }
        if (!this.isSelectable()) {
            return false;
        }
        if (!this.isBeingEdited()) {
            if (this.isEditable()) {
                this._startEditing(true);
            } else if (this.isSelectable()) {
                this._startEditing(false);
            }
        }
        if (!this.rootView().mouseStillDown()) {
            int charNumber = this.charNumberForPoint(event.x);
            this._clickCount = 0;
            this.selectRange(new Range(charNumber, 0));
            if (!this.hasSelection() && this.isEditable()) {
                this._canBlink = true;
                this._caretShowing = true;
                this.drawCaret();
                this._startBlinkTimer();
            }
            return true;
        }
        boolean caretWasShowing = this._caretShowing;
        this._caretShowing = false;
        this._canBlink = false;
        this._mouseDragging = true;
        if (this.hasSelection()) {
            redrawRect = this.rectForRange(this.selectionStart(), this.selectionStop());
        } else if (caretWasShowing) {
            this.hideCaret();
        }
        Range wasSelected = this.selectedRange();
        if (event.isShiftKeyDown() && this._clickCount == 1) {
            this._selectionEndChar = this.charNumberForPoint(event.x);
            if (redrawRect != null) {
                redrawRect.unionWith(this.rectForRange(this.selectionStart(), this.selectionStop()));
            } else {
                redrawRect = this.rectForRange(this.selectionStart(), this.selectionStop());
            }
        } else {
            this._selectionEndChar = this._initialAnchorChar = this.charNumberForPoint(event.x);
            this._selectionAnchorChar = this._initialAnchorChar;
        }
        switch (this._clickCount) {
            case 2: {
                Range r = this.groupForIndex(this._selectionAnchorChar);
                if (!r.isNullRange()) {
                    if (event.isShiftKeyDown()) {
                        Range otherRange = new Range(wasSelected);
                        otherRange.unionWith(r);
                        this.selectRange(otherRange);
                    } else {
                        this.selectRange(r);
                    }
                }
                redrawRect = null;
                break;
            }
            case 3: {
                this.selectRange(new Range(0, this.charCount()));
                redrawRect = null;
                break;
            }
        }
        if (redrawRect != null) {
            this.addDirtyRect(redrawRect);
            Rect.returnRect(redrawRect);
        }
        return true;
    }

    void _computeScrollOffset() {
        if (!this.isScrollable) {
            this._scrollOffset = 0;
            return;
        }
        int leftOffset = this.border.leftMargin() + this.leftIndent();
        int rightOffset = this.border.rightMargin() + this.rightIndent();
        Rect caretRect = this.caretRect();
        Rect interiorRect = this.interiorRect();
        String contentString = this.drawableString();
        if (interiorRect.width - (this.leftIndent() + this.rightIndent()) > this._font.fontMetrics().stringWidth(contentString)) {
            this._scrollOffset = 0;
            return;
        }
        if (caretRect.x >= leftOffset && caretRect.x < this.bounds.width - rightOffset) {
            Rect.returnRect(caretRect);
            return;
        }
        this._scrollOffset = caretRect.x < leftOffset ? (this._scrollOffset += caretRect.x - leftOffset) : (this._scrollOffset += caretRect.x - (this.bounds.width - rightOffset));
        Rect.returnRect(caretRect);
    }

    public void mouseDragged(MouseEvent event) {
        Range endRange;
        Range startRange;
        Range unionRange;
        boolean shouldRefresh = true;
        if (!this.isSelectable()) {
            return;
        }
        if (this._clickCount > 2) {
            return;
        }
        int oldEndChar = this._selectionEndChar;
        this._selectionEndChar = this.charNumberForPoint(event.x);
        if (this._clickCount == 2 && !(unionRange = Range.rangeFromUnion(startRange = this.groupForIndex(this._initialAnchorChar), endRange = this.groupForIndex(this._selectionEndChar))).isNullRange()) {
            if (endRange.index > startRange.index) {
                this._selectionAnchorChar = startRange.index;
                this._selectionEndChar = endRange.index + endRange.length;
            } else {
                this._selectionAnchorChar = startRange.index + startRange.length;
                this._selectionEndChar = endRange.index;
            }
        }
        if (!this.containsPointInVisibleRect(event.x, 1)) {
            int oldOffset = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != oldOffset) {
                this.drawInterior();
                shouldRefresh = false;
            }
        }
        if (shouldRefresh && this._selectionEndChar != oldEndChar) {
            int right;
            int left;
            if (this._selectionEndChar < this._selectionAnchorChar && oldEndChar > this._selectionAnchorChar || this._selectionEndChar > this._selectionAnchorChar && oldEndChar < this._selectionAnchorChar) {
                left = this.selectionStart();
                right = this.selectionStop();
                if (oldEndChar < left) {
                    left = oldEndChar;
                }
                if (oldEndChar > right) {
                    right = oldEndChar;
                }
            } else if (this._selectionEndChar > oldEndChar) {
                left = oldEndChar;
                right = this._selectionEndChar;
            } else {
                left = this._selectionEndChar;
                right = oldEndChar;
            }
            Rect redrawRect = this.rectForRange(left, right);
            this.addDirtyRect(redrawRect);
            Rect.returnRect(redrawRect);
        }
    }

    public void mouseUp(MouseEvent event) {
        this._mouseDragging = false;
        if (!this.hasSelection() && this.isEditable()) {
            this._canBlink = true;
            this._caretShowing = true;
            this.drawCaret();
        }
        this._initialAnchorChar = -1;
        this._clickCount = 0;
    }

    void _keyDown(KeyEvent event) {
        if (event.key == 1022) {
            return;
        }
        if (event.isReturnKey() || event.isTabKey() || event.isBackTabKey()) {
            int condition = event.isReturnKey() ? 2 : (event.isTabKey() ? 0 : 1);
            if (this._owner != null && !this._owner.textEditingWillEnd(this, condition, this._textChanged)) {
                return;
            }
            boolean didChange = this._textChanged;
            this._completeEditing();
            if (this._owner != null) {
                this._owner.textEditingDidEnd(this, condition, didChange);
            }
            if (event.isBackTabKey()) {
                this.sendBacktabCommand();
                if (didChange) {
                    this.sendCommitCommand(true);
                    return;
                }
            } else if (event.isTabKey()) {
                this.sendTabCommand();
                if (didChange) {
                    this.sendCommitCommand(true);
                    return;
                }
            } else {
                this.sendCommitCommand(true);
            }
            return;
        }
        if (event.isLeftArrowKey()) {
            if (event.isShiftKeyDown()) {
                int oldScrollOffset = this._scrollOffset;
                this.selectRange(this._selectionAnchorChar, this._selectionEndChar - 1);
                this._computeScrollOffset();
                if (this._scrollOffset != oldScrollOffset) {
                    this.drawInterior();
                    return;
                }
            } else {
                int oldAnchor = this._selectionAnchorChar;
                boolean wasASelection = false;
                if (this._selectionAnchorChar != this._selectionEndChar) {
                    wasASelection = true;
                    this._selectionAnchorChar = this.selectionStart();
                    oldAnchor = -1;
                } else if (this._selectionAnchorChar > 0) {
                    this.hideCaret();
                    --this._selectionAnchorChar;
                }
                this._selectionEndChar = this._selectionAnchorChar;
                if (oldAnchor != this._selectionAnchorChar) {
                    int oldOffset = this._scrollOffset;
                    this._computeScrollOffset();
                    if (oldOffset != this._scrollOffset || wasASelection) {
                        this._caretShowing = true;
                        this.drawInterior();
                        return;
                    }
                    this.showCaret();
                }
            }
            return;
        }
        if (event.isRightArrowKey()) {
            if (event.isShiftKeyDown()) {
                int oldScrollOffset = this._scrollOffset;
                this.selectRange(this._selectionAnchorChar, this._selectionEndChar + 1);
                this._computeScrollOffset();
                if (this._scrollOffset != oldScrollOffset) {
                    this.drawInterior();
                    return;
                }
            } else {
                int oldAnchor = this._selectionAnchorChar;
                boolean wasASelection = false;
                if (this._selectionAnchorChar != this._selectionEndChar) {
                    wasASelection = true;
                    this._selectionAnchorChar = this.selectionStop();
                    oldAnchor = -1;
                } else if (this._selectionAnchorChar < this._contents.length()) {
                    this.hideCaret();
                    ++this._selectionAnchorChar;
                    if (this._selectionAnchorChar > this._contents.length()) {
                        this._selectionAnchorChar = this._contents.length();
                    }
                }
                this._selectionEndChar = this._selectionAnchorChar;
                if (oldAnchor != this._selectionAnchorChar) {
                    int oldOffset = this._scrollOffset;
                    this._computeScrollOffset();
                    if (oldOffset != this._scrollOffset || wasASelection) {
                        this._caretShowing = true;
                        this.drawInterior();
                        return;
                    }
                    this.showCaret();
                }
            }
            return;
        }
        if (event.isHomeKey()) {
            this.selectedRange();
            if (event.isShiftKeyDown()) {
                this.selectRange(this._selectionAnchorChar, 0);
            } else {
                this.selectRange(new Range(0, 0));
            }
            int oldScrollOffset = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != oldScrollOffset) {
                this.drawInterior();
            }
            return;
        }
        if (event.isEndKey()) {
            this.selectedRange();
            int lastIndex = this._contents.length();
            if (event.isShiftKeyDown()) {
                this.selectRange(this._selectionAnchorChar, lastIndex);
            } else {
                this.selectRange(new Range(lastIndex, 0));
            }
            int oldScrollOffset = this._scrollOffset;
            this._computeScrollOffset();
            if (this._scrollOffset != oldScrollOffset) {
                this.drawInterior();
            }
            return;
        }
        if (!(event.isBackspaceKey() || event.isDeleteKey() || event.isPrintableKey())) {
            return;
        }
        if (this._oldContents == null) {
            this._oldContents = new FastStringBuffer(this._contents.toString());
        }
        this.hideCaret();
        if (this._selectionAnchorChar != this._selectionEndChar) {
            String contentString = this._contents.toString();
            int start = this.selectionStart();
            this._contents = new FastStringBuffer(contentString.substring(0, start));
            this._contents.append(contentString.substring(this.selectionStop()));
            this._selectionAnchorChar = this._selectionEndChar = start;
            if (event.isBackspaceKey() || event.isDeleteKey()) {
                event = null;
            }
        }
        if (event != null) {
            if (event.isBackspaceKey()) {
                if (this._contents.length() == 0 || this._selectionAnchorChar == 0) {
                    this.showCaret();
                    return;
                }
                this._contents.removeCharAt(this._selectionAnchorChar - 1);
                --this._selectionAnchorChar;
            } else if (event.isDeleteKey()) {
                if (this._selectionAnchorChar < this._contents.length()) {
                    this._contents.removeCharAt(this._selectionAnchorChar);
                } else {
                    this.showCaret();
                }
            } else {
                this._contents.insert((char)event.key, this._selectionAnchorChar++);
            }
            this._selectionEndChar = this._selectionAnchorChar;
        }
        this._computeScrollOffset();
        this.drawInterior();
        this.showCaret();
        if (this._owner != null) {
            this._owner.textWasModified(this);
            this._textChanged = true;
            return;
        }
        if (!this._textChanged) {
            this._textChanged = true;
        }
    }

    public void keyDown(KeyEvent event) {
        if (!this.isEditable()) {
            return;
        }
        if (this._filter != null) {
            if (this._filter.acceptsEvent(this, event, this._keyVector)) {
                this._keyVector.addElement(event);
            }
        } else {
            this._keyVector.addElement(event);
        }
        while (!this._keyVector.isEmpty()) {
            KeyEvent nextKey = (KeyEvent)this._keyVector.removeFirstElement();
            this._keyDown(nextKey);
        }
    }

    public void setFocusedView() {
        if (!this._editing && this.isEditable()) {
            this._startEditing(true);
            return;
        }
        super.setFocusedView();
    }

    private void _startEditing(boolean sendMessage) {
        if (this._superview != null) {
            if (this.isEditable()) {
                this._canBlink = this._caretShowing = this.hasInsertionPoint();
            } else {
                this._caretShowing = false;
                this._canBlink = false;
            }
            this._editing = true;
            if (this.isSelectable()) {
                this.setFocusedView();
            }
            if (this.hasInsertionPoint() && this.isEditable()) {
                this.showCaret();
            }
            if (sendMessage && this._owner != null) {
                this._owner.textEditingDidBegin(this);
            }
        }
    }

    private void _completeEditing() {
        this._oldContents = null;
        boolean shouldPerformAction = this._textChanged;
        this._editing = false;
        if (this._superview != null) {
            this._ignoreWillBecomeSelected = true;
            this._superview.setFocusedView(null);
            this._ignoreWillBecomeSelected = false;
        }
        if (shouldPerformAction) {
            this.sendContentsChangedCommand();
        }
    }

    void _startBlinkTimer() {
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer(this, BLINK_CARET, 750);
            this.blinkTimer.start();
        }
    }

    void _validateSelection() {
        this.stringValue();
        if (this._selectionAnchorChar == -1) {
            this.selectRange(new Range(0, 0));
            return;
        }
        if (this._selectionAnchorChar < 0) {
            this._selectionAnchorChar = 0;
        } else if (this._selectionAnchorChar > this._contents.length()) {
            this._selectionAnchorChar = this._contents.length();
        }
        if (this._selectionEndChar < 0) {
            this._selectionEndChar = 0;
            return;
        }
        if (this._selectionEndChar > this._contents.length()) {
            this._selectionEndChar = this._contents.length();
        }
    }

    public void startFocus() {
        this._validateSelection();
        this.hasFocus = true;
        if (this.isEditable()) {
            this._startBlinkTimer();
        }
        this.setDirty(true);
    }

    public void stopFocus() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
        }
        this.hasFocus = false;
        this._scrollOffset = 0;
        if (this._editing && this._owner != null && this.isEditable()) {
            this._owner.textEditingWillEnd(this, 3, this._textChanged);
        }
        this._canBlink = false;
        this._caretShowing = false;
        if (this._editing && this.isEditable()) {
            if (this._owner != null) {
                this._owner.textEditingDidEnd(this, 3, this._textChanged);
            }
            if (this._textChanged) {
                this.sendCommitCommand(false);
            }
        }
        this._textChanged = false;
        this._editing = false;
        this.drawInterior();
    }

    public void pauseFocus() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
            this.hideCaret();
        }
    }

    public void resumeFocus() {
        if (this.isEditable()) {
            this._startBlinkTimer();
        }
    }

    public void cancelEditing() {
        if (!this.isBeingEdited()) {
            return;
        }
        if (this._oldContents != null) {
            this._contents = this._oldContents;
            this._oldContents = null;
        }
        this._editing = false;
        if (this._superview != null) {
            this._ignoreWillBecomeSelected = true;
            this._superview.setFocusedView(null);
            this._ignoreWillBecomeSelected = false;
        }
    }

    public void completeEditing() {
        boolean textDidChange = this._textChanged;
        if (!this.isBeingEdited()) {
            return;
        }
        if (this._owner != null && !this._owner.textEditingWillEnd(this, 4, textDidChange)) {
            return;
        }
        this._completeEditing();
        if (this._owner != null) {
            this._owner.textEditingDidEnd(this, 4, textDidChange);
        }
    }

    void sendCommand(String command, Target aTarget) {
        if (aTarget != null) {
            aTarget.performCommand(command, this);
        }
    }

    void sendTabCommand() {
        if (this._tabCommand != null && this._tabTarget != null) {
            this.sendCommand(this._tabCommand, this._tabTarget);
            return;
        }
        if (this.rootView() != null) {
            this.rootView().selectViewAfter(this);
        }
    }

    void sendBacktabCommand() {
        if (this._backtabCommand != null && this._backtabCommand != null) {
            this.sendCommand(this._backtabCommand, this._backtabTarget);
            return;
        }
        if (this.rootView() != null) {
            this.rootView().selectViewBefore(this);
        }
    }

    void sendContentsChangedCommand() {
        this.sendCommand(this._contentsChangedCommand, this._contentsChangedTarget);
    }

    void sendCommitCommand(boolean selectNextField) {
        if (selectNextField && this._commitCommand == null && this._commitTarget == null && this._tabCommand != null && this._tabTarget != null) {
            this.sendTabCommand();
        }
        this.sendCommand(this._commitCommand, this._commitTarget);
    }

    public boolean canPerformCommand(String command) {
        return BLINK_CARET.equals(command) || SELECT_TEXT.equals(command) || this.isEditable() && "cut".equals(command) || "copy".equals(command) || this.isEditable() && "paste".equals(command);
    }

    public void performCommand(String command, Object data) {
        if (BLINK_CARET.equals(command)) {
            this.blinkCaret();
            return;
        }
        if (SELECT_TEXT.equals(command)) {
            this.selectText();
            return;
        }
        if ("cut".equals(command)) {
            this.cut();
            return;
        }
        if ("copy".equals(command)) {
            this.copy();
            return;
        }
        if ("paste".equals(command)) {
            this.paste();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + command);
    }

    private void blinkCaret() {
        if (this._canBlink) {
            this._caretShowing = !this._caretShowing;
            this.drawCaret();
            return;
        }
        if (!this._mouseDragging && this.hasInsertionPoint()) {
            this._canBlink = true;
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.TextField", 3);
        info.addField(CONTENTS_KEY, (byte)16);
        info.addField(OWNER_KEY, (byte)18);
        info.addField(FILTER_KEY, (byte)18);
        info.addField(TABREC_KEY, (byte)18);
        info.addField(BACKTABREC_KEY, (byte)18);
        info.addField(CONTENTSCHANGEDREC_KEY, (byte)18);
        info.addField(COMMITREC_KEY, (byte)18);
        info.addField(BORDER_KEY, (byte)18);
        info.addField(FONT_KEY, (byte)18);
        info.addField(TEXTC_KEY, (byte)18);
        info.addField(BACKGROUNDC_KEY, (byte)18);
        info.addField(SELECTIONC_KEY, (byte)18);
        info.addField(CARETC_KEY, (byte)18);
        info.addField(TABCOM_KEY, (byte)16);
        info.addField(BACKTABCOM_KEY, (byte)16);
        info.addField(CONTENTSCHANGEDCOM_KEY, (byte)16);
        info.addField(COMMITCOM_KEY, (byte)16);
        info.addField(SELECTIONANCH_KEY, (byte)8);
        info.addField(SELECTIONEND_KEY, (byte)8);
        info.addField(JUSTIFICATION_KEY, (byte)8);
        info.addField(SCROLLOFFSET_KEY, (byte)8);
        info.addField(EDITABLE_KEY, (byte)0);
        info.addField(SELECTABLE_KEY, (byte)0);
        info.addField(SHADOWED_KEY, (byte)0);
        info.addField(CANWRAP_KEY, (byte)0);
        info.addField(AUTOSCROLLEVENT_KEY, (byte)0);
        info.addField(TRANSPARENT_KEY, (byte)0);
        info.addField(DRAWABLE_CHAR_KEY, (byte)2);
        info.addField(SCROLLABLE_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeString(CONTENTS_KEY, this._contents.toString());
        encoder.encodeObject(OWNER_KEY, (Codable)((Object)this._owner));
        encoder.encodeObject(FILTER_KEY, (Codable)((Object)this._filter));
        encoder.encodeObject(TABREC_KEY, (Codable)((Object)this._tabTarget));
        encoder.encodeObject(BACKTABREC_KEY, (Codable)((Object)this._backtabTarget));
        encoder.encodeObject(CONTENTSCHANGEDREC_KEY, (Codable)((Object)this._contentsChangedTarget));
        encoder.encodeObject(COMMITREC_KEY, (Codable)((Object)this._commitTarget));
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeObject(FONT_KEY, this._font);
        encoder.encodeObject(TEXTC_KEY, this._textColor);
        encoder.encodeObject(BACKGROUNDC_KEY, this._backgroundColor);
        encoder.encodeObject(SELECTIONC_KEY, this._selectionColor);
        encoder.encodeObject(CARETC_KEY, this._caretColor);
        encoder.encodeString(TABCOM_KEY, this._tabCommand);
        encoder.encodeString(BACKTABCOM_KEY, this._backtabCommand);
        encoder.encodeString(CONTENTSCHANGEDCOM_KEY, this._contentsChangedCommand);
        encoder.encodeString(COMMITCOM_KEY, this._commitCommand);
        encoder.encodeInt(SELECTIONANCH_KEY, this._selectionAnchorChar);
        encoder.encodeInt(SELECTIONEND_KEY, this._selectionEndChar);
        encoder.encodeInt(JUSTIFICATION_KEY, this._justification);
        encoder.encodeInt(SCROLLOFFSET_KEY, this._scrollOffset);
        encoder.encodeBoolean(EDITABLE_KEY, this._editable);
        encoder.encodeBoolean(SELECTABLE_KEY, this._selectable);
        encoder.encodeBoolean(SHADOWED_KEY, this._shadowed);
        encoder.encodeBoolean(CANWRAP_KEY, this._canWrap);
        encoder.encodeBoolean(AUTOSCROLLEVENT_KEY, this.wantsAutoscrollEvents);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        encoder.encodeChar(DRAWABLE_CHAR_KEY, this._drawableCharacter);
        encoder.encodeBoolean(SCROLLABLE_KEY, this.isScrollable);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.TextField");
        super.decode(decoder);
        String contentString = decoder.decodeString(CONTENTS_KEY);
        if (contentString != null) {
            this._contents = new FastStringBuffer(contentString);
        }
        this._owner = (TextFieldOwner)decoder.decodeObject(OWNER_KEY);
        this._filter = (TextFilter)decoder.decodeObject(FILTER_KEY);
        this._tabTarget = (Target)decoder.decodeObject(TABREC_KEY);
        this._backtabTarget = (Target)decoder.decodeObject(BACKTABREC_KEY);
        this._contentsChangedTarget = (Target)decoder.decodeObject(CONTENTSCHANGEDREC_KEY);
        this._commitTarget = (Target)decoder.decodeObject(COMMITREC_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this._font = (Font)decoder.decodeObject(FONT_KEY);
        this._textColor = (Color)decoder.decodeObject(TEXTC_KEY);
        this._backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this._selectionColor = (Color)decoder.decodeObject(SELECTIONC_KEY);
        this._caretColor = (Color)decoder.decodeObject(CARETC_KEY);
        this._tabCommand = decoder.decodeString(TABCOM_KEY);
        this._backtabCommand = decoder.decodeString(BACKTABCOM_KEY);
        this._contentsChangedCommand = decoder.decodeString(CONTENTSCHANGEDCOM_KEY);
        this._commitCommand = decoder.decodeString(COMMITCOM_KEY);
        this._selectionAnchorChar = decoder.decodeInt(SELECTIONANCH_KEY);
        this._selectionEndChar = decoder.decodeInt(SELECTIONEND_KEY);
        this._justification = decoder.decodeInt(JUSTIFICATION_KEY);
        this._scrollOffset = decoder.decodeInt(SCROLLOFFSET_KEY);
        this._editable = decoder.decodeBoolean(EDITABLE_KEY);
        this._selectable = decoder.decodeBoolean(SELECTABLE_KEY);
        this._shadowed = decoder.decodeBoolean(SHADOWED_KEY);
        this._canWrap = decoder.decodeBoolean(CANWRAP_KEY);
        this.wantsAutoscrollEvents = decoder.decodeBoolean(AUTOSCROLLEVENT_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
        this._drawableCharacter = version >= 2 ? decoder.decodeChar(DRAWABLE_CHAR_KEY) : ANY_CHARACTER;
        if (version >= 3) {
            this.isScrollable = decoder.decodeBoolean(SCROLLABLE_KEY);
            return;
        }
        this.isScrollable = true;
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this.setFont(this._font);
    }

    boolean isWordCharacter(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    Range groupForIndex(int index) {
        int length = this.charCount();
        if (length == 0) {
            return new Range();
        }
        if (this._drawableCharacter != ANY_CHARACTER) {
            return new Range(0, this.charCount());
        }
        if (index < 0) {
            index = 0;
        } else if (index >= length) {
            index = length - 1;
        }
        int i = index;
        char c = this._contents.charAt(i);
        if (c == '\n') {
            return new Range(i, 1);
        }
        if (c == ' ' || c == '\t') {
            while (i > 0) {
                c = this._contents.charAt(i);
                if (c != ' ' && c != '\t') break;
                --i;
            }
            int relFirstIndex = i + 1;
            i = index;
            while (i < length) {
                c = this._contents.charAt(i);
                if (c != ' ' && c != '\t') break;
                ++i;
            }
            int relLastIndex = i - 1;
            return new Range(relFirstIndex, relLastIndex - relFirstIndex + 1);
        }
        if (!this.isWordCharacter(c)) {
            return new Range(index, 1);
        }
        int relFirstIndex = i;
        while (relFirstIndex > 0) {
            c = this._contents.charAt(relFirstIndex - 1);
            if (!this.isWordCharacter(c)) break;
            --relFirstIndex;
        }
        int relLastIndex = i;
        while (relLastIndex < length - 1) {
            c = this._contents.charAt(relLastIndex + 1);
            if (!this.isWordCharacter(c)) break;
            ++relLastIndex;
        }
        return new Range(relFirstIndex, relLastIndex - relFirstIndex + 1);
    }

    private String drawableString() {
        if (this._drawableCharacter == ANY_CHARACTER) {
            if (this._contents != null) {
                return this._contents.toString();
            }
            return "";
        }
        if (this._contents != null && this._contents.length() > 0) {
            char[] buf = new char[this._contents.length()];
            int i = 0;
            int c = buf.length;
            while (i < c) {
                buf[i] = this._drawableCharacter;
                ++i;
            }
            return new String(buf);
        }
        return "";
    }

    public void willBecomeSelected() {
        if (!this._ignoreWillBecomeSelected) {
            this.selectText();
        }
    }

    public boolean canBecomeSelectedView() {
        return this.isEditable();
    }

    public View nextSelectableView() {
        if (this._tabTarget != null && this._tabTarget instanceof View) {
            return (View)((Object)this._tabTarget);
        }
        return null;
    }

    public View previousSelectableView() {
        if (this._backtabTarget != null && this._backtabTarget instanceof View) {
            return (View)((Object)this._backtabTarget);
        }
        return null;
    }

    public void copy() {
        Application.setClipboardText(this.stringForRange(this.selectedRange()));
    }

    public void cut() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            if (range == null || range.index < 0) {
                return;
            }
            Application.setClipboardText(this.stringForRange(range));
            this.replaceRangeWithString(range, "");
            this.selectRange(new Range(range.index(), 0));
        }
    }

    public void paste() {
        if (this.isEditable()) {
            Range range = this.selectedRange();
            String text = Application.clipboardText();
            if (range == null || text == null) {
                return;
            }
            this.replaceRangeWithString(range, text);
            this.selectRange(new Range(range.index() + text.length(), 0));
        }
    }

    public boolean isScrollable() {
        return this.isScrollable;
    }

    public void setScrollable(boolean value) {
        this.isScrollable = value;
    }

    public String formElementText() {
        return this.stringValue();
    }
}

