/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.ScrollBarOwner;
import netscape.application.Scrollable;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class ScrollBar
extends View
implements Target {
    Scrollable scrollableView;
    Button increaseButton;
    Button decreaseButton;
    Image knobImage;
    Image trayTopImage;
    Image trayBottomImage;
    Image trayLeftImage;
    Image trayRightImage;
    Timer timer;
    int scrollValue;
    int origScrollValue;
    int knobLength;
    int lastMouseValue;
    int lastAltMouseValue;
    int lineIncrement;
    int axis;
    boolean active;
    boolean enabled;
    boolean shouldRedraw;
    float pageSizeAsPercent;
    int pixelScrollValue;
    ScrollBarOwner scrollBarOwner;
    public static final int DEFAULT_LINE_INCREMENT = 12;
    public static final float DEFAULT_PAGE_SIZE = 1.0f;
    public static final int DEFAULT_WIDTH = 0;
    public static final int DEFAULT_HEIGHT = 0;
    public static final String UPDATE = "updateScrollValue";
    public static final String SCROLL_PAGE_BACKWARD = "scrollPageBackward";
    public static final String SCROLL_PAGE_FORWARD = "scrollPageForward";
    public static final String SCROLL_LINE_BACKWARD = "scrollLineBackward";
    public static final String SCROLL_LINE_FORWARD = "scrollLineForward";
    private static final String TIMER_SCROLL_PAGE = "timerScroll";
    static final String SCROLLVIEW_KEY = "scrollView";
    static final String INCREASEBUTTON_KEY = "increaseButton";
    static final String DECREASEBUTTON_KEY = "decreaseButton";
    static final String KNOBIMAGE_KEY = "image";
    static final String SCROLLVALUE_KEY = "scrollValue";
    static final String AXIS_KEY = "axis";
    static final String ACTIVE_KEY = "active";
    static final String ENABLED_KEY = "enabled";
    static final String LINE_INCREMENT_KEY = "lineIncrement";
    static final String OWNER_KEY = "owner";

    public ScrollBar() {
        this(0, 0, 0, 0);
    }

    public ScrollBar(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ScrollBar(int x, int y, int width, int height) {
        this(x, y, width, height, 1);
    }

    public ScrollBar(int x, int y, int width, int height, int theAxis) {
        super(x, y, width, height);
        this.axis = theAxis;
        this.lineIncrement = 12;
        this.pageSizeAsPercent = 1.0f;
        this.setEnabled(true);
        Button button = new Button(0, 0, 16, 16);
        button.setType(3);
        button.setBordered(true);
        button.setRaisedBorder(BezelBorder.raisedScrollButtonBezel());
        button.setLoweredBorder(BezelBorder.loweredScrollButtonBezel());
        if (this.axis == 0) {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollRightArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollRightArrowActive.gif"));
        } else {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollDownArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollDownArrowActive.gif"));
        }
        this.setIncreaseButton(button);
        button = new Button(0, 0, 16, 16);
        button.setType(3);
        button.setBordered(true);
        button.setRaisedBorder(BezelBorder.raisedScrollButtonBezel());
        button.setLoweredBorder(BezelBorder.loweredScrollButtonBezel());
        if (this.axis == 0) {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollLeftArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollLeftArrowActive.gif"));
        } else {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollUpArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollUpArrowActive.gif"));
        }
        this.setDecreaseButton(button);
        if (this.axis == 0) {
            this.setHorizResizeInstruction(2);
            this.setVertResizeInstruction(8);
        } else {
            this.setHorizResizeInstruction(1);
            this.setVertResizeInstruction(16);
        }
        if (this.axis == 0) {
            this.setKnobImage(Bitmap.bitmapNamed("netscape/application/ScrollKnobH.gif"));
        } else {
            this.setKnobImage(Bitmap.bitmapNamed("netscape/application/ScrollKnobV.gif"));
        }
        this.trayTopImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayTop.gif");
        this.trayBottomImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayBottom.gif");
        this.trayLeftImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayLeft.gif");
        this.trayRightImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayRight.gif");
        if (this.axis == 0 && this.bounds.height == 0 || this.axis != 0 && this.bounds.width == 0) {
            this._adjustToFit();
        }
        this._computeScrollValue();
        this._setupKeyboard();
    }

    public boolean isTransparent() {
        return false;
    }

    public Rect interiorRect() {
        return Rect.newRect(1, 1, this.width() - 2, this.height() - 2);
    }

    public Size minSize() {
        int height;
        int width;
        if (this.increaseButton != null) {
            width = this.increaseButton.bounds.width;
            height = this.increaseButton.bounds.height;
        } else {
            height = 0;
            width = 0;
        }
        if (this.decreaseButton != null) {
            if (this.axis == 0) {
                width += this.decreaseButton.bounds.width;
                if (height < this.decreaseButton.bounds.height) {
                    height = this.decreaseButton.bounds.height;
                }
            } else {
                if (width < this.decreaseButton.bounds.width) {
                    width = this.decreaseButton.bounds.width;
                }
                height += this.decreaseButton.bounds.height;
            }
        }
        return new Size(width + 2, height + 2);
    }

    void _adjustToFit() {
        Size minSize = this.minSize();
        if (this.axis == 0) {
            this.sizeTo(this.bounds.width, minSize.height);
            return;
        }
        this.sizeTo(minSize.width, this.bounds.height);
    }

    public void didSizeBy(int deltaWidth, int deltaHeight) {
        super.didSizeBy(deltaWidth, deltaHeight);
        this._computeScrollValue();
    }

    public void setIncreaseButton(Button aButton) {
        if (this.increaseButton != null) {
            this.increaseButton.removeFromSuperview();
        }
        this.increaseButton = aButton;
        if (this.increaseButton != null) {
            this.increaseButton.setTarget(this);
            this.increaseButton.setCommand(SCROLL_LINE_FORWARD);
            if (this.axis == 0) {
                this.increaseButton.setHorizResizeInstruction(1);
                this.increaseButton.setVertResizeInstruction(16);
            } else {
                this.increaseButton.setHorizResizeInstruction(2);
                this.increaseButton.setVertResizeInstruction(8);
            }
            this._adjustToFit();
        }
        if (this.enabled && this.active) {
            this.addParts();
        }
    }

    public Button increaseButton() {
        return this.increaseButton;
    }

    public void setDecreaseButton(Button aButton) {
        if (this.decreaseButton != null) {
            this.decreaseButton.removeFromSuperview();
        }
        this.decreaseButton = aButton;
        if (this.decreaseButton != null) {
            this.decreaseButton.setTarget(this);
            this.decreaseButton.setCommand(SCROLL_LINE_BACKWARD);
            if (this.axis == 0) {
                this.decreaseButton.setHorizResizeInstruction(0);
                this.decreaseButton.setVertResizeInstruction(16);
            } else {
                this.decreaseButton.setHorizResizeInstruction(2);
                this.decreaseButton.setVertResizeInstruction(4);
            }
            this._adjustToFit();
        }
        if (this.enabled && this.active) {
            this.addParts();
        }
    }

    public Button decreaseButton() {
        return this.decreaseButton;
    }

    public void addParts() {
        int x = 1;
        int y = 1;
        if (this.decreaseButton != null) {
            this.decreaseButton.moveTo(x, y);
        }
        if (this.axis == 0) {
            if (this.increaseButton != null) {
                this.increaseButton.moveTo(this.width() - 1 - this.increaseButton.width(), y);
            }
        } else if (this.increaseButton != null) {
            this.increaseButton.moveTo(x, this.height() - 1 - this.increaseButton.height());
        }
        this.addSubview(this.increaseButton);
        this.addSubview(this.decreaseButton);
    }

    public void removeParts() {
        if (this.increaseButton != null) {
            this.increaseButton.removeFromSuperview();
        }
        if (this.decreaseButton != null) {
            this.decreaseButton.removeFromSuperview();
        }
    }

    public void setScrollableObject(Scrollable aScrollableView) {
        if (this.scrollableView == aScrollableView) {
            return;
        }
        this.scrollableView = aScrollableView;
        this._computeScrollValue();
    }

    public Scrollable scrollableObject() {
        return this.scrollableView;
    }

    public void setScrollBarOwner(ScrollBarOwner owner) {
        this.scrollBarOwner = owner;
    }

    public ScrollBarOwner scrollBarOwner() {
        return this.scrollBarOwner;
    }

    public Rect scrollTrayRect() {
        if (this.axis == 0) {
            int x = 1;
            if (this.decreaseButton != null) {
                x += this.decreaseButton.bounds.width;
            }
            int maxX = this.width() - 1;
            if (this.increaseButton != null) {
                maxX -= this.increaseButton.width();
            }
            return Rect.newRect(x, 1, maxX - x, this.height() - 2);
        }
        int y = 1;
        if (this.decreaseButton != null) {
            y += this.decreaseButton.height();
        }
        int maxY = this.height() - 1;
        if (this.increaseButton != null) {
            maxY -= this.increaseButton.height();
        }
        return Rect.newRect(1, y, this.width() - 2, maxY - y);
    }

    public int scrollTrayLength() {
        Rect scrollTrayRect = this.scrollTrayRect();
        int length = this.axis == 0 ? scrollTrayRect.width : scrollTrayRect.height;
        Rect.returnRect(scrollTrayRect);
        return length;
    }

    public void setKnobImage(Image anImage) {
        this.knobImage = anImage;
        this._adjustToFit();
    }

    public Image knobImage() {
        return this.knobImage;
    }

    public Rect knobRect() {
        int height;
        int width;
        int y;
        int x;
        Rect tmpRect = this.scrollTrayRect();
        if (this.axis == 0) {
            x = tmpRect.x + this.scrollValue;
            y = tmpRect.y;
            width = this.knobLength;
            height = tmpRect.height;
        } else {
            x = tmpRect.x;
            y = tmpRect.y + this.scrollValue;
            width = tmpRect.width;
            height = this.knobLength;
        }
        tmpRect.setBounds(x, y, width, height);
        return tmpRect;
    }

    public void setKnobLength(int newKnobLength) {
        int scrollTrayLength = this.scrollTrayLength();
        if (newKnobLength < this.minKnobLength()) {
            newKnobLength = this.minKnobLength();
        } else if (newKnobLength > scrollTrayLength) {
            newKnobLength = scrollTrayLength;
        }
        this.knobLength = newKnobLength;
    }

    public int knobLength() {
        return this.knobLength;
    }

    public int minKnobLength() {
        if (this.axis == 0) {
            return this.height() - 2;
        }
        return this.width() - 2;
    }

    public void setEnabled(boolean value) {
        if (value == this.enabled) {
            return;
        }
        this.enabled = value;
        if (this.active && this.enabled) {
            this.addParts();
        } else if (!this.enabled) {
            this.removeParts();
        } else {
            return;
        }
        this.setDirty(true);
        if (this.scrollBarOwner != null) {
            if (this.enabled) {
                this.scrollBarOwner.scrollBarWasEnabled(this);
                return;
            }
            this.scrollBarOwner.scrollBarWasDisabled(this);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActive(boolean value) {
        if (value == this.active) {
            return;
        }
        this.active = value;
        if (this.active && this.enabled) {
            this.addParts();
        } else if (!this.active) {
            this.removeParts();
        }
        this.setDirty(true);
        if (this.scrollBarOwner != null) {
            if (this.active) {
                this.scrollBarOwner.scrollBarDidBecomeActive(this);
                return;
            }
            this.scrollBarOwner.scrollBarDidBecomeInactive(this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void drawViewKnobInRect(Graphics g, Rect rect) {
        BezelBorder.raisedScrollButtonBezel().drawInRect(g, rect);
        g.setColor(Color.lightGray);
        g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        if (this.knobImage != null) {
            this.knobImage.drawCentered(g, rect);
        }
    }

    public void drawView(Graphics g) {
        g.setColor(Color.gray153);
        g.drawLine(0, 0, 0, this.height() - 1);
        g.drawLine(1, 0, this.width() - 1, 0);
        g.setColor(Color.gray231);
        g.drawLine(this.width() - 1, 0, this.width() - 1, this.height());
        g.drawLine(0, this.height() - 1, this.width() - 1, this.height() - 1);
        Rect areaRect = this.scrollTrayRect();
        int x = this.interiorRect().x;
        int y = this.interiorRect().y;
        int maxX = this.interiorRect().maxX();
        int maxY = this.interiorRect().maxY();
        int beforeX = areaRect.x;
        int beforeY = areaRect.y;
        int otherX = areaRect.x + areaRect.width;
        int otherY = areaRect.y + areaRect.height;
        if (!this.isEnabled() || !this.isActive()) {
            if (this.axis == 0) {
                g.setColor(Color.lightGray);
                g.fillRect(x + 1, y + 1, beforeX - 3, maxY - 3);
                g.fillRect(otherX + 1, y + 1, maxX - otherX - 2, maxY - 3);
                g.fillRect(areaRect.x + 1, areaRect.y + 1, areaRect.width - 2, areaRect.height - 2);
                g.setColor(Color.gray153);
                g.drawLine(x, maxY - 1, maxX - 1, maxY - 1);
                g.drawLine(maxX - 1, y, maxX - 1, maxY - 2);
                g.drawLine(beforeX - 1, y, beforeX - 1, maxY - 2);
                g.drawLine(otherX - 1, y, otherX - 1, maxY - 2);
                g.drawLine(x + 5, y + 7, x + 5, y + 8);
                g.drawLine(x + 6, y + 6, x + 6, y + 9);
                g.drawLine(x + 7, y + 5, x + 7, y + 10);
                g.drawLine(x + 8, y + 4, x + 8, y + 11);
                g.drawLine(x + 9, y + 3, x + 9, y + 12);
                g.drawLine(otherX + 6, y + 3, otherX + 6, y + 12);
                g.drawLine(otherX + 7, y + 4, otherX + 7, y + 11);
                g.drawLine(otherX + 8, y + 5, otherX + 8, y + 10);
                g.drawLine(otherX + 9, y + 6, otherX + 9, y + 9);
                g.drawLine(otherX + 10, y + 7, otherX + 10, y + 8);
                g.setColor(Color.gray231);
                g.drawLine(x, y, x, maxY - 2);
                g.drawLine(x + 1, y, beforeX - 2, y);
                g.drawLine(beforeX, y, beforeX, maxY - 2);
                g.drawLine(beforeX + 1, y, otherX - 2, y);
                g.drawLine(otherX, y, otherX, maxY - 2);
                g.drawLine(otherX + 1, y, maxX - 2, y);
            } else {
                g.setColor(Color.lightGray);
                g.fillRect(x + 1, y + 1, maxX - 3, beforeY - 3);
                g.fillRect(x + 1, otherY + 1, maxX - 3, maxY - otherY - 2);
                g.fillRect(areaRect.x + 1, areaRect.y + 1, areaRect.width - 2, areaRect.height - 2);
                g.setColor(Color.gray153);
                g.drawLine(maxX - 1, y, maxX - 1, maxY - 1);
                g.drawLine(x, maxY - 1, maxX - 2, maxY - 1);
                g.drawLine(x, beforeY - 1, maxX - 2, beforeY - 1);
                g.drawLine(x, otherY - 1, maxX - 2, otherY - 1);
                g.drawLine(x + 7, y + 5, x + 8, y + 5);
                g.drawLine(x + 6, y + 6, x + 9, y + 6);
                g.drawLine(x + 5, y + 7, x + 10, y + 7);
                g.drawLine(x + 4, y + 8, x + 11, y + 8);
                g.drawLine(x + 3, y + 9, x + 12, y + 9);
                g.drawLine(x + 3, otherY + 6, x + 12, otherY + 6);
                g.drawLine(x + 4, otherY + 7, x + 11, otherY + 7);
                g.drawLine(x + 5, otherY + 8, x + 10, otherY + 8);
                g.drawLine(x + 6, otherY + 9, x + 9, otherY + 9);
                g.drawLine(x + 7, otherY + 10, x + 8, otherY + 10);
                g.setColor(Color.gray231);
                g.drawLine(x, y, maxX - 2, y);
                g.drawLine(x, y + 1, x, beforeY - 2);
                g.drawLine(x, beforeY, maxX - 2, beforeY);
                g.drawLine(x, beforeY + 1, x, otherY - 2);
                g.drawLine(x, otherY, maxX - 2, otherY);
                g.drawLine(x, otherY + 1, x, maxY - 2);
            }
            Rect.returnRect(areaRect);
            return;
        }
        if (this.knobLength <= this.scrollTrayLength()) {
            x = areaRect.x;
            maxX = areaRect.maxX();
            y = areaRect.y;
            maxY = areaRect.maxY();
            if (this.axis == 0) {
                beforeX = x + this.scrollValue - 1;
                otherX = x + this.scrollValue + this.knobLength;
                if (this.scrollValue > 0) {
                    g.setColor(Color.gray153);
                    g.drawLine(x, y, beforeX, y);
                    g.drawLine(x, y + 1, x, maxY - 2);
                    this.trayTopImage.drawTiled(g, x + 1, y + 1, beforeX - x, 1);
                    this.trayBottomImage.drawTiled(g, x + 1, maxY - 1, beforeX - x, 1);
                    this.trayLeftImage.drawTiled(g, x + 1, y + 1, 1, maxY - 3);
                    g.setColor(Color.lightGray);
                    g.fillRect(x + 2, y + 2, beforeX - x - 1, maxY - y - 3);
                }
                if (otherX < maxX) {
                    g.setColor(Color.gray153);
                    g.drawLine(otherX, y, maxX - 2, y);
                    g.drawLine(maxX - 1, y, maxX - 1, maxY - 1);
                    this.trayTopImage.drawTiled(g, otherX, y + 1, maxX - otherX - 1, 1);
                    this.trayBottomImage.drawTiled(g, otherX, maxY - 1, maxX - otherX - 1, 1);
                    this.trayLeftImage.drawTiled(g, otherX, y + 1, 1, maxY - 3);
                    this.trayRightImage.drawTiled(g, maxX - 2, y + 1, 1, maxY - 3);
                    g.setColor(Color.lightGray);
                    g.fillRect(otherX + 1, y + 2, maxX - otherX - 3, maxY - y - 3);
                }
            } else {
                beforeY = y + this.scrollValue - 1;
                otherY = y + this.scrollValue + this.knobLength;
                if (this.scrollValue > 0) {
                    g.setColor(Color.gray153);
                    g.drawLine(x, y + 1, x, beforeY);
                    g.drawLine(x, y, maxX - 1, y);
                    this.trayTopImage.drawTiled(g, x + 1, y + 1, maxX - 2, 1);
                    this.trayLeftImage.drawTiled(g, x + 1, y + 1, 1, beforeY - y);
                    this.trayRightImage.drawTiled(g, maxX - 1, y + 1, 1, beforeY - y);
                    g.setColor(Color.lightGray);
                    g.fillRect(x + 2, y + 2, maxX - x - 3, beforeY - y - 1);
                }
                if (otherY < maxY) {
                    g.setColor(Color.gray153);
                    g.drawLine(x, otherY, x, maxY - 2);
                    g.drawLine(x, maxY - 1, maxX - 1, maxY - 1);
                    this.trayTopImage.drawTiled(g, x + 1, otherY, maxX - x - 2, 1);
                    this.trayBottomImage.drawTiled(g, x + 1, maxY - 2, maxX - x - 1, 1);
                    this.trayLeftImage.drawTiled(g, x + 1, otherY, 1, maxY - otherY - 2);
                    this.trayRightImage.drawTiled(g, maxX - 1, otherY, 1, maxY - otherY - 2);
                    g.setColor(Color.lightGray);
                    g.fillRect(x + 2, otherY + 1, maxX - x - 3, maxY - otherY - 3);
                }
            }
            Rect.returnRect(areaRect);
            Rect knobRect = this.knobRect();
            this.drawViewKnobInRect(g, knobRect);
            Rect.returnRect(knobRect);
            return;
        }
        if (this.axis == 0) {
            g.setColor(Color.lightGray);
            g.fillRect(areaRect.x + 1, areaRect.y + 1, areaRect.width - 2, areaRect.height - 2);
            g.setColor(Color.gray102);
            g.drawLine(x, maxY - 1, maxX - 1, maxY - 1);
            g.drawLine(otherX - 1, y, otherX - 1, maxY - 2);
            g.setColor(Color.gray231);
            g.drawLine(beforeX, y, beforeX, maxY - 2);
            g.drawLine(beforeX + 1, y, otherX - 2, y);
            return;
        }
        g.setColor(Color.lightGray);
        g.fillRect(areaRect.x + 1, areaRect.y + 1, areaRect.width - 2, areaRect.height - 2);
        g.setColor(Color.gray102);
        g.drawLine(maxX - 1, y, maxX - 1, maxY - 1);
        g.drawLine(x, otherY - 1, maxX - 2, otherY - 1);
        g.setColor(Color.gray231);
        g.drawLine(x, beforeY, maxX - 2, beforeY);
        g.drawLine(x, beforeY + 1, x, otherY - 2);
    }

    public void drawScrollTray() {
        Rect tmpRect = this.scrollTrayRect();
        this.addDirtyRect(tmpRect);
        Rect.returnRect(tmpRect);
    }

    void _setScrollValue(int newValue) {
        if (newValue < 0) {
            this.scrollValue = 0;
            return;
        }
        if (newValue > this._maxScrollValue()) {
            this.scrollValue = this._maxScrollValue();
            return;
        }
        this.scrollValue = newValue;
    }

    void _setScrollPercent(float percent) {
        if (percent < 0.0f || percent > 1.0f) {
            return;
        }
        int value = (int)(percent * (float)this._maxScrollValue());
        if (value != 0 || percent == 0.0f) {
            this._setScrollValue(value);
            return;
        }
        this._setScrollValue((int)Math.ceil(percent * (float)this._maxScrollValue()));
    }

    void _setPercentVisible(float percent) {
        int scrollTrayLength = this.scrollTrayLength();
        int newKnobLength = (int)(percent * (float)scrollTrayLength);
        this.setKnobLength(newKnobLength);
        if (scrollTrayLength < 1 || scrollTrayLength <= newKnobLength) {
            this.setActive(false);
            return;
        }
        this.setActive(true);
    }

    void _computeScrollValue() {
        int contentX;
        int contentWidth;
        int scrollWidth;
        int oldScrollValue = this.scrollValue;
        int oldKnobLength = this.knobLength;
        boolean oldActive = this.active;
        int scrollX = 0;
        if (this.scrollableView != null) {
            int theAxis = this.axis();
            scrollWidth = this.scrollableView.lengthOfScrollViewForAxis(theAxis);
            contentWidth = this.scrollableView.lengthOfContentViewForAxis(theAxis);
            contentX = this.scrollableView.positionOfContentViewForAxis(theAxis);
        } else {
            scrollWidth = 0;
            contentWidth = 0;
            contentX = 0;
        }
        if (contentWidth == 0) {
            this._setPercentVisible(1.0f);
        } else {
            this._setPercentVisible((float)scrollWidth / (float)contentWidth);
        }
        int delta = contentWidth - scrollWidth;
        if (delta <= 0) {
            this._setScrollPercent(0.0f);
        } else {
            this._setScrollPercent((float)(scrollX - contentX) / (float)delta);
        }
        if ((this.scrollValue != oldScrollValue || this.knobLength != oldKnobLength || this.active != oldActive) && this.isActive() && this.isEnabled()) {
            this.drawScrollTray();
        }
    }

    public int scrollValue() {
        return this.scrollValue;
    }

    int pixelScrollValue() {
        return this.pixelScrollValue;
    }

    int _maxScrollValue() {
        return this.scrollTrayLength() - this.knobLength;
    }

    public float scrollPercent() {
        int maxValue = this._maxScrollValue();
        if (maxValue == 0) {
            return 0.0f;
        }
        return (float)this.scrollValue() / (float)maxValue;
    }

    int _mouseValue(MouseEvent event) {
        Rect scrollTrayRect = this.scrollTrayRect();
        int value = this.axis == 0 ? event.x - scrollTrayRect.x : event.y - scrollTrayRect.y;
        Rect.returnRect(scrollTrayRect);
        return value;
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        this.lastMouseValue = this.lastAltMouseValue = this._mouseValue(event);
        if (event.isMetaKeyDown() && (this.lastMouseValue >= this.scrollValue + this.knobLength || this.lastMouseValue < this.scrollValue)) {
            int oldScrollValue = this.scrollValue;
            this._setScrollValue(this.lastMouseValue - this.knobLength / 2);
            int delta = this.scrollValue - oldScrollValue;
            if (delta != 0) {
                this.scrollToCurrentPosition();
            }
        } else if (this.lastMouseValue < this.scrollValue) {
            this.scrollPageBackward();
            this.timer = new Timer(this, TIMER_SCROLL_PAGE, 75);
            this.timer.setInitialDelay(300);
            if (this.lastMouseValue < this.scrollValue) {
                this.timer.start();
            } else if (this.lastMouseValue < this.scrollValue + this.knobLength) {
                this.timer = null;
            }
        } else if (this.lastMouseValue >= this.scrollValue + this.knobLength) {
            this.scrollPageForward();
            this.timer = new Timer(this, TIMER_SCROLL_PAGE, 75);
            this.timer.setInitialDelay(300);
            if (this.lastMouseValue >= this.scrollValue - this.knobLength) {
                this.timer.start();
            } else if (this.lastMouseValue >= this.scrollValue) {
                this.timer = null;
            }
        }
        this.origScrollValue = this.scrollValue;
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        int value = this._mouseValue(event);
        if (!this.isEnabled() || !this.isActive() || this.timer != null) {
            this.lastMouseValue = value;
            this.origScrollValue = this.scrollValue;
            return;
        }
        if (event.isControlKeyDown()) {
            this.pixelScrollValue = this.lastAltMouseValue - value;
            this.scrollByPixel(this.pixelScrollValue);
            this.lastAltMouseValue = value;
            this.origScrollValue = this.scrollValue;
            return;
        }
        this.lastAltMouseValue = value;
        int oldScrollValue = this.scrollValue;
        this._setScrollValue(this.origScrollValue + (value - this.lastMouseValue));
        int delta = this.scrollValue - oldScrollValue;
        if (delta != 0) {
            this.scrollToCurrentPosition();
        }
    }

    private void timerScroll() {
        if (this.lastMouseValue < this.scrollValue) {
            this.scrollPageBackward();
            if (this.lastMouseValue >= this.scrollValue) {
                this.timer.stop();
                if (this.lastMouseValue < this.scrollValue + this.knobLength) {
                    this.timer = null;
                }
            }
        } else if (this.lastMouseValue >= this.scrollValue + this.knobLength) {
            this.scrollPageForward();
            if (this.lastMouseValue < this.scrollValue - this.knobLength) {
                this.timer.stop();
                if (this.lastMouseValue >= this.scrollValue) {
                    this.timer = null;
                }
            }
        }
        this.origScrollValue = this.scrollValue;
    }

    public void mouseUp(MouseEvent event) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void performCommand(String command, Object data) {
        if (TIMER_SCROLL_PAGE.equals(command)) {
            this.timerScroll();
            return;
        }
        if (UPDATE.equals(command)) {
            this.update();
            return;
        }
        if (SCROLL_LINE_FORWARD.equals(command)) {
            this.scrollLineForward();
            return;
        }
        if (SCROLL_LINE_BACKWARD.equals(command)) {
            this.scrollLineBackward();
            return;
        }
        if (SCROLL_PAGE_FORWARD.equals(command)) {
            this.scrollPageForward();
            return;
        }
        if (SCROLL_PAGE_BACKWARD.equals(command)) {
            this.scrollPageBackward();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + command);
    }

    private void update() {
        int oldScrollValue = this.scrollValue;
        int oldKnobLength = this.knobLength;
        boolean oldActive = this.active;
        oldActive = this.active;
        this._computeScrollValue();
        if (oldActive != this.active) {
            this.setDirty(true);
            return;
        }
        if (this.shouldRedraw || (this.scrollValue != oldScrollValue || this.knobLength != oldKnobLength || this.active != oldActive) && this.isActive() && this.isEnabled()) {
            this.drawScrollTray();
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ScrollBar", 2);
        info.addField(SCROLLVIEW_KEY, (byte)18);
        info.addField(INCREASEBUTTON_KEY, (byte)18);
        info.addField(DECREASEBUTTON_KEY, (byte)18);
        info.addField(KNOBIMAGE_KEY, (byte)18);
        info.addField(SCROLLVALUE_KEY, (byte)8);
        info.addField(AXIS_KEY, (byte)8);
        info.addField(ACTIVE_KEY, (byte)0);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(LINE_INCREMENT_KEY, (byte)8);
        info.addField(OWNER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(SCROLLVIEW_KEY, this.scrollableView);
        encoder.encodeObject(INCREASEBUTTON_KEY, this.increaseButton);
        encoder.encodeObject(DECREASEBUTTON_KEY, this.decreaseButton);
        encoder.encodeObject(KNOBIMAGE_KEY, this.knobImage);
        encoder.encodeInt(SCROLLVALUE_KEY, this.scrollValue);
        encoder.encodeInt(AXIS_KEY, this.axis);
        encoder.encodeBoolean(ACTIVE_KEY, this.active);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeInt(LINE_INCREMENT_KEY, this.lineIncrement);
        encoder.encodeObject(OWNER_KEY, this.scrollBarOwner);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.ScrollBar");
        super.decode(decoder);
        this.scrollableView = (Scrollable)decoder.decodeObject(SCROLLVIEW_KEY);
        this.increaseButton = (Button)decoder.decodeObject(INCREASEBUTTON_KEY);
        this.decreaseButton = (Button)decoder.decodeObject(DECREASEBUTTON_KEY);
        this.knobImage = (Image)decoder.decodeObject(KNOBIMAGE_KEY);
        this.scrollValue = decoder.decodeInt(SCROLLVALUE_KEY);
        this.axis = decoder.decodeInt(AXIS_KEY);
        this.active = decoder.decodeBoolean(ACTIVE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        if (version >= 2) {
            this.lineIncrement = decoder.decodeInt(LINE_INCREMENT_KEY);
            this.scrollBarOwner = (ScrollBarOwner)decoder.decodeObject(OWNER_KEY);
        } else {
            this.lineIncrement = 12;
            this.scrollBarOwner = null;
        }
        this._computeScrollValue();
    }

    public int axis() {
        return this.axis;
    }

    public float pageSizeAsPercent() {
        return this.pageSizeAsPercent;
    }

    public void setPageSizeAsPercent(float value) {
        if (value <= 0.0f || value > 1.0f) {
            return;
        }
        this.pageSizeAsPercent = value;
    }

    public void setLineIncrement(int value) {
        if (value > 0) {
            this.lineIncrement = value;
        }
    }

    public int lineIncrement() {
        return this.lineIncrement;
    }

    private void scrollTo(int x, int y) {
        this.shouldRedraw = true;
        if (this.scrollableView != null) {
            this.scrollableView.scrollTo(x, y);
        }
        this.shouldRedraw = false;
    }

    private void scrollBy(int deltaX, int deltaY) {
        this.shouldRedraw = true;
        if (this.scrollableView != null) {
            this.scrollableView.scrollBy(deltaX, deltaY);
        }
        this.shouldRedraw = false;
    }

    private void scrollByPixel(int amount) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy(amount, 0);
                return;
            }
            this.scrollBy(0, amount);
        }
    }

    private void scrollByLine(int amount) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy(amount * this.lineIncrement, 0);
                return;
            }
            this.scrollBy(0, amount * this.lineIncrement);
        }
    }

    private void scrollByPage(float amount) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy((int)(amount * (float)this.scrollableView.lengthOfScrollViewForAxis(this.axis)), 0);
                return;
            }
            this.scrollBy(0, (int)(amount * (float)this.scrollableView.lengthOfScrollViewForAxis(this.axis)));
        }
    }

    private void scrollToPercent(float amount) {
        if (this.scrollableView != null) {
            int scrollLen = this.scrollableView.lengthOfContentViewForAxis(this.axis);
            int contentLen = this.scrollableView.lengthOfScrollViewForAxis(this.axis);
            int newAxis = -((int)(amount * (float)(scrollLen - contentLen)));
            if (this.axis == 0) {
                this.scrollTo(newAxis, this.scrollableView.positionOfContentViewForAxis(1));
                return;
            }
            this.scrollTo(this.scrollableView.positionOfContentViewForAxis(0), newAxis);
        }
    }

    public void scrollLineForward() {
        this.scrollByLine(-1);
    }

    public void scrollLineBackward() {
        this.scrollByLine(1);
    }

    public void scrollPageForward() {
        this.scrollByPage(-this.pageSizeAsPercent);
    }

    public void scrollPageBackward() {
        this.scrollByPage(this.pageSizeAsPercent);
    }

    public void scrollToCurrentPosition() {
        this.scrollToPercent(this.scrollPercent());
    }

    public void setScrollPercent(float value) {
        this._setScrollPercent(value);
        this.scrollToCurrentPosition();
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        if (this.axis() == 0) {
            this.setCommandForKey(SCROLL_LINE_FORWARD, 1007, 1);
            this.setCommandForKey(SCROLL_LINE_BACKWARD, 1006, 1);
            return;
        }
        this.setCommandForKey(SCROLL_LINE_FORWARD, 1005, 1);
        this.setCommandForKey(SCROLL_LINE_BACKWARD, 1004, 1);
    }

    public boolean hidesSubviewsFromKeyboard() {
        return true;
    }
}

