/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Point;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Rect
implements Codable {
    public int x;
    public int y;
    public int width;
    public int height;
    private static Vector _rectCache = new Vector();
    private static boolean _cacheRects = true;
    static final String X_KEY = "x";
    static final String Y_KEY = "y";
    static final String WIDTH_KEY = "width";
    static final String HEIGHT_KEY = "height";

    public static boolean contains(int x, int y, int width, int height, int pointX, int pointY) {
        return pointX >= x && pointX < x + width && pointY >= y && pointY < y + height;
    }

    public static Rect rectFromIntersection(Rect rect1, Rect rect2) {
        Rect newRect = new Rect(rect1);
        newRect.intersectWith(rect2);
        return newRect;
    }

    public static Rect rectFromUnion(Rect rect1, Rect rect2) {
        Rect newRect = new Rect(rect1);
        newRect.unionWith(rect2);
        return newRect;
    }

    public Rect() {
    }

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect(Rect templateRect) {
        this.x = templateRect.x;
        this.y = templateRect.y;
        this.width = templateRect.width;
        this.height = templateRect.height;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width < 0 ? 0 : width;
        this.height = height < 0 ? 0 : height;
    }

    public void setBounds(Rect rect) {
        if (rect == null) {
            this.setBounds(0, 0, 0, 0);
            return;
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCoordinates(int x1, int y1, int x2, int y2) {
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void moveBy(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
    }

    public void sizeTo(int width, int height) {
        this.width = width < 0 ? 0 : width;
        this.height = height < 0 ? 0 : height;
    }

    public void sizeBy(int deltaWidth, int deltaHeight) {
        this.width += deltaWidth;
        if (this.width < 0) {
            this.width = 0;
        }
        this.height += deltaHeight;
        if (this.height < 0) {
            this.height = 0;
        }
    }

    public void growBy(int deltaX, int deltaY) {
        this.x -= deltaX;
        this.y -= deltaY;
        this.width += 2 * deltaX;
        this.height += 2 * deltaY;
        if (this.width < 0) {
            this.width = 0;
        }
        if (this.height < 0) {
            this.height = 0;
        }
    }

    public int maxX() {
        return this.x + this.width;
    }

    public int maxY() {
        return this.y + this.height;
    }

    public int midX() {
        return this.x + this.width / 2;
    }

    public int midY() {
        return this.y + this.height / 2;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Rect)) {
            return false;
        }
        Rect rect = (Rect)anObject;
        return rect.x == this.x && rect.y == this.y && rect.width == this.width && rect.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public boolean contains(Point aPoint) {
        return this.contains(aPoint.x, aPoint.y);
    }

    public boolean contains(Rect aRect) {
        if (aRect == null) {
            return false;
        }
        return aRect.x >= this.x && aRect.x + aRect.width <= this.x + this.width && aRect.y >= this.y && aRect.y + aRect.height <= this.y + this.height;
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.x >= x + width || this.x + this.width <= x || this.y >= y + height || this.y + this.height <= y) {
            return false;
        }
        return this.width != 0 && this.height != 0 && width != 0 && height != 0;
    }

    public boolean intersects(Rect aRect) {
        if (aRect == null) {
            return false;
        }
        return this.intersects(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public void intersectWith(int x, int y, int width, int height) {
        int x1 = x;
        int y1 = y;
        int x2 = x1 + width;
        int y2 = y1 + height;
        int myx2 = this.x + this.width;
        int myy2 = this.y + this.height;
        if (this.x >= x2 || myx2 <= x1) {
            x2 = 0;
            x1 = 0;
        } else if (this.x > x1 && this.x < x2) {
            x1 = this.x;
            if (myx2 < x2) {
                x2 = myx2;
            }
        } else if (myx2 > x1 && myx2 < x2) {
            x2 = myx2;
        }
        if (this.y >= y2 || myy2 <= y1) {
            y2 = 0;
            y1 = 0;
        } else if (this.y > y1 && this.y < y2) {
            y1 = this.y;
            if (myy2 < y2) {
                y2 = myy2;
            }
        } else if (myy2 > y1 && myy2 < y2) {
            y2 = myy2;
        }
        this.setCoordinates(x1, y1, x2, y2);
    }

    public void intersectWith(Rect aRect) {
        this.intersectWith(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public Rect intersectionRect(Rect aRect) {
        int x1 = aRect.x;
        int y1 = aRect.y;
        int x2 = aRect.x + aRect.width;
        int y2 = aRect.y + aRect.height;
        int myx2 = this.x + this.width;
        int myy2 = this.y + this.height;
        if (this.x >= x2 || myx2 <= x1 || this.y >= y2 || myy2 <= y1) {
            return new Rect();
        }
        if (this.x > x1 && this.x < x2) {
            x1 = this.x;
            if (myx2 < x2) {
                x2 = myx2;
            }
        } else if (myx2 > x1 && myx2 < x2) {
            x2 = myx2;
        }
        if (this.y > y1 && this.y < y2) {
            y1 = this.y;
            if (myy2 < y2) {
                y2 = myy2;
            }
        } else if (myy2 > y1 && myy2 < y2) {
            y2 = myy2;
        }
        return new Rect(x1, y1, x2 - x1, y2 - y1);
    }

    public void unionWith(int x, int y, int width, int height) {
        int x1 = this.x < x ? this.x : x;
        int x2 = x + width;
        if (this.x + this.width > x2) {
            x2 = this.x + this.width;
        }
        int y1 = this.y < y ? this.y : y;
        int y2 = y + height;
        if (this.y + this.height > y2) {
            y2 = this.y + this.height;
        }
        this.setCoordinates(x1, y1, x2, y2);
    }

    public void unionWith(Rect aRect) {
        if (aRect == null) {
            return;
        }
        this.unionWith(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public Rect unionRect(Rect aRect) {
        if (aRect == null) {
            return new Rect(this);
        }
        int x1 = this.x < aRect.x ? this.x : aRect.x;
        int myx2 = this.x + this.width;
        int x2 = aRect.x + aRect.width;
        if (myx2 > x2) {
            x2 = myx2;
        }
        int y1 = this.y < aRect.y ? this.y : aRect.y;
        int myy2 = this.y + this.height;
        int y2 = aRect.y + aRect.height;
        if (myy2 > y2) {
            y2 = myy2;
        }
        return new Rect(x1, y1, x2 - x1, y2 - y1);
    }

    void filterEmptyRects(Vector aVector) {
        int i = aVector.count();
        while (i-- > 0) {
            Rect nextRect = (Rect)aVector.elementAt(i);
            if (nextRect.width != 0 && nextRect.height != 0) continue;
            aVector.removeElementAt(i);
        }
    }

    public void computeDisunionRects(Rect aRect, Vector rects) {
        if (aRect == null || !this.intersects(aRect) || rects == null) {
            return;
        }
        if (aRect.contains(this)) {
            return;
        }
        if (this.contains(aRect)) {
            rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, this.height));
            rects.addElement(Rect.newRect(aRect.x, this.y, aRect.width, aRect.y - this.y));
            rects.addElement(Rect.newRect(aRect.x, aRect.maxY(), aRect.width, this.maxY() - aRect.maxY()));
            rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), this.height));
            this.filterEmptyRects(rects);
            return;
        }
        if (aRect.x <= this.x && aRect.y <= this.y) {
            if (aRect.maxX() > this.maxX()) {
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            } else if (aRect.maxY() > this.maxY()) {
                rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), this.height));
            } else {
                rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), aRect.maxY() - this.y));
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            }
            this.filterEmptyRects(rects);
            return;
        }
        if (aRect.x <= this.x && aRect.maxY() >= this.maxY()) {
            if (aRect.maxX() > this.maxX()) {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
            } else {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(aRect.maxX(), aRect.y, this.maxX() - aRect.maxX(), this.maxY() - aRect.y));
            }
            this.filterEmptyRects(rects);
            return;
        }
        if (aRect.x <= this.x) {
            if (aRect.maxX() >= this.maxX()) {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            } else {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(aRect.maxX(), aRect.y, this.maxX() - aRect.maxX(), aRect.height));
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            }
            this.filterEmptyRects(rects);
            return;
        }
        if (aRect.x <= this.maxX() && aRect.maxX() > this.maxX()) {
            if (aRect.y <= this.y && aRect.maxY() > this.maxY()) {
                rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, this.height));
            } else if (aRect.y <= this.y) {
                rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, aRect.maxY() - this.y));
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            } else if (aRect.maxY() > this.maxY()) {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(this.x, aRect.y, aRect.x - this.x, this.maxY() - aRect.y));
            } else {
                rects.addElement(Rect.newRect(this.x, this.y, this.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(this.x, aRect.y, aRect.x - this.x, aRect.height));
                rects.addElement(Rect.newRect(this.x, aRect.maxY(), this.width, this.maxY() - aRect.maxY()));
            }
            this.filterEmptyRects(rects);
            return;
        }
        if (aRect.x >= this.x && aRect.maxX() <= this.maxX()) {
            if (aRect.y <= this.y && aRect.maxY() > this.maxY()) {
                rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, this.height));
                rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), this.height));
            } else if (aRect.y <= this.y) {
                rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, this.height));
                rects.addElement(Rect.newRect(aRect.x, aRect.maxY(), aRect.width, this.maxY() - aRect.maxY()));
                rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), this.height));
            } else {
                rects.addElement(Rect.newRect(this.x, this.y, aRect.x - this.x, this.height));
                rects.addElement(Rect.newRect(aRect.x, this.y, aRect.width, aRect.y - this.y));
                rects.addElement(Rect.newRect(aRect.maxX(), this.y, this.maxX() - aRect.maxX(), this.height));
            }
            this.filterEmptyRects(rects);
            return;
        }
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Rect", 1);
        info.addField(X_KEY, (byte)8);
        info.addField(Y_KEY, (byte)8);
        info.addField(WIDTH_KEY, (byte)8);
        info.addField(HEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(X_KEY, this.x);
        encoder.encodeInt(Y_KEY, this.y);
        encoder.encodeInt(WIDTH_KEY, this.width);
        encoder.encodeInt(HEIGHT_KEY, this.height);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.x = decoder.decodeInt(X_KEY);
        this.y = decoder.decodeInt(Y_KEY);
        this.width = decoder.decodeInt(WIDTH_KEY);
        this.height = decoder.decodeInt(HEIGHT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Rect newRect(int x, int y, int width, int height) {
        Rect theRect;
        Vector vector = _rectCache;
        synchronized (vector) {
            if (!_cacheRects || _rectCache.isEmpty()) {
                Rect rect = new Rect(x, y, width, height);
                Object var7_6 = null;
                return rect;
            }
            theRect = (Rect)_rectCache.removeLastElement();
        }
        theRect.setBounds(x, y, width, height);
        return theRect;
    }

    static Rect newRect(Rect templateRect) {
        if (templateRect == null) {
            return Rect.newRect(0, 0, 0, 0);
        }
        return Rect.newRect(templateRect.x, templateRect.y, templateRect.width, templateRect.height);
    }

    static Rect newRect() {
        return Rect.newRect(0, 0, 0, 0);
    }

    static void returnRect(Rect aRect) {
        if (!_cacheRects) {
            return;
        }
        Vector vector = _rectCache;
        synchronized (vector) {
            if (_rectCache.count() < 50) {
                _rectCache.addElement(aRect);
            }
            return;
        }
    }

    static void returnRects(Vector rects) {
        if (rects == null || !_cacheRects) {
            return;
        }
        int i = rects.count();
        while (i-- > 0) {
            Rect.returnRect((Rect)rects.elementAt(i));
        }
        rects.removeAllElements();
    }

    static void setShouldCacheRects(boolean flag) {
        Vector vector = _rectCache;
        synchronized (vector) {
            _cacheRects = flag;
            if (!_cacheRects) {
                _rectCache.removeAllElements();
            }
            return;
        }
    }
}

