/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Rectangle;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Polygon
implements Codable {
    public int numPoints;
    public int[] xPoints;
    public int[] yPoints;
    java.awt.Polygon awtPolygon;
    static final String XPOINTS = "xPoints";
    static final String YPOINTS = "yPoints";

    public Polygon() {
        this.awtPolygon = new java.awt.Polygon();
        this.update();
    }

    public Polygon(int[] xPoints, int[] yPoints, int numPoints) {
        this.awtPolygon = new java.awt.Polygon(xPoints, yPoints, numPoints);
        this.update();
    }

    public void addPoint(int x, int y) {
        this.awtPolygon.addPoint(x, y);
        this.update();
    }

    public Rect boundingRect() {
        Rectangle box = this.awtPolygon.getBoundingBox();
        Rect rect = new Rect(box.x, box.y, box.width, box.height);
        this.update();
        return rect;
    }

    public boolean containsPoint(int x, int y) {
        boolean contains = this.awtPolygon.inside(x, y);
        this.update();
        return contains;
    }

    public boolean containsPoint(Point aPoint) {
        return this.containsPoint(aPoint.x, aPoint.y);
    }

    public void moveBy(int deltaX, int deltaY) {
        int i = this.awtPolygon.npoints;
        while (i-- > 0) {
            int n = i;
            this.awtPolygon.xpoints[n] = this.awtPolygon.xpoints[n] + deltaX;
            int n2 = i;
            this.awtPolygon.ypoints[n2] = this.awtPolygon.ypoints[n2] + deltaY;
        }
    }

    private void update() {
        this.numPoints = this.awtPolygon.npoints;
        this.xPoints = this.awtPolygon.xpoints;
        this.yPoints = this.awtPolygon.ypoints;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Polygon", 1);
        info.addField(XPOINTS, (byte)9);
        info.addField(YPOINTS, (byte)9);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.numPoints == 0) {
            return;
        }
        encoder.encodeIntArray(XPOINTS, this.xPoints, 0, this.numPoints);
        encoder.encodeIntArray(YPOINTS, this.yPoints, 0, this.numPoints);
    }

    public void decode(Decoder decoder) throws CodingException {
        int[] xs = decoder.decodeIntArray(XPOINTS);
        int[] ys = decoder.decodeIntArray(YPOINTS);
        if (xs == null || xs.length == 0) {
            return;
        }
        this.numPoints = xs.length;
        int i = 0;
        while (i < xs.length) {
            this.addPoint(xs[i], ys[i]);
            ++i;
        }
    }

    public void finishDecoding() throws CodingException {
    }
}

