/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.MenuBar;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.FoundationCheckMenuItem;
import netscape.application.FoundationMenuItem;
import netscape.application.KeyEvent;
import netscape.application.MenuBorder;
import netscape.application.MenuItem;
import netscape.application.MenuView;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Menu
implements Codable {
    java.awt.Menu awtMenu;
    MenuBar awtMenuBar;
    Application application;
    Vector items = new Vector();
    MenuItem superitem;
    MenuItem prototypeItem;
    Border border;
    Color backgroundColor = Color.lightGray;
    boolean transparent = false;
    MenuView menuView;
    static final String ITEMS_KEY = "items";
    static final String SUPERITEM_KEY = "superitem";
    static final String PROTOTYPEITEM_KEY = "prototypeItem";
    static final String BORDER_KEY = "border";
    static final String BACKGROUNDCOLOR_KEY = "backgroundColor";
    static final String TRANSPARENT_KEY = "transparent";

    public Menu() {
        this(true);
    }

    public Menu(boolean isTopLevel) {
        this.setBorder(new MenuBorder(this));
        if (isTopLevel) {
            this.awtMenuBar = new MenuBar();
        } else {
            this.awtMenu = new java.awt.Menu("");
        }
        MenuItem protoItem = new MenuItem();
        this.setPrototypeItem(protoItem);
    }

    boolean isTopLevel() {
        return this.superitem == null || this.superitem.supermenu() == null;
    }

    void setSuperitem(MenuItem item) {
        this.superitem = item;
    }

    MenuItem superitem() {
        return this.superitem;
    }

    public void setPrototypeItem(MenuItem prototype) {
        this.prototypeItem = prototype;
    }

    public MenuItem prototypeItem() {
        return this.prototypeItem;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setBorder(Border aBorder) {
        if (aBorder == null) {
            this.border = EmptyBorder.emptyBorder();
            return;
        }
        this.border = aBorder;
    }

    public Border border() {
        return this.border;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    MenuItem createItem(boolean isCheckbox) {
        MenuItem menuItem = (MenuItem)this.prototypeItem().clone();
        if (!isCheckbox) {
            menuItem.foundationMenuItem = new FoundationMenuItem("", menuItem);
        } else {
            menuItem.foundationMenuItem = new FoundationCheckMenuItem("", menuItem);
            menuItem.setCheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
            menuItem.setUncheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
            menuItem.setImage(menuItem.uncheckedImage());
            menuItem.setSelectedImage(menuItem.uncheckedImage());
        }
        menuItem.setFont(this.prototypeItem().font());
        return menuItem;
    }

    protected Menu createMenuAsSubmenu() {
        Menu menu = new Menu(false);
        menu.setPrototypeItem(this.createItem(false));
        menu.setBackgroundColor(this.backgroundColor());
        return menu;
    }

    public MenuItem addItemWithSubmenu(String title) {
        MenuItem menuItem = this.createItem(false);
        menuItem.setTitle(title);
        Menu menu = this.createMenuAsSubmenu();
        menuItem.setSubmenu(menu);
        this.addItemAt(menuItem, this.itemCount());
        return menuItem;
    }

    public MenuItem addItem(String title, String command, Target target) {
        return this.addItem(title, '\u0000', command, target);
    }

    public MenuItem addItem(String title, String command, Target target, boolean isCheckbox) {
        return this.addItem(title, '\u0000', command, target, isCheckbox);
    }

    public MenuItem addItem(String title, char key, String command, Target target) {
        return this.addItem(title, key, command, target, false);
    }

    public MenuItem addItem(String title, char key, String command, Target target, boolean isCheckbox) {
        return this.addItemAt(title, key, command, target, isCheckbox, this.itemCount());
    }

    public MenuItem addItemAt(String title, char key, String command, Target target, boolean isCheckbox, int index) {
        MenuItem menuItem = this.createItem(isCheckbox);
        menuItem.setSubmenu(null);
        menuItem.setSupermenu(this);
        menuItem.setCommandKey(key);
        menuItem.setTitle(title);
        menuItem.setTarget(target);
        menuItem.setCommand(command);
        this.addItemAt(menuItem, index);
        return menuItem;
    }

    public MenuItem addSeparator() {
        MenuItem menuItem = null;
        menuItem = this.createItem(false);
        menuItem.setSeparator(true);
        this.addItemAt(menuItem, this.itemCount());
        return menuItem;
    }

    public int indexOfItem(MenuItem item) {
        return this.items.indexOf(item);
    }

    public int itemCount() {
        return this.items.count();
    }

    public MenuItem itemAt(int index) {
        return (MenuItem)this.items.elementAt(index);
    }

    public void addItemAt(MenuItem menuItem, int index) {
        menuItem.setSupermenu(this);
        if (menuItem.hasSubmenu()) {
            java.awt.Menu menu = menuItem.submenu().awtMenu();
            menu.setLabel(menuItem.title());
            menu.setFont(AWTCompatibility.awtFontForFont(menuItem.font()));
            if (this.isTopLevel()) {
                if (this.awtMenuBar != null) {
                    this.awtMenuBar.add(menu);
                }
            } else if (this.awtMenu != null) {
                this.awtMenu.add(menu);
            }
        } else if (!this.isTopLevel() && this.awtMenu != null) {
            if (menuItem.isSeparator()) {
                this.awtMenu.addSeparator();
            } else {
                this.awtMenu.add(menuItem.foundationMenuItem());
            }
        }
        this.items.insertElementAt(menuItem, index);
        int i = 0;
        while (i < this.itemCount()) {
            this.itemAt(i).setTitle(this.itemAt(i).title());
            ++i;
        }
    }

    public void removeItem(MenuItem menuItem) {
        this.items.removeElement(menuItem);
        if (this.isTopLevel()) {
            this.awtMenuBar.remove(menuItem.foundationMenuItem());
            return;
        }
        this.awtMenu.remove(menuItem.foundationMenuItem());
    }

    public void removeItemAt(int index) {
        this.items.removeElementAt(index);
        if (this.isTopLevel()) {
            this.awtMenuBar.remove(index);
            return;
        }
        this.awtMenu.remove(index);
    }

    public void replaceItemAt(int index, MenuItem menuItem) {
        this.items.replaceElementAt(index, menuItem);
    }

    public void replaceItem(MenuItem item, MenuItem newItem) {
        int i = this.indexOfItem(item);
        if (i != -1) {
            this.replaceItemAt(i, newItem);
        }
    }

    public void performCommand(String command, Object data) {
        if (data != null) {
            MenuItem item;
            item.setState(!(item = (MenuItem)data).state());
            item.sendCommand();
        }
    }

    int minItemWidth() {
        int maxWidth = 0;
        int i = 0;
        while (i < this.itemCount()) {
            int width = this.itemAt(i).minWidth();
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++i;
        }
        return maxWidth;
    }

    public boolean handleCommandKeyEvent(KeyEvent event) {
        boolean eventHandled = false;
        if (!event.isControlKeyDown()) {
            return false;
        }
        MenuItem item = this.itemForKeyEvent(event);
        if (item != null) {
            item.sendCommand();
            eventHandled = true;
        }
        return eventHandled;
    }

    MenuItem itemForKeyEvent(KeyEvent event) {
        MenuItem menuItem = null;
        if (!event.isControlKeyDown()) {
            return null;
        }
        int i = 0;
        while (i < this.itemCount() && menuItem == null) {
            MenuItem item = this.itemAt(i);
            if (item.isEnabled()) {
                if (item.hasSubmenu()) {
                    menuItem = item.submenu().itemForKeyEvent(event);
                } else if (item.commandKey() == event.key + 64) {
                    menuItem = item;
                }
            }
            ++i;
        }
        return menuItem;
    }

    java.awt.Menu awtMenu() {
        return this.awtMenu;
    }

    MenuBar awtMenuBar() {
        return this.awtMenuBar;
    }

    void setApplication(Application app) {
        this.application = app;
    }

    Application application() {
        return this.application;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Menu", 1);
        info.addField(ITEMS_KEY, (byte)18);
        info.addField(SUPERITEM_KEY, (byte)18);
        info.addField(PROTOTYPEITEM_KEY, (byte)18);
        info.addField(BORDER_KEY, (byte)18);
        info.addField(BACKGROUNDCOLOR_KEY, (byte)18);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(ITEMS_KEY, this.items);
        encoder.encodeObject(SUPERITEM_KEY, this.superitem);
        encoder.encodeObject(PROTOTYPEITEM_KEY, this.prototypeItem);
        encoder.encodeObject(BORDER_KEY, this.border);
        encoder.encodeObject(BACKGROUNDCOLOR_KEY, this.backgroundColor);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.items = (Vector)decoder.decodeObject(ITEMS_KEY);
        this.superitem = (MenuItem)decoder.decodeObject(SUPERITEM_KEY);
        this.prototypeItem = (MenuItem)decoder.decodeObject(PROTOTYPEITEM_KEY);
        this.border = (Border)decoder.decodeObject(BORDER_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDCOLOR_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

