/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import netscape.application.AWTCompatibility;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DebugGraphicsColorFilter;
import netscape.application.DebugGraphicsInfo;
import netscape.application.ExternalWindow;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.GraphicsState;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.View;

public class DebugGraphics
extends Graphics {
    static ExternalWindow debugWindow;
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;

    public DebugGraphics(View view) {
        super(view);
        this.setDebugOptions(view.shouldDebugGraphics());
    }

    public DebugGraphics(Bitmap aBitmap) {
        super(aBitmap);
    }

    public static void setFlashColor(Color flashColor) {
        DebugGraphics.info().flashColor = flashColor;
    }

    public static Color flashColor() {
        return DebugGraphics.info().flashColor;
    }

    public static void setFlashTime(int flashTime) {
        DebugGraphics.info().flashTime = flashTime;
    }

    public static int flashTime() {
        return DebugGraphics.info().flashTime;
    }

    public static void setFlashCount(int flashCount) {
        DebugGraphics.info().flashCount = flashCount;
    }

    public static int flashCount() {
        return DebugGraphics.info().flashCount;
    }

    public static void setLogStream(PrintStream stream) {
        DebugGraphics.info().stream = stream;
    }

    public static PrintStream logStream() {
        return DebugGraphics.info().stream;
    }

    public void pushState() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " -> state");
        }
        super.pushState();
    }

    public void popState() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " <- state");
        }
        super.popState();
    }

    public void setFont(Font aFont) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting font: " + aFont);
        }
        super.setFont(aFont);
    }

    public void setColor(Color aColor) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting color: " + aColor);
        }
        super.setColor(aColor);
    }

    public void translate(int x, int y) {
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Translating by: " + new Point(x, y) + " to: " + new Point(x + state.xOffset, y + state.yOffset));
        }
        super.translate(x, y);
    }

    public void setClipRect(Rect rect, boolean intersect) {
        this.state();
        super.setClipRect(rect, intersect);
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting clipRect: " + rect + " New clipRect: " + this.clipRect());
        }
    }

    public void setPaintMode() {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting paint mode");
        }
        super.setPaintMode();
    }

    public void setXORMode(Color aColor) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting XOR mode: " + aColor);
        }
        super.setXORMode(aColor);
    }

    public void drawRect(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rect: " + new Rect(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawRect(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawRect(x, y, width, height);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling rect: " + new Rect(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillRect(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.fillRect(x, y, width, height);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.fillRect(x, y, width, height);
    }

    public void drawRoundedRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rounded rect: " + new Rect(x, y, width, height) + " arcWidth: " + arcWidth + " archHeight: " + arcHeight);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawRoundedRect(x, y, width, height, arcWidth, arcHeight);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawRoundedRect(x, y, width, height, arcWidth, arcHeight);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawRoundedRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundedRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rounded rect: " + new Rect(x, y, width, height) + " arcWidth: " + arcWidth + " archHeight: " + arcHeight);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillRoundedRect(x, y, width, height, arcWidth, arcHeight);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.fillRoundedRect(x, y, width, height, arcWidth, arcHeight);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.fillRoundedRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing line: " + new Rect(x1, y1, x2, y2));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawLine(x1, y1, x2, y2);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawLine(x1, y1, x2, y2);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawLine(x1, y1, x2, y2);
    }

    public void drawPoint(int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing point: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawLine(x, y, x, y);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawLine(x, y, x, y);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawLine(x, y, x, y);
    }

    public void drawOval(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing oval: " + new Rect(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawOval(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawOval(x, y, width, height);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling oval: " + new Rect(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillOval(x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.fillOval(x, y, width, height);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.fillOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing arc: " + new Rect(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawArc(x, y, width, height, startAngle, arcAngle);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling arc: " + new Rect(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.fillArc(x, y, width, height, startAngle, arcAngle);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing polygon: " + " nPoints: " + nPoints + " X's: " + xPoints + " Y's: " + yPoints);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawPolygon(xPoints, yPoints, nPoints);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.drawPolygon(xPoints, yPoints, nPoints);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling polygon: " + " nPoints: " + nPoints + " X's: " + xPoints + " Y's: " + yPoints);
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.fillPolygon(xPoints, yPoints, nPoints);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            Color oldColor = state.color;
            int count = info.flashCount * 2 - 1;
            int i = 0;
            while (i < count) {
                super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                super.fillPolygon(xPoints, yPoints, nPoints);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
            super.setColor(oldColor);
        }
        super.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void drawBitmapAt(Bitmap bitmap, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing bitmap: " + bitmap + " at: " + new Point(x, y));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawBitmapAt(bitmap, x, y);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = AWTCompatibility.awtImageProducerForBitmap(bitmap);
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsColorFilter(info.flashColor));
            Bitmap newBitmap = AWTCompatibility.bitmapForAWTImageProducer(newProducer);
            int i = 0;
            while (i < count) {
                super.drawBitmapAt(i % 2 == 0 ? newBitmap : bitmap, x, y);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
        }
        super.drawBitmapAt(bitmap, x, y);
    }

    public void drawBitmapScaled(Bitmap bitmap, int x, int y, int width, int height) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (state.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing scaled bitmap: " + bitmap + " in rect: " + new Rect(x, y, width, height));
        }
        if (this.isDrawingBuffer()) {
            if (state.debugBuffered()) {
                Graphics debugGraphics = this.debugGraphics();
                debugGraphics.drawBitmapScaled(bitmap, x, y, width, height);
                debugGraphics.dispose();
            }
        } else if (state.debugFlash()) {
            int count = info.flashCount * 2 - 1;
            ImageProducer oldProducer = AWTCompatibility.awtImageProducerForBitmap(bitmap);
            FilteredImageSource newProducer = new FilteredImageSource(oldProducer, new DebugGraphicsColorFilter(info.flashColor));
            Bitmap newBitmap = AWTCompatibility.bitmapForAWTImageProducer(newProducer);
            int i = 0;
            while (i < count) {
                super.drawBitmapScaled(i % 2 == 0 ? newBitmap : bitmap, x, y, width, height);
                AWTCompatibility.awtToolkit().sync();
                this.sleep(info.flashTime);
                ++i;
            }
        }
        super.drawBitmapScaled(bitmap, x, y, width, height);
    }

    public void drawString(String aString, int x, int y) {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (!(state.debugOptions == 0 || state.font != null && state.font.wasDownloaded())) {
            if (state.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing string: \"" + aString + "\" at: " + new Point(x, y));
            }
            if (this.isDrawingBuffer()) {
                if (state.debugBuffered()) {
                    Graphics debugGraphics = this.debugGraphics();
                    debugGraphics.drawString(aString, x, y);
                    debugGraphics.dispose();
                }
            } else if (state.debugFlash()) {
                Color oldColor = state.color;
                int count = info.flashCount * 2 - 1;
                int i = 0;
                while (i < count) {
                    super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                    super.drawString(aString, x, y);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(info.flashTime);
                    ++i;
                }
                super.setColor(oldColor);
            }
        }
        super.drawString(aString, x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        Font font;
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (!(state.debugOptions == 0 || (font = this.font()) != null && font.wasDownloaded())) {
            if (state.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing bytes at: " + new Point(x, y));
            }
            if (this.isDrawingBuffer()) {
                if (state.debugBuffered()) {
                    Graphics debugGraphics = this.debugGraphics();
                    debugGraphics.drawBytes(data, offset, length, x, y);
                    debugGraphics.dispose();
                }
            } else if (state.debugFlash()) {
                Color oldColor = state.color;
                int count = info.flashCount * 2 - 1;
                int i = 0;
                while (i < count) {
                    super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                    super.drawBytes(data, offset, length, x, y);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(info.flashTime);
                    ++i;
                }
                super.setColor(oldColor);
            }
        }
        super.drawBytes(data, offset, length, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        Font font;
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (!(state.debugOptions == 0 || (font = this.font()) != null && font.wasDownloaded())) {
            if (state.debugLog()) {
                DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing chars at " + new Point(x, y));
            }
            if (this.isDrawingBuffer()) {
                if (state.debugBuffered()) {
                    Graphics debugGraphics = this.debugGraphics();
                    debugGraphics.drawChars(data, offset, length, x, y);
                    debugGraphics.dispose();
                }
            } else if (state.debugFlash()) {
                Color oldColor = state.color;
                int count = info.flashCount * 2 - 1;
                int i = 0;
                while (i < count) {
                    super.setColor(i % 2 == 0 ? info.flashColor : oldColor);
                    super.drawChars(data, offset, length, x, y);
                    AWTCompatibility.awtToolkit().sync();
                    this.sleep(info.flashTime);
                    ++i;
                }
                super.setColor(oldColor);
            }
        }
        super.drawChars(data, offset, length, x, y);
    }

    void copyArea(int x, int y, int width, int height, int destX, int destY) {
        if (this.state().debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Copying area from: " + new Rect(x, y, width, height) + " to: " + new Point(destX, destY));
        }
        super.copyArea(x, y, width, height, destX, destY);
    }

    final void sleep(int mSecs) {
        try {
            Thread.sleep(mSecs);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setDebugOptions(int debugOptions) {
        if (debugOptions != 0) {
            GraphicsState state = this.state();
            if (debugOptions == -1) {
                if (state.debugOptions != 0) {
                    System.err.println(String.valueOf(this.toShortString()) + " Disabling debug");
                    state.debugOptions = 0;
                    return;
                }
            } else if (state.debugOptions != debugOptions) {
                state.debugOptions |= debugOptions;
                if (state.debugLog()) {
                    System.err.println(String.valueOf(this.toShortString()) + " Enabling debug");
                }
            }
        }
    }

    public int debugOptions() {
        return this.state().debugOptions;
    }

    void setDebug(View view) {
        this.setDebugOptions(Graphics.viewDebug(view));
    }

    public int debug() {
        return this.state().debugOptions;
    }

    private Graphics debugGraphics() {
        DebugGraphicsInfo info = DebugGraphics.info();
        GraphicsState state = this.state();
        if (info.debugWindow == null) {
            info.debugWindow = new ExternalWindow();
            info.debugWindow.setResizable(false);
        }
        ExternalWindow debugWindow = info.debugWindow;
        Size windowSize = debugWindow.windowSizeForContentSize(this.primaryClipRect.width, this.primaryClipRect.height);
        Rect windowBounds = debugWindow.bounds();
        if (windowBounds.width > windowSize.width) {
            windowSize.width = windowBounds.width;
        }
        if (windowBounds.height > windowSize.height) {
            windowSize.height = windowBounds.height;
        }
        debugWindow.sizeTo(windowSize.width, windowSize.height);
        debugWindow.show();
        DebugGraphics debugGraphics = new DebugGraphics(debugWindow.rootView());
        ((Graphics)debugGraphics).setFont(state.font);
        ((Graphics)debugGraphics).setColor(state.color);
        ((Graphics)debugGraphics).translate(state.xOffset, state.yOffset);
        debugGraphics.setClipRect(this.clipRect());
        if (state.debugFlash()) {
            ((Graphics)debugGraphics).setDebugOptions(2);
        }
        return debugGraphics;
    }

    static DebugGraphicsInfo info() {
        return Graphics.info();
    }
}

