/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Container;
import java.awt.Frame;
import java.awt.MediaTracker;
import java.io.InputStream;
import java.net.URL;
import netscape.application.AppletResources;
import netscape.application.ApplicationEvent;
import netscape.application.ApplicationObserver;
import netscape.application.Bitmap;
import netscape.application.Clipboard;
import netscape.application.CommandEvent;
import netscape.application.CommandFilter;
import netscape.application.DebugGraphicsInfo;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.EventProcessor;
import netscape.application.ExternalWindow;
import netscape.application.FoundationApplet;
import netscape.application.FoundationAppletStub;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.KeyboardArrow;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Target;
import netscape.application.TextBag;
import netscape.application.TimerQueue;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Application
implements Runnable,
EventProcessor {
    static Hashtable groupToApplication = new Hashtable();
    static final String _releaseName = "IFC 1.1.1";
    static Clipboard clipboard;
    static Object clipboardLock;
    Applet applet;
    AppletResources _appResources;
    EventLoop eventLoop = new EventLoop();
    Vector _languageVector;
    Vector rootViews = new Vector();
    RootView mainRootView;
    boolean didCreateApplet;
    Vector _modalVector = new Vector();
    Vector observers = new Vector();
    Vector activeMenuViews = new Vector();
    boolean jdkMouseEventHackEnabled = true;
    MediaTracker tracker;
    int bitmapCount;
    Hashtable bitmapByName = new Hashtable();
    Hashtable soundByName = new Hashtable();
    Hashtable fontByName = new Hashtable();
    DebugGraphicsInfo debugGraphicsInfo;
    TimerQueue timerQueue;
    Object cleanupLock;
    boolean isPaused;
    boolean _kbdUIEnabled = true;
    Window currentDocumentWindow;
    KeyboardArrow keyboardArrow;
    public static final int TOP_LEFT_POSITION = 0;
    public static final int BOTTOM_LEFT_POSITION = 1;
    public static final int TOP_RIGHT_POSITION = 2;
    public static final int BOTTOM_RIGHT_POSITION = 3;
    static final int FIRST_POSITION = 0;
    static final int LAST_POSITION = 3;
    static final int arrowXOffset = 0;
    static final int arrowYOffset = 0;

    public Application() {
        groupToApplication.put(Thread.currentThread().getThreadGroup(), this);
        FoundationApplet ifcApplet = FoundationApplet.applet();
        if (ifcApplet == null) {
            ifcApplet = this.createApplet();
            ifcApplet.setApplication(this);
            this.didCreateApplet = true;
        } else {
            this.isPaused = true;
            ifcApplet.setupCanvas(this);
        }
        this.applet = ifcApplet;
        this._appResources = new AppletResources(this, this.codeBase());
        this.timerQueue = new TimerQueue();
        this.eventLoop.application = this;
    }

    public static String releaseName() {
        return _releaseName;
    }

    public Application(Applet applet) {
        groupToApplication.put(Thread.currentThread().getThreadGroup(), this);
        this.applet = applet;
        this._appResources = new AppletResources(this, this.codeBase());
        this.timerQueue = new TimerQueue();
        this.appletStarted();
        this.eventLoop.application = this;
    }

    public static Application application() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        Application app = (Application)groupToApplication.get(group);
        if (app == null) {
            app = FoundationApplet.currentApplication();
        }
        return app;
    }

    public void init() {
    }

    public void cleanup() {
        Enumeration groups = groupToApplication.keys();
        this.applicationDidStop();
        if (this.applet instanceof FoundationApplet) {
            ((FoundationApplet)this.applet).cleanup();
        }
        if (this.didCreateApplet) {
            ((FoundationApplet)this.applet).destroyFromIFC();
            if (this.applet.getParent() != null) {
                this.applet.getParent().remove(this.applet);
            }
        }
        while (groups.hasMoreElements()) {
            ThreadGroup group = (ThreadGroup)groups.nextElement();
            Application app = (Application)groupToApplication.get(group);
            if (app != this) continue;
            groupToApplication.remove(group);
            break;
        }
        this.timerQueue = null;
        this.observers.removeAllElements();
        this.eventLoop.application = null;
    }

    public void stopRunning() {
        this.eventLoop.stopRunning();
    }

    void stopRunningForAWT() {
        Object object = this.cleanupLock;
        synchronized (object) {
            this.eventLoop.stopRunning();
            while (true) {
                try {
                    this.cleanupLock.wait();
                    Object var2_2 = null;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public void run() {
        this.cleanupLock = new Object();
        this.applicationDidStart();
        this.init();
        this.eventLoop.run();
        this.cleanup();
        Object object = this.cleanupLock;
        synchronized (object) {
            this.cleanupLock.notify();
            return;
        }
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    Vector languagePreferences() {
        if (this._languageVector == null) {
            this._languageVector = new Vector();
        }
        return this._languageVector;
    }

    void syncGraphics() {
    }

    InputStream streamForInterface(String interfaceName) {
        return this._appResources.streamForInterface(interfaceName);
    }

    InputStream streamForResourceOfType(String resourceName, String type) {
        return this._appResources.streamForResourceOfType(resourceName, type);
    }

    public boolean isApplet() {
        return !this.didCreateApplet;
    }

    InputStream streamForRelativePath(String relativePath) {
        InputStream inputStream;
        URL documentURL;
        try {
            documentURL = new URL(this.codeBase(), relativePath);
        }
        catch (Exception e) {
            System.err.println("Application.streamForRelativePath() - " + e);
            documentURL = null;
        }
        if (documentURL == null) {
            return null;
        }
        try {
            inputStream = documentURL.openStream();
        }
        catch (Exception e) {
            System.err.println("Application.streamForURL() - Trouble retrieving URL " + documentURL + " : " + e);
            inputStream = null;
        }
        return inputStream;
    }

    AppletContext getAppletContext() {
        if (this.applet == null) {
            return null;
        }
        return this.applet.getAppletContext();
    }

    public URL codeBase() {
        return this.applet.getCodeBase();
    }

    public String parameterNamed(String name) {
        if (this.applet == null) {
            return null;
        }
        return this.applet.getParameter(name);
    }

    public RootView mainRootView() {
        return this.mainRootView;
    }

    public void setMainRootView(RootView view) {
        this.addRootView(view);
        this.mainRootView = view;
    }

    RootView firstRootView() {
        return (RootView)this.rootViews.lastElement();
    }

    public Vector rootViews() {
        return this.rootViews;
    }

    public Vector externalWindows() {
        int count = this.rootViews.count();
        Vector windows = new Vector();
        int i = 0;
        while (i < count) {
            RootView rootView = (RootView)this.rootViews.elementAt(i);
            ExternalWindow window = rootView.externalWindow();
            if (window != null) {
                windows.addElement(window);
            }
            ++i;
        }
        return windows;
    }

    void addRootView(RootView view) {
        if (!this.rootViews.contains(view)) {
            this.rootViews.insertElementAt(view, 0);
            view.setApplication(this);
        }
    }

    void removeRootView(RootView view) {
        this.rootViews.removeElement(view);
        view.setApplication(null);
        if (this.rootViews.count() > 0) {
            ((RootView)this.rootViews.lastElement()).didBecomeFirstRootView();
        }
    }

    void makeFirstRootView(RootView view) {
        if (this.rootViews.indexOf(view) == -1) {
            return;
        }
        if (this.rootViews.lastElement() != view) {
            RootView wasFirstRootView = (RootView)this.rootViews.lastElement();
            this.rootViews.removeElement(view);
            this.rootViews.addElement(view);
            if (wasFirstRootView != null) {
                wasFirstRootView.didResignFirstRootView();
            }
            view.didBecomeFirstRootView();
        }
    }

    Frame frame() {
        Container comp = this.applet;
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        if (comp != null) {
            return (Frame)comp;
        }
        return null;
    }

    synchronized MediaTracker mediaTracker() {
        if (this.tracker == null) {
            this.tracker = new MediaTracker(this.applet);
        }
        return this.tracker;
    }

    synchronized int nextBitmapNumber() {
        return this.bitmapCount++;
    }

    synchronized TimerQueue timerQueue() {
        return this.timerQueue;
    }

    void addActiveMenuView(MenuView menuView) {
        this.activeMenuViews.addElementIfAbsent(menuView);
    }

    void removeActiveMenuView(MenuView menuView) {
        this.activeMenuViews.removeElement(menuView);
    }

    public void willProcessEvent(Event anEvent) {
    }

    void willProcessInternalEvent(Event anEvent) {
        if (this.activeMenuViews.count() == 0 || anEvent.type() != -1) {
            return;
        }
        MenuView menuView = (MenuView)this.activeMenuViews.lastElement();
        menuView.mouseWillDown((MouseEvent)anEvent);
    }

    public void didProcessEvent(Event anEvent) {
    }

    void didProcessInternalEvent(Event anEvent) {
        this.drawAllDirtyViews();
    }

    protected void drawAllDirtyViews() {
        int count = this.rootViews.count();
        int i = 0;
        while (i < count) {
            RootView rView = (RootView)this.rootViews.elementAt(i);
            rView.drawDirtyViews();
            rView._updateCursorAndMoveView();
            ++i;
        }
    }

    boolean isMac() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Mac");
    }

    public void keyDown(KeyEvent event) {
        boolean processed = false;
        RootView frv = this.firstRootView();
        if (frv != null) {
            processed = frv.processKeyboardEvent(event, false);
        }
    }

    public void keyUp(KeyEvent event) {
    }

    protected void beginModalSessionForView(View aView) {
        if (aView == null) {
            throw new InconsistencyException("beginModalSessionForView called with null view");
        }
        this._modalVector.addElement(aView);
        RootView rootView = aView.rootView();
        if (rootView != null) {
            rootView.updateCursor();
        }
    }

    protected void endModalSessionForView(View aView) {
        if (aView != this._modalVector.lastElement()) {
            throw new InconsistencyException("endModalSessionForView called for a view that is not the last modal view");
        }
        this._modalVector.removeLastElement();
        RootView rootView = aView.rootView();
        if (rootView != null) {
            rootView.updateCursor();
            rootView.validateSelectedView();
        }
    }

    public View modalView() {
        if (this._modalVector.count() > 0) {
            return (View)this._modalVector.lastElement();
        }
        return null;
    }

    boolean isModalViewShowing() {
        return this._modalVector.count() != 0;
    }

    public void performCommandAndWait(Target target, String command, Object data) {
        CommandEvent commandEvent = new CommandEvent(target, command, data);
        this.eventLoop.addEventAndWait(commandEvent);
    }

    public void performCommandLater(Target target, String command, Object data, boolean ignorePrevious) {
        CommandEvent commandEvent = new CommandEvent(target, command, data);
        if (ignorePrevious) {
            this.eventLoop.filterEvents(new CommandFilter(commandEvent.target, commandEvent.command, data));
        }
        this.eventLoop.addEvent(commandEvent);
    }

    public void performCommandLater(Target target, String command, Object data) {
        this.performCommandLater(target, command, data, false);
    }

    protected FoundationApplet createApplet() {
        Frame awtFrame = new Frame();
        FoundationApplet applet = new FoundationApplet();
        awtFrame.add(applet);
        awtFrame.addNotify();
        applet.addNotify();
        applet.setStub(new FoundationAppletStub());
        return applet;
    }

    String exceptionHeader() {
        return "Uncaught exception.  IFC release: IFC 1.1.1";
    }

    public void addObserver(ApplicationObserver observer) {
        this.observers.addElementIfAbsent(observer);
    }

    public void removeObserver(ApplicationObserver observer) {
        this.observers.removeElement(observer);
    }

    public void appletStarted() {
        int i = this.observers.count();
        this.isPaused = false;
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            observer.applicationDidResume(this);
        }
        i = this.rootViews.count();
        while (i-- > 0) {
            RootView rootView = (RootView)this.rootViews.elementAt(i);
            if (rootView.externalWindow() != null) continue;
            rootView.setVisible(true);
        }
    }

    public void appletStopped() {
        int i = this.observers.count();
        this.isPaused = true;
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            observer.applicationDidPause(this);
        }
        i = this.rootViews.count();
        while (i-- > 0) {
            RootView rootView = (RootView)this.rootViews.elementAt(i);
            if (rootView.externalWindow() != null) continue;
            rootView.setVisible(false);
        }
    }

    void applicationDidStart() {
        int i = this.observers.count();
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            observer.applicationDidStart(this);
        }
    }

    void applicationDidStop() {
        int i = this.observers.count();
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            observer.applicationDidStop(this);
        }
    }

    public void processEvent(Event event) {
        if (event instanceof ApplicationEvent) {
            if (event.type == -26) {
                this.appletStopped();
                return;
            }
            if (event.type == -27) {
                this.appletStarted();
            }
        }
    }

    public boolean isRunning() {
        return this.eventLoop.isRunning();
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    static Clipboard clipboard() {
        Object object = clipboardLock;
        synchronized (object) {
            if (clipboard == null && (clipboard = JDK11AirLock.clipboard()) == null) {
                clipboard = new TextBag();
            }
            Clipboard clipboard = Application.clipboard;
            Object var2_2 = null;
            return clipboard;
        }
    }

    public void makeCurrentDocumentWindow(Window aWindow) {
        if (aWindow != null && !aWindow.containsDocument()) {
            throw new InconsistencyException("makeCurrentDocumentWindow: window is not a document");
        }
        if (this.currentDocumentWindow != null) {
            this.currentDocumentWindow.didResignCurrentDocument();
            this.currentDocumentWindow = null;
        }
        if (aWindow != null) {
            this.currentDocumentWindow = aWindow;
            this.currentDocumentWindow.didBecomeCurrentDocument();
        }
        int i = this.observers.count();
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            try {
                observer.currentDocumentDidChange(this, this.currentDocumentWindow);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        }
    }

    public Window currentDocumentWindow() {
        return this.currentDocumentWindow;
    }

    public void chooseNextCurrentDocumentWindow(Window aWindow) {
        Window nextWindow = null;
        if (aWindow == null || aWindow instanceof ExternalWindow) {
            nextWindow = this._chooseNextExternalWindowWithDocument((ExternalWindow)aWindow);
            if (nextWindow == null && this.mainRootView() != null) {
                nextWindow = this._chooseNextInternalWindowWithDocument(this.mainRootView(), null);
            }
        } else if (((InternalWindow)aWindow).rootView() != null) {
            nextWindow = this._chooseNextInternalWindowWithDocument(((InternalWindow)aWindow).rootView(), (InternalWindow)aWindow);
        }
        this.makeCurrentDocumentWindow(nextWindow);
    }

    Window _chooseNextInternalWindowWithDocument(RootView aRootView, InternalWindow win) {
        Vector vector = aRootView.internalWindows();
        int i = vector.count() - 1;
        while (i >= 0) {
            InternalWindow w = (InternalWindow)vector.elementAt(i);
            if (w != win && w.containsDocument()) {
                return w;
            }
            --i;
        }
        return null;
    }

    Window _chooseNextExternalWindowWithDocument(ExternalWindow win) {
        Vector vector = this.externalWindows();
        int i = vector.count() - 1;
        while (i >= 0) {
            ExternalWindow w = (ExternalWindow)vector.elementAt(i);
            if (w != win && w.containsDocument()) {
                return w;
            }
            --i;
        }
        return null;
    }

    void focusChanged(View newFocusedView) {
        int i = this.observers.count();
        while (i-- > 0) {
            ApplicationObserver observer = (ApplicationObserver)this.observers.elementAt(i);
            try {
                observer.focusDidChange(this, newFocusedView);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {}
        }
    }

    KeyboardArrow keyboardArrow() {
        if (this.keyboardArrow == null) {
            this.keyboardArrow = new KeyboardArrow();
        }
        return this.keyboardArrow;
    }

    public int keyboardArrowPosition(View aView) {
        RootView rv = aView.rootView();
        Rect rvBounds = rv.localBounds();
        Point extr = new Point();
        Rect vBounds = new Rect();
        aView.computeVisibleRect(vBounds);
        vBounds.intersectWith(aView.keyboardRect());
        aView.convertRectToView(rv, vBounds, vBounds);
        int i = 0;
        while (i <= 3) {
            Image image = this.keyboardArrowImage(i);
            Point hotSpot = this.keyboardArrowHotSpot(i);
            extr = this.keyboardArrowLocation(aView, i);
            extr.x -= hotSpot.x;
            extr.y -= hotSpot.y;
            if (rvBounds.contains(new Rect(extr.x, extr.y, image.width(), image.height()))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Image keyboardArrowImage(int position) {
        switch (position) {
            case 0: {
                return Bitmap.bitmapNamed("netscape/application/topLeftArrow.gif");
            }
            case 2: {
                return Bitmap.bitmapNamed("netscape/application/topRightArrow.gif");
            }
            case 3: {
                return Bitmap.bitmapNamed("netscape/application/bottomRightArrow.gif");
            }
            case 1: {
                return Bitmap.bitmapNamed("netscape/application/bottomLeftArrow.gif");
            }
        }
        return null;
    }

    public Point keyboardArrowHotSpot(int position) {
        switch (position) {
            case 0: {
                return new Point(8, 12);
            }
            case 2: {
                return new Point(0, 12);
            }
            case 3: {
                return new Point(0, 0);
            }
            case 1: {
                return new Point(8, 0);
            }
        }
        return null;
    }

    public Point keyboardArrowLocation(View aView, int position) {
        RootView rv = aView.rootView();
        rv.localBounds();
        Rect b = aView.localBounds();
        b = new Rect();
        aView.computeVisibleRect(b);
        b.intersectWith(aView.keyboardRect());
        if (b.width == 0 || b.height == 0) {
            return new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        aView.convertRectToView(aView.rootView(), b, b);
        switch (position) {
            case 0: {
                return new Point(b.x, b.y);
            }
            case 2: {
                return new Point(b.x + b.width, b.y);
            }
            case 1: {
                return new Point(b.x, b.y + b.height);
            }
            case 3: {
                return new Point(b.x + b.width, b.y + b.height);
            }
        }
        throw new InconsistencyException("Unknown position " + position);
    }

    public void setKeyboardUIEnabled(boolean aFlag) {
        this._kbdUIEnabled = aFlag;
    }

    public boolean isKeyboardUIEnabled() {
        return this._kbdUIEnabled;
    }

    public Applet applet() {
        return this.applet;
    }

    public AppletResources appletResources() {
        return this._appResources;
    }

    public static String clipboardText() {
        return Application.clipboard().text();
    }

    public static void setClipboardText(String text) {
        Application.clipboard().setText(text);
    }

    public void setHandleJDK11MouseEvents(boolean b) {
        this.jdkMouseEventHackEnabled = b;
    }

    public boolean handleJDK11MouseEvents() {
        return this.jdkMouseEventHackEnabled;
    }

    static {
        clipboardLock = new Object();
    }
}

