/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import netscape.javascript.JSObject;
import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocumentReader;
import netscape.plugin.composer.ComposerDocumentWriter;
import netscape.plugin.composer.Document;
import netscape.plugin.composer.PluginManager;

class ComposerDocument
extends Document {
    private Composer composer;
    private String workDirectory;
    private String text;
    private URL base;
    private URL workDirectoryURL;
    private String eventName;
    private URL documentURL;
    private ComposerDocumentReader in;
    private ComposerDocumentWriter out;
    private PluginManager manager;
    private JSObject jsobject;

    public ComposerDocument(Composer composer, String document, URL base, String workDirectory, URL workDirectoryURL, String eventName, URL documentURL, JSObject jsobject) {
        this.composer = composer;
        this.text = document;
        this.workDirectory = workDirectory;
        this.base = base;
        this.workDirectoryURL = workDirectoryURL;
        this.eventName = eventName;
        this.documentURL = documentURL;
        this.jsobject = jsobject;
    }

    public URL getBase() {
        return this.base;
    }

    public File getWorkDirectory() {
        return new File(this.workDirectory);
    }

    public URL getWorkDirectoryURL() {
        return this.workDirectoryURL;
    }

    public Reader getInput() throws IOException {
        if (this.in != null) {
            throw new IOException("Must close existing input stream first.");
        }
        this.in = new ComposerDocumentReader(this, this.text.toCharArray());
        return this.in;
    }

    public Writer getOutput() throws IOException {
        this.doOutputCheck();
        this.out = new ComposerDocumentWriter(this);
        return this.out;
    }

    private void doOutputCheck() throws IOException {
        if (this.out != null) {
            throw new IOException("Must close existing output stream first.");
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) throws IOException {
        this.doOutputCheck();
        this.text = text;
        this.composer.newText(text);
    }

    void inputDone(ComposerDocumentReader in) {
        if (in == this.in) {
            this.in = null;
        }
    }

    void outputDone(ComposerDocumentWriter out, String text) {
        if (out == this.out) {
            this.out = null;
            try {
                this.setText(text);
                return;
            }
            catch (IOException e) {
                System.err.println("Couldn't set text.");
                e.printStackTrace();
                return;
            }
        }
    }

    public URL getDocumentURL() {
        return this.documentURL;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void redirectDocumentOpen(String newURL) {
        if (this.eventName.equals("edit")) {
            this.composer.newText(newURL);
        }
    }

    public JSObject getJSObject() {
        return this.jsobject;
    }

    Composer getComposer() {
        return this.composer;
    }
}

