/*                                         W3C Reference Library libwww Access Authentication
                              ACCESS AUTHENTICATION MANAGER
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   The _Authentication Manager_ is a registry for _Authentication Schemes_ that follow the
   generic syntax defined by the HTTP WWW-authenticateand Authorizationheaders. Currently,
   the only scheme defined is _Basic Authentication_, but _Digest Authentication _will
   soon follow. All _Authentication Schemes_ are registered at run-time in form of an
   _Authentication Module_. An _Authentication Module_ consists of the following:
   
  _scheme_               The name which is used to identify the scheme. This is equivalent
                         to the <scheme>part of the WWW-authenticateHTTP header, for
                         example "basic"
                         
  _BEFORE Filter_        When a new request is issued, the _Authentication Manage_r looks
                         in the URL tree to see if we have any access authentication
                         information for this particular request. The search is based on
                         the realm (if known) in which the request belongs and the URL
                         itself. If a record is found then the _Authentication Manager_
                         calls the _Authentication Module_ in order to generate the
                         credentials.
                         
  _AFTER Filter_         After a request has terminated and the result was lack of
                         credentials, the request should normally be repeated with a new
                         set of credentials. The AFTER filter is responsible for
                         extracting the challenge from the HTTP response and store it in
                         the URL tree, so that we next time we request the same URL we
                         know that it is protected and we can ask the user for the
                         appropriate credentials (user name and password, for example).
                         
  _garbage collection_   The authentication information is stored in a URL Tree but as it
                         doesn't know the format of the scheme specific parts, you must
                         register a garbage collector (gc). The gc is called when node is
                         deleted in the tree.
                         
   _Note: _The _Authentication Manager_ itself consists of _BEFORE_ and an _AFTER_ filter
   - just like the _Authentication Modules_. This means that any _Authentication Module_
   also can be registered directly as a _BEFORE_ and _AFTER_ filter by the Net Manager.
   The reason for having the two layer model is that the _Authentication Manager_
   maintains a single URL tree for storing access information for all _Authentication
   Schemes_.
   
   An _Authentication Module_ has three resources, it can use when creating challenges or
   credentials:
   
      Handle the _credentials_ which is a part of the Request obejct. The credentials are
      often generated by asking the user for a user name ansd a password.
      
      Handle the _challenges_ which is a part of the Request object. The MIME parser will
      normally find the credentials as we parse the HTTP response.
      
      Add information to the URL Tree
      
   This module is implemented by HTAAUtil.c, and it is a part of the W3C Reference
   Library.
   
 */
#ifndef HTAAUTIL_H
#define HTAAUTIL_H
#include "HTReq.h"
#include "HTNet.h"
#include "HTUTree.h"
/*

AUTHENTICATION SCHEME REGISTRATION

   An _Authentication Scheme_ is registered by registering an _Authentication Module_ to
   in the _Authentication Manager_.
   
  Add an Authentication Module
  
   You can add an authentication scheme by using the following method. Each of the
   callback function must have the type as defined below.
   
 */
typedef struct _HTAAModule HTAAModule;

extern HTAAModule * HTAA_newModule (const char *                scheme,
                                    HTNetBefore *               before,
                                    HTNetAfter *                after,
                                    HTUTree_gc *                gc,
                                    HTUTree_gc *                copy
);
/*

  Find an Authentication Module
  
 */
extern HTAAModule * HTAA_findModule (const char * scheme);
/*

  Delete an Authentication Module
  
 */
extern BOOL HTAA_deleteModule (const char * scheme);
/*

  Delete ALL Authentication modules
  
 */
extern BOOL HTAA_deleteAllModules (void);
/*

HANDLING THE URL TREE

   The authentication information is stored as URL Trees.  The root of a URL Tree is
   identified by a _hostname_ and a _port number_. Each URL Tree contains a set of
   templates and realms which can be used to predict what information to use in a
   hierarchical tree.
   
   The URL trees are automatically collected after some time so the application does not
   have to worry about freeing the trees. When a node in a tree is freed, the gc
   registered as part of the Authentication Module is called.
   
   Server applications can have different authentication setups for each hostname and port
   number, they control. For example, a server with interfaces "www.foo.com" and
   "internal.foo.com" can have different protection setups for each interface.
   
  Add new or Update Existng information to the Database
  
   Add an access authentication information node to the database or update an existing
   one. If the entry is already found then it is replaced with the new one. The template
   must follow normal URI syntax but can include a wildcard Return YES if added (or
   replaced), else NO
   
 */
extern void * HTAA_updateNode (BOOL proxy,
                               char const * scheme,
                               const char * realm, const char * url,
                               void * context);
/*

THE AUTHENTICATION MANAGER FILTERS

   As mentioned, the _Access Authentication Manager_ is itself a set of filters that can
   be registered by the Net manager.
   
  Before Filter
  
   Make a lookup in the URL tree to find any context for this node, If no context is found
   then we assume that we don't know anything about this URL and hence we don't call any
   _BEFORE_ filters at all.
   
 */
HTNetBefore HTAA_beforeFilter;
/*

  After Filter
  
   Call the _AFTER_ filter that knows how to handle this scheme.
   
 */
HTNetAfter HTAA_afterFilter;
/*

  Proxy Authentication Filter
  
   Just as for normal authentication we have a filter for proxy authentication. The proxy
   authentication uses exactly the same code as normal authentication but it stores the
   information in a separate proxy authentication URL tree. That way, we don't get any
   clashes between a server acting as a proxy and a normal server at the same time on the
   same port. The difference is that we only have a ingoing filter (a before filter) as
   the out going filter is identical to the normal authentication filter. The filter
   requires to be called after a proxy filter as we otherwise don't know whether we are
   using a proxy or not.
   
 */
HTNetBefore HTAA_proxyBeforeFilter;
/*

 */
#endif  /* NOT HTAAUTIL_H */
/*

   
   ___________________________________
   
                          @(#) $Id: HTAAUtil.h,v 1.2 1998/06/18 14:04:29 cvs Exp $
                                                                                          
    */
