#ifndef LIBFAKE_H
#define LIBFAKE_H


#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utsname.h>

#define FAKEROOTKEY_ENV "FAKEROOTKEY"

#define FAKEROOTUID_ENV "FAKEROOTUID"
#define FAKEROOTGID_ENV "FAKEROOTGID"
#define FAKEROOTEUID_ENV "FAKEROOTEUID"
#define FAKEROOTEGID_ENV "FAKEROOTEGID"
#define FAKEROOTDONTTRYCHOWN_ENV "FAKEROOTDONTTRYCHOWN"

#define FAKELIBDIR "/usr/lib/fakeroot"
#define FAKELIBNAME "libfakeroot.so.0"

/* #ifndef _STAT_VER */
/* #  define _STAT_VER LINUX_STAT_VERSION */
/* #endif */

#ifndef S_ISTXT
#  define S_ISTXT S_ISVTX
#endif

#ifndef ALLPERMS
#  define ALLPERMS (S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO)/* 07777 */
#endif



/* Define big enough _constant size_ types for the various types of the
   stat struct. I cannot (or rather, shouldn't) use struct stat itself
   in the communication between the fake-daemon and the client (libfake),
   as the sizes elements of struct stat may depend on the compiler or
   compile time options of the C compiler, or the C library used. Thus,
   the fake-daemon may have to communicate with two clients that have
   different views of struct stat (this is the case for libc5 and
   libc6 (glibc2) compiled programmes on Linux)
*/

typedef long int fake_ino_t;
typedef long int fake_dev_t;
typedef long int fake_uid_t;
typedef long int fake_gid_t;
typedef long int fake_mode_t;
typedef long int fake_nlink_t;

typedef  enum {chown_func,
        /*2*/  chmod_func,
        /*3*/  mknod_func, 
               stat_func,
        /*5*/  unlink_func,
               debugdata_func,
               reqoptions_func,
               last_func} func_id;

struct fakestat{
  fake_uid_t   uid;
  fake_gid_t   gid;
  fake_ino_t   ino;
  fake_dev_t   dev;
  fake_dev_t   rdev;
  fake_mode_t mode;
  fake_nlink_t nlink;
  
};
struct fake_msg{
  long mtype;   /* message type in SYSV message sending */
  func_id id;   /* the requested function */
  pid_t pid;
  int   serial;
  struct fakestat st;
};

#ifdef __cplusplus
  extern "C" {
#endif

  extern int init_get_msg();
  extern void send_stat(const struct stat *st, func_id f);
  extern void send_fakem(const struct fake_msg *buf);
  extern void send_get_stat(struct stat *buf);
  extern void cpyfakemstat(struct fake_msg *b1, const struct stat     *st);
  /*extern void cpyfakemfake(struct fake_msg *b1, const struct fakestat *b2);
    extern void cpyfakefakem(struct fakestat *b1, const struct fake_msg *b2);
  */
  extern void cpyfakefake (struct fakestat *b1, const struct fakestat *b2);
  extern void cpystatfakem(struct    stat  *st,  const struct fake_msg *buf);
  extern key_t get_ipc_key();



#ifdef __cplusplus
	     }
#endif

extern int msg_snd;
extern int msg_get;
extern int sem_id;

#endif
