/* 
 * Copyright (C) 1996-1998 Claus-Justus Heine.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /usr/src/oldsrc/cvs/ftape-stacked/ftape/setup/ftape-setup.c,v $
 * $Revision: 1.7 $
 * $Date: 1998/08/18 08:16:42 $
 *
 *      This file contains the code for processing the kernel command
 *      line options for the QIC-40/80/3010/3020 floppy-tape driver
 *      "ftape" for Linux.
 */

#include <linux/config.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/ctype.h>

#include <linux/ftape.h>
#include "../lowlevel/ftape-tracing.h"

/* the setup function are required to return 0 if they have handled an
 * option which doesn't need further processing, 1 if they didn't
 * handle the option and -EINVAL when the option doesn't make any
 * sense and it is clear that the other modules can't make any sense
 * of it either.
 */
extern int ftape_lowlevel_setup(char *str, int *ints);
#ifdef CONFIG_FT_INTERNAL
extern int ftape_internal_setup(char *str, int *ints);
#endif
#ifdef CONFIG_FT_TRAKKER
extern int ftape_trakker_setup(char *str, int *ints);
#endif
#ifdef CONFIG_FT_BPCK
extern int ftape_bpck_setup(char *str, int *ints);
#endif

#define GLOBAL_TRACING
#include "../lowlevel/ftape-real-tracing.h"

#ifdef FT_TRACE_ATTR
# undef FT_TRACE_ATTR
#endif
#define FT_TRACE_ATTR __initlocaldata

/* do some options standarization here. The kernel get_options()
 * function doesn't allow negative numbers, we use the keywords "a"
 * and "n" for "auto" and "none" and convert it to "-1" and "-2".
 *
 * If ints[0] is non-zero, then simply do nothing as the kernel
 * already did the right thing
 */
void __init ftape_setup(char *str, int *ints)
{
	TRACE_FUN(ft_t_flow);

	if (strchr(str, ',') != NULL) {
		char *cur = str;
		int i = ints[0] + 1;

		while (cur && i <= 5) {
			if (isdigit(*cur)) {
				ints[i++] = simple_strtoul(cur,NULL,0);
			} else if (cur[0] == 'n' && cur[1] == ',') {
				ints[i++] = -2;
			} else if (cur[0] == 'a' && cur[1] == ',') {
				ints[i++] = -1;
			} else {
				TRACE(ft_t_any,"Remaining part of option: %s",
				      cur);
				      
				break;
			}
			if ((cur = strchr(cur,',')) != NULL) {
				cur++;
			}
		}
		if (cur && strchr(cur, ',') == NULL) {
			/* otherwise we couldn't parse all key words */
			ints[0] = i-1;
			str = cur;
		}
		for (i = 1; i <= ints[0]; i++) {
			TRACE(ft_t_noise, "got %d", ints[i]);
		}
	}
	TRACE(ft_t_noise, "Called with %s", str);

	if (ftape_lowlevel_setup(str, ints) <= 0) {
		/* error or no need to proceed */
		TRACE_EXIT;
	}
#ifdef CONFIG_FT_INTERNAL
	if (ftape_internal_setup(str, ints) <= 0) {
		TRACE_EXIT;
	}
#endif
#ifdef CONFIG_FT_TRAKKER
	if (ftape_trakker_setup(str, ints) <= 0) {
		TRACE_EXIT;
	}
#endif
#ifdef CONFIG_FT_BPCK
	if (ftape_bpck_setup(str, ints) <= 0) {
		TRACE_EXIT;
	}
#endif
	TRACE_EXIT;
}
