/*
Released under GPL, written by Caolan.McNamara@ul.ie.

Copyright (C) 1998 
	Caolan McNamara

Real Life: Caolan McNamara           *  Doing: MSc in HCI
Work: Caolan.McNamara@ul.ie          *  Phone: +353-61-202699
URL: http://skynet.csn.ul.ie/~caolan *  Sig: an oblique strategy
How would you have done it?
*/

/*warning: this software requires laola's lls to be installed*/

/*

this code is often all over the shop, being more of an organic entity
that a carefully planed piece of code, so no laughing there at the back!

and send me patches by all means, but think carefully before sending me
a patch that doesnt fix a bug or add a feature but instead just changes
the style of coding, i.e no more thousand line patches that fix my 
indentation.

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "config.h"
#include "mswordview.h"
#include "roman.h"
#include "utf.h"

extern char *symbolurl;
extern char *wingdingurl;

olestream * divide_streams(char *filename,char **analyze,char **slashtmp,  char *argv0)
	{
	olestream *olelist;
	olestream *olelistptr;
	pid_t pid;
    int filedes[2];
    char *execut[4];
    char buffer[4096];
    char fullfilepath[PATH_MAX];
    char currentdir[PATH_MAX];
    int i,j,k=0;
    int scan=0;
    int scanbracket=0;
	int scanlevel=0;
	int level=0;
	int len;
	
	char numbers[4];
	
	char *ptr=NULL;
    char basename[PATH_MAX];

	memset(fullfilepath, 0, PATH_MAX);
	memset(currentdir, 0, PATH_MAX);
	memset(basename, 0, PATH_MAX);

    execut[0] = "lls-mswordview";
    execut[1] = "-s";
    execut[3] = NULL;


	if (pipe (filedes))
        {
        fprintf (stderr, "Pipe failed.\n");
        exit(-1);
        }

    if (filename[0] != '/')
        {
        if (NULL == getcwd(currentdir,PATH_MAX))
            {
            fprintf (stderr, "couldnt get current directory\n");
            exit(-1);
            }
        strcpy(fullfilepath,currentdir);
        }
    if (currentdir[strlen(currentdir)] != '/')
        strcat(currentdir,"/");
    if (fullfilepath[strlen(fullfilepath)] != '/')
        strcat(fullfilepath,"/");
    strncat(fullfilepath,filename,PATH_MAX-(strlen(fullfilepath)+1));
    error(stderr,"full filename is %s\n",fullfilepath);

    execut[2] = fullfilepath;

    *slashtmp = tmpnam(NULL);
    if (0 != mkdir((const char *)*slashtmp,S_IRWXU))
        {
        fprintf (stderr, "mkdir of %s failed\n",*slashtmp);
        exit(-1);
        }
    else
        {
        error(stderr, "mkdir of %s suceeded\n",*slashtmp);
        }

	*analyze =(char *) malloc (strlen(*slashtmp) + strlen("analyze") + 3);
    if (*analyze == NULL)
        {
        fprintf (stderr, "malloc failed\n");
        exit (-1);
        }
    strcpy(*analyze,*slashtmp);
    strcat(*analyze,"/analyze/");

	strcpy(basename,*analyze); 

	pid = fork ();
    if (pid == (pid_t) 0)  /*child*/
        {
        close (1);                      /* close stdout */
        dup (filedes[1]);               /* make pipe stdout */
        close (filedes[1]);
        chdir(*slashtmp);
        execvp(execut[0],(char* const *) execut);
#if defined(HAVE_ERRNO_H)
		fprintf( stderr, "Exec of %s failed with error code %d, trying a different tack\n", execut[0], errno );
#else
		fprintf( stderr, "Exec of %s failed, trying a different tack\n", execut[0]);
#endif
		/*if that failed try again, with zack@studioarchetype.com idea*/
		if (strchr(argv0,'/') != NULL) 
			{
			execut[0] = malloc((strlen(argv0) + strlen("/lls-mswordview") + 1) * sizeof(char));
			argv0[strlen(argv0) - strlen(strrchr(argv0,'/'))] = '\0';
			sprintf(execut[0],"%s/lls-mswordview",argv0);
		    } 
		else 
			{
			execut[0] = malloc((strlen(currentdir) + strlen("/lls-mswordview") + 1) * sizeof(char));
			sprintf(execut[0],"%s/lls-mswordview",currentdir);
			}
        execvp(execut[0],(char* const *) execut);
#if defined(HAVE_ERRNO_H)
		fprintf( stderr, "Exec of %s also failed with error code %d, trying one last tack\n", execut[0], errno );
#else
		fprintf( stderr, "Exec of %s also failed, trying one last tack\n", execut[0]);
#endif
		/*if that failed try again, with zack@studioarchetype.com idea*/
		if (strchr(argv0,'/') != NULL) 
			{
			execut[0] = malloc((strlen(argv0) + strlen("/laola/lls-mswordview") + 1) * sizeof(char));
			argv0[strlen(argv0) - strlen(strrchr(argv0,'/'))] = '\0';
			sprintf(execut[0],"%s/laola/lls-mswordview",argv0);
		    } 
		else 
			{
			execut[0] = malloc((strlen(currentdir) + strlen("/laola/lls-mswordview") + 1) * sizeof(char));
			sprintf(execut[0],"%s/laola/lls-mswordview",currentdir);
			}
        execvp(execut[0],(char* const *) execut);
#if defined(HAVE_ERRNO_H)
		fprintf( stderr, "Exec of %s also failed with error code %d\n", execut[0], errno );
#else
		fprintf( stderr, "Exec of %s also failed\n", execut[0]);
#endif
		exit(-1);
        }
    else if (pid < (pid_t) 0)
        {
        /* The fork failed. */
        fprintf (stderr, "Fork failed.\n");
        exit (-1);
        }

    close (filedes[1]);


	olelist = (olestream *) malloc(sizeof(olestream));
	if (olelist == NULL)
		{
		fprintf (stderr, "malloc failed.\n");
        exit (-1);
		}


	/*work backwards to the the first / or beginning*/

	k = strlen(basename);

	j=strlen(filename);
    while((filename[j] != '/') && (j!=0))
		j--;

	/*j now a beginning of basename*/
    while((filename[j] != '.') && (j<strlen(filename)))
		{
        basename[k++] = filename[j++];
		basename[k] = '\0';
		}

	basename[k++] = '.';
	basename[k] = '\0';
	error(stderr,"basename is %s\n",basename);

    error(stderr,"filename base is %s\n",basename);

    olelistptr = olelist;


	while ((len = read (filedes[0],buffer,4095)) > 0)
        {
        for (i=0;i<len;i++)
            {
            if ((buffer[i] == '\'') && (scan == 0))
                {
                scan=1;
                ptr = olelistptr->streamname;
                j=0;
                }
            else if ((buffer[i] == '\'') && (scan == 1))
                {
                scan=0;
                ptr[j] = '\0';
                }
            else if ((buffer[i] == '(') && (scanbracket == 0))
                {
				error(stderr,"streamname is %s\n",olelistptr->streamname);
                scanbracket=1;
				ptr = numbers;
				j = 0;
                }
            else if ((buffer[i] == ')') && (scanbracket == 1))
                {
                scanbracket=0;
                ptr[j] = '\0';
				error(stderr,"filename nos %s\n",numbers);
				sprintf(olelistptr->filename,"%s%.2x",basename,(int)strtol(numbers,(char **)NULL,16));
				error(stderr,"filename is %s\n",olelistptr->filename);
				olelistptr->level = level/3;
				error(stderr,"level is %d\n",level/3);
                olelistptr->next = (olestream *) malloc(sizeof(olestream));
                if (olelistptr == NULL)
                    {
                    fprintf (stderr, "malloc failed.\n");
                    exit (-1);
                    }
                olelistptr = olelistptr->next;
                olelistptr->next=NULL;
                }
            else if (scan == 1)
                {
                ptr[j++] = buffer[i];
                }
            else if (scanbracket==1)
                {
                if (isxdigit(buffer[i]))
                    ptr[j++] = buffer[i];
                }
			else if (buffer[i] == ':')
				{
				scanlevel=1;
				level=0;
				}
			else if (scanlevel == 1)
				{
				if (isspace(buffer[i]))
					level++;
				else
					scanlevel=0;
				}
            }
        }

	return(olelist);
	}

void cleanupstreams(char *analyze,char *slashtmp)
	{
	DIR *adir;
	struct dirent *thedir;
	char currentdir[PATH_MAX] ="/";

 	if (NULL == getcwd(currentdir,PATH_MAX))
            fprintf (stderr, "minor warning: couldnt get current directory path,continuing.\n");

	chdir(analyze);
	adir = opendir(analyze);	
	if (adir == NULL)
		error (stderr, "couldnt open %s\n",analyze);
	else
		{
		while (NULL != (thedir = readdir(adir)))
			{
			if (strcmp(thedir->d_name,"..") && strcmp(thedir->d_name,"."))
				{
				error(stderr,"removing %s\n",thedir->d_name);
				remove(thedir->d_name);
				}
			}
		closedir(adir);
		}
	chdir(currentdir);

	if (0 != rmdir((const char *)analyze))
		fprintf (stderr, "rmdir of %s failed\n",analyze);
	else
		error(stderr, "rmdir of %s suceeded\n",analyze);

	if (0 != rmdir((const char *)slashtmp))
		fprintf (stderr, "rmdir of %s failed\n",slashtmp);
	else
		error (stderr, "rmdir of %s suceeded\n",slashtmp);
	}


int decode_symbol(U16 fontspec)
	{
	error(stderr,"given symbol %ld, converting to %ld\n",fontspec,fontspec-61472);
	fontspec = fontspec-61472;
	if (fontspec < 95)
		fontspec+=34;
	printf("<img src=\"%s/%d.gif\">",symbolfontdir(),fontspec);
	return(1);
	}
	
char *symbolfontdir(void)
	{
	if (symbolurl != NULL)
		return(symbolurl);
	return(SYMBOLFONTDIR);
	}

int decode_wingding(U16 fontspec)
	{
	error(stderr,"given wingding %ld, converting to %ld\n",fontspec,fontspec-61472);
	fontspec = fontspec-61472;
	fontspec+=34;
	if (fontspec > 86) 
		fontspec+=4;
	if (fontspec == 114)
		fontspec = 153;
	else if (fontspec == 115)
		fontspec = 160;
	else if (fontspec == 116)
		fontspec = 163;
	else if (fontspec == 117)
		fontspec = 165;
	else if (fontspec == 118)
		fontspec = 164;
	else if (fontspec == 119)
		fontspec = 168;
	else if (fontspec == 120)
		fontspec = 167;
	else if (fontspec == 121)
		fontspec = 171;
	else if (fontspec == 122)
		fontspec = 172;
	else if (fontspec == 123)
		fontspec = 170;
	else if (fontspec == 124)
		fontspec = 184;
	else if (fontspec == 125)
		fontspec = 169;
	else if (fontspec == 129)
		fontspec = 116;
	else if (fontspec == 130)
		fontspec = 117;
	else if (fontspec == 131)
		fontspec = 114;
	else if (fontspec == 132)
		fontspec = 115;
	else if ( (fontspec > 132) && (fontspec < 156) )
		fontspec-=5;
	else if ( (fontspec >= 156) && (fontspec < 164 ) )
		fontspec-=38;
	else if (fontspec == 164)
		fontspec=151;
	else if (fontspec == 165)
		fontspec=152;
	else if (fontspec == 166)
		fontspec=161;
	else if  ((fontspec > 166) && (fontspec < 173 ) )
		fontspec-=13;
	else if (fontspec == 173)
		fontspec=162;
	else if (fontspec == 174)
		fontspec=164;
	else if ((fontspec > 174) && (fontspec < 186))
		fontspec-=2;
	else if ( (fontspec >= 186) && (fontspec < 257) )
		fontspec--;
	else if (fontspec > 256)
		fontspec-=170;
	
	printf("<img src=\"%s/%d.gif\">",wingdingfontdir(),fontspec);
	return(1);
	}
	
char *wingdingfontdir(void)
	{
	if (wingdingurl != NULL)
		return(wingdingurl);
	return(WINGDINGFONTDIR);
	}


char *ms_strlower(char *in)
	{
	char *useme = in;
	while(*useme != '\0')
		{
		*useme = tolower(*useme);
		useme++;
		}
	return(in);
	}


U32 read_32ubit(FILE *in)
	{
	U16 temp1,temp2;
	U32 ret;
	temp1 = read_16ubit(in);
	temp2 = read_16ubit(in); 
	ret = temp2;
	ret = ret << 16;
	ret += temp1;
	return(ret);
	}

U32 sread_32ubit(U8 *in)
	{
	U16 temp1,temp2;
	U32 ret;
	temp1 = sread_16ubit(in);
	temp2 = sread_16ubit(in+2);
	ret = temp2;
	ret = ret << 16;
	ret+=temp1;
	return(ret);
	}

U16 read_16ubit(FILE *in)
	{
	/*im pretty insecure when it come to dealing with bits, i like
	 *to address them by their meaning not the reality
	 */
	U8 temp1,temp2;
	U16 ret;
	temp1 = getc(in);
	temp2 = getc(in);
	ret = temp2;
	ret = ret << 8;
	ret += temp1;
	return(ret);
	}


U16 sread_16ubit(U8 *in)
	{
	U8 temp1,temp2;
	U16 ret;
	temp1 = *in;
	temp2 = *(in+1);
	ret = temp2;
	ret = ret << 8;
	ret += temp1;
	return(ret);
	}

U32 dread_32ubit(FILE *in,U8 **list)
	{
	U8 *temp;
	U32 ret;
	if (list == NULL)
		return(read_32ubit(in));
	else
		{
		temp = *list;
		(*list)+=4;
		ret = sread_32ubit(temp);
		return(ret);
		}
	}

U16 dread_16ubit(FILE *in,U8 **list)
	{
	U8 *temp;
	U16 ret;
	if (list == NULL)
		return(read_16ubit(in));
	else
		{
		temp = *list;
		(*list)+=2;
		ret = sread_16ubit(temp);
		return(ret);
		}
	}

U8 dgetc(FILE *in,U8 **list)
	{
	U8 *temp;
	if (list == NULL)
		return(getc(in));
	else
		{
		temp = *list;
		(*list)++;
		return(sgetc(temp));
		}
	}

U8 sgetc(U8 *in)
	{
	return(*in);
	}



void oprintf(int silentflag,char *fmt, ...)
	{
    va_list argp;
	if (!silentflag)
		{
		va_start(argp, fmt);
		vfprintf(stdout, fmt, argp);
		va_end(argp);
		}
    }

void error(FILE *stream,char *fmt, ...)
	{
	#ifdef DEBUG
    va_list argp;
    fprintf(stream, "error: ");
    va_start(argp, fmt);
    vfprintf(stream, fmt, argp);
    va_end(argp);
    fprintf(stream, "\n");
	#endif
    }

RETSIGTYPE reaper (int ignored)
    {
#ifdef MUST_REINSTALL_SIGHANDLERS
    signal_handle (SIGCHLD, reaper);
#endif
    while (WAITPID (-1, 0, WNOHANG) > 0)
        ;

    }

RETSIGTYPE timeingout(int ignored)
    {
	fprintf(stderr,"\nconversion took too long, assuming something wrong and aborting\n");
	fprintf(stderr,"\nset timeout value higher (or dont set it) to try for longer\n");
	exit(-1);
    }

#if defined (HAVE_POSIX_SIGNALS)
void signal_handle (int sig, SigHandler * handler)
    {
    struct sigaction act, oact;

    act.sa_handler = handler;
    act.sa_flags = 0 | SA_NOCLDSTOP | SA_RESTART;
    sigemptyset (&act.sa_mask);
    sigemptyset (&oact.sa_mask);
    sigaction (sig, &act, &oact);
    }
#endif


