/*
 * Copyright (c) 1996 Henry S. Thompson
 * See the file COPYING for copying permission.
 *
 */

#ifndef lint
static const char *rcsid =
"$Header: /home/ht/dsssl/src/RCS/ndscEventHandler.C,v 1.15 1996/11/28 15:47:03 ht Exp $";
#endif

#ifdef __GNUG__
#pragma implementation
#endif

#include <stdio.h>
#include "config.h"
#include "ndscEventHandler.h"
#include "ndscMessages.h"
#include "StringC.h"

#ifdef SP_NAMESPACE
namespace SP_NAMESPACE {
#endif

NamedSpec::NamedSpec(const StringC &name,StartElementEvent &event)
: Named(name), specEvent_(event), isConref_(0)
{
}

SpecResult::SpecResult() : firstOne_(0) {
};

inline NamedTable<NamedSpec> &SpecResult::specTable() { return specTable_; };
inline const StringC *SpecResult::firstOne() { return firstOne_; };

StringC makeStringC(const char *s)
{
  StringC tem;
  if (s)
    while (*s)
      tem += (unsigned char)*s++;
  return tem;
}

const StringC SpecResult::dssslSpecSC_(
  makeStringC("DSSSL-SPECIFICATION"));
const StringC SpecResult::extSpecSC_(
      makeStringC("EXTERNAL-SPECIFICATION"));
const StringC SpecResult::styleSpecSC_(
      makeStringC("STYLE-SPECIFICATION"));
const StringC SpecResult::styleBodySC_(
      makeStringC("STYLE-SPECIFICATION-BODY"));
const StringC SpecResult::transSpecSC_(
      makeStringC("TRANSFORMATION-SPECIFICATION"));
const StringC SpecResult::transBodySC_(
      makeStringC("TRANSFORMATION-SPECIFICATION-BODY"));

void SpecResult::noteDtd(const Dtd &dtd) {
  dssslSpecET_=dtd.lookupElementType(dssslSpecSC_);
  extSpecET_=dtd.lookupElementType(extSpecSC_);
  styleSpecET_=dtd.lookupElementType(styleSpecSC_);
  styleBodyET_=dtd.lookupElementType(styleBodySC_);
  transSpecET_=dtd.lookupElementType(transSpecSC_);
  transBodyET_=dtd.lookupElementType(transBodySC_);
};

const StringC ndscEventHandler::idStr_(makeStringC("ID"));
const StringC ndscEventHandler::topStr_(makeStringC("top"));
const StringC ndscEventHandler::firstStr_(makeStringC("first"));

ndscEventHandler::ndscEventHandler(SpecResult &specResult)
: inElt_(none), specResult_(specResult), curSpec_(0)
{
}

ndscEventHandler::~ndscEventHandler()
{
}

void ndscEventHandler::endProlog(EndPrologEvent *event) {
  specResult_.noteDtd(event->dtd());
};

void ndscEventHandler::startElement(StartElementEvent *event) {
  const StringC *id;
  if (event->elementType()==specResult_.styleSpecET_ ||
      event->elementType()==specResult_.transSpecET_ ||
      event->elementType()==specResult_.extSpecET_) {
    const AttributeList &atl(event->attributes());
    unsigned n;
    if (atl.attributeIndex(idStr_,n) && atl.specified(n)) {
      const AttributeValue *idv=atl.value(n);
      id=new StringC(((const TokenizedAttributeValue*)idv)->token(0));
      event->copyData();
      specResult_.specTable_.insert(curSpec_=new NamedSpec(*id,*event));
      if (!specResult_.firstOne_) {
	/* note per agreement with James Clark this means an ext-spec can
	   be first */
	specResult_.firstOne_=id;
      };
    }
    else if (!specResult_.firstOne_) {
      event->copyData(); // ok to call twice
      specResult_.firstOne_=id=&firstStr_;
      specResult_.specTable_.insert(curSpec_=new NamedSpec(*id,*event));
    }
    else {
      // Un-named, not first, no way it's relevant
      ((XndscEventHandler*)this)->messenger_->
	message(specUnreachableWarning,
		((LocatedEvent*)event)->location());
      delete event;
    };
  }
  else if (event->elementType()==specResult_.dssslSpecET_) {
    // save this one for its decls
    event->copyData();
    specResult_.specTable_.insert(curSpec_=new NamedSpec(topStr_,*event));
  }
  else if (event->elementType()==specResult_.styleBodyET_ ||
	   event->elementType()==specResult_.transBodyET_) {
    if (event->attributes().conref()) {
      event->copyData();
      curSpec_->bodyQueue_.append(event);
      curSpec_->isConref_=1;
    }
    else {
      inElt_=body;
      // not needed
      delete event;
    };
  }
  else {
    // must be a declaration
    event->copyData();
    curSpec_->declQueue_.append(event);
    inElt_=decl;
  };
}

void ndscEventHandler::endElement(EndElementEvent *event) {
  inElt_=none;
  delete event;
}
  
void ndscEventHandler::data(DataEvent *event) {
  // note inElt_ will not be set for unnamed non-first specs
  switch (inElt_) {
  case body:
    event->copyData();
    curSpec_->bodyQueue_.append(event);
    break;
  case decl:
    event->copyData();
    curSpec_->declQueue_.append(event);
    break;
  case none:
    SHOULDNT;
    delete event;
  };
};
