#define VERSION "0.2.1"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <gtk/gtk.h>
#include <glib.h>

#undef GTK_WINDOW
#undef GTK_BOX
#undef GTK_OBJECT
#undef GTK_CONTAINER
#undef GTK_CLIST
#undef GTK_TEXT
#undef GTK_LABEL
#undef GTK_ENTRY
#undef GTK_WIDGET
#undef GTK_MENU_BAR
#undef GTK_DIALOG
#undef GTK_FILE_SELECTION
#undef GTK_PANED
#undef GTK_TABLE
#undef GTK_DRAWING_AREA

#define GTK_WINDOW(n) ((GtkWindow *)n)
#define GTK_BOX(n) ((GtkBox *)n)
#define GTK_OBJECT(n) ((GtkObject *)n)
#define GTK_CONTAINER(n) ((GtkContainer *)n)
#define GTK_CLIST(n) ((GtkCList *)n)
#define GTK_TEXT(n) ((GtkText *)n)
#define GTK_LABEL(n) ((GtkLabel *)n)
#define GTK_ENTRY(n) ((GtkEntry *)n)
#define GTK_WIDGET(n) ((GtkWidget *)n)
#define GTK_MENU_BAR(n) ((GtkMenuBar *)n)
#define GTK_DIALOG(n) ((GtkDialog *)n)
#define GTK_FILE_SELECTION(n) ((GtkFileSelection *)n)
#define GTK_PANED(n) ((GtkPaned *)n)
#define GTK_TABLE(n) ((GtkTable *)n)
#define GTK_DRAWING_AREA(n) ((GtkDrawingArea *)n)

struct xchatprefs
{
   long flags;
   char nick1[64];
   char nick2[64];
   char nick3[64];
   char realname[64];
   char username[64];
   char awayreason[72];
   char quitreason[72];
   char font_normal[100];
   char font_bold[100];
   unsigned char bg_color;
   unsigned char fg_color;

   char dialog_font_normal[100];
   char dialog_font_bold[100];
   unsigned char dialog_bg_color;
   unsigned char dialog_fg_color;

   long bufsize;
};
 
struct setup
{
   GtkWidget *settings_window;
   GtkWidget *bg_color;
   GtkWidget *fg_color;
   GtkWidget *font_normal;
   GtkWidget *font_bold;
   
   GtkWidget *dialog_bg_color;
   GtkWidget *dialog_fg_color;
   GtkWidget *dialog_font_normal;
   GtkWidget *dialog_font_bold;
   
   GtkWidget *entry_quit;
   GtkWidget *entry_away;
   GtkWidget *entry_bufsize;
   struct xchatprefs prefs;
};

#define flag_t flag_wid[0]
#define flag_n flag_wid[1]
#define flag_s flag_wid[2]
#define flag_i flag_wid[3]
#define flag_p flag_wid[4]
#define flag_m flag_wid[5]
#define flag_l flag_wid[6]
#define flag_k flag_wid[7]

struct session
{
   GtkWidget *window;
   GtkWidget *changad;
   GtkWidget *topicgad;
   GtkWidget *textgad;
   GtkWidget *namelistgad;
   GtkWidget *nickgad;
   GtkWidget *inputgad;
   GtkWidget *namelistinfo;
   GtkWidget *leftpane;
   GtkWidget *vscrollbar;

   GtkWidget *flag_wid[8];

   gint selected; // selected row in userlist, or -1
   struct server *server;
   struct user *userlist;
   char channel[72];
   char waitchannel[72]; // waiting to join this channel
   char willjoinchannel[72]; // /join done for this channel

   char lastnick[64];  // last nick you /msg'ed

   char *history[100];
   int pos;
   int realpos;

   int chanflags;   // BIT 0 = names done,     BIT 1 = modes done
                    // BIT 2 = chan date done, BIT 4 = endofnames
   int ops;
   int total;
  
   struct setup *setup;
};

struct server
{
   struct server *next;
   long port;
   long sok;
   long childread;
   int childpid;
   gint iotag;
   char used;
   char servername[71];
   char password[86];
   char nick[64];
   long flags; /* BIT 0 = Connected */
   char linebuf[1024];
   long pos;
   int nickcount;

   struct session *front_session;

   GtkWidget *rawlog_window;
   GtkWidget *rawlog_textlist;
   
   GtkWidget *chanlist_window;
   GtkWidget *chanlist_list;
   GtkWidget *chanlist_rbutton;
   int chanlist_minusers;
   long chanlist_selected;
};

struct DCC
{
   struct DCC *next;
   struct session *sess;
   char used;
   char type; // 0 = SEND  1 = RECV  2 = CHAT
   char stat; // 0 = QUEUED  1 = ACTIVE  2 = FAILED  3 = DONE
   char misc;
   long sok;
   gint iotag;
   unsigned long addr;
   unsigned long size;
   unsigned long resumable;
   unsigned long ack;
   unsigned long pos;
   unsigned long oldpos;
   long port;
   long starttime;
   long cps;
   char file[128];
   char nick[128];
   int fp; // file pointer
   struct dccdraw *dccdraw;
};

struct dialog
{
   struct dialog *next;
   struct server *serv;
   GtkWidget *window;
   GtkWidget *inputgad;
   GtkWidget *listgad;
   GtkWidget *ipgad;
   char used;
   char nick[127];
   char ip[128];
};

// xchatprefs flags

#define PREFS_AUTOSAVE 0
#define PREFS_AUTODIALOG 1
#define PREFS_AUTORECONNECT 2
#define PREFS_INVISIBLE 3
#define PREFS_SERVERNOTICE 4
#define PREFS_WALLOPS 5
#define PREFS_SKIPMOTD 6
#define PREFS_AWAY 7
#define PREFS_AUTOREJOIN 8
