/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "voice.xpm"
#include "op.xpm"
#include "xchat.h"
#include "userlist.h"

GdkPixmap *op_pixmap, *voice_pixmap;
GdkBitmap *op_mask, *voice_mask;

void init_userlist_xpm(struct session *sess)
{
   GtkStyle *style = gtk_widget_get_style(sess->window);
   char **opxpm = op_xpm;
   char **voicexpm = voice_xpm;

   op_pixmap = gdk_pixmap_create_from_xpm_d(sess->window->window,
					 &op_mask, &style->bg[GTK_STATE_NORMAL],
					 opxpm);
   voice_pixmap = gdk_pixmap_create_from_xpm_d(sess->window->window,
					 &voice_mask, &style->bg[GTK_STATE_NORMAL],
					 voicexpm);
}

void change_num_ops(struct session *sess, int change)
{
   char tbuf[64];
   sess->ops += change;
   sprintf(tbuf, "%d ops, %d total", sess->ops, sess->total);
   gtk_label_set(GTK_LABEL(sess->namelistinfo), tbuf);
}

void change_num_total(struct session *sess, int change)
{
   char tbuf[64];
   sess->total += change;
   sprintf(tbuf, "%d ops, %d total", sess->ops, sess->total);
   gtk_label_set(GTK_LABEL(sess->namelistinfo), tbuf);
}

void update_user_list(struct session *sess)
{
   gint i;
   int ops = 0, total = 0;
   char tbuf[42];
   struct user *user = sess->userlist;
   gtk_clist_clear((GtkCList*)sess->namelistgad);
   gtk_clist_freeze((GtkCList*)sess->namelistgad);
   while(user)
   {
      char *name = (char *)&(user->user);
      i = gtk_clist_append((GtkCList*)sess->namelistgad, &name);
      
      if(user->voice)
	 gtk_clist_set_pixtext((GtkCList*)sess->namelistgad, i, 0,
			 user->user, 3, voice_pixmap, voice_mask);
      
      if(user->op)
      {
	 gtk_clist_set_pixtext((GtkCList*)sess->namelistgad, i, 0,
			 user->user, 3, op_pixmap, op_mask);
	 ops++;
      }
      
      total++;
      user = user->next;
   }
   gtk_clist_thaw((GtkCList*)sess->namelistgad);
   if(sess->selected != -1) gtk_clist_select_row((GtkCList*)sess->namelistgad, sess->selected, 0);
   sprintf(tbuf, "%d ops, %d total", ops, total);
   gtk_label_set(GTK_LABEL(sess->namelistinfo), tbuf);
   sess->ops = ops;
   sess->total = total;
}

int nick_cmp(struct user *user1, struct user *user2)
{
   if(user1->op && !user2->op) return -1;
   if(!user1->op && user2->op) return +1;

   if(user1->voice && !user2->voice) return -1;
   if(!user1->voice && user2->voice) return +1;

   return strcasecmp(user1->user, user2->user);
}

void sort_namelist(struct session *sess)
{
   struct user temp;
   struct user *innext, *inuser, *next;
   struct user *user = sess->userlist;

   while(user)
   {
      next = user->next;
      
      inuser = sess->userlist;
      while(inuser)
      {
	 innext = inuser->next;

	 if(nick_cmp(inuser, user) > 0)
	 {
	    memcpy(&temp, inuser, sizeof(struct user));
	    strcpy(inuser->user, user->user);
	    inuser->op = user->op;
	    inuser->voice = user->voice;
	    strcpy(user->user, temp.user);
	    user->op = temp.op;
	    user->voice = temp.voice;
	 }
	 inuser = innext;
      }
      user = next;
   }
}

void clear_user_list(struct session *sess)
{
   struct user *next;
   struct user *user = sess->userlist;
   gtk_clist_clear((GtkCList*)sess->namelistgad);
   while(user)
   {
      next = user->next;
      free(user);
      user = next;
   }
   sess->userlist = 0;
}

struct user *find_name(struct session *sess, char *name)
{
   struct user *user = sess->userlist;
   while(user)
   {
      if(!strcasecmp(user->user, name)) return user;
      user = user->next;
   }
   return FALSE;
}

void op_name(struct session *sess, char *name)
{
   struct user *user = find_name(sess, name);
   if(user)
   {
      user->op = TRUE;
      sort_namelist(sess);
      update_user_list(sess);
   }
}

void deop_name(struct session *sess, char *name)
{
   struct user *user = find_name(sess, name);
   if(user)
   {
      user->op = FALSE;
      sort_namelist(sess);
      update_user_list(sess);
   }
}

void voice_name(struct session *sess, char *name)
{
   struct user *user = find_name(sess, name);
   if(user)
   {
      user->voice = TRUE;
      sort_namelist(sess);
      update_user_list(sess);
   }
}

void devoice_name(struct session *sess, char *name)
{
   struct user *user = find_name(sess, name);
   if(user)
   {
      user->voice = FALSE;
      update_user_list(sess);
   }
}

void change_nick(struct session *sess, char *oldname, char *newname)
{
   struct user *user = find_name(sess, oldname);
   if(user)
   {
      strcpy(user->user, newname);
      sort_namelist(sess);
      update_user_list(sess);
   }
}

int sub_name(struct session *sess, char *name)
{
   struct user *prev = sess->userlist;
   struct user *user = sess->userlist;
   while(user)
   {
      if(!strcmp(user->user, name))
      {
	 if(prev != user) // if not first entry
	   prev->next = user->next;
	 else
	   sess->userlist = user->next;
	 free(user);
	 update_user_list(sess);
	 return TRUE;
      }
      prev = user;
      user = user->next;
   }
   return FALSE;
}

void add_name(struct session *sess, char *name, int sort, int update)
{
   struct user *prev;
   struct user *user = sess->userlist;

   if(!user)
   {
      sess->userlist = malloc(sizeof(struct user));
      user = sess->userlist;
      goto jump;
   }

   do
   {
      prev = user;
      user = user->next;
   } while(user);

   prev->next = malloc(sizeof(struct user));
   if(prev->next)
   {
      user = prev->next;
      jump:
      memset(user, 0, sizeof(struct user));
      if(*name == '@') { name++; user->op = TRUE; }
      if(*name == '+') { name++; user->voice = TRUE; }
      strcpy(user->user, name);
      if(sort) sort_namelist(sess);
      if(update) update_user_list(sess);
   }
}
