/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"


void chanlist_addentry(struct server *serv, char *chan, char *users, char *topic)
{
   gchar *new[1][3];

   if(atoi(users) < serv->chanlist_minusers) return;
   
   new[0][0] = chan;
   new[0][1] = users;
   new[0][2] = topic;

   gtk_clist_append(GTK_CLIST(serv->chanlist_list), new[0]);
}

void chanlist_join(GtkWidget *wid, struct server *serv)
{
   if(serv->chanlist_selected != -1)
   {
      char *chan;
      gtk_clist_get_text(GTK_CLIST(serv->chanlist_list), serv->chanlist_selected, 0, &chan);
      if(serv->flags&(1<<0))
      {
	 char tbuf[128];
	 sprintf(tbuf, "JOIN %s\r\n", chan);
	 send(serv->sok, tbuf, strlen(tbuf), 0);
      }
   }
}

void chanlist_refresh(GtkWidget *wid, struct server *serv)
{
   serv->chanlist_selected = -1;
   gtk_clist_clear(GTK_CLIST(serv->chanlist_list));
   if(serv->flags&(1<<0)) // if CONNECTED
      send(serv->sok, "LIST\r\n", 6, 0);
}

void chanlist_minusers(GtkWidget *wid, struct server *serv)
{
   char buf[16];
   char *minusers = gtk_entry_get_text(GTK_ENTRY(wid));
   serv->chanlist_minusers = atoi(minusers);
   sprintf(buf, "%d", serv->chanlist_minusers);
   gtk_entry_set_text(GTK_ENTRY(wid), buf);
}

void chanlist_row_unselected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct server *serv)
{
   serv->chanlist_selected = -1;
}

void chanlist_row_selected(GtkWidget *clist, gint row, gint column,
		       GdkEventButton *even, struct server *serv)
{
   serv->chanlist_selected = row;
}

void chanlist_closegui(GtkWidget *wid, struct server *serv)
{
   if(serv->chanlist_window)
   {
      gtk_widget_destroy(serv->chanlist_window);
      serv->chanlist_window = 0;
   }
}

void chanlist_opengui(struct server *serv)
{
   static gchar *titles[] = {"Channel", "Users", "Topic"};
   GtkWidget *vbox, *hbox, *wid;
   char tbuf[256];

   if(serv->chanlist_window)
   {
      chanlist_closegui(0, serv);
      return;
   }

   sprintf(tbuf, "X-Chat: Channel List (%s)", serv->servername);
   
   serv->chanlist_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize(GTK_WIDGET(serv->chanlist_window), 450, 200);
   gtk_window_set_title(GTK_WINDOW(serv->chanlist_window), tbuf);
   gtk_signal_connect(GTK_OBJECT(serv->chanlist_window), "destroy",
                             GTK_SIGNAL_FUNC(chanlist_closegui), serv);
   
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(serv->chanlist_window), vbox);
   gtk_widget_show(vbox);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 4);
   gtk_widget_show(hbox);
   
   wid = gtk_label_new("Minimum Users:");
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);
   
   wid = gtk_entry_new_with_max_length(6);
   gtk_entry_set_text(GTK_ENTRY(wid), "3");
   gtk_signal_connect(GTK_OBJECT(wid), "activate",
		      GTK_SIGNAL_FUNC(chanlist_minusers), serv);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);
   serv->chanlist_minusers = 3;
   
   serv->chanlist_list = gtk_clist_new_with_titles(3, titles);
   gtk_signal_connect(GTK_OBJECT(serv->chanlist_list),
		      "select_row", GTK_SIGNAL_FUNC(chanlist_row_selected), serv);
   gtk_signal_connect(GTK_OBJECT(serv->chanlist_list),
		      "unselect_row", GTK_SIGNAL_FUNC(chanlist_row_unselected), serv);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 0, 90);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 1, 50);
   gtk_clist_set_column_width(GTK_CLIST(serv->chanlist_list), 2, 165);
   gtk_container_add(GTK_CONTAINER(vbox), serv->chanlist_list);
   gtk_widget_show(serv->chanlist_list);
   
   wid = gtk_button_new_with_label("Refresh the list");
   gtk_box_pack_end(GTK_BOX(vbox), wid, FALSE, FALSE, 4);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(chanlist_refresh), serv);
   gtk_widget_show(wid);
   serv->chanlist_rbutton = wid;

   wid = gtk_button_new_with_label("Join Channel");
   gtk_box_pack_end(GTK_BOX(vbox), wid, FALSE, FALSE, 4);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(chanlist_join), serv);
   gtk_widget_show(wid);

   gtk_widget_show(serv->chanlist_window);
   serv->chanlist_selected = -1;
}

