/*
 * radzap	Zap a user from the radutmp and radwtmp file.
 *
 * Version:	@(#)radzap  2.10  21-04-1997  miquels@cistron.nl
 *
 */
#include	<sys/types.h>
#include	<sys/time.h>

#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<unistd.h>
#include	<errno.h>
#include	<stdarg.h>
#include	"radiusd.h"
#include	"radutmp.h"

/*
 *	We need some global variables.
 *	This is a hack because the rest of the code isn't modular enough.
 *
 *	FIXME: Move radzap() out of acct.c and read_clients_file() out
 *	of files.c so we don't have to link the rest of radiusd into radzap.
 */
char *radius_dir 	= RADIUS_DIR;
char *progname   	= "radzap";
char *radacct_dir	= "/";
char send_buffer[4096];
char recv_buffer[4096];
int debug_flag = 0;
int use_dbm = 0;
int log_stripped_names = 0;
void debug_pair(FILE *fd, VALUE_PAIR *pair) { }

extern CLIENT *clients;
extern NAS *naslist;


int log(int lvl, char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	return 0;
}
int log_debug(char *fmt, ...)
{
	return log(1, fmt);
}


UINT4 findnas(char *nasname)
{
	NAS *cl;

	for(cl = naslist; cl; cl = cl->next) {
		if (strcmp(nasname, cl->shortname) == 0 ||
		    strcmp(nasname, cl->longname) == 0)
			return cl->ipaddr;
	}

	return 0;
}


/*
 *	Zap a user from the radutmp and radwtmp file.
 */
int main(int argc, char **argv)
{
	int	nas_port = -1;
	char	*user = NULL;
	char	*s;
	UINT4	ip;
	time_t	t;
	char	buf[256];

	if (argc < 2 || argc > 4 || (argc > 1 && argv[1][0] == '-')) {
		fprintf(stderr, "Usage: radzap termserver [port] [user]\n");
		fprintf(stderr, "       radzap is only an admin tool to clean the radutmp file!\n");
		exit(1);
	}
	if (argc > 2) {
		s = argv[2];
		if (*s == 's' || *s == 'S') s++;
		nas_port = atoi(s);
	}
	if (argc > 3) user     = argv[3];

	/*
	 *	Read the "naslist" file.
	 */
	sprintf(buf, "%s/%s", RADIUS_DIR, RADIUS_NASLIST);
	if (read_naslist_file(buf) < 0)
		exit(1);

	/*
	 *	Find the IP address of the terminal server.
	 */
	if ((ip = findnas(argv[1])) == 0 && argv[1][0] != 0) {
		if ((ip = get_ipaddr(argv[1])) == 0) {
			fprintf(stderr, "%s: host not found.\n", argv[1]);
			exit(1);
		}
	}

	printf("radzap: zapping termserver %s, port %d",
		ip_hostname(ip), nas_port);
	if (user) printf(", user %s", user);
	printf("\n");

	t = time(NULL);
	radzap(ip, nas_port, user, t);

	return 0;
}
