/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifndef STATUS_STRUCTURE_H
#define STATUS_STRUCTURE_H

#if !defined Linux
#include <errno.h>
#if defined HP_UX
extern char **sys_errlist;
#endif
#endif
#if !defined HAVE_SYS_ERRLIST
#define _PFTP_ERROR_ARRAY_     "error"
#define _PFTP_ERROR_ARRAY_PID_ "error"
#else
#define _PFTP_ERROR_ARRAY_     *(sys_errlist+errno)
#define _PFTP_ERROR_ARRAY_PID_ *(sys_errlist+pid)
#endif

#define BIT_ONE              01
#define BIT_TWO              02
#define PFTPRESOURCE         "/.pftprc"
#define PFTPSYSTEMRC         "/etc/pftp.conf"

#if defined HAVE_GLIB || defined ULTRIX || defined NEXTSTEP || defined OSF1
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#endif

struct status_type {
   unsigned _STANDARD_INPUT_: 1; /* standard input */
   unsigned _SET_STDIN_BUF_: 1; /* standard input buffer */
   unsigned _RECURS_: 1; /* send directories recursivly */
   unsigned OVERWRITE: 2; /* overwrite all existing files */
   unsigned _PFTP_DAEMON_: 2; /* run as daemon: 1) exit after first connect 2) keep running */
   unsigned lol: 1; /* output '\r' */
   unsigned lognames: 1; /* log names when running as inetd server/ daemon */
   unsigned delete_info: 1; /* delete info file */
#ifdef USE_POSIX_THREAD
   unsigned free: 1;
   unsigned RECEIVING: 1;
#endif
   short _SKIP_;    /* skip all existing files */
   short _OPTIONS_; /* number of options */
   size_t _STDIN_BUFSIZ_; /* size of stdin buffer */
   size_t bsize;
   char *_STDIN_BUFFER_; /* buffers stdin data */
   char *REMOTEHOSTNAME; /* name of current remote client host */
   char *_HOSTNAME_;
   char *home; /* home directory */
   char *version; /* version of server */
   char *sstatus; /* status of server */
   short usefilter; /* flag for option '-f' */
   int ns; /* client/server port to read from */
   int ws; /* client/server port to write to */
   int size;
   long mul;
   unsigned long _BANDWIDTH_; /* sets the bandwidth in bytes */
   FILE *fp;
   FILE *rp;
   int pid;
   char *rlogin;
   char *rpass;
   char *from;
   char *pw_name; 
   char *pw_passwd; 
   char *pw_dir; 
   uid_t pw_uid;
   gid_t pw_gid;
#ifdef USE_POSIX_THREAD
   double start;
   int output;
#endif
};

struct client_type {
   char **argv;
   int argc;
};

#define MEM_CHECK(ALLOC_MEM) \
        if (!ALLOC_MEM) { \
           fprintf(stderr, "** calloc: Cannot allocate enough memory.\n"); \
           exit(1); \
        }
#endif /* STATUS_STRUCTURE_H */
