/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/types.h>
#include <sys/errno.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#include "connect.h"
#include "main.h"

extern void set_tty(int);
extern long offset[SONAME];
extern void check_bandwidth(double);
   

void sending(struct client_type  *clientstr)
{
   FILE *fp = (*statstr)->fp;
   char *hostname = (*statstr)->_HOSTNAME_;
   char **argv;
   char name[LONAME], *tmpname=NULL;
   char fstr[BUFSIZE];
   char *sargv[HUNAME]; /* Hopefully this will be enough ;^) */
   FILE *fd, *fe=stderr;
   DIR *ff;
   unsigned long ci;
   int ofse=0;
   register int n;
   int mode=0;
   int c, lastrr=0, rr=0, maxrr=(*statstr)->bsize;
   double sum_bytes=0; /* see check_bandwidth() */
   struct stat buf;
#if defined Linux
   struct direct *dir;
#else
   struct dirent *dir;
#endif

   /*
    * Check if the client sends data to the daemon.  If so send
    * the destination directory and the password to the client.
    */
   if ((*statstr)->_PFTP_DAEMON_ && client_destdir && !(*statstr)->from) {
      int ll=0;
      char *passwd=NULL;

      if ((*statstr)->rpass) passwd = (*statstr)->rpass;
      else {
         MEM_CHECK((passwd = (char *)calloc(SONAME, sizeof(char))));
         bzero(passwd, SONAME);
         set_tty(2);
         fprintf(stderr, "Password: "); fgets(passwd, SONAME, stdin);
         set_tty(0);
         fputc('\r', stderr);
         for (ll=0; *(passwd+ll); ll++) {
            if (*(passwd+ll) == '\n') *(passwd+ll) = '\0';
         }
      }
      fprintf(fp, "DDIR %s\nPASS %s\nGOON 1\n", client_destdir, passwd);
      bzero(passwd, SONAME);
      if (passwd) free(passwd);
      if (client_destdir) {
         free(client_destdir);
         client_destdir = NULL;
      }
   }
   else if ((data_subject || data_info) && (*statstr)->from) {
      long psize=0;
      if (data_info && !stat(data_info, &buf) && (buf.st_mode & S_IFREG)) {
         FILE *fip=NULL;
         if (data_subject) {
            sprintf(fstr, "Subject: %s\n", data_subject);
            psize = strlen(fstr);
         }
         fprintf(fp, "._pftp_info_file 384 %ld\nH", psize+buf.st_size);
         fflush(fp);
         if (data_subject) fwrite(fstr, sizeof(char), psize, fp);
         if (!(fip = fopen(data_info, "r"))) {
            if (slfp) fprintf(slfp, "** %s: %s\n", data_info, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         if (slfp) fprintf(slfp, "* Sending message file to %s...\r", hostname);
         while ((n = fread(fstr, sizeof(char), BUFSIZE, fip)) > 0) {
            fwrite(fstr, sizeof(char), n, fp);
         }
         fclose(fip);
         if ((*statstr)->delete_info) unlink(data_info);
      }
      else if (data_subject) {
         sprintf(fstr, "Subject: %s", data_subject);
         psize = strlen(fstr);
         fprintf(fp, "._pftp_info_file 384 %ld\nH", psize);
         fwrite(fstr, sizeof(char), psize, fp);
         fflush(fp);
      }
   }

#ifdef HP_UX
   lastrr = BUFSIZE;
#endif

   /*
    * Initialize Bandwidth if '-W' was given on command line.
    */
   if ((*statstr)->_BANDWIDTH_) check_bandwidth((double)0);

   for (argv=clientstr->argv; --(clientstr->argc); argv++) {
      if (!(*statstr)->_STANDARD_INPUT_) {
         bzero((char *)name, LONAME);
         bcopy((*argv), name, strlen((*argv)));
         /*
          * Get protection bits.
          */
         stat((*argv), &buf);
         mode = buf.st_mode;

         /*
          * Check file.
          */
         if (access(name, F_OK) != 0 ) {
            fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            if (pftplog) {
               if ((fe = fopen(pftplog , "a")) != NULL) {
                  fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                  fclose(fe);
               }
            }
            continue;
         }
         else if (!buf.st_size) {
            if (slfp) fprintf(slfp, "** File %s is empty.\n", name);
            if (pftplog) {
               if ((fe = fopen(pftplog, "a")) != NULL) {
                  fprintf(fe, "** File %s is empty.\n", name);
                  fclose(fe);
               }
            }
            continue;
         }
         else if ((*statstr)->_RECURS_ && (buf.st_mode & S_IFDIR)) {
            struct client_type *tmpstr;
            MEM_CHECK((tmpstr = (struct client_type *)calloc(1, sizeof(struct client_type))));
            if ((ff = opendir(name)) == NULL) {
               fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a")) != NULL) {
                     fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                     fclose(fe);
                  }
               }
               continue;
            }
            for (c = 0; (dir = readdir(ff)); c++)
            {
               if (!dir->d_ino || !strcmp(".", dir->d_name) || !strcmp("..", dir->d_name)) {
                  c--;
               }
               else {
                  MEM_CHECK((*(sargv+c) = (char *)calloc(LONAME, sizeof(char))));
                  sprintf(*(sargv+c), "%s%s%s",
                  name, *(name+strlen(name)-1) != '/'? "/": "", dir->d_name);
               }
            }
            closedir(ff);

            tmpstr->argc = c + 1;
            tmpstr->argv = sargv;
            
            sending(tmpstr);
            free(tmpstr);
            while (c) {
               c--; 
               if (sargv[c]) free(sargv[c]);
            }
            continue;
         }
         else if ((buf.st_mode & S_IFMT) != S_IFREG) {
            if (slfp) fprintf(slfp, "** %s is not a regular file.\n", name);
            continue;
         }
      }
         
      /*
       * Open file for reading.
       */
      if ((*statstr)->_STANDARD_INPUT_) {
         fd = stdin;
      }
      else if ((fd = fopen(name, "r")) == NULL) {
         fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
         if (pftplog) {
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               fclose(fe);
            }
         }
         continue;
      }
      else if (*(offset+ofse) >= 0) {
         if (fseek(fd, *(offset+ofse), 0)) {
            fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         buf.st_size -= *(offset+ofse);
         ofse++;
      }

      /*
       * Send information about the file.
       */
      if ((*statstr)->version) {
         for (tmpname=name; *tmpname; tmpname++) {
            if (*tmpname == '\n') *tmpname = '_';
         }
      }
      else {
         for (tmpname=name; *tmpname; tmpname++) {
            if (*tmpname == ' ' || *tmpname == '\t' || *tmpname == '\n') {
               *tmpname = '_';
            }
         }
      }
      if ((*statstr)->_STANDARD_INPUT_) {
            strcpy(name, "|"); mode = 0644; buf.st_size = 0;
      }
      fprintf(fp, "%s %d %ld\nH", name, mode, buf.st_size);
      fflush(fp);

      /*
       * Read from local file and write to filter/remote port.
       */
      if (!(*statstr)->_STANDARD_INPUT_) (*statstr)->lol = 1;
      if (slfp) {
         fprintf(slfp, "* Sending %s %s to %s ...%s",
         (*statstr)->_STANDARD_INPUT_ ? "a stream": "file", 
         (*statstr)->_STANDARD_INPUT_ ? "\b": (*argv), hostname, 
         (*statstr)->_STANDARD_INPUT_ ? "\n": "");
      }
      if (!(*statstr)->_STANDARD_INPUT_) {
         rr = maxrr > buf.st_size ? buf.st_size: maxrr;
#ifdef HP_UX
         if (lastrr < rr)
#else
         if (lastrr != rr)
#endif
         {
            if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&rr, sizeof(rr)) < 0) {
               fprintf(stderr, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            lastrr = rr;
         }
         if (!(*statstr)->_BANDWIDTH_) {
            for (ci=n=0; (n = fread(fstr, sizeof(char), rr, fd)) > 0; ci+=n) {
               fwrite(fstr, sizeof(char), n, fp);
            }
         }
         else {
            for (ci=n=0; (n = fread(fstr, sizeof(char), rr, fd)) > 0; ci+=n) {
               fwrite(fstr, sizeof(char), n, fp);
               sum_bytes += (double)n;
               /* waiting if necessary */
               check_bandwidth(sum_bytes);
            }
         }
         fclose(fd);
      }
      else {
         if ((*statstr)->_STDIN_BUFSIZ_) {
            if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&((*statstr)->_STDIN_BUFSIZ_), sizeof((*statstr)->_STDIN_BUFSIZ_)) < 0) {
               fprintf(stderr, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
         }
         if (!(*statstr)->_BANDWIDTH_) {
            for (ci=0; (c = fgetc(fd)) != EOF; ci++) fputc(c, fp);
         }
         else {
            for (ci=0; (c = fgetc(fd)) != EOF; ci++) {
               fputc(c, fp);
               sum_bytes++;
               /* waiting if necessary */
               check_bandwidth(sum_bytes);
            }
         }
      }

      if (slfp) {
         fflush(slfp);
         if ((ci == (unsigned long)buf.st_size) || (*statstr)->_STANDARD_INPUT_) {
            if ((*statstr)->lol) fputc(slfp == stderr ? '\r': '\n', slfp);
            fprintf(slfp, "--> %s (%ld bytes) sent to %s.\n",
            (*statstr)->_STANDARD_INPUT_ ? "Stream": (*argv), ci, hostname);
         }
         else {
            /*
             * Though the network buffer is probably too big.
             */
            fprintf(slfp, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": (*argv), hostname);
            if (pftplog) {
               if ((fe = fopen(pftplog, "a")) != NULL) {
                  fprintf(fe, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": (*argv), hostname);
                  fclose(fe);
               }
            }
         }
      }
   }
   fflush(fp);
}
