/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <sys/types.h>
#include <pwd.h>
#include "connect.h"
#include "main.h"

extern void set_tty(int);
extern void shost(int, int *, short);
extern void lhost(char *, int *, short);
extern short get_var_from_pftprc(const char *, char *, short);
extern void pmanager(short);
extern void warranty(void);
extern void display_pa(char **, char *, char *, int);
extern short mycmp(char *, char *);
int printlist(int, char *, short);
void create_passwd(void);
int getoffset(char *);
long offset[SONAME];  /* hold all offsets of the beginning of files */

#define HELPLINES 60

void help() {
   char *firstline=NULL;
   char *helpstr[HELPLINES+1] = {
      " Server: pftp [port] [OPTIONS]                                   \n",
      "                                                                 \n",
      "    -         a) Remote stdin is written to stdout.              \n",
      "              b) Exit after the first connection.                \n",
      "    -b[NUM]   Same as `-' except that stdout is buffered.        \n",
      "              NUM is the size in bytes of the buffer.            \n",
      "              The buffer size defaults to 4096 bytes.            \n",
      "    -bb       Same as `-b32767'.                                 \n",
      "    -B        Set the net buffer size in bytes to the maximum    \n",
      "              value specified in the variable PFTPNETBUF.        \n",
      "    -a        Overwrite all existing files.                      \n",
      "    -c hosts  Accept specified clients only.  Hosts beginning    \n",
      "              with a `.' are supposed to be domain names.        \n",
      "              If hosts are omitted the variable PFTPCLIENTS      \n",
      "              which may hold host and domain names is read.      \n",
      "    -d        Start pftp as a daemon. The number of the filter   \n",
      "              to be used is specified by the client.  The filter \n",
      "              is read from user's pftp resource file.            \n",
      "    -f[NUM]   Use filter NUM specified in the variable           \n",
      "              PFTPSFILTER.  NUM defaults to 1.                   \n",
      "    -i        Start pftp from `/etc/inetd.conf'.  The number of  \n",
      "              the filter to be used is specified by the client.  \n",
      "              The filter is read from user's pftp resource file. \n",
      "    -q        Run silently--existing files are skipped by default\n",
      "    -r        Receive directories recursively.                   \n",
      "    -s        Skip all existing files.                           \n",
      "                                                                 \n",
      "                                                                 \n",
      " Client: pftp [port] [OPTIONS] [-l|-NUM| hostname] [files]       \n",
      "                                                                 \n",
      "    -         Send stdin unbuffered.  Standard input is          \n",
      "              incompatible with option `-l'.                     \n",
      "    -b[NUM]   Same as `-' except that stdin is buffered.         \n",
      "              NUM is the size in bytes of the buffer.            \n",
      "              The buffer size defaults to 4096 bytes.            \n",
      "    -bb       Same as `-b32767'.                                 \n",
      "    -B        Set the net buffer size in bytes to the maximum    \n",
      "              value specified in variable PFTPNETBUF.            \n",
      "    -d[=DIR]  Send data to the daemon.  The files are uploaded   \n",
      "              in the directory DIR on the remote host.           \n",
      "    -e        Create a normal Unix password with crypt()         \n",
      "    -f[NUM]   Use filter NUM specified in variable               \n",
      "              PFTPCFILTER.  NUM defaults to 1.                   \n",
      "    -i[=DIR]  Send data to the inetd server.  The files are      \n",
      "              uploaded in the directory DIR on the remote host.  \n",
      "    -l        Select hostname from list and send the files       \n",
      "              specified on command line.                         \n",
      "    -m[=FILE] In combination with `-n': Add message file FILE or \n",
      "              if FILE is not given write the file interactively. \n",
      "    -N        Peek for new data in the upload directory.         \n",
      "    -n        Start the pftp file and directory manager.         \n",
      "    -nn       Send data to a friend and ask for subject.         \n",
      "    -n[=SUBJ] Send data [of subject SUBJ] to a friend.           \n",
      "    -NUM      NUM is the number of the host in your pftp resource\n",
      "              file.  Try `pftp -l .' to see the numbers.         \n",
      "    -oN1oN2   Begin sending at the N1th byte of the first file...\n",
      "              See the manual page for further notices.           \n",
      "    -q        Run silently.                                      \n",
      "    -r        Send directories recursively.                      \n",
      "    -W        Bandwidth in bytes read from variable PFTPBANDWID. \n",
      "    -w        Display warranty.                                  \n"
   };
   
   if (isatty(1)) {
      char *ctmp=NULL;
      MEM_CHECK((firstline = (char *)calloc(SONAME, sizeof(char))));
      sprintf(firstline, "*** Port-FTP Version %s Copyright (C) 1996, 1997, 1998 Ben Schluricke ***", VERSION); 
      for (ctmp=firstline; *ctmp; ctmp++);
      for (; ctmp - firstline < _WINCOLS_; ctmp++) *ctmp = '*';
      *(ctmp-1) = ' ';
      *ctmp = '\0';
      fprintf(stdout, "[?25l[H[J");
      set_tty(2);
      display_pa(helpstr, firstline, "                                                                            ", HELPLINES);  
      set_tty(0);
      fprintf(stderr, "[?25h\r                                                                       \r");
      free(firstline);
   }
   else {
      int j=0;
      fprintf(stdout, "\n*** Port-FTP Version %s ", VERSION); 
      fprintf(stdout, "Copyright (C) 1996, 1997, 1998 Ben Schluricke ***\n\n");
      for (j=0; j <= HELPLINES; j++) fputs(*(helpstr+j), stdout);
   }
   exit(0);
}

int argum(int argc, char **argv, int *portn)
{
   int _ISDIGIT_=0;
   (*statstr)->usefilter = 0;
   *offset = -1;

   /*
    * Set the default maximum package size.
    */
   (*statstr)->bsize = BUFSIZE;

   /*
    * Please don't change this option.
    */
   if (argc == 2 && (strcmp(*(argv+1), "-H") == 0)) {
      char *blankline=NULL, *ctmp=NULL;
      MEM_CHECK((blankline = (char *)calloc(SONAME, sizeof(char))));
      for (ctmp=blankline; ctmp - blankline < (_WINCOLS_-45)/2; ctmp++) *ctmp = ' ';
      *ctmp='\0';
      fprintf(stderr, "[?25l[31m[H[J[%dH%s", _WINROWS_/2, blankline);
      free(blankline);
      fprintf(stderr, "This program is dedicated to Heather O'Rourke");
      fprintf(stderr, "[0m[%dH", _WINROWS_);
      set_tty(2); fgetc(stdin); set_tty(0);
      fprintf(stderr, "[?25h[H[J");
      exit(0);
   }
   else if (argc == 2 && !mycmp(*(argv+1), "-n")) {
      pmanager(0);
      exit(0);
   }
   else if (argc == 2 && !mycmp(*(argv+1), "-N")) {
      pmanager(1);
      exit(0);
   }
   else if (argc == 2 && (mycmp(*(argv+1), "-w") == 0)) {
      fprintf(stderr, "[?25l");
      set_tty(2);
      warranty();
      set_tty(0);
      fprintf(stderr, "[?25h\r");
      exit(0);
   }
   else if (argc == 1) {
      (*statstr)->_OPTIONS_=1;
      *portn=-1;
      lhost(NULL, portn, 0);
      return 1;
   }
   else if (argc == 2 && (atoi(*(argv+1)) && strlen(*(argv+1)) > 6) && **(argv+1) != '-') {
      return 1;
   }
   else if (*argv[1] == '-' || argc > 1) {
      int i, j, c, _NEXT_, cl=0;
      char *gtmp=NULL;
      short clhosts=0;

      if (!strcmp(*(argv+1), "-h")) help();
      else if (**(argv+1) == '-' || !atoi(*(argv+1)) || strlen(*(argv+1)) > 5) {
         *portn=-1;
         lhost(NULL, portn, 0);
         (*statstr)->_OPTIONS_ = 1;
      }
      else {
         if (!(*portn = atoi(*(argv+1)))) *portn = 0;
         (*statstr)->_OPTIONS_ = 2;
      }

      while ((*statstr)->_OPTIONS_ < argc && *argv[(*statstr)->_OPTIONS_] == '-') {
         _NEXT_ = 1;
         clhosts = 0;
         for (i=1; _NEXT_ && (c = *(argv[(*statstr)->_OPTIONS_]+i)); i++) {
            switch(c) {
               case 'c':
                  /* get host names of accepted clients */
                  if (argc > (*statstr)->_OPTIONS_ + 1) {
                     if (!getenv("PFTPCLIENTS") && *argv[(*statstr)->_OPTIONS_+1] == '-') {
                        MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                        if (!get_var_from_pftprc("PFTPCLIENTS", gtmp, 0)) help();
                     }
                     else if (*argv[(*statstr)->_OPTIONS_+1] != '-') clhosts = 1;
                  }
                  else if (argc == (*statstr)->_OPTIONS_ + 1) {
                     if (!getenv("PFTPCLIENTS")) {
                        MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                        if (!get_var_from_pftprc("PFTPCLIENTS", gtmp, 0)) help();
                     }
                  }
                  if (!*_CLIENTHOSTNAME_ && isatty(2)) {
                     fprintf(stderr, "\n*** Connections are accepted from the following host(s) ***\n\n");
                  }
                  for (cl=0; cl < MAXCLIENTHOSTS && *(_CLIENTHOSTNAME_+cl); cl++);

                  /*
                   * Read from command line.
                   */
                  if (clhosts) {
                     for (; ++(*statstr)->_OPTIONS_ < argc && *argv[(*statstr)->_OPTIONS_] != '-'; cl++) {
                        MEM_CHECK((*(_CLIENTHOSTNAME_+cl) = (char *)calloc(SONAME, sizeof(char))));
                        printlist(cl, argv[(*statstr)->_OPTIONS_], 0);
                     }
                     if (!*_CLIENTHOSTNAME_) help();
                     _NEXT_ = 0;
                     (*statstr)->_OPTIONS_--;
                     continue;
                  }
                  /*
                   * Read from environment variable or resource file.
                   */
                  else if (getenv("PFTPCLIENTS") || gtmp) {
                     char *tmp=NULL;
                     if (getenv("PFTPCLIENTS")) {
                        if (!gtmp) MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                        strcpy(gtmp, getenv("PFTPCLIENTS"));
                     }
                     tmp = gtmp;
                     while (*tmp == ' ' || *tmp == '*') tmp++;
                     for (; *tmp; cl++) {
                        MEM_CHECK((*(_CLIENTHOSTNAME_+cl) = (char *)calloc(SONAME, sizeof(char))));
                        tmp += printlist(cl, tmp, 0);
                        while (*(++tmp) == ' ' || *tmp == '*');
                     }
                     if (!*_CLIENTHOSTNAME_) help();
                     free(gtmp);
                  }
                  else help();
                  break;
               case 'W':
                  /*
                   * Get the size of the bandwidth
                   */
                  if (!getenv("PFTPBANDWID")) {
                     MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                     if (!get_var_from_pftprc("PFTPBANDWID", gtmp, 0)) {
                        fprintf(stderr, "** Please set the variable PFTPBANDWID!\n");
                        exit(1);
                     }
                     (*statstr)->_BANDWIDTH_ = (size_t) atol(gtmp);
                     free(gtmp);
                  }
                  else (*statstr)->_BANDWIDTH_ = (size_t) atol(getenv("PFTPBANDWID"));
/*
fprintf(stderr, "Bandwidth is %lu bytes/sec.\n", (*statstr)->_BANDWIDTH_);
exit(1);
*/
                  break;
               case 'B':
                  /*
                   * Get the size of the net buffer.
                   */
                  if (!getenv("PFTPNETBUF")) {
                     MEM_CHECK((gtmp = (char *)calloc(SONAME, sizeof(char))));
                     if (!get_var_from_pftprc("PFTPNETBUF", gtmp, 0)) {
                        fprintf(stderr, "** Please set the variable PFTPNETBUF!\n");
                        exit(1);
                     }
                     (*statstr)->bsize = (size_t) atol(gtmp);
                     free(gtmp);
                  }
                  else (*statstr)->bsize = (size_t) atol(getenv("PFTPNETBUF"));
                  break;
               case 'b':
                  if (isdigit(argv[(*statstr)->_OPTIONS_][i+1])) { 
                     char *tmp = NULL;
                     size_t bf = (size_t)0;

                     for (tmp=argv[(*statstr)->_OPTIONS_],++i; isdigit(*(tmp+i)); i++) {
                           bf = (bf * 10) + (size_t) (*(tmp+i) - '0');
                     }
                     MEM_CHECK((_STDOUT_BUFFER_ = (char *)calloc(bf, sizeof(char))));
                     MEM_CHECK(((*statstr)->_STDIN_BUFFER_ = (char *)calloc(bf, sizeof(char))));
                     (*statstr)->_STDIN_BUFSIZ_ = bf;
                     i--;
                  } 
                  else {
                     MEM_CHECK((_STDOUT_BUFFER_ = (char *)calloc((size_t)(argv[(*statstr)->_OPTIONS_][i+1] == 'b' ? BUFSIZE: DEFAULT_STDIN_BUFSIZ), sizeof(char))));
                     MEM_CHECK(((*statstr)->_STDIN_BUFFER_ = (char *)calloc((size_t)(argv[(*statstr)->_OPTIONS_][i+1] == 'b' ? BUFSIZE: DEFAULT_STDIN_BUFSIZ), sizeof(char))));
                     (*statstr)->_STDIN_BUFSIZ_ = (argv[(*statstr)->_OPTIONS_][i+1] == 'b' ? BUFSIZE: DEFAULT_STDIN_BUFSIZ);
                     if (argv[(*statstr)->_OPTIONS_][i+1] == 'b') i++;
                  }
                  (*statstr)->_SET_STDIN_BUF_ = BIT_ONE;
               case '-':
                  (*statstr)->_STANDARD_INPUT_ = BIT_ONE;
                  break;
               case 'i':
                  /*
                   * Exit after first connection.
                   * This is meant for `inetd.conf'.
                   */
                  (*statstr)->_PFTP_DAEMON_ = BIT_TWO;
#ifdef INETD_PORT
                  *portn = INETD_PORT;
#else
                  *portn = 27;
#endif
               case 'd':
                  /*
                   * Run as long as to be killed.
                   */
                  if (c == 'd') (*statstr)->_PFTP_DAEMON_ = BIT_ONE;
                  client_destdir = NULL;
                  MEM_CHECK((client_destdir = (char *)calloc(LONAME, sizeof(char))));
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     strcpy(client_destdir, (argv[(*statstr)->_OPTIONS_]+i+2));
                     /*
                      * Nobody else should see the destination directory.
                      */
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else strcpy(client_destdir, "~");
                  break;
               case 'e':
                  create_passwd();
                  break;
               case 'f':
                  if ((cl = argv[(*statstr)->_OPTIONS_][i+1]) == 'S' || cl == 'C') {
                     char *tmp=NULL;
                     /*
                      * List all Server/Client filters.
                      */
                     if (cl == 'S') {
                        tmp = getenv("PFTPSFILTER");
                        if (!tmp) {
                           MEM_CHECK((tmp = (char *)calloc(SONAME, sizeof(char))));
                           if (!get_var_from_pftprc("PFTPSFILTER", tmp, 0)) {
                              free(tmp);
                              tmp = NULL;
                           }
                        }
                     }
                     else {
                        tmp = getenv("PFTPCFILTER");
                        if (!tmp) {
                           MEM_CHECK((tmp = (char *)calloc(SONAME, sizeof(char))));
                           if (!get_var_from_pftprc("PFTPCFILTER", tmp, 0)) {
                              free(tmp);
                              tmp = NULL;
                           }
                        }
                     }
                     if (!tmp) {
                        fprintf(stderr, "** %s is not set.\n", cl == 'S'?"PFTPSFILTER":"PFTPCFILTER");
                        exit(1);
                     }
                     for (j=0;*(tmp+j) == ' ' && *(tmp+j); j++);
                     if (!*(tmp+j)) {
                        fprintf(stderr, "** %s is empty.\n", cl == 'S'?"PFTPSFILTER":"PFTPCFILTER");
                     }
                     else {
                        int skip_space=1;
                        fprintf(stderr, "\n* List of %s filters:\n\n", cl == 'S'?"server":"client");
                        fprintf(stderr, "      1) ");
                        for (i=0,j=2; *(tmp+i); i++) {
                           if (*(tmp+i) == ':') {
                              fprintf(stderr, "\n      %d) ", j++);
                              skip_space = 1;
                           }
                           else {
                              if (*(tmp+i) == ' ' || *(tmp+i) == '\t') {
                                 while(*(tmp+i) == ' ' || *(tmp+i) == '\t') i++;
                                 if (!skip_space) i--;
                              }
                              skip_space = 0;
                              fputc(*(tmp+i), stderr);
                           }
                        }
                        fprintf(stderr, "\n\n");
                     }
                     exit(0);
                  }
                  else {
                     for (j=1,(*statstr)->usefilter=0; isdigit(argv[(*statstr)->_OPTIONS_][i+j]); j++) {
                        if ((*statstr)->usefilter) (*statstr)->usefilter *= 10;
                        (*statstr)->usefilter += argv[(*statstr)->_OPTIONS_][i+j] - '0';
                     }
                     if (j == 1) (*statstr)->usefilter=1;
                     i += j - 1;
                  }
                  break;
               case 'm':
                  (*statstr)->delete_info = 0;
                  MEM_CHECK((data_info = (char *)calloc(SONAME, sizeof(char))));
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     strcpy(data_info, (argv[(*statstr)->_OPTIONS_]+i+2));
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else {
                     (*statstr)->delete_info = 1;
                     *data_info = '\0';
                  }
                  break;
               case 'n':
                  if (*(argv[(*statstr)->_OPTIONS_]+i+1) == '=') {
                     MEM_CHECK((data_subject = (char *)calloc(SONAME, sizeof(char))));
                     strcpy(data_subject, (argv[(*statstr)->_OPTIONS_]+i+2));
                     strcat(data_subject, "\n");
                     /*
                      * Nobody else should see the subject.
                      */
                     for (; *(argv[(*statstr)->_OPTIONS_]+i+1); i++) {
                        *(argv[(*statstr)->_OPTIONS_]+i+1) = '\0';
                     }
                     _NEXT_ = 0;
                  }
                  else if (*(argv[(*statstr)->_OPTIONS_]+i+1) == 'n') {
                     MEM_CHECK((data_subject = (char *)calloc(SONAME, sizeof(char))));
                     fprintf(stdout, "Subject: ");
                     fgets(data_subject, SONAME, stdin);
                     i++;
                  }
                  MEM_CHECK(((*statstr)->from = (char *)calloc(SONAME, sizeof(char))));
                  if (getpwuid(getuid())) {
                     strcpy((*statstr)->from, (char *)getpwuid(getuid())->pw_name);
                  }
                  else {
                     if (stderr) fprintf(stderr, "** Who are you?!\n");
                     exit(1);
                  }
                  if (!(*statstr)->_PFTP_DAEMON_) {
                     (*statstr)->_PFTP_DAEMON_ = BIT_TWO;
#ifdef INETD_PORT
                     *portn = INETD_PORT;
#else
                     *portn = 27;
#endif
                  }
                  break;
               case 'o':
                  if (*offset < 0) i =+ getoffset((argv[(*statstr)->_OPTIONS_]+i+1))+1;
                  else help();
                  break;
               case 'r':
                  (*statstr)->_RECURS_ = 1;
                  break;
               case 'a':
                  (*statstr)->OVERWRITE = BIT_TWO;
                  (*statstr)->_SKIP_ = 0;
                  break;
               case 'l':
                  if (!isatty(2)) {
                     fprintf(stderr, "** Sorry, '-l' needs a tty for output.\n");
                     exit(1);
                  }
                  else if (_ISDIGIT_ == 1) help();
                  else _ISDIGIT_ = 2;
                  break;
               case 's':
                  (*statstr)->_SKIP_ = 1;
                  (*statstr)->OVERWRITE = 0;
                  break;
               case 'q':
                  slfp = NULL;
                  break;
               case 'h':
                  help();
                  break;
               default:
                  if (_ISDIGIT_ > 1 || !isdigit(c)) {
                     fprintf(stderr, "**\n** unknown option `%c'\n**\n", c);
                     help();
                  }
                  else if (!_ISDIGIT_) {
                     lhost((argv[(*statstr)->_OPTIONS_]+i), portn, 0); 
                     _ISDIGIT_ = 1;
                  }
                  break;
            }
         }
         if (i == 1) (*statstr)->_STANDARD_INPUT_ = 1;
         (*statstr)->_OPTIONS_++;
      }
   }
   else if (argc < 3) {
      help();
   }

   /*
    * Indentify and check.
    */
   if(_ISDIGIT_) (*statstr)->_OPTIONS_--;
   if(((*statstr)->OVERWRITE && (*statstr)->_SKIP_) || ((*statstr)->OVERWRITE && _ISDIGIT_)) help();
   /*
    * If the program is running as the server return 1 else 
    * if the program is running as the client return 0.
    * Print help a message if an error occurs.
    */
   else if ((((argc == 2) && (!isalpha(argv[1][0]))) \
        || ((*statstr)->_OPTIONS_ == argc)) && (!_ISDIGIT_) \
        && (!(*statstr)->_BANDWIDTH_) && (*offset < 0)) 
        /*
         * Program is running as the server.
         */
        return 1;
   else if (((*statstr)->OVERWRITE || (*statstr)->_SKIP_ || *_CLIENTHOSTNAME_) \
        || (_ISDIGIT_ > 1 && (*statstr)->_STANDARD_INPUT_) \
        || ((*statstr)->_RECURS_ && (*statstr)->_STANDARD_INPUT_) \
        || ((*statstr)->_RECURS_ && !_ISDIGIT_ && (*statstr)->_OPTIONS_ == argc - 1) \
        || ((*statstr)->_STANDARD_INPUT_ && argv[argc-2][0] != '-') \
        || (!(*statstr)->_STANDARD_INPUT_ && argv[argc-1][0] == '-') \
        || ((*statstr)->_STANDARD_INPUT_ && argv[argc-1][0] != '-'  && _ISDIGIT_) \
        || (argc < 3))
           help();
   else if (_ISDIGIT_ > 1) lhost("l", portn, 0);

   if (_ISDIGIT_ > 1 && (*statstr)->_OPTIONS_ == argc - 1) {
      fprintf(stderr, "** No files specified!\n");
      exit(1);
   }

   /*
    * Program is running as the client.
    */
   return 0;
}


int printlist(int cl, char *chost, short strnum)
{
   char *clienthost = NULL;
   struct hostent *hp;
   short _ISNUM_=1;
   char *tmphost=NULL;
   int inum, j, tmp;

   MEM_CHECK((clienthost = (char *)calloc(SONAME, sizeof(char))));
   strcpy(clienthost, chost);
   for (j=0; *(clienthost+j) != ' ' && *(clienthost+j); j++)
      if (!isdigit(*(clienthost+j))) _ISNUM_=0;
   *(clienthost+j) = '\0';
   tmp = j;
   if (!_ISNUM_) {
      tmphost = clienthost;
   }
   else {
      int dummy;
      shost(atoi(clienthost), &dummy, strnum);
      tmphost = (*statstr)->_HOSTNAME_;
   }
   inum = inet_addr(tmphost);
   if (*tmphost != '.') {
      if ((hp = (struct hostent *)gethostbyname(tmphost)) != NULL);
      else if ((hp = gethostbyaddr((char *)&inum, sizeof(inum), AF_INET)) == 0) {
         fprintf(stderr, "** %s: unknown host.\n", tmphost);
         exit(1);
      }
      if (isatty(2)) fprintf(stderr, "   %d) %s\n", cl+1, hp->h_name);
      for (j=0; *(hp->h_name+j); j++) *(*(_CLIENTHOSTNAME_+cl)+j) = tolower(*(hp->h_name+j));
   }
   else {
      if (isatty(2)) fprintf(stderr, "   %d) *%s\n", cl+1, tmphost);
      for (j=0; *(tmphost+j); j++) *(*(_CLIENTHOSTNAME_+cl)+j) = tolower(*(tmphost+j));
   }
   free(clienthost);
   return tmp;
}

int getoffset(char *z)
{
   char *tmpz = z;
   long *t = offset;

   for (*t=0L; *z; z++) {
      if (isdigit(*z)) *t = (*t * 10) + (long) (*z - '0');
      else if (*z == 'o' && isdigit(*(z+1))) {
         t++;
         *t = 0L;
      }
      else break;
   }
   t++;
   *t = -1;

   return (int) (z - tmpz);
}
