# A verb is a special method on a thing in the moo, that may be called by
# users. A verb has associated with it some parameters that must match
# if the verb is to be used.

package Verb;
use strict;
use VerbCall;
use vars qw($AUTOLOAD);

# You can pass in a hash with keys of sub, command, direct_object,
# preposition, and indirect_object to set the properties of the verb.
sub new {
	my $proto=shift;
	my $class = ref($proto) || $proto;
	my $this = {};
	
	if (@_) {
		my %init=@_;
		foreach (keys %init) {
			$this->{$_}=$init{$_};
		}
	}

	bless($this, $class);
	return $this;
}

# Returns true if this verb will work on a verbcall.
sub match {
	my $this=shift;
	my $verbcall=shift;

	# Test command. 
	# If "*" appears somewhere in a command, the remainder of that
	# command is optional.
	# If "*" appears at the end of a command, you can add anything
	# to the end.
	if ($this->{command}=~/(.*)\*(.*)/) {
		my $req=$1;
		my $opt=$2;
		if ($verbcall->word('verb')=~m/^$req(.*)/) {
			my $rest=$1;
			if ($opt) {
				if (index($opt,$rest) == -1) {
					# Stuff after * didn't match.
					return undef;
				}
			}	
		}
		else {
			# Stuff beofre * didn't match.
			return undef;
		}
	}
	elsif ($verbcall->word('verb') ne $this->{command}) {
		return undef;
	}

	# Test direct object.
	if ($this->{direct_object} eq 'this') {
		return undef if $verbcall->object != $verbcall->direct_object;
	}
	elsif ($this->{direct_object} eq 'none') {
		return undef if $verbcall->direct_object;
	}
	elsif ($this->{direct_object} eq 'any') {
	}
	elsif ($this->{direct_object} ne $verbcall->word('direct_object')) {
		return undef;
	}

	# Test preposition.
	if ($this->{preposition} eq 'any') {
	}
	elsif ($this->{preposition} eq 'none') {
		return undef if $verbcall->word('preposition');
	}
	elsif ($this->{preposition} ne $verbcall->word('preposition')) {
		return undef;
	}

	# Test indirect object.
        if ($this->{indirect_object} eq 'this') {
		return undef if $verbcall->object != $verbcall->indirect_object;
	}
	elsif ($this->{indirect_object} eq 'none') {
		return undef if $verbcall->indirect_object;
	}
	elsif ($this->{indirect_object} eq 'any') {
	}
	elsif ($this->{indirect_object} ne $verbcall->word('indirect_object')) {
		return undef;
	}

	return 1;
}

sub AUTOLOAD {
	my $this=shift;
	
	my $name = $AUTOLOAD;
	$name =~ s/.*://; # strip fully-qualified portion

	if (@_) {
		return $this->{$name} = shift;
	}
	else {
		return $this->{$name};
	}	
}

1;
